/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.initbill;

import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.tmc.cfm.common.enums.LoanTypeEnum;
import kd.tmc.cfm.common.helper.CfmFinVarietyHelper;
import kd.tmc.cfm.common.helper.CreditLimitHelper;
import kd.tmc.cfm.common.helper.CreditUseHelper;
import kd.tmc.cfm.formplugin.common.InitBillCreditLinkGmHelper;
import kd.tmc.cfm.formplugin.resource.CfmFormResourceEnum;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.CreditFinTypeEnum;
import kd.tmc.fbp.common.enums.CreditorTypeEnum;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.model.CreditLimitUseBean;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.common.AbstractCreditLimitEditPlugin;
import org.apache.commons.lang3.StringUtils;

public class InitBillLoanCreditLimitPlugin
extends AbstractCreditLimitEditPlugin
implements RowClickEventListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("loanentry");
        entryGrid.addRowClickListener((RowClickEventListener)this);
    }

    protected Map<String, String> getCreditlimiFieldMap() {
        HashMap<String, String> fieldMap = new HashMap<String, String>(1);
        fieldMap.put(this.getCreditLimitField(), "investor_entry");
        return fieldMap;
    }

    protected Map<String, String> getBizPropertys() {
        HashMap<String, String> propertys = new HashMap<String, String>();
        propertys.put("org", "org");
        propertys.put("finorg", "e_investorid");
        propertys.put("drawamount", "e_investamount");
        propertys.put("startDate", "bizdate");
        propertys.put("endDate", "enddate");
        propertys.put("currency", "currency");
        return propertys;
    }

    protected Set<String> getEntryFields() {
        HashSet<String> entryFields = new HashSet<String>();
        entryFields.add("e_investorid");
        entryFields.add("e_investamount");
        return entryFields;
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        int entryRowCount = this.getModel().getEntryRowCount("investor_entry");
        for (int i = 0; i < entryRowCount; ++i) {
            this.enableCredit(i);
        }
        InitBillCreditLinkGmHelper.setEnable(this.getView(), this.getModel());
    }

    public void entryRowClick(RowClickEvent evt) {
        EntryGrid entryGrid = (EntryGrid)evt.getSource();
        if ("loanentry".equals(entryGrid.getKey())) {
            DynamicObjectCollection entryEntitys = this.getModel().getEntryEntity("investor_entry");
            long vestorLimit = entryEntitys.stream().filter(o -> EmptyUtil.isNoEmpty((DynamicObject)o.getDynamicObject("e_vrcreditlimit")) && BigDecimal.ZERO.compareTo(o.getBigDecimal("e_vrcreditamt")) == 0).count();
            if (vestorLimit == 0L) {
                return;
            }
            this.setCreditUseFields();
        }
    }

    protected String creditType() {
        int rowIdx = this.getModel().getEntryCurrentRowIndex("investor_entry");
        String investorType = ((DynamicObject)this.getModel().getEntryEntity("investor_entry").get(rowIdx)).getString("e_investortype");
        if (CreditorTypeEnum.CUSTOM.getValue().equals(investorType)) {
            return CreditFinTypeEnum.BIZPARTNER.getValue();
        }
        return CreditFinTypeEnum.FINORG.getValue();
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String key = ((Control)event.getSource()).getKey();
        if ("e_vrcreditlimit".equals(key)) {
            String sourceMethod = event.getSourceMethod();
            if ("getLookUpList".equals(sourceMethod) || "setItemByNumber".equals(sourceMethod)) {
                this.getView().showTipNotification(CfmFormResourceEnum.InitBillCreditLimitEdit_0.loadKDString());
                event.setCancel(true);
                this.getModel().setValue(key, null);
                return;
            }
            if (!this.checkCreditlimitParams()) {
                event.setCancel(true);
                return;
            }
            int rowIndex = this.getModel().getEntryCurrentRowIndex("investor_entry");
            CreditLimitUseBean useBean = new CreditLimitUseBean();
            int parentIndex = this.getModel().getEntryCurrentRowIndex("loanentry");
            DynamicObject loanEntry = (DynamicObject)this.getModel().getEntryEntity("loanentry").get(parentIndex);
            Long loanId = loanEntry.getLong("loanbillid");
            if (EmptyUtil.isEmpty((Long)loanId)) {
                loanId = DB.genLongId((String)EntityMetadataCache.getDataEntityType((String)"cfm_loancontractbill").getAlias());
                this.getModel().setValue("loanbillid", (Object)loanId, parentIndex);
            }
            useBean.setPkId(loanId);
            Long investorEntryId = (Long)this.getModel().getValue("e_investorentryid", rowIndex);
            if (EmptyUtil.isEmpty((Long)investorEntryId)) {
                investorEntryId = DB.genLongId((String)EntityMetadataCache.getDataEntityType((String)"cfm_loancontractbill").getAlias());
                this.getModel().setValue("e_investorentryid", (Object)investorEntryId, rowIndex);
            }
            useBean.setSourceBillEntryId(investorEntryId);
            useBean.setCreditFinType(this.creditType());
            DynamicObject company = (DynamicObject)this.getModel().getValue("org");
            Long orgId = EmptyUtil.isNoEmpty((DynamicObject)company) ? (Long)company.getPkValue() : 0L;
            useBean.setEntityName("cfm_loanbill_bond");
            useBean.setOrgId(orgId);
            useBean.setFinOrgId((Long)this.getModel().getValue("e_investorid", rowIndex));
            useBean.setCurrencyId((Long)((DynamicObject)this.getModel().getValue("currency")).getPkValue());
            DynamicObject financingType = (DynamicObject)this.getModel().getValue("finproduct");
            useBean.setCreditTypeId(financingType != null ? CfmFinVarietyHelper.getCreditTypeByFinVarietyId((Long)((Long)financingType.getPkValue())) : null);
            useBean.setCreditVariety(financingType != null ? financingType.getString("name") : "");
            useBean.setBizAmt((BigDecimal)this.getModel().getValue("e_investamount", rowIndex));
            useBean.setMaxAmt((BigDecimal)this.getModel().getValue("e_investamount", rowIndex));
            useBean.setStartDate((Date)this.getModel().getValue("loaddate", parentIndex));
            useBean.setEndDate((Date)this.getModel().getValue("expiredate", parentIndex));
            useBean.setPreOccupy(Boolean.valueOf(false));
            ListShowParameter sp = (ListShowParameter)event.getFormShowParameter();
            sp.setMultiSelect(false);
            sp.setCustomParam("KEY_F7PARAM", (Object)useBean);
            sp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, event.getProperty().getName()));
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        Object returnData = e.getReturnData();
        String actionId = e.getActionId();
        if (StringUtils.equals((CharSequence)"e_vrcreditlimit", (CharSequence)actionId) && returnData instanceof String) {
            int rowIndex = this.getModel().getEntryCurrentRowIndex("investor_entry");
            this.getPageCache().put("cache_usebean" + rowIndex, (String)returnData);
        }
        super.closedCallBack(e);
    }

    public boolean isPreOccupy() {
        return false;
    }

    protected BigDecimal setCreditRatio() {
        DynamicObject creditUseBill;
        BigDecimal creditRatio;
        DynamicObject creditLimit = (DynamicObject)this.getModel().getValue("e_vrcreditlimit");
        DynamicObject finProduct = this.getFinProduct();
        BigDecimal bigDecimal = creditRatio = finProduct != null ? finProduct.getBigDecimal("creditratio") : Constants.ONE_HUNDRED;
        if (creditLimit == null) {
            return creditRatio;
        }
        if (this.getPageCache().get("ratio") != null) {
            return new BigDecimal(this.getPageCache().get("ratio"));
        }
        int parentIndex = this.getModel().getEntryCurrentRowIndex("loanentry");
        long loanBillId = ((DynamicObject)this.getModel().getEntryEntity("loanentry").get(parentIndex)).getLong("loanbillid");
        if (EmptyUtil.isNoEmpty((Long)loanBillId) && (creditUseBill = CreditLimitHelper.getCreditUseBill((Long)loanBillId, (String)"cfm_loanbill")) != null) {
            return creditUseBill.getBigDecimal("creditratio");
        }
        return creditRatio;
    }

    private DynamicObject getFinProduct() {
        return (DynamicObject)this.getModel().getValue("finproduct");
    }

    protected String getCreditVariety() {
        DynamicObject finProduct = this.getFinProduct();
        return finProduct.getString("name");
    }

    protected BigDecimal getAmount() {
        int rowIdx = this.getModel().getEntryCurrentRowIndex("investor_entry");
        return (BigDecimal)this.getModel().getValue("e_investamount", rowIdx);
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        super.beforeDeleteRow(e);
        String entryName = e.getEntryProp().getName();
        if ("investor_entry".equals(entryName)) {
            this.getModel().setValue("e_vrcreditlimit", null, e.getRowIndexs()[0]);
        }
        if ("gmsubentry".equals(entryName)) {
            if ("yes".equals(this.getView().getPageCache().get("isDeleteGuaranteeEntry"))) {
                this.getView().getPageCache().put("isDeleteGuaranteeEntry", "no");
                return;
            }
            for (int rowIndex : e.getRowIndexs()) {
                if (!((Boolean)this.getModel().getValue("gcreditguarantee", rowIndex)).booleanValue()) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6388\u4fe1\u643a\u5e26\u8fc7\u6765\u7684\u62c5\u4fdd\u4fe1\u606f\u4e0d\u53ef\u4ee5\u5220\u9664\u3002", (String)"InitBillLoanCreditLimitPlugin_1", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                break;
            }
        }
    }

    public boolean isSubmitReCreate() {
        return false;
    }

    public boolean checkCreditlimitParams() {
        return TmcViewInputHelper.checkMustInput((IFormView)this.getView(), (IDataModel)this.getModel(), (boolean)false, (String[])new String[]{"currency", "finproduct", "e_investamount", "e_investorname"});
    }

    protected Long getSourceBillId() {
        return null;
    }

    protected String getSourceType() {
        return null;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String prop = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        Object oldValue = e.getChangeSet()[0].getOldValue();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        switch (prop) {
            case "e_investortype": {
                this.clearFieldVal("e_investorname", "e_investorid", this.getCreditLimitField());
                this.controlCredit();
                break;
            }
            case "e_investamount": {
                this.validatorAmt();
                this.clearFieldVal(this.getCreditLimitField());
                break;
            }
            case "e_investorname": {
                this.clearFieldVal(this.getCreditLimitField());
                break;
            }
            case "e_vrcreditlimit": {
                InitBillCreditLinkGmHelper.dealInitGmContract(this.getView(), this.getModel(), this.getPageCache(), newValue, oldValue, rowIndex);
                if (newValue != null) break;
                TmcViewInputHelper.clearValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (int)rowIndex, (String[])new String[]{"e_vrcreditcurrency", "e_vrcreditamt"});
                break;
            }
        }
    }

    private void validatorAmt() {
        DynamicObjectCollection investorEntrys;
        BigDecimal totalMoney;
        int parentIndex = this.getModel().getEntryCurrentRowIndex("loanentry");
        DynamicObject loanEntry = (DynamicObject)this.getModel().getEntryEntity("loanentry").get(parentIndex);
        BigDecimal drawAmount = loanEntry.getBigDecimal("drawamount");
        if (drawAmount.compareTo(totalMoney = (investorEntrys = loanEntry.getDynamicObjectCollection("investor_entry")).stream().map(row -> row.getBigDecimal("e_investamount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO)) < 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6295\u8d44\u5b50\u5206\u5f55\u91d1\u989d\u603b\u548c\u4e0d\u80fd\u8d85\u8fc7\u5bf9\u5e94\u53d1\u884c\u5355\u91d1\u989d\u3002", (String)"InitBillLoanCreditLimitPlugin_0", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
        }
    }

    private void clearFieldVal(String ... fields) {
        int rowIdx = this.getModel().getEntryCurrentRowIndex("investor_entry");
        for (String field : fields) {
            if ("e_investorname".equals(field)) {
                this.getModel().setValue(field, (Object)"", rowIdx);
                continue;
            }
            if ("e_investorid".equals(field)) {
                this.getModel().setValue(field, (Object)0, rowIdx);
                continue;
            }
            this.getModel().setValue(field, null, rowIdx);
        }
    }

    private void controlCredit() {
        int rowIdx = this.getModel().getEntryCurrentRowIndex("investor_entry");
        this.enableCredit(rowIdx);
    }

    protected void enableCredit(int rowIdx) {
        String investorType = (String)this.getModel().getValue("e_investortype", rowIdx);
        this.getView().setEnable(Boolean.valueOf(!CreditorTypeEnum.OTHER.getValue().equals(investorType)), rowIdx, new String[]{this.getCreditLimitField()});
    }

    protected String getCreditUseAmtField() {
        return "e_vrcreditamt";
    }

    protected String getCreditUseCurrencyField() {
        return "e_vrcreditcurrency";
    }

    protected String getCreditLimitField() {
        return "e_vrcreditlimit";
    }

    protected void setCreditUseFields() {
        if (!LoanTypeEnum.isBond((String)((String)this.getModel().getValue("loantype")))) {
            return;
        }
        DynamicObjectCollection entryEntitys = this.getModel().getEntryEntity("investor_entry");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)entryEntitys)) {
            return;
        }
        long vestorLimit = entryEntitys.stream().filter(o -> EmptyUtil.isNoEmpty((DynamicObject)o.getDynamicObject("e_vrcreditlimit"))).count();
        if (vestorLimit == 0L) {
            return;
        }
        int loanIdx = this.getModel().getEntryCurrentRowIndex("loanentry");
        Long billId = (Long)this.getModel().getValue("loanbillid", loanIdx);
        DynamicObjectCollection creditUses = CreditUseHelper.getCreditUses((long)billId, (long)0L, (String)"sourcebillentryid,currency,realamt");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)creditUses)) {
            return;
        }
        Map creditUseMap = creditUses.stream().collect(Collectors.toMap(o -> o.getLong("sourcebillentryid"), Function.identity(), (v1, v2) -> v2));
        int entryRowCount = this.getModel().getEntryRowCount("investor_entry");
        for (int i = 0; i < entryRowCount; ++i) {
            long investEntryId;
            DynamicObject creditUse;
            if (EmptyUtil.isEmpty((Object)this.getModel().getValue("e_vrcreditlimit", i)) || EmptyUtil.isEmpty((DynamicObject)(creditUse = (DynamicObject)creditUseMap.get(investEntryId = ((Long)this.getModel().getValue("e_investorentryid", i)).longValue())))) continue;
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"e_vrcreditcurrency", (Object)creditUse.getLong("currency"), (int)i);
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"e_vrcreditamt", (Object)creditUse.getBigDecimal("realamt"), (int)i);
        }
    }

    protected Long getCreditTypeId() {
        DynamicObject finProduct = this.getFinProduct();
        DynamicObject creditType = finProduct != null ? finProduct.getDynamicObject("credittype") : null;
        return creditType != null ? creditType.getLong("id") : 0L;
    }
}

