/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.initbill;

import java.math.BigDecimal;
import java.math.RoundingMode;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.tmc.cfm.formplugin.initbill.AbsInitBillFeeInfoEdit;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class InitBillLoanFeeInfoEdit
extends AbsInitBillFeeInfoEdit {
    private static final String PREFIX_L = "l";
    private static final BigDecimal MAX_FEE = new BigDecimal("9999999999999.999999");
    private static final BigDecimal MIN_FEE = BigDecimal.ZERO;

    @Override
    String getFeeProp(String srcFeeProp) {
        return PREFIX_L + srcFeeProp;
    }

    @Override
    String getFeeEntryProp() {
        return "loan_feedetail";
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        int parentRowIndex = e.getChangeSet()[0].getParentRowIndex();
        Object newValue = e.getChangeSet()[0].getNewValue();
        switch (propertyName) {
            case "lfeescheme": {
                this.feeSchemeChgEvt(parentRowIndex, rowIndex, (DynamicObject)newValue);
                break;
            }
            case "lfeeoppunit": {
                this.oppUnitChgEvt(rowIndex, (DynamicObject)newValue);
                break;
            }
            case "lfeeoppunittype": {
                this.getModel().setValue("lfeeoppunittext", null, rowIndex);
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"lfeeoppacctbank", null, (int)rowIndex);
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"lfeeoppbebank", null, (int)rowIndex);
                break;
            }
            case "lfeerate": 
            case "lfeeamt": 
            case "lexcrate": {
                this.amtCalChgEvt(parentRowIndex, rowIndex, propertyName);
                break;
            }
            case "drawamount": {
                this.drawAmtCalChgEvt(rowIndex, (BigDecimal)newValue);
                break;
            }
            case "lfeecurrency": {
                this.currencyChgEvt(parentRowIndex, rowIndex);
            }
        }
    }

    private void drawAmtCalChgEvt(int rowIndex, BigDecimal bizAmt) {
        DynamicObject loanInfo = this.getModel().getEntryRowEntity("loanentry", rowIndex);
        DynamicObjectCollection entrys = loanInfo.getDynamicObjectCollection("loan_feedetail");
        for (int i = 0; i < entrys.size(); ++i) {
            DynamicObject entry = (DynamicObject)entrys.get(i);
            BigDecimal lFeeRate = entry.getBigDecimal("lfeerate");
            BigDecimal lFeeAmt = entry.getBigDecimal("lfeeamt");
            if (EmptyUtil.isEmpty((BigDecimal)lFeeRate) && EmptyUtil.isEmpty((BigDecimal)lFeeAmt)) continue;
            if (EmptyUtil.isNoEmpty((BigDecimal)lFeeRate)) {
                BigDecimal feeAmt = bizAmt.multiply(lFeeRate.divide(BigDecimal.valueOf(100L), 6, RoundingMode.HALF_UP));
                if (MIN_FEE.compareTo(feeAmt) > 0 || MAX_FEE.compareTo(feeAmt) < 0) {
                    this.getView().showTipNotification(ResManager.loadResFormat((String)"\u8d39\u7528\u91d1\u989d\u8d85\u51fa\u8303\u56f4\u3002", (String)"AbsInitBillFeeInfoEdit_4", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
                    continue;
                }
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"lfeeamt", (Object)feeAmt, (int)i);
                continue;
            }
            BigDecimal rateAmt = lFeeAmt.multiply(BigDecimal.valueOf(100L)).divide(bizAmt, 6, RoundingMode.HALF_UP);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"lfeerate", (Object)rateAmt, (int)i);
        }
    }
}

