/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.initbill;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.EventObject;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class InitBillLoanUnderwriterEdit
extends AbstractBasePlugIn {
    public void afterBindData(EventObject e) {
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (String[])new String[]{"e_underwritertype", "e_underwriter", "e_underwriteratio", "e_underwriteamount"});
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        EntryProp entryProp = e.getEntryProp();
        if ("underwriter_entry".equals(entryProp.getName())) {
            int rowIndex = e.getRowDataEntities()[0].getRowIndex();
            int parentRowIndex = e.getRowDataEntities()[0].getParentRowIndex();
            if (rowIndex == 0) {
                this.getModel().setValue("e_underwritertype", (Object)"lead", rowIndex, parentRowIndex);
                this.getModel().setValue("e_isbookrunner", (Object)true, rowIndex, parentRowIndex);
            } else {
                this.getModel().setValue("e_underwritertype", (Object)"joint", rowIndex, parentRowIndex);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "e_underwriteratio": 
            case "e_underwriteamount": 
            case "e_isbookrunner": {
                this.underwriteChgEvt(e);
                break;
            }
            case "drawamount": {
                this.amountChgEvt(e);
                break;
            }
        }
    }

    private void amountChgEvt(PropertyChangedArgs e) {
        int row = this.getModel().getEntryRowCount("underwriter_entry");
        this.getModel().beginInit();
        BigDecimal totalAmt = (BigDecimal)e.getChangeSet()[0].getNewValue();
        for (int rowIndex = 0; rowIndex < row; ++rowIndex) {
            BigDecimal ratio = (BigDecimal)this.getModel().getValue("e_underwriteratio", rowIndex);
            this.getModel().setValue("e_underwriteamount", (Object)ratio.multiply(totalAmt).divide(BigDecimal.valueOf(100L), 4, RoundingMode.HALF_UP), rowIndex);
        }
        this.getModel().endInit();
        this.getView().updateView("underwriter_entry");
    }

    private void underwriteChgEvt(PropertyChangedArgs e) {
        DynamicObject currLoanEntry;
        String key = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        int rowIndex = changeData[0].getRowIndex();
        String entityName = changeData[0].getDataEntity().getDynamicObjectType().getName();
        int parentRowIndex = changeData[0].getParentRowIndex();
        BigDecimal totalAmt = BigDecimal.ZERO;
        if ("underwriter_entry".equals(entityName) && EmptyUtil.isNoEmpty((DynamicObject)(currLoanEntry = this.getModel().getEntryRowEntity("loanentry", parentRowIndex)))) {
            totalAmt = currLoanEntry.getBigDecimal("drawamount");
        }
        block5 : switch (key) {
            case "e_underwriteratio": {
                if (totalAmt == null || totalAmt.compareTo(BigDecimal.ZERO) == 0) {
                    TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"e_underwriteamount", (Object)BigDecimal.ZERO, (int)rowIndex, (int)parentRowIndex);
                    break;
                }
                BigDecimal underwriteAmt = totalAmt.multiply((BigDecimal)newValue).divide(BigDecimal.valueOf(100L), 4, RoundingMode.HALF_UP);
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"e_underwriteamount", (Object)underwriteAmt, (int)rowIndex, (int)parentRowIndex);
                break;
            }
            case "e_underwriteamount": {
                BigDecimal underwriteRatio;
                if (totalAmt == null || totalAmt.compareTo(BigDecimal.ZERO) == 0) {
                    TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"e_underwriteratio", (Object)BigDecimal.ZERO, (int)rowIndex, (int)parentRowIndex);
                    return;
                }
                BigDecimal underWriteAmount = (BigDecimal)newValue;
                EntryGrid entryGrid = (EntryGrid)this.getControl("underwriter_entry");
                BigDecimal sum_underWriteAmount = entryGrid.getSum("e_underwriteamount").subtract(underWriteAmount);
                if (underWriteAmount.compareTo(totalAmt.subtract(sum_underWriteAmount)) == 0) {
                    BigDecimal rowIndexRatio = (BigDecimal)this.getModel().getValue("e_underwriteratio", rowIndex);
                    BigDecimal sum_underWriteRatio = entryGrid.getSum("e_underwriteratio").subtract(rowIndexRatio);
                    underwriteRatio = new BigDecimal("100").subtract(sum_underWriteRatio);
                } else {
                    underwriteRatio = underWriteAmount.divide(totalAmt, 4, RoundingMode.HALF_UP).multiply(BigDecimal.valueOf(100L));
                }
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"e_underwriteratio", (Object)underwriteRatio, (int)rowIndex, (int)parentRowIndex);
                break;
            }
            case "e_isbookrunner": {
                boolean isBookrunner = (Boolean)newValue;
                if (!isBookrunner) break;
                int rc = this.getModel().getEntryRowCount("underwriter_entry");
                for (int i = 0; i < rc; ++i) {
                    boolean _isbookrunner = (Boolean)this.getModel().getValue("e_isbookrunner", i, parentRowIndex);
                    if (!_isbookrunner || i == rowIndex) continue;
                    TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"e_isbookrunner", (Object)Boolean.FALSE, (int)i, (int)parentRowIndex);
                    break block5;
                }
                break;
            }
        }
    }
}

