/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.initbill;

import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cfm.common.helper.BondLimitHelper;
import kd.tmc.fbp.common.enums.RepaymentWayEnum;
import kd.tmc.fbp.common.enums.SettleIntModeEnum;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class InitBondBillEdit
extends AbstractBasePlugIn
implements BeforeF7SelectListener {
    private static final Map<String, String> initHeadEntryRelationMap = new HashMap<String, String>(16);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit ratingAgencyEntry = (BasedataEdit)this.getControl("loan_ratingagency");
        if (ratingAgencyEntry != null) {
            ratingAgencyEntry.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        BasedataEdit occupyBondLimit = (BasedataEdit)this.getControl("occupybondlimit");
        occupyBondLimit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit occupyBondLimit_a = (BasedataEdit)this.getControl("occupybondlimit_a");
        occupyBondLimit_a.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String name = event.getProperty().getName();
        if ("occupybondlimit".equals(name) || "occupybondlimit_a".equals(name)) {
            this.filterOccupyBondLimit(event);
        }
        if ("loan_ratingagency".equals(name)) {
            QFilter qFilter = new QFilter("orgtype", "=", (Object)"ratingagency");
            ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
            showParameter.getListFilterParameter().getQFilters().add(qFilter);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        int rows = this.getModel().getEntryRowCount("loanentry");
        switch (propertyName) {
            case "loan_repaymentway": {
                this.loanRepaymentWayChgEvt((String)newValue, rowIndex);
                this.clearRowPlanInfo(rowIndex);
                break;
            }
            case "contractno": 
            case "contractname": 
            case "shortname": 
            case "term": 
            case "ratingagency": 
            case "ratingscale": 
            case "custodianfinorg": 
            case "underwritemethod": 
            case "loanuse": {
                for (int i = 0; i < rows; ++i) {
                    this.setDefaultLoanEntryInfoChgEvt(i, propertyName);
                }
                break;
            }
            case "currency": 
            case "finproduct": 
            case "org": {
                for (int i = 0; i < rows; ++i) {
                    this.getModel().setValue("occupybondlimit", null, i);
                }
                break;
            }
            case "loan_settleintmode": {
                this.settlementChangeEvent(rowIndex);
            }
        }
    }

    private void settlementChangeEvent(int rowIndex) {
        String settleMode = (String)this.getModel().getValue("loan_settleintmode", rowIndex);
        if (!SettleIntModeEnum.isGdpljx((String)settleMode)) {
            this.getModel().setValue("loan_interestsettledplan", null, rowIndex);
        }
    }

    private void clearRowPlanInfo(int rowIndex) {
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"stageplan", (Object)0, (int)rowIndex);
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"interestsettledplan", (Object)0, (int)rowIndex);
    }

    private void loanRepaymentWayChgEvt(String repayWay, int rowIndex) {
        HashSet<String> repayWayLSBQ = new HashSet<String>(5);
        repayWayLSBQ.add(RepaymentWayEnum.bqhblsbq.getValue());
        repayWayLSBQ.add(RepaymentWayEnum.dqhblsbq.getValue());
        repayWayLSBQ.add(RepaymentWayEnum.debx.getValue());
        repayWayLSBQ.add(RepaymentWayEnum.debj.getValue());
        repayWayLSBQ.add(RepaymentWayEnum.dbdx.getValue());
        HashSet<String> repayWayFIX = new HashSet<String>(2);
        repayWayFIX.add(RepaymentWayEnum.dqhbdqhx.getValue());
        repayWayFIX.add(RepaymentWayEnum.bqhbdqhx.getValue());
        if (repayWayLSBQ.contains(repayWay)) {
            this.getModel().setValue("loan_settleintmode", (Object)SettleIntModeEnum.lsbq.getValue(), rowIndex);
        } else if (repayWayFIX.contains(repayWay)) {
            this.getModel().setValue("loan_settleintmode", (Object)SettleIntModeEnum.gdpljx.getValue(), rowIndex);
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        EntryProp entryProp = e.getEntryProp();
        String entryName = entryProp.getName();
        if ("loanentry".equals(entryName)) {
            for (RowDataEntity row : e.getRowDataEntities()) {
                int index = row.getRowIndex();
                if (index < 0) continue;
                this.setDefaultLoanEntryInfoChgEvt(index, "contractno", "contractname", "shortname", "term", "ratingagency", "ratingscale", "debtratingscale", "custodianfinorg", "underwritemethod", "loanuse");
                this.loanRepaymentWayChgEvt(RepaymentWayEnum.bqhbdqhx.getValue(), index);
            }
        }
    }

    private void setDefaultLoanEntryInfoChgEvt(int index, String ... fields) {
        for (String field : fields) {
            if (!EmptyUtil.isEmpty((Object)this.getModel().getValue(initHeadEntryRelationMap.get(field), index))) continue;
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)initHeadEntryRelationMap.get(field), (Object)this.getModel().getValue(field), (int)index);
        }
    }

    private void filterOccupyBondLimit(BeforeF7SelectEvent event) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        DynamicObject finproduct = (DynamicObject)this.getModel().getValue("finproduct");
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        Date bizdate = (Date)this.getModel().getValue("loaddate", event.getRow());
        if (EmptyUtil.isEmpty((DynamicObject)org)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53d1\u884c\u4eba\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BondLoanBillEdit_11", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
            event.setCancel(true);
            return;
        }
        if (EmptyUtil.isEmpty((DynamicObject)finproduct)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u503a\u5238\u54c1\u79cd\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BondLoanBillEdit_13", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
            event.setCancel(true);
            return;
        }
        if (EmptyUtil.isEmpty((DynamicObject)currency)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53d1\u884c\u5e01\u79cd\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BondLoanBillEdit_14", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
            event.setCancel(true);
            return;
        }
        if (EmptyUtil.isEmpty((Object)bizdate)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53d1\u884c\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BondLoanBillEdit_15", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
            event.setCancel(true);
            return;
        }
        ListFilterParameter listFilterParameter = ((ListShowParameter)event.getFormShowParameter()).getListFilterParameter();
        List qFilters = listFilterParameter.getQFilters();
        qFilters.add(BondLimitHelper.getBondlimitFilter((Long)org.getLong("id"), (Long)currency.getLong("id"), (Long)finproduct.getLong("id"), (Date)bizdate));
        event.getFormShowParameter().setCloseCallBack(new CloseCallBack((IFormPlugin)this, "occupybondlimit"));
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        ListSelectedRowCollection selectedRows;
        super.closedCallBack(event);
        String key = event.getActionId();
        if ("occupybondlimit".equals(key) && EmptyUtil.isNoEmpty((Object)(selectedRows = (ListSelectedRowCollection)event.getReturnData())) && selectedRows.size() > 0) {
            ListSelectedRow listSelectedRow = selectedRows.get(0);
            Object primaryKeyValue = listSelectedRow.getPrimaryKeyValue();
            DynamicObject limit = QueryServiceHelper.queryOne((String)"bdim_bond_limit", (String)"availamt", (QFilter[])new QFilter[]{new QFilter("id", "=", primaryKeyValue)});
            BigDecimal drawAmount = (BigDecimal)this.getModel().getValue("drawamount");
            if (drawAmount.compareTo(limit.getBigDecimal("availamt")) > 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ef\u7528\u989d\u5ea6\u4e0d\u8db3\uff0c\u8bf7\u9009\u62e9\u5176\u5b83\u6ce8\u518c\u989d\u5ea6\u3002", (String)"BondLoanBillEdit_30", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
            } else {
                this.getModel().setValue("occupybondlimit", primaryKeyValue);
            }
        }
    }

    static {
        initHeadEntryRelationMap.put("contractno", "loan_contractno");
        initHeadEntryRelationMap.put("contractname", "loan_contractname");
        initHeadEntryRelationMap.put("shortname", "loan_shortname");
        initHeadEntryRelationMap.put("term", "loanterm");
        initHeadEntryRelationMap.put("ratingagency", "loan_ratingagency");
        initHeadEntryRelationMap.put("ratingscale", "loan_ratingscale");
        initHeadEntryRelationMap.put("debtratingscale", "loan_debtratingscale");
        initHeadEntryRelationMap.put("custodianfinorg", "loan_custodianfinorg");
        initHeadEntryRelationMap.put("underwritemethod", "loan_underwritemethod");
        initHeadEntryRelationMap.put("loanuse", "loan_use");
    }
}

