/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.interestbill;

import java.util.EventObject;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cfm.common.repository.RepaymentBillRepository;
import kd.tmc.fbp.common.helper.TmcAccountHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class IntBillModifyAccountPlugin
extends AbstractBasePlugIn
implements BeforeF7SelectListener {
    private static final String INTERESTBILL_PROP = "id,billno,billstatus,org,instbillctg,loanbillno,repaymentid,contractno,contractbillno";
    private static final String INVEST_INTERESTBILL_PROP = "id,billno,billstatus,org,instbillctg,loanbillno,repaymentid,contractno,contractbillno,loaneracctbank";
    private static final String CFM_INTERESTBILL_PROP = "id,billno,billstatus,org,instbillctg,loanbillno,repaymentid,contractno,contractbillno,instbankacct";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit interestAccount = (BasedataEdit)this.getControl("interestaccount");
        interestAccount.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.loadInterestAccountDefault();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String property = e.getProperty().getName();
        if ("interestaccount".equals(property)) {
            DynamicObject interestAccount = (DynamicObject)this.getModel().getValue("interestaccount");
            if (EmptyUtil.isEmpty((DynamicObject)interestAccount)) {
                return;
            }
            this.getModel().setValue("interestbank", interestAccount.get("bank.name"));
            this.getModel().setDataChanged(false);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        if ("ok".equals(args.getOperateKey())) {
            DynamicObject interestAccount = (DynamicObject)this.getModel().getValue("interestaccount");
            if (EmptyUtil.isEmpty((DynamicObject)interestAccount)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ed8\u606f\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"IntBillModifyAccountPlugin_1", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
                return;
            }
            String formId = (String)this.getView().getFormShowParameter().getCustomParam("billFormId");
            Object intBillId = this.getView().getFormShowParameter().getCustomParam("pkId");
            DynamicObject interestBill = TmcDataServiceHelper.loadSingle((Object)intBillId, (String)"cfm_interestbill");
            if ("cim_invest_interestbill".equals(formId)) {
                interestBill = TmcDataServiceHelper.loadSingle((Object)intBillId, (String)"cim_invest_interestbill");
            }
            if (EmptyUtil.isEmpty((DynamicObject)interestBill)) {
                return;
            }
            if ("cim_invest_interestbill".equals(formId)) {
                interestBill.set("loaneracctbank", (Object)interestAccount);
            } else {
                interestBill.set("instbankacct", (Object)interestAccount);
            }
            SaveServiceHelper.update((DynamicObject)interestBill);
            this.getView().close();
        }
    }

    private void loadInterestAccountDefault() {
        DynamicObject accountBank;
        Object intBillId = this.getView().getFormShowParameter().getCustomParam("pkId");
        if (EmptyUtil.isEmpty((Object)intBillId)) {
            return;
        }
        String formId = (String)this.getView().getFormShowParameter().getCustomParam("billFormId");
        DynamicObject interestBill = TmcDataServiceHelper.loadSingle((Object)intBillId, (String)"cfm_interestbill", (String)CFM_INTERESTBILL_PROP);
        DynamicObject dynamicObject = accountBank = EmptyUtil.isEmpty((DynamicObject)interestBill) ? null : interestBill.getDynamicObject("instbankacct");
        if ("cim_invest_interestbill".equals(formId)) {
            interestBill = TmcDataServiceHelper.loadSingle((Object)intBillId, (String)"cim_invest_interestbill", (String)INVEST_INTERESTBILL_PROP);
            DynamicObject dynamicObject2 = accountBank = EmptyUtil.isEmpty((DynamicObject)interestBill) ? null : interestBill.getDynamicObject("loaneracctbank");
        }
        if (accountBank != null) {
            this.getModel().setValue("interestaccount", (Object)accountBank);
            this.getModel().setValue("interestbank", accountBank.get("bank.name"));
            return;
        }
        Object repaymentId = interestBill.get("repaymentid");
        if (EmptyUtil.isEmpty((Object)repaymentId)) {
            return;
        }
        DynamicObject repaymentBill = RepaymentBillRepository.loadSingle((Object)repaymentId, (String)"id,billno,accountbank");
        if (EmptyUtil.isEmpty((DynamicObject)repaymentBill)) {
            return;
        }
        accountBank = repaymentBill.getDynamicObject("accountbank");
        if (EmptyUtil.isNoEmpty((DynamicObject)accountBank)) {
            this.getModel().setValue("interestaccount", (Object)accountBank);
            this.getModel().setValue("interestbank", accountBank.get("bank.name"));
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "interestaccount": {
                Object intBillId = this.getView().getFormShowParameter().getCustomParam("pkId");
                DynamicObject interestBill = TmcDataServiceHelper.loadSingle((Object)intBillId, (String)"cfm_interestbill", (String)INTERESTBILL_PROP);
                long orgId = EmptyUtil.isEmpty((DynamicObject)interestBill) || EmptyUtil.isEmpty((DynamicObject)interestBill.getDynamicObject("org")) ? 0L : interestBill.getDynamicObject("org").getLong("id");
                QFilter qFilter = new QFilter("acctstatus", "in", (Object)new String[]{"normal", "freeze"}).and(TmcAccountHelper.getAccountBankFilterByOrg((Long)orgId));
                ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter().setFilter(qFilter);
            }
        }
    }
}

