/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.interestbill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.DBServiceHelper;
import kd.tmc.fbp.common.bean.CalcBasisInfo;
import kd.tmc.fbp.common.enums.BasisEnum;
import kd.tmc.fbp.common.enums.IntCalMethodEnum;
import kd.tmc.fbp.common.enums.IntHTRuleEnum;
import kd.tmc.fbp.common.enums.IntPrincipleRuleEnum;
import kd.tmc.fbp.common.enums.RepaySchemeEnum;
import kd.tmc.fbp.common.enums.RepaymentWayEnum;
import kd.tmc.fbp.common.enums.RoundRuleEnum;
import kd.tmc.fbp.common.enums.SettleIntModeEnum;
import kd.tmc.fbp.common.helper.MarketDataServiceHelper;
import kd.tmc.fbp.common.helper.TermHelper;
import kd.tmc.fbp.common.model.interest.BizBillInfo;
import kd.tmc.fbp.common.model.interest.IntBillDetailInfo;
import kd.tmc.fbp.common.model.interest.IntBillInfo;
import kd.tmc.fbp.common.model.interest.IntCalRequest;
import kd.tmc.fbp.common.model.interest.PlanCallResult;
import kd.tmc.fbp.common.model.interest.RateInfo;
import kd.tmc.fbp.common.model.interest.RepayPlanCallRequest;
import kd.tmc.fbp.common.model.interest.RepaySchemeInfo;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.ListUtils;
import kd.tmc.fbp.service.factory.IntCallFactory;
import kd.tmc.fbp.service.factory.PlanCallStragetyFactory;
import kd.tmc.fbp.service.inst.interest.IIntCallStragety;

public class IntCallToolPlugin
extends AbstractFormPlugin {
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        AbstractOperate op = (AbstractOperate)args.getSource();
        switch (op.getOperateKey()) {
            case "rate": {
                this.initRate();
                break;
            }
            case "repay": {
                this.callRepayPlan();
                break;
            }
            case "int": {
                this.callInt();
                break;
            }
        }
    }

    private void initRate() {
        Date beginDate = (Date)this.getModel().getValue("intdate");
        Date endDate = (Date)this.getModel().getValue("expiredate");
        DynamicObject referRate = (DynamicObject)this.getModel().getValue("refer");
        Map rateDatas = MarketDataServiceHelper.referRate((String)referRate.getString("number"), (Date)beginDate, (Date)endDate);
        this.getModel().deleteEntryData("ratelist");
        rateDatas.forEach((bizdate, rate) -> {
            int index = this.getModel().createNewEntryRow("ratelist");
            this.getModel().setValue("effectdate", bizdate, index);
            this.getModel().setValue("referrate", rate, index);
        });
    }

    private List<PlanCallResult> createRepayPlan() {
        String offetDay;
        IDataModel model = this.getModel();
        RepayPlanCallRequest request = new RepayPlanCallRequest();
        request.setBeginDate((Date)model.getValue("loandate")).setEndDate((Date)model.getValue("expiredate")).setRepayWay(RepaymentWayEnum.getByValue((String)((String)model.getValue("repayway")))).setBalance((BigDecimal)model.getValue("amount")).setFixedRepayAmount((BigDecimal)model.getValue("fixamount"));
        DynamicObject repaysSheme = (DynamicObject)model.getValue("repayscheme");
        String period = repaysSheme.getString("period");
        RepaySchemeEnum repaySchemeEnum = RepaySchemeEnum.trans2RepaySchemeEnum((String)period);
        RepaySchemeInfo schemeInfo = new RepaySchemeInfo();
        schemeInfo.setRepayScheme(repaySchemeEnum);
        schemeInfo.setRepayMonths(ListUtils.strToIntList((String)repaysSheme.getString("month")));
        String day = repaysSheme.getString("day");
        if (EmptyUtil.isNotBlank((CharSequence)day)) {
            schemeInfo.setRepayDay(Integer.valueOf(Integer.parseInt(day)));
        }
        if (EmptyUtil.isNotBlank((CharSequence)(offetDay = repaysSheme.getString("offetday")))) {
            schemeInfo.setOffetDay(Integer.valueOf(Integer.parseInt(offetDay)));
        }
        schemeInfo.setRepayMonthSettle(Boolean.valueOf(repaysSheme.getBoolean("drawmonthsettle")));
        request.setSchemeInfo(schemeInfo);
        request.setAmountRound(Integer.valueOf(RoundRuleEnum.valueOf((String)((String)this.getModel().getValue("round"))).getRound()));
        DynamicObject currency = (DynamicObject)model.getValue("currency");
        if (currency != null) {
            request.setAmountScale(Integer.valueOf(currency.getInt("amtprecision")));
        }
        return PlanCallStragetyFactory.createRepayPlanCallStragety().createPlan(request);
    }

    private void callRepayPlan() {
        List<PlanCallResult> repayPlanList = this.createRepayPlan();
        this.fillRepayPlanList(repayPlanList);
        Date beginDate = (Date)this.getModel().getValue("intdate");
        Date endDate = (Date)this.getModel().getValue("expiredate");
        this.getModel().deleteEntryData("entrys");
        for (BasisEnum basis : BasisEnum.values()) {
            int index = this.getModel().createNewEntryRow("entrys");
            this.getModel().setValue("basis_t", (Object)basis.getName(), index);
            this.getModel().setValue("bdate", (Object)beginDate, index);
            this.getModel().setValue("edate", (Object)endDate, index);
            this.getModel().setValue("basis_tv", (Object)TermHelper.getBaseBasis((Date)beginDate, (Date)endDate, (BasisEnum)basis, null), index);
        }
    }

    private void fillRepayPlanList(List<PlanCallResult> repayPlanList) {
        this.getModel().deleteEntryData("repaybill");
        for (PlanCallResult repayPlan : repayPlanList) {
            int index = this.getModel().createNewEntryRow("repaybill");
            this.getModel().setValue("repaydate", (Object)repayPlan.getBizDate(), index);
            this.getModel().setValue("repayamt", (Object)repayPlan.getPrinciple(), index);
        }
    }

    private List<PlanCallResult> callIntPlan() {
        IDataModel model = this.getModel();
        Date beginDate = (Date)model.getValue("intdate");
        Date endDate = (Date)model.getValue("expiredate");
        List<PlanCallResult> repayPlanList = this.getAllRepayPlanList();
        RepayPlanCallRequest callRequest = new RepayPlanCallRequest();
        callRequest.setBeginDate(beginDate).setEndDate(endDate).setRepayWay(RepaymentWayEnum.valueOf((String)((String)model.getValue("repayway")))).setBalanceList(repayPlanList).setSettleIntMode(SettleIntModeEnum.gdpljx);
        RepaySchemeInfo schemeInfo = new RepaySchemeInfo();
        DynamicObject intScheme = (DynamicObject)model.getValue("intscheme");
        schemeInfo.setRepayScheme(RepaySchemeEnum.getByValue((String)intScheme.getString("intereststpd")));
        schemeInfo.setRepayMonths(ListUtils.strToIntList((String)intScheme.getString("intereststmh")));
        String day = intScheme.getString("intereststday");
        if (EmptyUtil.isNotBlank((CharSequence)day)) {
            schemeInfo.setRepayDay(Integer.valueOf(Integer.parseInt(day)));
        }
        schemeInfo.setOffetDay(Integer.valueOf(intScheme.getInt("offetday")));
        schemeInfo.setRepayMonthSettle(Boolean.valueOf(intScheme.getBoolean("drawmonthsettle")));
        callRequest.setSchemeInfo(schemeInfo);
        return PlanCallStragetyFactory.createIntPlanCallStragety().createPlan(callRequest);
    }

    private void callInt() {
        Set<RateInfo> rateList = this.getRateList();
        Date intDate = (Date)this.getModel().getValue("intdate");
        Date beginDate = (Date)this.getModel().getValue("intdate");
        BigDecimal balance = (BigDecimal)this.getModel().getValue("amount");
        List<PlanCallResult> repayPlanList = this.getAllRepayPlanList();
        List<PlanCallResult> intPlanList = this.callIntPlan();
        ArrayList<IntBillInfo> list = new ArrayList<IntBillInfo>(10);
        RepaymentWayEnum repayWay = RepaymentWayEnum.valueOf((String)((String)this.getModel().getValue("repayway")));
        for (int period = 1; period <= intPlanList.size(); ++period) {
            PlanCallResult plan = intPlanList.get(period - 1);
            Date endDate = plan.getBizDate();
            IntCalRequest request = new IntCalRequest();
            request.setRepayList(repayPlanList);
            BizBillInfo bizBill = this.getBizBill(balance, intDate, beginDate, endDate, period);
            request.setBizBill(bizBill);
            request.setRateList(rateList);
            IIntCallStragety stragety = IntCallFactory.getInstance((RepaymentWayEnum)bizBill.getRepayWay());
            IntBillInfo intBill = stragety.callInt(request);
            if (EmptyUtil.isNoEmpty((Object)intBill) && EmptyUtil.isNoEmpty((Object)intBill.getDetails())) {
                BigDecimal principle = ((IntBillDetailInfo)intBill.getDetails().get(0)).getPrinciple();
                plan.setPrinciple(principle);
                if (RepaymentWayEnum.debx == repayWay) {
                    repayPlanList.get(period - 1).setPrinciple(principle);
                    this.getModel().setValue("repayamt", (Object)principle, period - 1);
                }
            }
            list.add(intBill);
            beginDate = endDate;
        }
        this.fillIntPlanList(list, repayWay);
    }

    private Set<RateInfo> getRateList() {
        HashSet<RateInfo> rateList = new HashSet<RateInfo>();
        BigDecimal startIntRate = (BigDecimal)this.getModel().getValue("startloanrate");
        if (EmptyUtil.isNoEmpty((BigDecimal)startIntRate)) {
            RateInfo info = new RateInfo();
            info.setEffectiveDate((Date)this.getModel().getValue("intdate"));
            info.setRate(startIntRate);
            rateList.add(info);
        } else {
            DynamicObjectCollection rates = this.getModel().getEntryEntity("ratelist");
            for (DynamicObject rate : rates) {
                RateInfo info = new RateInfo();
                info.setEffectiveDate(rate.getDate("effectdate"));
                info.setRate(rate.getBigDecimal("referrate"));
                rateList.add(info);
            }
        }
        return rateList;
    }

    private List<PlanCallResult> getAllRepayPlanList() {
        ArrayList<PlanCallResult> repayPlanList = new ArrayList<PlanCallResult>();
        DynamicObjectCollection colls = this.getModel().getEntryEntity("repaybill");
        for (DynamicObject repayPlan : colls) {
            PlanCallResult info = new PlanCallResult();
            info.setBizDate(repayPlan.getDate("repaydate"));
            info.setPrinciple(repayPlan.getBigDecimal("repayamt"));
            repayPlanList.add(info);
        }
        return repayPlanList;
    }

    private BizBillInfo getBizBill(BigDecimal balance, Date intDate, Date lastIntDate, Date endDate, int period) {
        IDataModel model = this.getModel();
        BizBillInfo bizBill = new BizBillInfo();
        bizBill.setLoanAmount(balance);
        bizBill.setBeginDate(lastIntDate);
        bizBill.setEndDate(endDate);
        bizBill.setRepayWay(RepaymentWayEnum.valueOf((String)((String)model.getValue("repayway"))));
        bizBill.setBasis(BasisEnum.valueOf((String)((String)model.getValue("basis"))));
        bizBill.setPrincipleRule(IntPrincipleRuleEnum.valueOf((String)((String)model.getValue("principlerule"))));
        bizBill.setHtRule(IntHTRuleEnum.valueOf((String)((String)model.getValue("htrule"))));
        bizBill.setIntSchemeId(((DynamicObject)model.getValue("intscheme")).getLong("id"));
        bizBill.setRepaySchemeId(((DynamicObject)model.getValue("repayscheme")).getLong("id"));
        bizBill.setRound(RoundRuleEnum.valueOf((String)((String)model.getValue("round"))));
        bizBill.setIntCalMethod(IntCalMethodEnum.valueOf((String)((String)model.getValue("intcalmethod"))));
        bizBill.setCurrencyId(((DynamicObject)model.getValue("currency")).getLong("id"));
        bizBill.setPeriod(period);
        bizBill.setStartIntDate(intDate);
        return bizBill;
    }

    private void fillIntPlanList(List<IntBillInfo> intBills, RepaymentWayEnum repayWay) {
        IDataModel model = this.getModel();
        model.deleteEntryData("intbill");
        model.deleteEntryData("detail");
        Date startIntDate = (Date)this.getModel().getValue("intdate");
        DynamicObjectCollection colls = model.getEntryEntity("intbill");
        for (int index = 0; index < intBills.size(); ++index) {
            IntBillInfo intBill = intBills.get(index);
            if (intBill == null) continue;
            DynamicObject info = colls.addNew();
            info.set("id", (Object)DBServiceHelper.genGlobalLongId());
            info.set("payintdate", (Object)intBill.getBizDate());
            info.set("totalamt", (Object)intBill.getAmount());
            DynamicObjectCollection entrys = info.getDynamicObjectCollection("detail");
            for (IntBillDetailInfo detail : intBill.getDetails()) {
                DynamicObject entry = entrys.addNew();
                entry.set("begindate", (Object)detail.getBeginDate());
                entry.set("enddate", (Object)detail.getEndDate());
                entry.set("days", (Object)detail.getDays());
                entry.set("principle", (Object)detail.getPrinciple());
                entry.set("intrate", (Object)detail.getRate());
                entry.set("intdays", (Object)detail.getDays());
                entry.set("intamount", (Object)detail.getAmount());
                BasisEnum basis = BasisEnum.valueOf((String)((String)model.getValue("basis")));
                CalcBasisInfo basisInfo = TermHelper.getBaseBasisInfo((Date)detail.getBeginDate(), (Date)detail.getEndDate(), (BasisEnum)basis, (Date)startIntDate, null);
                entry.set("basis_v", (Object)basisInfo.getBasisAmt());
                if (!RepaymentWayEnum.isHbfx((String)repayWay.getValue())) continue;
                entry.set("allamt", (Object)detail.getAmount().add((BigDecimal)model.getValue("repayamt", index)));
            }
        }
        for (int i = 0; i < intBills.size(); ++i) {
            model.createNewEntryRow("intbill", (DynamicObject)colls.get(i));
            model.setValue("totalamt", (Object)intBills.get(i).getAmount(), i);
        }
        this.getView().updateView("intbill");
    }
}

