/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.interestbill;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.tmc.cfm.common.enums.DataSourceEnum;
import kd.tmc.cfm.common.helper.CfmBillCommonHelper;
import kd.tmc.cfm.common.helper.FormParameterHelper;
import kd.tmc.cfm.common.resource.AbstractBizResource;
import kd.tmc.cfm.common.resource.BizResourceFactory;
import kd.tmc.cfm.formplugin.common.CfmPush2PayFormOrListHelper;
import kd.tmc.cfm.formplugin.common.CommonBillFormHelper;
import kd.tmc.cfm.formplugin.helper.CfmFormHelper;
import kd.tmc.cfm.formplugin.loanbill.LoanBillFormHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.CreditorTypeEnum;
import kd.tmc.fbp.common.enums.RepaymentWayEnum;
import kd.tmc.fbp.common.helper.TmcAccountHelper;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.model.interest.IntBillDetailExtInfo;
import kd.tmc.fbp.common.model.interest.IntBillExtInfo;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class InterestBillEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        TextEdit loanBill = (TextEdit)this.getControl("loanbillno");
        loanBill.addButtonClickListener((ClickListener)this);
        BasedataEdit intBankAcct = (BasedataEdit)this.getControl("instbankacct");
        this.addBeforeF7Select(intBankAcct);
        BasedataEdit lendDrAccount = (BasedataEdit)this.getControl("lenddraccount");
        this.addBeforeF7Select(lendDrAccount);
        BasedataEdit lendCrAccount = (BasedataEdit)this.getControl("lendcraccount");
        this.addBeforeF7Select(lendCrAccount);
        BasedataEdit loanDrAccount = (BasedataEdit)this.getControl("loandraccount");
        this.addBeforeF7Select(loanDrAccount);
        BasedataEdit loanCrAccount = (BasedataEdit)this.getControl("loancraccount");
        this.addBeforeF7Select(loanCrAccount);
        BasedataEdit currency = (BasedataEdit)this.getControl("currency");
        this.addBeforeF7Select(currency);
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        CfmBillCommonHelper.PreOpenPageDeal((PreOpenFormEventArgs)e, (boolean)false);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "instbankacct": 
            case "loaneracctbank": {
                this.acctBankF7Evt(evt);
                break;
            }
            case "lenddraccount": 
            case "lendcraccount": 
            case "loandraccount": 
            case "loancraccount": {
                CommonBillFormHelper.setAccountF7Evt(evt, this.getModel(), this.getView());
                break;
            }
            case "currency": {
                String loanBillNo = (String)this.getModel().getValue("loanbillno");
                DynamicObject loanBill = TmcDataServiceHelper.loadSingle((String)"cfm_loanbill", (String)"id, productfactory", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)loanBillNo)});
                if (EmptyUtil.isEmpty((DynamicObject)loanBill)) {
                    return;
                }
                LoanBillFormHelper.currencyF7Evt(evt, this.getModel(), this.getView(), loanBill.getDynamicObject("productfactory"));
                break;
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getModel().setValue("org", null);
        this.getModel().setValue("creditorg", null);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IDataModel model = this.getModel();
        DynamicObject dataEntity = model.getDataEntity();
        boolean isChanged = model.getDataChanged();
        this.initIntDate();
        this.initIntYearRate(model, dataEntity);
        this.getModel().setDataChanged(isChanged);
        this.initOverseaEntFillData();
        this.initRateEnable();
        CfmFormHelper.setUnlockPayAmt(this.getModel(), "actualinstamt");
    }

    private void initRateEnable() {
        boolean isDiffCurrency;
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        DynamicObject loanCurrency = (DynamicObject)this.getModel().getValue("loancurrency");
        boolean bl = isDiffCurrency = currency != null && loanCurrency != null && !currency.getPkValue().equals(loanCurrency.getPkValue());
        if (isDiffCurrency) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"convertrate"});
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{"convertrate"});
        }
    }

    private void initIntYearRate(IDataModel model, DynamicObject dataEntity) {
        if (EmptyUtil.isEmpty((BigDecimal)dataEntity.getBigDecimal("intyearrate"))) {
            BigDecimal predictInstAmt = dataEntity.getBigDecimal("predictinstamt");
            BigDecimal intYearRate = this.getIntYearRate(dataEntity, dataEntity.getBigDecimal("actualinstamt"), predictInstAmt);
            model.setValue("intyearrate", (Object)intYearRate);
            model.setValue("preintyearrate", (Object)this.getIntYearRate(dataEntity, predictInstAmt, predictInstAmt));
        }
    }

    protected void initIntDate() {
        Long loanId = (Long)this.getModel().getValue("sourcebillid");
        if (EmptyUtil.isEmpty((Long)loanId)) {
            return;
        }
        DynamicObject loanBillDO = TmcDataServiceHelper.loadSingle((Object)loanId, (String)"cfm_loanbill", (String)"id,issofrrate,productfactory,endinstdate,startintdate,isoverseaentfill");
        String billstatus = (String)this.getModel().getValue("billstatus");
        Boolean isOverseaEntFill = loanBillDO.getBoolean("isoverseaentfill");
        if (BillStatusEnum.SAVE.getValue().equals(billstatus) && (OperationStatus.EDIT.getValue() == this.getView().getFormShowParameter().getStatus().getValue() || BillOperationStatus.EDIT.getValue() == ((BillShowParameter)this.getView().getFormShowParameter()).getBillStatus().getValue() || OperationStatus.ADDNEW.getValue() == this.getView().getFormShowParameter().getStatus().getValue() && EmptyUtil.isNoEmpty((DynamicObject)loanBillDO))) {
            Date endinstDate = loanBillDO.getDate("endinstdate");
            if (EmptyUtil.isNoEmpty((Object)endinstDate)) {
                String endinstDateStr = DateUtils.formatString((Date)endinstDate, (String)"yyyyMMdd");
                Date newStartInstDate = DateUtils.getNextDay((Date)endinstDate, (int)1);
                String newStartInstDateStr = DateUtils.formatString((Date)newStartInstDate, (String)"yyyyMMdd");
                List<String> newStartInstDateStrVals = Arrays.asList(endinstDateStr, newStartInstDateStr);
                Date pageStartInstDate = (Date)this.getModel().getValue("startinstdate");
                if (EmptyUtil.isNoEmpty((Object)pageStartInstDate)) {
                    DynamicObject bizBill = this.getModel().getDataEntity();
                    String pageStartInstDateStr = DateUtils.formatString((Date)pageStartInstDate, (String)"yyyyMMdd");
                    AbstractBizResource bizResource = new BizResourceFactory().getBizResource(bizBill.getString("datasource"));
                    if (!newStartInstDateStrVals.contains(pageStartInstDateStr)) {
                        if (!isOverseaEntFill.booleanValue()) {
                            this.getModel().setValue("startinstdate", (Object)newStartInstDate);
                        }
                        this.getModel().setValue("predictinstamt", (Object)0);
                        this.getModel().deleteEntryData("entrys");
                        this.getView().showTipNotification(bizResource.getIbStartinstDateHaschange(), Integer.valueOf(6000));
                    }
                }
            } else {
                Date startDate = (Date)this.getModel().getValue("startinstdate");
                if (EmptyUtil.isEmpty((Object)startDate)) {
                    startDate = loanBillDO.getDate("startintdate");
                    if (!isOverseaEntFill.booleanValue()) {
                        this.getModel().setValue("startinstdate", (Object)startDate);
                    }
                }
            }
        }
        this.setEntryColumnVisibleForSofr(loanBillDO);
    }

    private void setEntryColumnVisibleForSofr(DynamicObject loanBillDO) {
        boolean isSofrRate = loanBillDO.getBoolean("issofrrate");
        this.getControl("entrys").getView().setVisible(Boolean.valueOf(isSofrRate), new String[]{"confirmratedate", "lookdays", "totalint", "lasttotalint", "curtotalint"});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        CfmPush2PayFormOrListHelper.formPush2PayForwardValid(args, this.getView());
        if ("calinterest".equals(operateKey)) {
            String formId = this.getView().getFormShowParameter().getFormId();
            String dataSource = DataSourceEnum.CFM.getValue();
            if ("cfm_interestbill_bond".equals(formId)) {
                dataSource = DataSourceEnum.BOND.getValue();
            } else if ("cim_invest_interestbill".equals(formId)) {
                dataSource = DataSourceEnum.INVEST.getValue();
            }
            if (EmptyUtil.isEmpty((Object)this.getModel().getValue("loanbillno"))) {
                this.getView().showTipNotification(new BizResourceFactory().getBizResource(dataSource).getIbMustChooseloanno());
                args.setCancel(true);
            }
            if (EmptyUtil.isEmpty((Object)this.getModel().getValue("bizdate"))) {
                this.getView().showTipNotification(new BizResourceFactory().getBizResource(dataSource).getIbMustChooseBizDate());
                args.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        OperationResult opResult = args.getOperationResult();
        if (opResult == null || !opResult.isSuccess()) {
            return;
        }
        switch (args.getOperateKey()) {
            case "calinterest": {
                this.getView().updateView();
                break;
            }
            case "trackrepayment": {
                this.track2RepaymentBill();
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String fieldKey = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        IDataModel model = this.getModel();
        DynamicObject dataEntity = model.getDataEntity(true);
        switch (fieldKey) {
            case "bizdate": {
                if (!EmptyUtil.isNoEmpty((Object)newValue)) break;
                model.setValue("actualinstamt", (Object)0);
                model.setValue("endinstdate", (Object)DateUtils.getLastDay((Date)((Date)newValue), (int)1));
                model.deleteEntryData("entrys");
                model.setValue("predictinstamt", (Object)0);
                break;
            }
            case "calcoverint": {
                BigDecimal preIntAmt = dataEntity.getBigDecimal("predictinstamt");
                this.getView().invokeOperation("calinterest");
                BigDecimal newPreIntAmt = dataEntity.getBigDecimal("predictinstamt");
                if (preIntAmt.equals(newPreIntAmt)) break;
                model.setValue("actualinstamt", (Object)newPreIntAmt);
                break;
            }
            case "instamt": {
                this.instAmtChgEvt();
                break;
            }
            case "actualinstamt": {
                BigDecimal intYearRate = this.getIntYearRate(dataEntity, (BigDecimal)newValue, dataEntity.getBigDecimal("predictinstamt"));
                model.setValue("intyearrate", (Object)intYearRate);
                this.getView().updateView("intyearrate");
                this.setConvertIntAmt();
                CfmFormHelper.setUnlockPayAmt(this.getModel(), "actualinstamt");
                break;
            }
            case "predictinstamt": {
                BigDecimal intYearRate = this.getIntYearRate(dataEntity, (BigDecimal)newValue, dataEntity.getBigDecimal("predictinstamt"));
                model.setValue("preintyearrate", (Object)intYearRate);
                break;
            }
            case "currency": {
                this.payCurrencyChg(e);
                break;
            }
            case "convertrate": {
                this.convertRateChgEvt(e);
                break;
            }
            case "combineinst": 
            case "isrelcash": 
            case "instbillctg": {
                CfmFormHelper.setUnlockPayAmt(this.getModel(), "actualinstamt");
                break;
            }
        }
    }

    private void convertRateChgEvt(PropertyChangedArgs e) {
        BigDecimal newRate = (BigDecimal)e.getChangeSet()[0].getNewValue();
        if (newRate.compareTo(BigDecimal.ZERO) <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6c47\u7387\u5fc5\u987b\u5927\u4e8e0\u3002", (String)"LoanBillEdit_14", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
            return;
        }
        BigDecimal preDictInstAmt = (BigDecimal)this.getModel().getValue("predictinstamt");
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        this.getModel().setValue("actualinstamt", (Object)preDictInstAmt.divide(newRate, currency.getInt("amtprecision"), RoundingMode.HALF_UP));
        this.getModel().setValue("convertintamt", (Object)preDictInstAmt);
    }

    private void setConvertIntAmt() {
        BigDecimal convertRate = (BigDecimal)this.getModel().getValue("convertrate");
        convertRate = convertRate.compareTo(BigDecimal.ZERO) > 0 ? convertRate : BigDecimal.ONE;
        BigDecimal actualInstAmt = (BigDecimal)this.getModel().getValue("actualinstamt");
        this.getModel().setValue("convertintamt", (Object)actualInstAmt.multiply(convertRate));
    }

    private void payCurrencyChg(PropertyChangedArgs e) {
        BigDecimal rate;
        boolean isDiffCurrency;
        DynamicObject currency = (DynamicObject)e.getChangeSet()[0].getNewValue();
        DynamicObject oldCurrency = (DynamicObject)e.getChangeSet()[0].getOldValue();
        DynamicObject loanCurrency = (DynamicObject)this.getModel().getValue("loancurrency");
        boolean bl = isDiffCurrency = currency != null && loanCurrency != null && oldCurrency != null && !currency.getPkValue().equals(oldCurrency.getPkValue());
        if (isDiffCurrency) {
            DynamicObject company = (DynamicObject)this.getModel().getValue("org");
            String datasource = (String)this.getModel().getValue("datasource");
            if (DataSourceEnum.INVEST.getValue().equals(datasource)) {
                company = (DynamicObject)this.getModel().getValue("creditorg");
            }
            if (currency.getPkValue().equals(loanCurrency.getPkValue())) {
                rate = BigDecimal.ONE;
                this.getView().setEnable(Boolean.FALSE, new String[]{"convertrate"});
            } else {
                rate = TmcBusinessBaseHelper.getExchangeRateNew((long)currency.getLong("id"), (long)loanCurrency.getLong("id"), (long)company.getLong("id"), (Date)DateUtils.getCurrentDate());
                if (rate == null) {
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4%1$s%2$s\u5151%3$s\u6c47\u7387\u3002", (String)"LoanBillEdit_15", (String)"tmc-cfm-formplugin", (Object[])new Object[0]), company.getString("name"), loanCurrency.getString("name"), currency.getString("name")));
                    return;
                }
                this.getView().setEnable(Boolean.TRUE, new String[]{"convertrate"});
            }
        } else {
            rate = BigDecimal.ONE;
            this.getView().setEnable(Boolean.FALSE, new String[]{"convertrate"});
        }
        this.getModel().setValue("convertrate", (Object)rate);
    }

    private BigDecimal getIntYearRate(DynamicObject dataEntity, BigDecimal intAmount, BigDecimal predictInstAmt) {
        DynamicObjectCollection entrys = dataEntity.getDynamicObjectCollection("entrys");
        IntBillExtInfo extInfo = new IntBillExtInfo();
        extInfo.setAmount(predictInstAmt);
        BigDecimal benchmarkInt = entrys.stream().map(e -> e.getBigDecimal("benchmarkint")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        if (benchmarkInt.compareTo(BigDecimal.ZERO) == 0) {
            benchmarkInt = entrys.stream().map(e -> e.getBigDecimal("instamt").subtract(e.getBigDecimal("floatint"))).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        }
        extInfo.setBenchmarkInt(benchmarkInt);
        BigDecimal floatInt = entrys.stream().map(e -> e.getBigDecimal("floatint")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        extInfo.setFloatInt(floatInt);
        ArrayList<IntBillDetailExtInfo> extDetails = new ArrayList<IntBillDetailExtInfo>(entrys.size());
        for (DynamicObject entry : entrys) {
            IntBillDetailExtInfo detail = new IntBillDetailExtInfo();
            detail.setAmount(entry.getBigDecimal("instamt"));
            detail.setFloatInt(entry.getBigDecimal("floatint"));
            detail.setRate(entry.getBigDecimal("rate"));
            detail.setFloatRate(entry.getBigDecimal("floatrate"));
            detail.setPrinciple(entry.getBigDecimal("instprincipalamt"));
            detail.setDays(entry.getInt("instdays"));
            detail.setBasisDay(entry.getInt("ratetrandays"));
            extDetails.add(detail);
        }
        extInfo.setExtDetails(extDetails);
        return extInfo.calcIntYearRate(intAmount);
    }

    public void click(EventObject evt) {
        if (evt.getSource() instanceof Control) {
            String key;
            switch (key = ((Control)evt.getSource()).getKey()) {
                case "loanbillno": {
                    this.drawLoanBill();
                }
            }
        }
    }

    private void track2RepaymentBill() {
        Long repaymentid = (Long)this.getModel().getValue("repaymentid");
        if (repaymentid == 0L) {
            DynamicObject bizBill = this.getModel().getDataEntity();
            AbstractBizResource bizResource = new BizResourceFactory().getBizResource(bizBill.getString("datasource"));
            this.getView().showTipNotification(bizResource.getIbIsnotrepaymentstyle());
            return;
        }
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId(FormParameterHelper.getRepayBillFormByBizType((IFormView)this.getView()));
        showParameter.setPkId((Object)repaymentid);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setStatus(OperationStatus.VIEW);
        showParameter.setCustomParam("isshowtoolbarap", (Object)"no");
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void drawLoanBill() {
        OperateOption option = OperateOption.create();
        QFilter instBillfilter = new QFilter("repaymentway", "not in", (Object)new String[]{RepaymentWayEnum.debx.getValue(), RepaymentWayEnum.debj.getValue(), RepaymentWayEnum.dbdx.getValue()});
        option.setVariableValue("instBillfilter", instBillfilter.toSerializedString());
        String formId = this.getView().getFormShowParameter().getFormId();
        if ("cfm_interestbill_e".equals(formId)) {
            this.getView().invokeOperation("draworg", option);
        } else if ("cfm_interestbill_bond".equals(formId)) {
            this.getView().invokeOperation("drawbond", option);
        } else if ("cim_invest_interestbill".equals(formId)) {
            this.getView().invokeOperation("drawinvest", option);
        } else {
            this.getView().invokeOperation("drawbank", option);
        }
    }

    private void acctBankF7Evt(BeforeF7SelectEvent evt) {
        QFilter qFilter;
        String mainOrgProp = this.getModel().getDataEntityType().getMainOrg();
        DynamicObject mainOrg = (DynamicObject)this.getModel().getValue(mainOrgProp);
        String[] temp = new String[]{"normal", "freeze"};
        long orgId = mainOrg == null ? 0L : Long.parseLong(mainOrg.getPkValue().toString());
        QFilter accountBankFilter = TmcAccountHelper.getAccountBankFilterByOrg((Long)orgId);
        QFilter acctStatusFilter = new QFilter("acctstatus", "in", (Object)temp);
        QFilter qFilter2 = qFilter = accountBankFilter == null ? acctStatusFilter : accountBankFilter.and(acctStatusFilter);
        if (CreditorTypeEnum.SETTLECENTER.getValue().equals(this.getModel().getDataEntity().getString("creditortype"))) {
            DynamicObject currency;
            Long creditorid = this.getModel().getDataEntity().getLong("creditor");
            if (EmptyUtil.isNoEmpty((Long)creditorid)) {
                qFilter.and(new QFilter("bank.id", "=", (Object)creditorid));
            }
            if (EmptyUtil.isNoEmpty((DynamicObject)(currency = (DynamicObject)this.getModel().getValue("currency")))) {
                qFilter.and("currency.fbasedataid", "=", currency.getPkValue());
            }
        } else {
            qFilter.and(new QFilter("acctclassify", "!=", (Object)"I"));
        }
        ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter().setFilter(qFilter);
    }

    private void addBeforeF7Select(BasedataEdit basedataEdit) {
        if (EmptyUtil.isNoEmpty((Object)basedataEdit)) {
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    private void instAmtChgEvt() {
        BigDecimal actualInstAmt = BigDecimal.ZERO;
        DynamicObjectCollection entry = this.getModel().getEntryEntity("entrys");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)entry)) {
            actualInstAmt = entry.stream().map(v -> v.getBigDecimal("instamt")).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"actualinstamt", (Object)actualInstAmt);
    }

    private void initOverseaEntFillData() {
        String formId = this.getView().getFormShowParameter().getFormId();
        if (!"cfm_interestbill_b".equals(formId)) {
            return;
        }
        if (this.getModel().getDataEntity().containsProperty("isoverseaentfill") && ((Boolean)this.getModel().getValue("isoverseaentfill")).booleanValue()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"fieldgrouppanelap", "transdetl"});
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"startinstdate", "endinstdate", "bizdate", "actualinstamt"});
            if (OperationStatus.ADDNEW.getValue() == this.getView().getFormShowParameter().getStatus().getValue()) {
                TmcViewInputHelper.clearValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String[])new String[]{"startinstdate", "endinstdate", "bizdate", "actualinstamt"});
            }
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"calcoverint"});
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"calcoverint", (Object)Boolean.FALSE);
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"fieldgrouppanelap", "transdetl"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"startinstdate", "endinstdate", "bizdate"});
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"calcoverint"});
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"calcoverint", (Object)Boolean.TRUE);
        }
    }
}

