/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.interestbill;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.algo.DataSet;
import kd.bos.algo.util.io.IOUtils;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cfm.common.constant.CfmBizConstant;
import kd.tmc.cfm.common.enums.LoanTypeEnum;
import kd.tmc.cfm.common.helper.CfmBillCommonHelper;
import kd.tmc.cfm.common.helper.IfmBizDealHelper;
import kd.tmc.cfm.common.helper.IntBillWriteOffHelper;
import kd.tmc.cfm.common.resource.AbstractBizResource;
import kd.tmc.cfm.common.resource.BizResourceFactory;
import kd.tmc.cfm.formplugin.common.CfmPush2PayFormOrListHelper;
import kd.tmc.cfm.formplugin.common.CommonBillFormHelper;
import kd.tmc.cfm.formplugin.helper.CfmFormHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.CreditorTypeEnum;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.list.AbstractTmcListPlugin;
import org.apache.commons.lang3.StringUtils;

public class InterestBillList
extends AbstractTmcListPlugin {
    public void initialize() {
        super.initialize();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String isShowToolBarAp = (String)formShowParameter.getCustomParam("isshowtoolbarap");
        if (null != isShowToolBarAp && isShowToolBarAp.equals("no")) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"filtercontainerap"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"toolbarap"});
        }
        this.addItemClickListeners(new String[]{"tblwriteoff"});
        this.addClickListeners(new String[]{"tblwriteoff"});
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        CfmBillCommonHelper.PreOpenPageDeal((PreOpenFormEventArgs)e, (boolean)true);
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        Object param;
        List filterColumnList = args.getFilterContainerInitEvent().getCommonFilterColumns();
        CommonFilterColumn bizDateFilterCol = filterColumnList.stream().filter(filterCol -> StringUtils.equals((CharSequence)filterCol.getFieldName(), (CharSequence)"bizdate")).findFirst().orElse(null);
        if (bizDateFilterCol == null) {
            return;
        }
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String isShowToolBarAp = (String)formShowParameter.getCustomParam("isshowtoolbarap");
        if (null != isShowToolBarAp && isShowToolBarAp.equals("no")) {
            bizDateFilterCol.setDefaultValue(null);
        }
        if (null != (param = formShowParameter.getCustomParam("filter"))) {
            QFilter qfilter = QFilter.fromSerializedString((String)param.toString());
            String property = qfilter.getProperty();
            Object value = qfilter.getValue();
            String cp = qfilter.getCP();
            for (FilterColumn filterColumn : args.getFilterContainerInitEvent().getCommonFilterColumns()) {
                CommonFilterColumn commonFilter = (CommonFilterColumn)filterColumn;
                if (commonFilter.getFieldName().equals(property)) {
                    if (StringUtils.equals((CharSequence)"in", (CharSequence)cp) && value != null) {
                        ArrayList<String> values = new ArrayList<String>(Arrays.asList((String[])value));
                        commonFilter.setDefaultValues(values);
                        continue;
                    }
                    commonFilter.setDefaultValue(value == null ? "" : value.toString());
                    continue;
                }
                commonFilter.setDefaultValue(null);
            }
        }
    }

    public void setFilter(SetFilterEvent e) {
        String formId;
        FormShowParameter parameter = this.getView().getFormShowParameter();
        List qFilters = e.getQFilters();
        String bizType = (String)parameter.getCustomParam("biztype");
        if (EmptyUtil.isNoEmpty((String)bizType)) {
            qFilters.add(new QFilter("loantype", "in", (Object)bizType.split(",")));
        }
        qFilters.add(new QFilter("settlestatus", "!=", (Object)"hide"));
        QFilter intBillIdFilter = this.getIntBillIdFilter();
        if (intBillIdFilter != null) {
            qFilters.add(intBillIdFilter);
        }
        if (Objects.equals(formId = ((ListShowParameter)this.getView().getFormShowParameter()).getBillFormId(), "cfm_interestbill_b") && !CfmBillCommonHelper.isRelateAppSet((String)TmcAppEnum.CFM.getValue())) {
            qFilters.add(new QFilter("creditortype", "!=", (Object)CreditorTypeEnum.SETTLECENTER.getValue()));
        }
        qFilters.add(new QFilter("loantype", "!=", (Object)LoanTypeEnum.FINLEASE.getValue()));
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        if (parameter.getCustomParams().containsKey("biztype")) {
            String bizType = (String)parameter.getCustomParam("biztype");
            e.getParameter().getCustomParams().put("biztype", bizType);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        CfmPush2PayFormOrListHelper.listPush2PayForwardValid(args, this.getView());
        switch (operateKey) {
            case "pushbizdealbill": {
                this.validatePush2SettleCenter(args);
                break;
            }
            case "writeoff": {
                List ids = this.getSelectedIdList();
                if (ids.size() > 0 && IntBillWriteOffHelper.verifyCanWriteOff((IFormView)this.getView(), (List)ids)) {
                    FormShowParameter showParameter = new FormShowParameter();
                    String appid = this.getView().getFormShowParameter().getAppId();
                    showParameter.setFormId("cfm_interestbill_writeoff");
                    if ("bdim".equals(appid)) {
                        showParameter.setFormId("cfm_intbill_writeoff_bond");
                    }
                    showParameter.getOpenStyle().setShowType(ShowType.Modal);
                    showParameter.setStatus(OperationStatus.ADDNEW);
                    showParameter.setCustomParam(CfmBizConstant.INTBILLIDS, (Object)ids);
                    showParameter.setCustomParam(CfmBizConstant.BIZ_WRITEOFF, (Object)"writeoff");
                    showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "writeoff"));
                    this.getView().showForm(showParameter);
                }
                args.setCancel(true);
                break;
            }
            case "unwriteoff": {
                List ids = this.getSelectedIdList();
                if (ids.size() > 0 && IntBillWriteOffHelper.verifyCanUnWriteOff((IFormView)this.getView(), (List)ids)) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u53cd\u51b2\u9500\u5c06\u5bf9\u8be5\u51b2\u9500\u6279\u6b21\u7684\u5229\u606f\u5355\u5168\u90e8\u8fdb\u884c\u53cd\u51b2\u9500\u64cd\u4f5c\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"InterestBillList_0", (String)"tmc-cfm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("unwriteoff"));
                }
                args.setCancel(true);
                break;
            }
            case "modifyinterestaccount": {
                this.validInterestAccountOp(args);
                break;
            }
        }
    }

    private void validInterestAccountOp(BeforeDoOperationEventArgs args) {
        IListView listview = (IListView)this.getView();
        ListSelectedRowCollection selectedRows = listview.getSelectedRows();
        if (selectedRows.getPrimaryKeyValues().length > 1) {
            this.getView().showErrorNotification(new BizResourceFactory().getBizResource("").getLbBatcherror());
            args.setCancel(true);
        } else {
            DynamicObject interestBillDO = TmcDataServiceHelper.loadSingle((Object)selectedRows.get(0).getPrimaryKeyValue(), (String)"cfm_interestbill", (String)"billstatus,instbillctg,paybill.number");
            String billStatus = interestBillDO.getString("billstatus");
            String payBillNumber = interestBillDO.getString("paybill.number");
            if (!BillStatusEnum.AUDIT.getValue().equals(billStatus) || !EmptyUtil.isEmpty((String)payBillNumber)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u7ecf\u5ba1\u6838\u3001\u4e14\u672a\u751f\u6210\u4ed8\u6b3e\u5355\u7684\u4ed8\u606f\u5355\uff0c\u53ef\u4ee5\u4f7f\u7528\u6b64\u529f\u80fd\uff0c\u5bf9\u4ed8\u606f\u8d26\u53f7\u8fdb\u884c\u66f4\u65b0\u3002", (String)"InterestBillList_3", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        OperationResult operationResult = args.getOperationResult();
        switch (operateKey) {
            case "trackrepayment": {
                if (operationResult == null || !operationResult.isSuccess()) break;
                this.track2RepaymentBill();
                break;
            }
            case "modifyinterestaccount": {
                if (operationResult == null || !operationResult.isSuccess()) break;
                this.modifyInterestAccountShowForm();
                break;
            }
            case "pushandsave2pay": {
                if (operationResult == null || !operationResult.isSuccess()) break;
                this.getView().invokeOperation("refresh");
                break;
            }
        }
    }

    private void modifyInterestAccountShowForm() {
        IListView listview = (IListView)this.getView();
        ListSelectedRowCollection selectedRows = listview.getSelectedRows();
        BillShowParameter param = new BillShowParameter();
        param.setCustomParam("pkId", selectedRows.get(0).getPrimaryKeyValue());
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        param.setCustomParam("billFormId", (Object)listShowParameter.getBillFormId());
        param.setFormId("cfm_interestaccount");
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setBillStatus(BillOperationStatus.VIEW);
        param.setStatus(OperationStatus.EDIT);
        this.getView().showForm((FormShowParameter)param);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        if ("writeoff".equals(evt.getActionId()) && EmptyUtil.isNoEmpty((Object)evt.getReturnData())) {
            Map returnVal = (Map)evt.getReturnData();
            OperateOption operate = OperateOption.create();
            List intBillIds = (List)JSON.parseObject((String)returnVal.get(CfmBizConstant.INTBILLIDS).toString(), List.class);
            operate.setVariableValue(CfmBizConstant.PREINTBILLIDS, returnVal.get(CfmBizConstant.PREINTBILLIDS).toString());
            operate.setVariableValue("writeoffamt", JSON.toJSONString(returnVal.get("writeoffamt")));
            OperationResult result = TmcOperateServiceHelper.execOperate((String)"writeoff", (String)this.getDataEntityName(), (Object[])intBillIds.toArray(), (OperateOption)operate);
            if (result != null && result.isSuccess()) {
                this.getView().invokeOperation("refresh");
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u51b2\u9500\u6210\u529f\u3002", (String)"InterestBillList_1", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
            }
        } else if ("unwriteoff".equals(evt.getActionId()) && EmptyUtil.isNoEmpty((Object)evt.getReturnData())) {
            List ids = this.getSelectedIdList();
            OperationResult result = TmcOperateServiceHelper.execOperate((String)"unwriteoff", (String)this.getDataEntityName(), (Object[])ids.toArray(), (OperateOption)OperateOption.create());
            if (result != null && result.isSuccess()) {
                this.getView().invokeOperation("refresh");
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53cd\u51b2\u9500\u6210\u529f\u3002", (String)"InterestBillList_2", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        List ids = this.getSelectedIdList();
        if (ids.size() > 0 && "unwriteoff".equals(evt.getCallBackId()) && evt.getResult().getValue() == MessageBoxResult.Yes.getValue()) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("cfm_interestbill_writeoff");
            String appid = this.getView().getFormShowParameter().getAppId();
            if ("bdim".equals(appid)) {
                showParameter.setFormId("cfm_intbill_writeoff_bond");
            }
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setStatus(OperationStatus.ADDNEW);
            showParameter.setCustomParam(CfmBizConstant.INTBILLIDS, (Object)ids);
            showParameter.setCustomParam(CfmBizConstant.BIZ_WRITEOFF, (Object)"unwriteoff");
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "unwriteoff"));
            this.getView().showForm(showParameter);
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        String fieldName;
        switch (fieldName = args.getFieldName()) {
            case "paybill_number": {
                CfmFormHelper.showPayBillList(args, this.getView());
                break;
            }
        }
    }

    private void track2RepaymentBill() {
        BillShowParameter showParameter;
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows == null || selectedRows.size() == 0) {
            return;
        }
        ArrayList<Long> billIds = new ArrayList<Long>();
        for (ListSelectedRow row : selectedRows) {
            billIds.add((Long)row.getPrimaryKeyValue());
        }
        DynamicObject[] interestBills = TmcDataServiceHelper.load((String)"cfm_interestbill", (String)"id,repaymentid,datasource", (QFilter[])new QFilter[]{new QFilter("id", "in", billIds)});
        HashSet<Long> pks = new HashSet<Long>(10);
        HashSet<String> datasourceKings = new HashSet<String>(10);
        if (interestBills.length > 0) {
            for (DynamicObject interestBill : interestBills) {
                String datasource = interestBill.getString("datasource");
                datasourceKings.add(datasource);
                long repaymentId = interestBill.getLong("repaymentid");
                if (repaymentId == 0L) continue;
                pks.add(repaymentId);
            }
        }
        if (datasourceKings.size() > 1) {
            this.getView().showTipNotification(new BizResourceFactory().getBizResource("").getIbDatasourcediff());
            return;
        }
        AbstractBizResource bizResource = new BizResourceFactory().getBizResource(interestBills[0].getString("datasource"));
        if (pks.size() == 0) {
            this.getView().showTipNotification(bizResource.getIbThoesnotrepaymentStyle());
            return;
        }
        Long pkId = Long.parseLong(String.valueOf(pks.iterator().next()));
        String repaymentFormId = CommonBillFormHelper.getRepaymentFormId(this.getView(), pkId);
        if (pks.size() == 1) {
            showParameter = new BillShowParameter();
            showParameter.setFormId(repaymentFormId);
            showParameter.setPkId((Object)pkId);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setStatus(OperationStatus.VIEW);
            showParameter.setCustomParam("isshowtoolbarap", (Object)"no");
            this.getView().showForm((FormShowParameter)showParameter);
        } else {
            showParameter = new ListShowParameter();
            showParameter.setIsolationOrg(false);
            showParameter.setBillFormId(repaymentFormId);
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
            qFilters.add(new QFilter("id", "in", pks));
            showParameter.getListFilterParameter().setQFilters(qFilters);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setStatus(OperationStatus.VIEW);
            showParameter.setCustomParam("isshowtoolbarap", (Object)"no");
            showParameter.setShowFilter(false);
            showParameter.setShowQuickFilter(false);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    private void validatePush2SettleCenter(BeforeDoOperationEventArgs args) {
        List intIds = this.getSelectedIdList();
        if (EmptyUtil.isEmpty((Collection)intIds)) {
            return;
        }
        IfmBizDealHelper.validatePush2SettleCenter((IFormView)this.getView(), (String)"cfm_interestbill", (List)intIds, (BeforeDoOperationEventArgs)args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QFilter getIntBillIdFilter() {
        QFilter qFilter = new QFilter("billstatus", "in", Arrays.asList("A", "B")).and("entry.intbillid", ">", (Object)0L);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"queryBatchIntBillid", (String)"cfm_intbill_batch_loan", (String)"entry.intbillid", (QFilter[])qFilter.toArray(), null);
        try {
            ArrayList intBillids = new ArrayList(8);
            dataSet.forEach(d -> intBillids.add(d.get("entry.intbillid")));
            QFilter qFilter2 = EmptyUtil.isNoEmpty(intBillids) ? new QFilter("id", "not in", intBillids).or("billstatus", "in", Arrays.asList("A", "C")) : null;
            return qFilter2;
        }
        finally {
            IOUtils.closeQuietly((AutoCloseable)dataSet);
        }
    }
}

