/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.interestbill;

import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.tmc.cfm.common.enums.LoanTypeEnum;
import kd.tmc.cfm.common.helper.BatchIntBillHelper;
import kd.tmc.cfm.common.helper.BusinessHelper;
import kd.tmc.cfm.formplugin.resource.CfmFormResourceEnum;
import kd.tmc.fbp.common.util.EmptyUtil;

public class InterestBillSlEdit
extends AbstractBillPlugIn {
    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        switch (name = e.getProperty().getName()) {
            case "actualinstamt": {
                this.actualInstAmtChange("currency");
                break;
            }
            case "convertintamt": {
                this.actualInstAmtChange("loancurrency");
                break;
            }
            case "s_repayinst": {
                this.entryRepayInstChange();
                break;
            }
        }
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        String key;
        super.beforeFieldPostBack(e);
        Control source = (Control)e.getSource();
        switch (key = source.getKey()) {
            case "s_repayinst": {
                this.checkSlAmount(e, "actualinstamt");
                break;
            }
        }
    }

    private void checkSlAmount(BeforeFieldPostBackEvent e, String headField) {
        int rowIndex = e.getRowIndex();
        Object value = e.getValue();
        BigDecimal repayInstAmt = (BigDecimal)this.getModel().getValue(headField);
        if (EmptyUtil.isNoEmpty((Object)value)) {
            BigDecimal amount = new BigDecimal(String.valueOf(value));
            if (amount.compareTo(repayInstAmt) > 0) {
                e.setCancel(true);
                DynamicObject currency = (DynamicObject)this.getModel().getValue("actualinstamt".equals(headField) ? "currency" : "loancurrency");
                int currencyPresion = BusinessHelper.getCurrencyPresion((DynamicObject)currency);
                this.getView().showTipNotification(CfmFormResourceEnum.InterestBillSlEdit_0.loadKDString(repayInstAmt.setScale(currencyPresion)));
                this.getView().updateView("actualinstamt".equals(headField) ? "s_repayinst" : "s_convertintamt", rowIndex);
            } else if (BigDecimal.ZERO.compareTo(amount) > 0) {
                e.setCancel(true);
                this.getView().updateView("actualinstamt".equals(headField) ? "s_repayinst" : "s_convertintamt", rowIndex);
            }
        }
    }

    public void entryRepayInstChange() {
        BigDecimal repayInstTotalAmt = (BigDecimal)this.getModel().getValue("actualinstamt");
        int currIdx = this.getModel().getEntryCurrentRowIndex("slentryentity");
        BigDecimal rowInstAmt = (BigDecimal)this.getModel().getValue("s_repayinst", currIdx);
        DynamicObject bank = (DynamicObject)this.getModel().getValue("s_bank", currIdx);
        long bankId = EmptyUtil.isNoEmpty((DynamicObject)bank) ? bank.getLong("id") : 0L;
        DynamicObjectCollection slBankEntrys = this.getModel().getEntryEntity("slentryentity");
        BigDecimal rowTotalAmt = slBankEntrys.stream().map(o -> o.getBigDecimal("s_repayinst")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        BigDecimal subAmount = repayInstTotalAmt.subtract(rowTotalAmt);
        if (!EmptyUtil.isEmpty((BigDecimal)subAmount)) {
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)slBankEntrys) && slBankEntrys.size() == 2) {
                DynamicObject entry = slBankEntrys.stream().filter(o -> EmptyUtil.isNoEmpty((DynamicObject)o.getDynamicObject("s_bank")) && bankId != o.getDynamicObject("s_bank").getLong("id")).findFirst().orElse(null);
                if (EmptyUtil.isNoEmpty((DynamicObject)entry)) {
                    BigDecimal amount = repayInstTotalAmt.subtract(rowInstAmt);
                    entry.set("s_repayinst", (Object)(amount.compareTo(BigDecimal.ZERO) > 0 ? amount : BigDecimal.ZERO));
                }
            } else {
                DynamicObject rowEntity;
                BigDecimal loanAmount;
                int slRowCount = this.getModel().getEntryRowCount("slentryentity");
                if (slRowCount - 1 > currIdx && EmptyUtil.isNoEmpty((BigDecimal)(loanAmount = (rowEntity = this.getModel().getEntryRowEntity("slentryentity", slRowCount - 1)).getBigDecimal("s_loanamount")))) {
                    BigDecimal instAmt = rowEntity.getBigDecimal("s_repayinst").add(subAmount);
                    rowEntity.set("s_repayinst", (Object)(instAmt.compareTo(BigDecimal.ZERO) > 0 ? instAmt : BigDecimal.ZERO));
                }
            }
        }
        this.setEntryCoverAmt();
        this.getView().updateView("slentryentity");
    }

    public void setEntryCoverAmt() {
        BigDecimal rate = (BigDecimal)this.getModel().getValue("convertrate");
        BigDecimal convertIntamt = (BigDecimal)this.getModel().getValue("convertintamt");
        DynamicObject loanCurrency = (DynamicObject)this.getModel().getValue("loancurrency");
        int currencyPresion = BusinessHelper.getCurrencyPresion((DynamicObject)loanCurrency);
        DynamicObjectCollection slBankEntrys = this.getModel().getEntryEntity("slentryentity");
        BigDecimal sumAmount = BigDecimal.ZERO;
        for (DynamicObject slBankEntry : slBankEntrys) {
            BigDecimal repayInstAmt = slBankEntry.getBigDecimal("s_repayinst");
            BigDecimal coverAmount = (EmptyUtil.isNoEmpty((BigDecimal)repayInstAmt) ? repayInstAmt : BigDecimal.ZERO).multiply(rate).setScale(currencyPresion, 4);
            slBankEntry.set("s_convertintamt", (Object)coverAmount);
            sumAmount = sumAmount.add(coverAmount);
        }
        BigDecimal subAmount = convertIntamt.subtract(sumAmount);
        if (subAmount.compareTo(BigDecimal.ZERO) != 0) {
            for (DynamicObject slBankEntry : slBankEntrys) {
                BigDecimal rowCoverAmount = slBankEntry.getBigDecimal("s_convertintamt");
                BigDecimal rowInstAmount = slBankEntry.getBigDecimal("s_repayinst");
                if (rowInstAmount.compareTo(BigDecimal.ZERO) == 0) {
                    slBankEntry.set("s_convertintamt", (Object)BigDecimal.ZERO);
                    continue;
                }
                if ((rowCoverAmount = rowCoverAmount.add(subAmount)).compareTo(BigDecimal.ZERO) >= 0) {
                    slBankEntry.set("s_convertintamt", (Object)rowCoverAmount);
                    break;
                }
                subAmount = rowCoverAmount;
                slBankEntry.set("s_convertintamt", (Object)0);
            }
        }
    }

    public void actualInstAmtChange(String currencyField) {
        if (!LoanTypeEnum.isBanksLoan((String)String.valueOf(this.getModel().getValue("loantype")))) {
            return;
        }
        BigDecimal actualInstAmt = (BigDecimal)this.getModel().getValue("currency".equals(currencyField) ? "actualinstamt" : "convertintamt");
        DynamicObjectCollection slBankEntrys = this.getModel().getEntryEntity("slentryentity");
        List slBankEntryList = slBankEntrys.stream().filter(o -> EmptyUtil.isNoEmpty((DynamicObject)o.getDynamicObject("s_loanbillno"))).collect(Collectors.toList());
        DynamicObject amtCurrency = (DynamicObject)this.getModel().getValue(currencyField);
        this.getModel().beginInit();
        BatchIntBillHelper.setSlBankEntryAmount(slBankEntryList, (BigDecimal)actualInstAmt, (String)("currency".equals(currencyField) ? "s_repayinst" : "s_convertintamt"), (DynamicObject)amtCurrency, (boolean)false);
        this.getModel().endInit();
        this.getView().updateView("slentryentity");
    }
}

