/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.interestbill.batch;

import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.tmc.cfm.common.enums.BatchIntViewInfoEnum;
import kd.tmc.cfm.common.helper.BatchIntBillHelper;
import kd.tmc.cfm.common.helper.FormParameterHelper;
import kd.tmc.fbp.common.enums.InvestTypeEnum;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public abstract class AbstractIntBillBatchEdit
extends AbstractFormPlugin
implements HyperLinkClickListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entrysGrid = (EntryGrid)this.getControl("entry");
        entrysGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String fieldName = evt.getFieldName();
        if (fieldName.equals("interestamt")) {
            this.showIntDetailForm(evt.getRowIndex());
        } else if (fieldName.equals("intdetailnum")) {
            this.showIntBillForm(evt.getRowIndex());
        } else if (fieldName.equals("loannum")) {
            this.showLoanBillForm(evt.getRowIndex());
        }
    }

    public void afterCreateNewData(EventObject e) {
        Map param = this.getView().getFormShowParameter().getCustomParams();
        Object navparam = param.get("navparam");
        if (EmptyUtil.isEmpty(navparam)) {
            return;
        }
        Map navParam = (Map)SerializationUtils.fromJsonString((String)navparam.toString(), Map.class);
        if (EmptyUtil.isNoEmpty((Object)navParam)) {
            Object settleCenterJson = navParam.get("settlecenter");
            if (EmptyUtil.isNoEmpty(settleCenterJson)) {
                Object[] settleCenters = DynamicObjectSerializeUtil.deserialize((String)((String)settleCenterJson), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_finorginfo"));
                DynamicObject settleCenter = (DynamicObject)settleCenters[0];
                this.getModel().setValue("settlecenter", (Object)settleCenter);
                this.getModel().setValue("org", (Object)settleCenter.getDynamicObject("org"));
            } else {
                String appId = this.getView().getFormShowParameter().getAppId();
                long orgId = RequestContext.get().getOrgId();
                DynamicObject currentPermOrg = TmcOrgDataHelper.getCurrentAuthPermOrg((String)appId, (String)this.getView().getEntityId(), (String)"47150e89000000ac", (long)orgId);
                if (EmptyUtil.isNoEmpty((DynamicObject)currentPermOrg)) {
                    this.getModel().setValue("org", currentPermOrg.getPkValue());
                }
            }
            this.getModel().setValue("bizdate", (Object)DateUtils.stringToDate((String)((String)navParam.get("endintdate")), (String)"yyyy-MM-dd"));
        }
        BatchIntViewInfoEnum batchIntViewInfo = this.getBatchIntViewInfo();
        this.getModel().setValue("loantype", (Object)batchIntViewInfo.getLoanType());
        this.getModel().setValue("biztype", (Object)batchIntViewInfo.getOperateType());
        this.getModel().setValue("datasource", (Object)BatchIntBillHelper.getDatasource((BatchIntViewInfoEnum)batchIntViewInfo));
        this.getModel().setValue("description", (Object)BatchIntBillHelper.genCommentTemplate((BatchIntViewInfoEnum)batchIntViewInfo));
        this.loadIntDetail();
    }

    private void showIntDetailForm(int index) {
        FormShowParameter parameter = new FormShowParameter();
        IDataModel model = this.getModel();
        DynamicObject entry = model.getEntryRowEntity("entry", index);
        String callIntStr = entry.getString("intdetail_tag");
        DataEntityPropertyCollection entryProperties = FormParameterHelper.getDataEntityProperties((IDataModel)model, (String)"entry");
        DynamicObject currency = entry.getDynamicObject("currency");
        Map customParams = parameter.getCustomParams();
        customParams.put("intdetail", callIntStr);
        List<String> list = Arrays.asList("cfm_intbill_batch_b", "cfm_intbill_batch_e", "cfm_intbill_batch_loan", "ifm_intbill_batch_loan", "cfm_intbill_batch_invest", "cfm_intbill_batch_bond");
        if (list.contains(this.getView().getFormShowParameter().getFormId())) {
            currency = entry.getDynamicObject("loancurrency");
        }
        customParams.put("currency", currency.getPkValue());
        if (entryProperties != null && entryProperties.containsKey((Object)"loanbillid")) {
            customParams.put("loanbillid", entry.getLong("loanbillid"));
        }
        parameter.setStatus(OperationStatus.VIEW);
        parameter.setFormId(this.getIntDetailFormId(entry));
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(parameter);
    }

    protected String getIntDetailFormId(DynamicObject entry) {
        return "ifm_intbill_detail";
    }

    private void showIntBillForm(int index) {
        BillShowParameter parameter = new BillShowParameter();
        parameter.setStatus(OperationStatus.VIEW);
        parameter.setPkId(this.getModel().getValue("intbillid", index));
        parameter.setFormId(BatchIntBillHelper.getIntBillFormId((String)this.getView().getFormShowParameter().getFormId()));
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void showLoanBillForm(int index) {
        BillShowParameter parameter = new BillShowParameter();
        parameter.setStatus(OperationStatus.VIEW);
        Object pkId = this.getModel().getValue("loanbillid", index);
        if (EmptyUtil.isEmpty((Object)pkId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AbstractIntBillBatchEdit_1", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject billDyn = QueryServiceHelper.queryOne((String)"cim_deposit", (String)"investvarieties.investtype investtype", (QFilter[])new QFilter[]{new QFilter("id", "=", pkId)});
        if (EmptyUtil.isEmpty((DynamicObject)billDyn)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AbstractIntBillBatchEdit_1", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
            return;
        }
        String investType = billDyn.getString("investtype");
        String formId = "";
        if (InvestTypeEnum.isFixed((String)investType)) {
            formId = "cim_deposit";
        } else if (InvestTypeEnum.isNotice((String)investType)) {
            formId = "cim_noticedeposit";
        }
        parameter.setPkId(pkId);
        parameter.setFormId(formId);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)parameter);
    }

    protected BatchIntViewInfoEnum getBatchIntViewInfo() {
        return BatchIntViewInfoEnum.getInfoEnumByFormId((String)this.getParentFormId());
    }

    protected String getParentFormId() {
        Map param = this.getView().getFormShowParameter().getCustomParams();
        Object navParamObj = param.get("navparam");
        if (EmptyUtil.isEmpty(navParamObj)) {
            return this.getView().getFormShowParameter().getFormId();
        }
        Map navParam = (Map)SerializationUtils.fromJsonString((String)navParamObj.toString(), Map.class);
        return EmptyUtil.isNoEmpty(navParam.get("formid")) ? navParam.get("formid").toString() : "";
    }

    protected abstract void loadIntDetail();

    protected abstract String getEntityName();
}

