/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.interestbill.batch;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.tmc.cfm.common.enums.BatchIntViewInfoEnum;
import kd.tmc.cfm.common.enums.BillTypeEnum;
import kd.tmc.cfm.common.enums.DataSourceEnum;
import kd.tmc.cfm.common.enums.LoanTypeEnum;
import kd.tmc.cfm.common.helper.BatchIntBillHelper;
import kd.tmc.cfm.common.helper.CfmBillCommonHelper;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.helper.SettleCenterHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.list.AbstractTmcListPlugin;
import org.apache.commons.lang3.tuple.Pair;

public class IntBillBatchList
extends AbstractTmcListPlugin {
    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        ListView source = (ListView)e.getSource();
        BillShowParameter billShowParameter = e.getParameter();
        String billFormId = source.getBillFormId();
        if (StringUtils.equals((CharSequence)billFormId, (CharSequence)"ifm_intbill_batch_pre")) {
            if (OperationStatus.EDIT == e.getParameter().getStatus() || OperationStatus.VIEW == e.getParameter().getStatus()) {
                e.getParameter().setFormId(billShowParameter.getFormId());
            }
        } else {
            billShowParameter.setFormId(billFormId);
        }
    }

    public void setFilter(SetFilterEvent e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String trackTag = (String)customParams.get("bos_call_source_type");
        if (EmptyUtil.isNoEmpty((String)trackTag) && StringUtils.equals((CharSequence)trackTag, (CharSequence)"botp_track")) {
            return;
        }
        String datasource = BatchIntBillHelper.getDatasource((BatchIntViewInfoEnum)this.getBatchIntViewInfo());
        if (StringUtils.equals((CharSequence)datasource, (CharSequence)"ifm")) {
            this.addIfmListFilter(e);
        } else {
            this.addCfmListFilter(e);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        List<String> singleOps = Arrays.asList("submit", "unsubmit", "audit", "unaudit");
        Set selectEdPks = args.getListSelectedData().stream().map(v -> v.getPrimaryKeyValue()).collect(Collectors.toSet());
        if (singleOps.contains(operateKey) && selectEdPks.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u64cd\u4f5c\u3002", (String)"IntBillBatchList_0", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        } else if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"new")) {
            args.setCancel(true);
            this.openAddNewNavigateForm();
        } else if (StringUtils.equals((CharSequence)"trackup", (CharSequence)operateKey) || StringUtils.equals((CharSequence)"trackdown", (CharSequence)operateKey)) {
            args.setCancel(true);
            this.track(args.getListSelectedData(), operateKey);
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        Map navParam = (Map)evt.getReturnData();
        if (StringUtils.equals((CharSequence)"CLOSE_BAKE_KEY_FILTER", (CharSequence)evt.getActionId()) && null != evt.getReturnData()) {
            BillShowParameter parameter = new BillShowParameter();
            parameter.setStatus(OperationStatus.ADDNEW);
            this.initShowParameter(parameter, navParam);
            parameter.setCustomParam("navparam", evt.getReturnData());
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "CLOSE_BAKE_KEY_EXIST"));
            this.getView().showForm((FormShowParameter)parameter);
        } else if (StringUtils.equals((CharSequence)"CLOSE_BAKE_KEY_EXIST", (CharSequence)evt.getActionId())) {
            BillList billList = (BillList)this.getControl("billlistap");
            billList.refresh();
        }
    }

    private void initShowParameter(BillShowParameter parameter, Map<?, ?> navParam) {
        String formid = this.getFormId();
        if ("ifm_intbill_batch_pre".equals(formid)) {
            String viewparam = (String)this.getView().getFormShowParameter().getCustomParams().get("viewparam");
            if (StringUtils.equals((CharSequence)"ifm#loanpreint", (CharSequence)viewparam)) {
                parameter.setFormId("ifm_preintbill_batch_l");
            } else {
                parameter.setFormId("ifm_preintbill_batch_c");
            }
        } else {
            parameter.setFormId(this.getFormId());
        }
    }

    private void openAddNewNavigateForm() {
        FormShowParameter showParameter = new FormShowParameter();
        List settleCenters = this.getPageFilterColumnCache("settlecenter.name");
        if (EmptyUtil.isNoEmpty((Object)settleCenters)) {
            showParameter.getCustomParams().put("settlecenter", settleCenters.get(0));
        }
        this.configShowParameter(showParameter);
        String entity = this.getEntityId();
        showParameter.getCustomParams().put("entity", entity);
        showParameter.getCustomParams().put("formid", this.getFormId());
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "CLOSE_BAKE_KEY_FILTER"));
        StyleCss sc = new StyleCss();
        if ("ifm_intbill_batch_current".equals(entity)) {
            sc.setHeight("500px");
        } else if ("ifm_intbill_batch_loan".equals(entity)) {
            sc.setHeight("670px");
        }
        showParameter.getOpenStyle().setInlineStyleCss(sc);
        this.getView().showForm(showParameter);
    }

    private void configShowParameter(FormShowParameter showParameter) {
        String formId = this.getFormId();
        if (StringUtils.equals((CharSequence)"ifm_intbill_batch_pre", (CharSequence)formId)) {
            String viewparam = (String)this.getView().getFormShowParameter().getCustomParams().get("viewparam");
            if (StringUtils.equals((CharSequence)"ifm#loanpreint", (CharSequence)viewparam)) {
                showParameter.setFormId("cfm_navigate_pre_addnew");
            } else {
                showParameter.setFormId("ifm_navigate_pre_addnew");
            }
        } else if (StringUtils.equals((CharSequence)"ifm_accrual_batch_bank", (CharSequence)formId)) {
            showParameter.setFormId("ifm_navigate_bank_addnew");
        } else {
            showParameter.setFormId(BatchIntBillHelper.getAddNewNavFormId((BatchIntViewInfoEnum)this.getBatchIntViewInfo()));
        }
    }

    private void track(ListSelectedRowCollection selectedData, String trackType) {
        Object[] batchBillIds = selectedData.getPrimaryKeyValues();
        String entityId = this.getEntityId();
        DynamicObject[] batchBills = TmcDataServiceHelper.load((Object[])batchBillIds, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entityId));
        Pair<String, List<Long>> trackPair = null;
        for (DynamicObject batchBill : batchBills) {
            trackPair = StringUtils.equals((CharSequence)trackType, (CharSequence)"trackup") ? this.genTrackUpPair(batchBill) : this.genTrackDownPair(batchBill);
            if (trackPair != null) {
                this.removeUnExistData(trackPair);
                this.showTrackView(trackPair);
                continue;
            }
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5173\u8054\u6570\u636e\u3002", (String)"IntBillBatchList_1", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
        }
    }

    private void showTrackView(Pair<String, List<Long>> trackPair) {
        IFormView view = this.getView();
        if (null == trackPair || EmptyUtil.isEmpty((String)((String)trackPair.getLeft())) || EmptyUtil.isEmpty((Collection)((Collection)trackPair.getRight()))) {
            view.showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5173\u8054\u6570\u636e\u3002", (String)"IntBillBatchList_1", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
            return;
        }
        List pkIds = (List)trackPair.getRight();
        String formId = (String)trackPair.getLeft();
        if (pkIds.size() == 1) {
            BillShowParameter showParameter = new BillShowParameter();
            showParameter.setPkId(pkIds.get(0));
            showParameter.setFormId(formId);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setCustomParam("isshowtoolbarap", (Object)"no");
            view.showForm((FormShowParameter)showParameter);
        } else {
            ListShowParameter showParameter = new ListShowParameter();
            showParameter.setIsolationOrg(false);
            showParameter.setBillFormId(formId);
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>(16);
            qFilters.add(new QFilter("id", "in", (Object)pkIds));
            showParameter.getListFilterParameter().setQFilters(qFilters);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setCustomParam("isshowtoolbarap", (Object)"yes");
            showParameter.setShowFilter(false);
            showParameter.setShowQuickFilter(false);
            view.showForm((FormShowParameter)showParameter);
        }
    }

    private Pair<String, List<Long>> genTrackUpPair(DynamicObject batchBill) {
        DynamicObjectCollection entrys = batchBill.getDynamicObjectCollection("entry");
        String trackObjName = "";
        List<Object> trackObjIds = new ArrayList();
        String entityName = this.getFormId();
        if (StringUtils.equals((CharSequence)"ifm_intbill_batch_current", (CharSequence)entityName)) {
            trackObjIds = entrys.stream().map(v -> v.getDynamicObject("intobject").getLong("id")).collect(Collectors.toList());
            trackObjName = StringUtils.equals((CharSequence)batchBill.getString("intsource"), (CharSequence)"accountview") ? "ifm_extintobject" : "ifm_intobject";
        } else if (StringUtils.equals((CharSequence)"ifm_intbill_batch_pre", (CharSequence)entityName) && StringUtils.equals((CharSequence)((String)this.getView().getFormShowParameter().getCustomParams().get("viewparam")), (CharSequence)"ifm#currpreint")) {
            trackObjIds = entrys.stream().map(v -> v.getDynamicObject("inneracct").getLong("id")).collect(Collectors.toList());
            trackObjName = "am_accountbank";
        } else {
            trackObjIds = entrys.stream().map(v -> v.getLong("loanbillid")).collect(Collectors.toList());
            BatchIntViewInfoEnum batchIntViewInfo = this.getBatchIntViewInfo();
            trackObjName = batchIntViewInfo.getLoanBillFormId();
        }
        if (EmptyUtil.isNoEmpty(trackObjIds)) {
            return Pair.of((Object)trackObjName, trackObjIds);
        }
        return null;
    }

    private Pair<String, List<Long>> genTrackDownPair(DynamicObject batchBill) {
        DynamicObjectCollection entrys = batchBill.getDynamicObjectCollection("entry");
        List trackObjIds = entrys.stream().map(v -> v.getLong("intbillid")).filter(EmptyUtil::isNoEmpty).collect(Collectors.toList());
        if (EmptyUtil.isEmpty(trackObjIds)) {
            return null;
        }
        String trackObjName = StringUtils.equals((CharSequence)"ifm_intbill_batch_pre", (CharSequence)this.getFormId()) ? (StringUtils.equals((CharSequence)((String)this.getView().getFormShowParameter().getCustomParams().get("viewparam")), (CharSequence)"ifm#loanpreint") ? "ifm_preinterestbill" : "ifm_currentintbill_p") : this.getBatchIntViewInfo().getIntBillFormId();
        return Pair.of((Object)trackObjName, trackObjIds);
    }

    private void removeUnExistData(Pair<String, List<Long>> trackPair) {
        if (null == trackPair || EmptyUtil.isEmpty((String)((String)trackPair.getLeft())) || EmptyUtil.isEmpty((Collection)((Collection)trackPair.getRight()))) {
            return;
        }
        String intBillFormId = StringUtils.equals((CharSequence)this.getBatchIntViewInfo().getOperateType(), (CharSequence)"preint") ? "cfm_preinterestbill" : "cfm_interestbill";
        DynamicObject[] trackBills = TmcDataServiceHelper.load((String)intBillFormId, (String)"id", (QFilter[])new QFilter("id", "in", trackPair.getRight()).toArray());
        List trackBillIds = Arrays.stream(trackBills).map(v -> v.getLong("id")).collect(Collectors.toList());
        trackPair = Pair.of((Object)trackPair.getLeft(), trackBillIds);
    }

    private Set<Long> getAuthorizedBankCenterIds() {
        String appId = this.getView().getFormShowParameter().getAppId();
        if (EmptyUtil.isNoEmpty((String)appId)) {
            return SettleCenterHelper.hasPermissionSettleCenter((String)appId, (String)this.getDataEntityName(), (String)this.getPermissionItem());
        }
        return Collections.emptySet();
    }

    protected BatchIntViewInfoEnum getBatchIntViewInfo() {
        return BatchIntViewInfoEnum.getInfoEnumByFormId((String)this.getFormId());
    }

    private void addIfmListFilter(SetFilterEvent e) {
        String formId = this.getFormId();
        List qFilters = e.getQFilters();
        qFilters.add(new QFilter("datasource", "in", (Object)new String[]{"ifm", "hand"}));
        String bizType = "";
        switch (formId) {
            case "ifm_intbill_batch_loan": {
                bizType = BillTypeEnum.LOAN.getValue();
                break;
            }
            case "ifm_intbill_batch_current": {
                bizType = BillTypeEnum.CURRENTINT.getValue();
                qFilters.add(new QFilter("intsource", "not in", Arrays.asList("bankjournal", "bei")));
                break;
            }
            case "ifm_intbill_batch_pre": {
                bizType = BillTypeEnum.PREINT.getValue();
                qFilters.add(new QFilter("loantype", "!=", (Object)LoanTypeEnum.DEPOSIT.getValue()));
                break;
            }
            case "ifm_depositprebatch": {
                bizType = BillTypeEnum.PREINT.getValue();
                qFilters.add(new QFilter("loantype", "=", (Object)LoanTypeEnum.DEPOSIT.getValue()));
                break;
            }
        }
        qFilters.add(new QFilter("biztype", "=", (Object)bizType));
        Set<Long> bankIds = this.getAuthorizedBankCenterIds();
        for (QFilter fi : qFilters) {
            if (!"settlecenter.id".equals(fi.getProperty())) continue;
            return;
        }
        if (EmptyUtil.isNoEmpty(bankIds)) {
            QFilter filter = new QFilter("settlecenter.id", "in", bankIds).or("settlecenter.id", "=", (Object)0);
            e.getQFilters().add(filter);
        }
    }

    private void addCfmListFilter(SetFilterEvent e) {
        BatchIntViewInfoEnum batchIntViewInfo = this.getBatchIntViewInfo();
        QFilter qFilter = this.getLoanTypeFilter(batchIntViewInfo);
        qFilter.and("biztype", "=", (Object)batchIntViewInfo.getOperateType());
        List<Long> authOrgIds = this.getAuthOrgIds();
        if (authOrgIds != null) {
            if (EmptyUtil.isEmpty(authOrgIds)) {
                qFilter.and("org.id", "=", (Object)0);
            } else {
                qFilter.and("org.id", "in", authOrgIds);
            }
        }
        qFilter.and("datasource", "=", (Object)BatchIntBillHelper.getDatasource((BatchIntViewInfoEnum)batchIntViewInfo));
        if (this.getFormId().startsWith("cfm") && !CfmBillCommonHelper.isRelateAppSet((String)TmcAppEnum.CFM.getValue())) {
            QFilter filter = QFilter.isNull((String)"settlecenter").or("settlecenter.id", "=", (Object)0);
            e.getQFilters().add(filter);
        }
        e.getQFilters().add(qFilter);
    }

    private QFilter getLoanTypeFilter(BatchIntViewInfoEnum batchIntViewInfo) {
        ArrayList<String> loanTypes = new ArrayList<String>();
        String dataSource = BatchIntBillHelper.getDatasource((BatchIntViewInfoEnum)batchIntViewInfo);
        String loanType = batchIntViewInfo.getLoanType();
        if (DataSourceEnum.isCfm((String)dataSource) && (LoanTypeEnum.isBankLoan((String)loanType) || LoanTypeEnum.isBanksLoan((String)loanType))) {
            loanTypes.addAll(Arrays.asList(LoanTypeEnum.BANKLOAN.getValue(), LoanTypeEnum.BANKSLOAN.getValue()));
        } else if (DataSourceEnum.isBond((String)dataSource)) {
            loanTypes.add(LoanTypeEnum.BOND.getValue());
        } else if (DataSourceEnum.isCim((String)dataSource) || DataSourceEnum.isIfm((String)dataSource) && LoanTypeEnum.isDeposit((String)loanType)) {
            loanTypes.add(LoanTypeEnum.DEPOSIT.getValue());
        } else if ((DataSourceEnum.isCfm((String)dataSource) || DataSourceEnum.isInvest((String)dataSource)) && (LoanTypeEnum.isLinklend((String)loanType) || LoanTypeEnum.isEntrustLoan((String)loanType))) {
            loanTypes.addAll(Arrays.asList(LoanTypeEnum.LINKLEND.getValue(), LoanTypeEnum.ENTRUSTLOAN.getValue()));
        } else {
            loanTypes.addAll(Arrays.asList(LoanTypeEnum.BANKLOAN.getValue(), LoanTypeEnum.BANKSLOAN.getValue()));
        }
        return new QFilter("loantype", "in", loanTypes);
    }

    private String getFormId() {
        BillList billList = (BillList)this.getControl("billlistap");
        String billFormId = billList.getBillFormId();
        if (StringUtils.equals((CharSequence)billFormId, (CharSequence)"cfm_intbill_batch_loan")) {
            billFormId = "cfm_intbill_batch_b";
        } else if (StringUtils.equals((CharSequence)billFormId, (CharSequence)"cfm_intbill_batch_pre")) {
            billFormId = "cfm_intbill_batch_pre_b";
        }
        return billFormId;
    }

    private String getEntityId() {
        BillList billList = (BillList)this.getControl("billlistap");
        return billList.getEntityId();
    }

    private List<Long> getAuthOrgIds() {
        String appid = this.getView().getFormShowParameter().getAppId();
        long currUserId = RequestContext.get().getCurrUserId();
        BatchIntViewInfoEnum batchIntViewInfo = this.getBatchIntViewInfo();
        String entityId = batchIntViewInfo.getEntityId();
        String permissionId = batchIntViewInfo.getPermissionId();
        return TmcOrgDataHelper.getAuthorizedBankOrgIdList((Long)currUserId, (String)appid, (String)entityId, (String)permissionId);
    }
}

