/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.interestbill.batch;

import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cfm.common.enums.DataSourceEnum;
import kd.tmc.cfm.common.enums.LoanTypeEnum;
import kd.tmc.cfm.common.helper.CfmSysParamHelper;
import kd.tmc.cfm.formplugin.interestbill.batch.AbstractNavAddNewPlugin;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.tuple.Pair;

public class IntNavAddNewPlugin
extends AbstractNavAddNewPlugin {
    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)propName, (CharSequence)"payplan")) {
            this.getModel().setValue("loanbill", null);
            Object newValue = e.getChangeSet()[0].getNewValue();
            boolean isPayIntByPlan = (Boolean)newValue;
            if (isPayIntByPlan) {
                this.getModel().setValue("startdate", (Object)DateUtils.getCurrentDate());
                this.getModel().setValue("enddate", (Object)DateUtils.getCurrentDate());
            }
            this.getView().setVisible(Boolean.valueOf(isPayIntByPlan), new String[]{"payintdaterange"});
            this.getView().setVisible(Boolean.valueOf(!isPayIntByPlan), new String[]{"endintdate"});
        }
    }

    @Override
    public boolean isPreInt() {
        return false;
    }

    @Override
    public boolean isPayIntByPlan() {
        return (Boolean)this.getModel().getValue("payplan");
    }

    @Override
    public Date getStartDate(DynamicObject loanBill) {
        Date beginDate = loanBill.getDate("endinstdate");
        beginDate = EmptyUtil.isNoEmpty((Object)beginDate) ? DateUtils.getNextDay((Date)beginDate, (int)1) : loanBill.getDate("startintdate");
        return beginDate;
    }

    @Override
    public String getNonIntDataTip() {
        return ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u7ed3\u606f\u7684\u6570\u636e\u3002", (String)"IntNavAddNewPlugin_3", (String)"tmc-cfm-formplugin", (Object[])new Object[0]);
    }

    @Override
    public String getExistOnWayDataTip(String loanNum, String batchNums) {
        return ResManager.loadKDString((String)"%1$s\u5b58\u5728\u6b63\u5728\u5904\u7406\u7684\u6279\u91cf\u5229\u606f\u5355:%2$s\uff0c\u8bf7\u5148\u5b8c\u6210\u540e\u518d\u64cd\u4f5c\u3002", (String)"IntNavAddNewPlugin_6", (String)"tmc-cfm-formplugin", (Object[])new Object[]{loanNum, batchNums});
    }

    @Override
    public String getEndIntDateTip() {
        return ResManager.loadKDString((String)"\u8ba1\u606f\u65e5\u671f\u5e94\u5927\u4e8e\u7b49\u4e8e\u6700\u8fd1\u8fd8\u6b3e\u65e5\u3002", (String)"IntNavAddNewPlugin_5", (String)"tmc-cfm-formplugin", (Object[])new Object[0]);
    }

    @Override
    public void addExclusiveFilter(QFilter qfilter) {
        boolean isPayIntByPlan = (Boolean)this.getModel().getValue("payplan");
        if (isPayIntByPlan) {
            Date startDate = (Date)this.getModel().getValue("startdate");
            Date endDate = (Date)this.getModel().getValue("enddate");
            if (EmptyUtil.isNoEmpty((Object)startDate)) {
                qfilter.and("interest_entry.interesdate", ">=", (Object)DateUtils.getDataFormat((Date)startDate, (boolean)true));
            }
            if (EmptyUtil.isNoEmpty((Object)endDate)) {
                qfilter.and("interest_entry.interesdate", "<=", (Object)DateUtils.getDataFormat((Date)endDate, (boolean)false));
            }
            qfilter.and("interest_entry.intstate", "=", (Object)"0");
        } else {
            Date endIntDate = (Date)this.getModel().getValue("endintdate");
            qfilter.and(QFilter.isNotNull((String)"endinstdate").and(new QFilter("endinstdate", "<", (Object)endIntDate)).or(QFilter.isNull((String)"endinstdate").and(new QFilter("startintdate", "<=", (Object)endIntDate))));
            qfilter.and(QFilter.isNull((String)"lastpayinstdate").or(QFilter.isNotNull((String)"lastpayinstdate").and(new QFilter("lastpayinstdate", "<", (Object)endIntDate))));
            qfilter.and(QFilter.isNull((String)"lastrepaydate").or(QFilter.isNotNull((String)"lastrepaydate").and(new QFilter("lastrepaydate", "<=", (Object)endIntDate))));
        }
        Object loanIds = this.getView().getFormShowParameter().getCustomParams().get("loanIds");
        if (EmptyUtil.isNoEmpty(loanIds)) {
            qfilter.and("id", "not in", loanIds);
        }
        qfilter.and(new QFilter("drawtype", "in", Arrays.asList("drawed", "partpayment", "allpayment")));
        this.addQfilterByIsPayIntByPlan(qfilter, isPayIntByPlan);
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Map customParam = this.getView().getFormShowParameter().getCustomParams();
        if (customParam.containsKey("fromLoanBill")) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"company", "settlecenterloan", "currency", "contractbill", "contractnum", "settlecenter", "payintdaterange"});
            if (customParam.containsKey("isPayIntByPlan")) {
                boolean isPayIntByPlan = (Boolean)customParam.get("isPayIntByPlan");
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"payplan", (Object)isPayIntByPlan);
                this.getView().setVisible(Boolean.valueOf(!isPayIntByPlan), new String[]{"endintdate"});
            }
        } else {
            boolean isPayIntByPlan = (Boolean)this.getModel().getValue("payplan");
            this.getView().setVisible(Boolean.valueOf(isPayIntByPlan), new String[]{"payintdaterange"});
        }
    }

    private void addQfilterByIsPayIntByPlan(QFilter qfilter, boolean isPayIntByPlan) {
        String loanType = this.getBatchIntViewInfo().getLoanType();
        boolean isEcOrIfm = LoanTypeEnum.isLinklend((String)loanType) || LoanTypeEnum.isIfm((String)loanType);
        String mainOrgFeild = isEcOrIfm ? "creditorg" : "org";
        DynamicObjectCollection loanBills = QueryServiceHelper.query((String)"ifm_loanbill", (String)(mainOrgFeild + ", datasource"), (QFilter[])qfilter.toArray());
        if (loanBills.size() == 0) {
            return;
        }
        Set orgIds = loanBills.stream().map(d -> d.getLong(mainOrgFeild)).collect(Collectors.toSet());
        List orgList = orgIds.stream().collect(Collectors.toList());
        String dataSource = ((DynamicObject)loanBills.get(0)).getString("datasource");
        Pair orgs = DataSourceEnum.isBond((String)dataSource) ? CfmSysParamHelper.getAppBoolParameterBatch((String)TmcAppEnum.BOND.getId(), (String)"bdim002", orgList) : CfmSysParamHelper.getAppBoolParameterBatch((String)TmcAppEnum.CFM.getId(), (String)"cfm012", orgList);
        qfilter.and(new QFilter(mainOrgFeild, "in", isPayIntByPlan ? orgs.getLeft() : orgs.getRight()));
    }
}

