/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.interestbill.batch;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cfm.common.enums.PreintTypeEnum;
import kd.tmc.cfm.common.helper.InterestCalcHelper;
import kd.tmc.fbp.common.enums.InterestTypeEnum;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.model.interest.IntBillDetailExtInfo;
import kd.tmc.fbp.common.model.interest.IntBillDetailInfo;
import kd.tmc.fbp.common.model.interest.IntBillExtInfo;
import kd.tmc.fbp.common.model.interest.IntBillInfo;
import kd.tmc.fbp.common.util.EmptyUtil;

public class IntbillDetailEdit
extends AbstractFormPlugin {
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.loanIntDetailInfo();
    }

    private void loanIntDetailInfo() {
        DynamicObject loanInfo;
        this.initIntTypeComb();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object currency = customParams.get("currency");
        String callIntStr = (String)customParams.get("intdetail");
        if (EmptyUtil.isEmpty((String)callIntStr)) {
            return;
        }
        Object loanId = customParams.get("loanbillid");
        if (EmptyUtil.isNoEmpty(loanId) && EmptyUtil.isNoEmpty((DynamicObject)(loanInfo = QueryServiceHelper.queryOne((String)"cfm_loanbill", (String)"id,interesttype,ratesign,ratefloatpoint", (QFilter[])new QFilter[]{new QFilter("id", "=", loanId)})))) {
            this.docfmBiz(currency, callIntStr, loanInfo);
            return;
        }
        this.doOtherBiz(currency, callIntStr);
    }

    private void doOtherBiz(Object currency, String callIntStr) {
        IntBillInfo intBillInfo = (IntBillInfo)SerializationUtils.fromJsonString((String)callIntStr, IntBillInfo.class);
        if (EmptyUtil.isEmpty((Object)intBillInfo)) {
            return;
        }
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"floatrate", "floatint", "benchmarkrate", "benchmarkint"});
        List details = intBillInfo.getDetails();
        if (EmptyUtil.isEmpty((Collection)details)) {
            return;
        }
        details.sort(Comparator.comparing(IntBillDetailInfo::getBeginDate));
        ArrayList dataMap = new ArrayList(details.size());
        for (IntBillDetailInfo intDetail : details) {
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("startdate", intDetail.getBeginDate());
            data.put("enddate", intDetail.getEndDate());
            data.put("intdays", intDetail.getDays());
            data.put("principle", intDetail.getPrinciple());
            data.put("rate", intDetail.getRate());
            data.put("intdate", intDetail.getBeginDate());
            data.put("currency", currency);
            data.put("totalint", intDetail.getAmount());
            data.put("basis", intDetail.getBasisDay());
            data.put("intcategory", intDetail.getIntType().getValue());
            dataMap.add(data);
        }
        TmcViewInputHelper.batchFillEntity((String)"entry", (AbstractFormDataModel)((AbstractFormDataModel)this.getModel()), dataMap);
        this.getView().updateView("entry");
    }

    private void docfmBiz(Object currency, String callIntStr, DynamicObject loanInfo) {
        IntBillExtInfo intBillInfo = (IntBillExtInfo)SerializationUtils.fromJsonString((String)callIntStr, IntBillExtInfo.class);
        List details = intBillInfo.getExtDetails();
        if (EmptyUtil.isEmpty((Collection)details)) {
            this.doOtherBiz(currency, callIntStr);
        } else {
            details.sort(Comparator.comparing(IntBillDetailInfo::getBeginDate));
            ArrayList dataMap = new ArrayList(details.size());
            String interestType = loanInfo.getString("interesttype");
            boolean isFloatRate = InterestTypeEnum.isFloat((String)interestType);
            String rateSign = loanInfo.getString("ratesign");
            BigDecimal rateFloatpoint = loanInfo.getBigDecimal("ratefloatpoint");
            for (IntBillDetailExtInfo intDetail : details) {
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("startdate", intDetail.getBeginDate());
                data.put("enddate", intDetail.getEndDate());
                data.put("intdays", intDetail.getDays());
                data.put("principle", intDetail.getPrinciple());
                data.put("rate", intDetail.getRate());
                data.put("intdate", intDetail.getBeginDate());
                data.put("currency", currency);
                BigDecimal totalRate = intDetail.getRate();
                BigDecimal totalInt = intDetail.getTotalInt();
                totalInt = EmptyUtil.isEmpty((BigDecimal)totalInt) ? intDetail.getAmount() : totalInt;
                BigDecimal resPointRate = InterestCalcHelper.getPointRate((boolean)isFloatRate, (String)rateSign, (BigDecimal)rateFloatpoint, (BigDecimal)intDetail.getFloatRate());
                BigDecimal resPointInt = InterestCalcHelper.getPointInt((BigDecimal)totalRate, (BigDecimal)totalInt, (BigDecimal)resPointRate);
                data.put("floatrate", resPointRate);
                data.put("floatint", resPointInt);
                data.put("benchmarkrate", totalRate.subtract(resPointRate));
                data.put("benchmarkint", totalInt.subtract(resPointInt));
                data.put("totalint", totalInt);
                data.put("basis", intDetail.getBasisDay());
                data.put("intcategory", intDetail.getIntType().getValue());
                dataMap.add(data);
            }
            TmcViewInputHelper.batchFillEntity((String)"entry", (AbstractFormDataModel)((AbstractFormDataModel)this.getModel()), dataMap);
            this.getView().updateView("entry");
        }
    }

    private void initIntTypeComb() {
        boolean isCurrentPre;
        ComboEdit categoryComb = (ComboEdit)this.getControl("intcategory");
        IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        if (EmptyUtil.isEmpty((Object)parentView)) {
            return;
        }
        IDataModel pModel = parentView.getModel();
        if (EmptyUtil.isEmpty((Object)pModel)) {
            return;
        }
        Object currentIntType = this.getView().getFormShowParameter().getCustomParams().get("currentinttype");
        String pModelName = pModel.getDataEntityType().getName();
        boolean isCurrentInt = EmptyUtil.isNoEmpty(currentIntType) || pModelName.equals("ifm_intbill_batch_current");
        boolean bl = isCurrentPre = pModelName.equals("ifm_intbill_batch_pre") && PreintTypeEnum.CURRENTINT.getValue().equals(pModel.getValue("interesttype"));
        if (!isCurrentInt && !isCurrentPre) {
            ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(2);
            comboItems.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u6b63\u5e38\u5229\u606f", (String)"IntbillDetailEdit_0", (String)"tmc-cfm-formplugin", (Object[])new Object[0])), "normal"));
            comboItems.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u903e\u671f\u5229\u606f", (String)"IntbillDetailEdit_1", (String)"tmc-cfm-formplugin", (Object[])new Object[0])), "overdue"));
            comboItems.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5c55\u671f\u5229\u606f", (String)"IntbillDetailEdit_2", (String)"tmc-cfm-formplugin", (Object[])new Object[0])), "extend"));
            categoryComb.setComboItems(comboItems);
        }
    }
}

