/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.interestbill.batch;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.tmc.cfm.common.helper.BatchIntBillHelper;
import kd.tmc.cfm.common.helper.BusinessHelper;
import kd.tmc.cfm.formplugin.resource.CfmFormResourceEnum;
import kd.tmc.fbp.common.util.EmptyUtil;

public class InterestBillSlBatchEdit
extends AbstractBillPlugIn {
    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        switch (name = e.getProperty().getName()) {
            case "currency": 
            case "convertintamt": {
                this.setSlBankEntryConvertIntamt();
                break;
            }
            case "actualinstamt": {
                this.setSlBankEntryInstamt();
                break;
            }
            case "s_repayinst": {
                this.slRepayintamtChange();
                break;
            }
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        int entryRowCount = this.getModel().getEntryRowCount("slentryentity");
        this.getView().setVisible(Boolean.valueOf(entryRowCount != 0), new String[]{"sl_entry"});
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        Control source = (Control)e.getSource();
        String key = source.getKey();
        if ("s_repayinst".equals(key)) {
            int currIdx = this.getModel().getEntryCurrentRowIndex("slentryentity");
            DynamicObject loanBillno = (DynamicObject)this.getModel().getValue("s_loanbillno", currIdx);
            if (EmptyUtil.isEmpty((DynamicObject)loanBillno) || EmptyUtil.isEmpty((Object)e.getValue())) {
                return;
            }
            BigDecimal amount = new BigDecimal(String.valueOf(e.getValue()));
            if (BigDecimal.ZERO.compareTo(amount) > 0) {
                e.setCancel(true);
                this.getView().updateView("s_repayinst", currIdx);
                return;
            }
            BigDecimal loanAmount = (BigDecimal)this.getModel().getValue("s_loanamount", currIdx);
            DynamicObject loanEntry = this.getLoanEntry(loanBillno.getLong("id"));
            if (EmptyUtil.isEmpty((BigDecimal)loanAmount) && EmptyUtil.isNoEmpty((BigDecimal)amount)) {
                e.setCancel(true);
                this.getView().showTipNotification(CfmFormResourceEnum.InterestBillSlBatchEdit_1.loadKDString());
                this.getView().updateView("s_repayinst", currIdx);
                return;
            }
            if (EmptyUtil.isNoEmpty((DynamicObject)loanEntry) && loanEntry.getBigDecimal("actualinstamt").compareTo(amount) < 0) {
                e.setCancel(true);
                int amtPrecision = BusinessHelper.getCurrencyPresion((DynamicObject)((DynamicObject)this.getModel().getValue("s_instcurrency", currIdx)));
                this.getView().showTipNotification(CfmFormResourceEnum.InterestBillSlBatchEdit_0.loadKDString(loanEntry.getBigDecimal("actualinstamt").setScale(amtPrecision)));
                this.getView().updateView("s_repayinst", currIdx);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("deleteentryloans".equals(operateKey)) {
            this.deleteSlBankEntry();
        }
    }

    private void deleteSlBankEntry() {
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("entry");
        Set loanBillIds = entrys.stream().map(o -> o.getLong("loanbillid")).collect(Collectors.toSet());
        int slRowCount = this.getModel().getEntryRowCount("slentryentity");
        HashSet<Integer> rowIdx = new HashSet<Integer>(slRowCount);
        for (int i2 = 0; i2 < slRowCount; ++i2) {
            DynamicObject loanBill = (DynamicObject)this.getModel().getValue("s_loanbillno", i2);
            if (!EmptyUtil.isEmpty((DynamicObject)loanBill) && loanBillIds.contains(loanBill.getLong("id"))) continue;
            rowIdx.add(i2);
        }
        if (rowIdx.size() > 0) {
            this.getModel().deleteEntryRows("slentryentity", rowIdx.stream().mapToInt(i -> i).toArray());
        }
        int entryRowCount = this.getModel().getEntryRowCount("slentryentity");
        this.getView().setVisible(Boolean.valueOf(entryRowCount != 0), new String[]{"sl_entry"});
    }

    private void slRepayintamtChange() {
        List<DynamicObject> slEntrys;
        DynamicObject loanEntry;
        block2: {
            BigDecimal subAmount;
            DynamicObject loanBillNo;
            block3: {
                BigDecimal slTotalInstAmt;
                int currIdx = this.getModel().getEntryCurrentRowIndex("slentryentity");
                loanBillNo = (DynamicObject)this.getModel().getValue("s_loanbillno", currIdx);
                if (EmptyUtil.isEmpty((DynamicObject)loanBillNo)) {
                    return;
                }
                loanEntry = this.getLoanEntry(loanBillNo.getLong("id"));
                BigDecimal loanInstAmt = loanEntry.getBigDecimal("actualinstamt");
                subAmount = loanInstAmt.subtract(slTotalInstAmt = (slEntrys = this.getslBankEntryList(loanBillNo.getLong("id"))).stream().map(o -> o.getBigDecimal("s_repayinst")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                if (EmptyUtil.isEmpty((BigDecimal)subAmount)) break block2;
                DynamicObject bank = (DynamicObject)this.getModel().getValue("s_bank", currIdx);
                if (slEntrys.size() != 2 || !EmptyUtil.isNoEmpty((DynamicObject)bank)) break block3;
                DynamicObject slEntry = slEntrys.stream().filter(o -> EmptyUtil.isNoEmpty((DynamicObject)o.getDynamicObject("s_bank")) && EmptyUtil.isNoEmpty((BigDecimal)o.getBigDecimal("s_loanamount")) && o.getDynamicObject("s_bank").getLong("id") != bank.getLong("id")).findFirst().orElse(null);
                if (!EmptyUtil.isNoEmpty((DynamicObject)slEntry)) break block2;
                BigDecimal sRepayInt = slEntry.getBigDecimal("s_repayinst").add(subAmount);
                slEntry.set("s_repayinst", (Object)(sRepayInt.compareTo(BigDecimal.ZERO) > 0 ? sRepayInt : BigDecimal.ZERO));
                break block2;
            }
            int slRowCount = this.getModel().getEntryRowCount("slentryentity");
            for (int i = currIdx + 1; i <= slRowCount; ++i) {
                DynamicObject rowEntity;
                BigDecimal loanAmount;
                DynamicObject loanBill;
                DynamicObject dynamicObject = loanBill = i < slRowCount ? (DynamicObject)this.getModel().getValue("s_loanbillno", i) : null;
                if (slRowCount != i && (loanBill == null || loanBill.getLong("id") == loanBillNo.getLong("id")) || !EmptyUtil.isNoEmpty((BigDecimal)(loanAmount = (rowEntity = this.getModel().getEntryRowEntity("slentryentity", i - 1)).getBigDecimal("s_loanamount")))) continue;
                BigDecimal instAmt = rowEntity.getBigDecimal("s_repayinst").add(subAmount);
                rowEntity.set("s_repayinst", (Object)(instAmt.compareTo(BigDecimal.ZERO) > 0 ? instAmt : BigDecimal.ZERO));
                break;
            }
        }
        this.setSlConvertIntamt(slEntrys, loanEntry.getBigDecimal("convertrate"), loanEntry.getBigDecimal("convertintamt"));
        this.getView().updateView("slentryentity");
    }

    private void setSlConvertIntamt(List<DynamicObject> slEntrys, BigDecimal rate, BigDecimal convertTotalAmout) {
        BigDecimal totalAmount = BigDecimal.ZERO;
        for (DynamicObject slEntry : slEntrys) {
            int amtPrecision = BusinessHelper.getCurrencyPresion((DynamicObject)slEntry.getDynamicObject("s_instcurrency"));
            BigDecimal actualInstAmt = slEntry.getBigDecimal("s_repayinst");
            if (EmptyUtil.isEmpty((BigDecimal)actualInstAmt)) {
                slEntry.set("s_convertintamt", (Object)BigDecimal.ZERO);
                continue;
            }
            BigDecimal convertintAmt = actualInstAmt.multiply(rate).setScale(amtPrecision, RoundingMode.HALF_UP);
            slEntry.set("s_convertintamt", (Object)convertintAmt);
            totalAmount = totalAmount.add(convertintAmt);
        }
        BigDecimal subAmount = convertTotalAmout.subtract(totalAmount);
        if (EmptyUtil.isEmpty((BigDecimal)subAmount)) {
            return;
        }
        for (DynamicObject slEntry : slEntrys) {
            if (EmptyUtil.isEmpty((BigDecimal)slEntry.getBigDecimal("s_repayinst"))) continue;
            BigDecimal conAmt = slEntry.getBigDecimal("s_convertintamt").add(subAmount);
            if (BigDecimal.ZERO.compareTo(conAmt) > 0) {
                subAmount = conAmt;
            }
            slEntry.set("s_convertintamt", (Object)(conAmt.compareTo(BigDecimal.ZERO) >= 0 ? conAmt : BigDecimal.ZERO));
            if (!EmptyUtil.isEmpty((BigDecimal)subAmount) && conAmt.compareTo(BigDecimal.ZERO) < 0) continue;
            break;
        }
    }

    private DynamicObject getLoanEntry(long loanBillid) {
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("entry");
        DynamicObject entry = entrys.stream().filter(o -> EmptyUtil.isNoEmpty((Long)o.getLong("loanbillid")) && o.getLong("loanbillid") == loanBillid).findFirst().orElse(null);
        return entry;
    }

    private void setSlBankEntryInstamt() {
        int currIdx = this.getModel().getEntryCurrentRowIndex("entry");
        Long loanBillId = (Long)this.getModel().getValue("loanbillid");
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency", currIdx);
        BigDecimal actualInstamt = (BigDecimal)this.getModel().getValue("actualinstamt", currIdx);
        List<DynamicObject> slBankEntryList = this.getslBankEntryList(loanBillId);
        this.getModel().beginInit();
        BatchIntBillHelper.setSlBankEntryAmount(slBankEntryList, (BigDecimal)actualInstamt, (String)"s_repayinst", (DynamicObject)currency, (boolean)false);
        this.getModel().endInit();
        this.getView().updateView("slentryentity");
    }

    private void setSlBankEntryConvertIntamt() {
        int currIdx = this.getModel().getEntryCurrentRowIndex("entry");
        Long loanBillId = (Long)this.getModel().getValue("loanbillid");
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency", currIdx);
        BigDecimal convertIntAmt = (BigDecimal)this.getModel().getValue("convertintamt", currIdx);
        List<DynamicObject> slBankEntryList = this.getslBankEntryList(loanBillId);
        BatchIntBillHelper.setSlBankEntryAmount(slBankEntryList, (BigDecimal)convertIntAmt, (String)"s_convertintamt", (DynamicObject)currency, (boolean)false);
        this.getView().updateView("slentryentity");
    }

    private List<DynamicObject> getslBankEntryList(long loanBillId) {
        DynamicObjectCollection slBankEntrys = this.getModel().getEntryEntity("slentryentity");
        List<DynamicObject> slBankEntryList = slBankEntrys.stream().filter(o -> EmptyUtil.isNoEmpty((DynamicObject)o.getDynamicObject("s_loanbillno")) && o.getDynamicObject("s_loanbillno").getLong("id") == loanBillId).collect(Collectors.toList());
        return slBankEntryList;
    }
}

