/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.interestway;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.TextEdit;
import kd.bos.form.operate.FormOperate;
import kd.tmc.cfm.common.enums.InschemeEnum;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.ListUtils;

public class InschemeEdit
extends AbstractBasePlugIn {
    private static final String TMC_CFM_FORMPLUGIN = "tmc-cfm-formplugin";
    private static final String DEFAULT_INTDAY = "20";
    private static final Map<String, String> ckDayMap = new HashMap<String, String>(50);
    private static final Map<String, String> ckMonthMap = new HashMap<String, String>(12);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"save"});
        this.addClickListeners(new String[]{"intereststmh", "intereststday", "offetday", "flexpmb", "flexpmlab", "flexpdb", "flexpdlab"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        int billStatus = this.getView().getFormShowParameter().getStatus().getValue();
        this.setControlVisible(billStatus != 0, "preset");
        boolean isChanged = this.getModel().getDataChanged();
        this.changeCkMonth();
        this.changeCkDay();
        this.getModel().setDataChanged(isChanged);
    }

    private void setControlVisible(Boolean isVisible, String ... controls) {
        this.getView().setVisible(isVisible, controls);
    }

    private void setControlValue(String propName, boolean mustInput, String value) {
        TextEdit textEdit = (TextEdit)this.getView().getControl(propName);
        textEdit.setMustInput(mustInput);
        this.getModel().setValue(propName, (Object)value);
    }

    private void setInterestMonthDayValue(boolean mustInput, String monthValue, String dayValue) {
        this.setControlValue("intereststmh", mustInput, monthValue);
        this.setControlValue("intereststday", mustInput, dayValue);
    }

    public void propertyChanged(PropertyChangedArgs arg0) {
        String propName;
        super.propertyChanged(arg0);
        switch (propName = arg0.getProperty().getName()) {
            case "intereststpd": {
                this.changeInteresetPd();
                break;
            }
            case "intereststmh": {
                this.changeCkMonth();
                break;
            }
            case "intereststday": {
                this.changeCkDay();
                break;
            }
            default: {
                if (ckDayMap.containsKey(propName)) {
                    this.setControlValue("intereststday", this.repeatByDay(propName));
                }
                if (!ckMonthMap.containsKey(propName)) break;
                this.setControlValue("intereststmh", this.repeatByMonth());
            }
        }
    }

    private void updateView(String ... propNames) {
        IFormView view = this.getView();
        for (String propName : propNames) {
            view.updateView(propName);
        }
    }

    private void setControlValue(String name, Object value) {
        this.getModel().beginInit();
        this.getModel().setValue(name, value);
        this.getModel().endInit();
        this.updateView(name);
    }

    private String loadKDString(String desc, String resourceID) {
        return ResManager.loadKDString((String)desc, (String)resourceID, (String)TMC_CFM_FORMPLUGIN, (Object[])new Object[0]);
    }

    private void changeInteresetPd() {
        String pd = this.getModel().getValue("intereststpd").toString();
        if (EmptyUtil.isEmpty((String)pd)) {
            return;
        }
        InschemeEnum inschemeEnum = InschemeEnum.getByValue((String)pd);
        if (inschemeEnum == null) {
            return;
        }
        this.getModel().beginInit();
        boolean isCycle = InschemeEnum.isCycle((String)pd);
        this.setInterestMonthDayValue(isCycle, isCycle ? InschemeEnum.getMonths((InschemeEnum)inschemeEnum) : null, isCycle ? DEFAULT_INTDAY : null);
        this.getModel().setValue("drawmonthsettle", (Object)(isCycle ? Boolean.FALSE : null));
        boolean isToCycle = InschemeEnum.isToCycle((String)pd);
        this.getModel().setValue("offetday", (Object)(isToCycle ? Integer.valueOf(1) : null));
        this.getModel().endInit();
        this.updateView("intereststmh", "intereststday", "offetday", "drawmonthsettle");
        this.changeCkMonth();
        this.changeCkDay();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "save": {
                String pd = (String)this.getModel().getValue("intereststpd");
                if (InschemeEnum.isCycle((String)pd) && !TmcViewInputHelper.checkMustInput((IFormView)this.getView(), (IDataModel)this.getModel(), (boolean)false, (String[])new String[]{"intereststday", "intereststmh"})) {
                    args.setCancel(true);
                }
                if (this.Choose()) break;
                args.setCancel(true);
                break;
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        switch (source.getKey()) {
            case "intereststmh": {
                if (EmptyUtil.isEmpty((Object)this.getModel().getValue("intereststpd"))) {
                    this.getView().showTipNotification(this.loadKDString("\u8bf7\u5148\u9009\u62e9\u7ed3\u606f\u5468\u671f\u3002", "InschemeEdit_1"));
                    return;
                }
                this.setControlVisible(true, "flexpmonths");
                break;
            }
            case "flexpmb": 
            case "flexpmlab": {
                this.setControlVisible(false, "flexpmonths");
                break;
            }
            case "intereststday": {
                if (EmptyUtil.isEmpty((Object)this.getModel().getValue("intereststpd"))) {
                    this.getView().showTipNotification(this.loadKDString("\u8bf7\u5148\u9009\u62e9\u7ed3\u606f\u5468\u671f\u3002", "InschemeEdit_1"));
                    return;
                }
                this.setControlVisible(true, "flexpdays");
                break;
            }
            case "flexpdb": 
            case "flexpdlab": {
                this.setControlVisible(false, "flexpdays");
                break;
            }
        }
    }

    private boolean Choose() {
        String selectedMonths = (String)this.getModel().getValue("intereststmh");
        if (EmptyUtil.isEmpty((String)selectedMonths)) {
            return true;
        }
        if (",".equals(selectedMonths.substring(0, 1))) {
            selectedMonths = selectedMonths.substring(1);
        }
        List monthList = ListUtils.strToIntList((String)selectedMonths);
        Integer[] newMonthArray = monthList.toArray(new Integer[monthList.size()]);
        int monthNum = newMonthArray.length;
        String period = this.getModel().getValue("intereststpd").toString();
        InschemeEnum inschemeEnum = InschemeEnum.getByValue((String)period);
        if (inschemeEnum == null) {
            return true;
        }
        switch (inschemeEnum) {
            case YEAR: {
                if (monthNum == 1) break;
                this.getView().showMessage(this.loadKDString("\u60a8\u5fc5\u987b\u9009\u62e9\u4e00\u4e2a\u7ed3\u606f\u6708\u4efd\u3002", "InschemeEdit_2"));
                return false;
            }
            case HALFYEAR: {
                if (monthNum != 2) {
                    this.getView().showMessage(this.loadKDString("\u60a8\u5fc5\u987b\u9009\u62e9\u4e24\u4e2a\u7ed3\u606f\u6708\u4efd\u3002", "InschemeEdit_3"));
                    return false;
                }
                if (newMonthArray[0] >= 1 && newMonthArray[0] <= 6 && newMonthArray[1] >= 7 && newMonthArray[1] <= 12) break;
                this.getView().showMessage(this.loadKDString("\u8bf7\u5728\u4e0a\u534a\u5e74\u4e0b\u534a\u5e74\u5404\u9009\u4e00\u4e2a\u7ed3\u606f\u6708\u4efd", "InschemeEdit_4"));
                return false;
            }
            case QUARTER: {
                if (monthNum != 4) {
                    this.getView().showMessage(this.loadKDString("\u60a8\u5fc5\u987b\u9009\u62e9\u56db\u4e2a\u7ed3\u606f\u6708\u4efd\u3002", "InschemeEdit_5"));
                    return false;
                }
                if (newMonthArray[0] >= 1 && newMonthArray[0] <= 3 && newMonthArray[1] >= 4 && newMonthArray[1] <= 6 && newMonthArray[2] >= 7 && newMonthArray[2] <= 9 && newMonthArray[3] >= 10 && newMonthArray[3] <= 12) break;
                this.getView().showMessage(this.loadKDString("\u8bf7\u6bcf\u4e2a\u5b63\u5ea6\u9009\u62e9\u4e00\u4e2a\u7ed3\u606f\u6708\u4efd\u3002", "InschemeEdit_6"));
                return false;
            }
            case MONTH: {
                if (monthNum == 12) break;
                this.getView().showMessage(this.loadKDString("\u60a8\u5fc5\u987b\u9009\u62e9\u5341\u4e8c\u4e2a\u7ed3\u606f\u6708\u4efd\u3002", "InschemeEdit_7"));
                return false;
            }
        }
        return true;
    }

    private String repeatByDay(String propName) {
        IDataModel dataModel = this.getModel();
        Boolean value = (Boolean)dataModel.getValue(propName);
        String day = "";
        for (Map.Entry<String, String> cbox : ckDayMap.entrySet()) {
            String key = cbox.getKey();
            if (key.equals(propName) && value.booleanValue()) {
                day = cbox.getValue();
            }
            if (key.equals(propName) || !value.booleanValue() || !((Boolean)dataModel.getValue(key)).booleanValue()) continue;
            this.setControlValue(key, Boolean.FALSE);
        }
        return day;
    }

    private void changeCkDay() {
        IDataModel dataModel = this.getView().getModel();
        String day = (String)dataModel.getValue("intereststday");
        dataModel.beginInit();
        for (Map.Entry<String, String> cbox : ckDayMap.entrySet()) {
            dataModel.setValue(cbox.getKey(), (Object)day.equals(cbox.getValue()));
        }
        dataModel.endInit();
        this.updateView((String[])ckDayMap.keySet().stream().toArray(String[]::new));
    }

    private String repeatByMonth() {
        IDataModel dataModel = this.getView().getModel();
        ArrayList<String> ckeys = new ArrayList<String>();
        ArrayList<Integer> selectMonths = new ArrayList<Integer>(12);
        for (Map.Entry<String, String> cbox : ckMonthMap.entrySet()) {
            if (!((Boolean)dataModel.getValue(cbox.getKey())).booleanValue()) continue;
            ckeys.add(cbox.getKey());
            selectMonths.add(Integer.valueOf(cbox.getValue()));
        }
        this.setCkMonthEnable(ckeys);
        Collections.sort(selectMonths);
        return selectMonths.stream().map(String::valueOf).collect(Collectors.joining(","));
    }

    private void changeCkMonth() {
        IDataModel dataModel = this.getView().getModel();
        String months = (String)dataModel.getValue("intereststmh");
        ArrayList<String> ckMonthKeys = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)months)) {
            ckMonthKeys.addAll(Arrays.asList(months.split(",")));
        }
        ArrayList<String> ckeys = new ArrayList<String>();
        dataModel.beginInit();
        for (Map.Entry<String, String> cbox : ckMonthMap.entrySet()) {
            boolean isContainKey = ckMonthKeys.contains(cbox.getValue());
            dataModel.setValue(cbox.getKey(), (Object)isContainKey);
            if (!isContainKey) continue;
            ckeys.add(cbox.getKey());
        }
        dataModel.endInit();
        this.updateView((String[])ckMonthMap.keySet().stream().toArray(String[]::new));
        this.setCkMonthEnable(ckeys);
    }

    private void setCkMonthEnable(List<String> ckeys) {
        Boolean cleDisEnable = Boolean.TRUE;
        String period = (String)this.getModel().getValue("intereststpd");
        InschemeEnum inschemeEnum = InschemeEnum.getByValue((String)period);
        if (inschemeEnum == null) {
            return;
        }
        int ckeySize = ckeys.size();
        switch (inschemeEnum) {
            case YEAR: {
                cleDisEnable = ckeySize == 0;
                break;
            }
            case HALFYEAR: {
                cleDisEnable = ckeySize <= 1;
                break;
            }
            case QUARTER: {
                cleDisEnable = ckeySize <= 3;
                break;
            }
            case MONTH: {
                cleDisEnable = ckeySize <= 11;
            }
        }
        String[] keys = ckMonthMap.keySet().toArray(new String[ckMonthMap.size()]);
        if (cleDisEnable.booleanValue()) {
            this.getView().setEnable(Boolean.valueOf(true), keys);
        } else {
            List<String> ks = Arrays.stream(keys).filter(v -> !ckeys.contains(v)).collect(Collectors.toList());
            this.getView().setEnable(Boolean.valueOf(false), ks.toArray(new String[ks.size()]));
            this.getView().setEnable(Boolean.valueOf(true), ckeys.toArray(new String[ckeySize]));
        }
    }

    static {
        ckDayMap.put("ckone", "1");
        ckDayMap.put("cktwo", "2");
        ckDayMap.put("ckthree", "3");
        ckDayMap.put("ckfour", "4");
        ckDayMap.put("ckfive", "5");
        ckDayMap.put("cksix", "6");
        ckDayMap.put("ckseven", "7");
        ckDayMap.put("ckeight", "8");
        ckDayMap.put("cknine", "9");
        ckDayMap.put("ckten", "10");
        ckDayMap.put("ckeleven", "11");
        ckDayMap.put("cktwelve", "12");
        ckDayMap.put("ckthirteen", "13");
        ckDayMap.put("ckfourteen", "14");
        ckDayMap.put("ckfifteen", "15");
        ckDayMap.put("cksixteen", "16");
        ckDayMap.put("ckseventeen", "17");
        ckDayMap.put("ckeighteen", "18");
        ckDayMap.put("cknineteen", "19");
        ckDayMap.put("cktwenty", DEFAULT_INTDAY);
        ckDayMap.put("cktwentyone", "21");
        ckDayMap.put("cktwentytwo", "22");
        ckDayMap.put("cktwentythree", "23");
        ckDayMap.put("cktwentyfour", "24");
        ckDayMap.put("cktwentyfive", "25");
        ckDayMap.put("cktwentysix", "26");
        ckDayMap.put("cktwentyseven", "27");
        ckDayMap.put("cktwentyeight", "28");
        ckDayMap.put("cktwentynine", "29");
        ckDayMap.put("ckthirty", "30");
        ckDayMap.put("ckthirtyone", "31");
        ckMonthMap.put("ckjan", "1");
        ckMonthMap.put("ckfeb", "2");
        ckMonthMap.put("ckmar", "3");
        ckMonthMap.put("ckapr", "4");
        ckMonthMap.put("ckmay", "5");
        ckMonthMap.put("ckjun", "6");
        ckMonthMap.put("ckjul", "7");
        ckMonthMap.put("ckaug", "8");
        ckMonthMap.put("cksep", "9");
        ckMonthMap.put("ckoct", "10");
        ckMonthMap.put("cknov", "11");
        ckMonthMap.put("ckdec", "12");
    }
}

