/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.loanbill;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.tmc.cfm.common.enums.LoanTypeEnum;
import kd.tmc.cfm.common.helper.CfmFinVarietyHelper;
import kd.tmc.cfm.common.helper.CreditLimitHelper;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.model.CreditLimitUseBean;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.common.AbstractCreditLimitEditPlugin;

public class BankLoanBillCreditLimitPlugin
extends AbstractCreditLimitEditPlugin {
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.controlSlCreditlimit();
    }

    private void controlSlCreditlimit() {
        boolean slLoanCreditlimit = this.isSlLoanCreditlimit();
        this.getView().setVisible(Boolean.valueOf(slLoanCreditlimit), new String[]{"e_bankcreditlimit", "e_bankcreditcurrency", "e_bankcreditamt"});
    }

    private boolean isSlLoanCreditlimit() {
        String loanType = (String)this.getModel().getValue("loantype");
        boolean isBanksLoan = LoanTypeEnum.isBanksLoan((String)loanType);
        if (!isBanksLoan) {
            return false;
        }
        DynamicObject loanConBill = (DynamicObject)this.getModel().getValue("loancontractbill");
        if (EmptyUtil.isNoEmpty((DynamicObject)loanConBill)) {
            boolean isConCreditUse = CreditLimitHelper.isCreditUse((long)loanConBill.getLong("id"), null);
            return !isConCreditUse;
        }
        return false;
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey = args.getOperateKey();
        if (args.getOperationResult() == null || !args.getOperationResult().isSuccess()) {
            return;
        }
        switch (operateKey) {
            case "audit": {
                this.afterAuditOperation(args);
                this.controlSlCreditlimit();
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if ("e_bankcreditlimit".equals(actionId)) {
            this.getView().updateView("banksyndicate_entry");
        }
    }

    private void afterAuditOperation(AfterDoOperationEventArgs args) {
        if (args.getOperationResult().isSuccess()) {
            this.getView().updateView("banksyndicate_entry");
        }
    }

    protected Map<String, String> getCreditlimiFieldMap() {
        HashMap<String, String> fieldMap = new HashMap<String, String>(8);
        fieldMap.put("e_bankcreditlimit", "banksyndicate_entry");
        return fieldMap;
    }

    protected Map<String, String> getBizPropertys() {
        HashMap<String, String> propertys = new HashMap<String, String>();
        propertys.put("org", "org");
        propertys.put("finorg", "e_bank");
        propertys.put("amount", "e_shareamount");
        propertys.put("currency", "currency");
        propertys.put("startDate", "bizdate");
        propertys.put("endDate", "expiredate");
        return propertys;
    }

    protected Set<String> getEntryFields() {
        HashSet<String> entryFields = new HashSet<String>();
        entryFields.add("e_bank");
        entryFields.add("e_shareamount");
        entryFields.add("e_bankcreditlimit");
        return entryFields;
    }

    protected BigDecimal getAmount() {
        return (BigDecimal)this.getModel().getValue("e_shareamount", this.getModel().getEntryCurrentRowIndex("banksyndicate_entry"));
    }

    public boolean checkCreditlimitParams() {
        return TmcViewInputHelper.checkMustInput((IFormView)this.getView(), (IDataModel)this.getModel(), (boolean)false, (String[])new String[]{this.getBizPropertys().get("org"), this.getBizPropertys().get("finorg"), this.getBizPropertys().get("currency"), this.getBizPropertys().get("amount"), "finproduct"});
    }

    protected CreditLimitUseBean getCreditLimitUseInfo(String f7Key) {
        return super.getCreditLimitUseInfo(f7Key);
    }

    protected Long getCreditTypeId() {
        DynamicObject finProduct = (DynamicObject)this.getModel().getValue("finproduct");
        return CfmFinVarietyHelper.getCreditTypeByFinVarietyId((Long)((Long)finProduct.getPkValue()));
    }

    protected BigDecimal setCreditRatio() {
        return Constants.ONE_HUNDRED;
    }

    protected String getCreditVariety() {
        DynamicObject finProduct = (DynamicObject)this.getModel().getValue("finproduct");
        return finProduct.getString("name");
    }

    public boolean isSubmitReCreate() {
        return Boolean.FALSE;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "lenderapplyno": 
            case "loantype": {
                this.removeCreditLimit(null);
                break;
            }
            case "e_bank": 
            case "drawamount": {
                this.removeCreditLimit(null);
                break;
            }
            case "productfactory": {
                this.removeCreditLimit(null);
                break;
            }
            case "e_bankcreditlimit": {
                int currIdx = this.getModel().getEntryCurrentRowIndex("banksyndicate_entry");
                TmcViewInputHelper.clearValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (int)currIdx, (String[])new String[]{"e_bankcreditcurrency", "e_bankcreditamt"});
            }
        }
    }

    private void removeCreditLimit(Integer i) {
        if (this.isBanksLoanComit()) {
            return;
        }
        if (i == null) {
            for (int index = 0; index < this.getModel().getEntryRowCount("banksyndicate_entry"); ++index) {
                this.getModel().setValue("e_bankcreditlimit", null, index);
            }
        } else {
            this.getModel().setValue("e_bankcreditlimit", null, i.intValue());
        }
    }

    protected String getCreditUseAmtField() {
        String loanType = (String)this.getModel().getValue("loantype");
        if (LoanTypeEnum.BANKSLOAN.getValue().equals(loanType)) {
            return "e_bankcreditamt";
        }
        return null;
    }

    protected String getCreditUseCurrencyField() {
        String loanType = (String)this.getModel().getValue("loantype");
        if (LoanTypeEnum.BANKSLOAN.getValue().equals(loanType)) {
            return "e_bankcreditcurrency";
        }
        return null;
    }

    public Long getCreditUseSrcBillId() {
        if (this.isBanksLoanComit()) {
            DynamicObject loancontractbill = (DynamicObject)this.getModel().getValue("loancontractbill");
            return loancontractbill.getLong("id");
        }
        return null;
    }

    private boolean isBanksLoanComit() {
        DynamicObject productFactory = (DynamicObject)this.getModel().getValue("productfactory");
        String loanType = (String)this.getModel().getValue("loantype");
        return LoanTypeEnum.BANKSLOAN.getValue().equals(loanType) && EmptyUtil.isNoEmpty((DynamicObject)productFactory) && productFactory.getBoolean("isloancommit");
    }

    protected void setCreditUseFields() {
        String loanType = (String)this.getModel().getValue("loantype");
        if (LoanTypeEnum.isBanksLoan((String)loanType)) {
            super.setCreditUseFields();
            int entryRowCount = this.getModel().getEntryRowCount("banksyndicate_entry");
            for (int i = 0; i < entryRowCount; ++i) {
                Object eLimit = this.getModel().getValue("e_bankcreditlimit", i);
                if (!EmptyUtil.isEmpty((Object)eLimit)) continue;
                TmcViewInputHelper.clearValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (int)i, (String[])new String[]{"e_bankcreditcurrency", "e_bankcreditamt"});
            }
        }
    }

    public boolean isPreOccupy() {
        Object status = this.getModel().getValue("billstatus");
        return BillStatusEnum.SAVE.getValue().equals(status);
    }
}

