/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.loanbill;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.tmc.cfm.common.enums.BizTypeEnum;
import kd.tmc.cfm.common.enums.SlBankRoleEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class BankLoanBillEdit
extends AbstractBillPlugIn {
    public void propertyChanged(PropertyChangedArgs e) {
        String propName;
        switch (propName = e.getProperty().getName()) {
            case "drawamount": {
                this.setShareAmount();
                break;
            }
            case "e_shareamount": {
                this.checkShareAmount(e);
                break;
            }
        }
    }

    private void checkShareAmount(PropertyChangedArgs e) {
        if (this.getPageCache().getAll().containsKey("e_shareamount")) {
            return;
        }
        int currIdx = this.getModel().getEntryCurrentRowIndex("banksyndicate_entry");
        DynamicObject rowEntity = this.getModel().getEntryRowEntity("banksyndicate_entry", currIdx);
        ChangeData[] changeSet = e.getChangeSet();
        BigDecimal oldValue = (BigDecimal)changeSet[0].getOldValue();
        BigDecimal newValue = (BigDecimal)changeSet[0].getNewValue();
        BigDecimal notDrawAmount = rowEntity.getBigDecimal("e_notdrawamount");
        BigDecimal drawAmount = (BigDecimal)this.getModel().getValue("drawamount");
        if (newValue != null && (newValue.compareTo(notDrawAmount) > 0 || newValue.compareTo(drawAmount) > 0)) {
            this.getPageCache().put("e_shareamount", "e_shareamount");
            rowEntity.set("e_shareamount", (Object)oldValue);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u63d0\u6b3e\u4efd\u989d\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u94f6\u56e2\u53ef\u63d0\u6b3e\u4efd\u989d\u91d1\u989d\u548c\u63d0\u6b3e\u91d1\u989d\u3002", (String)"BankLoanBillEdit_0", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
            this.getPageCache().remove("e_shareamount");
            return;
        }
        this.getModel().setValue("e_bankcreditlimit", null, currIdx);
        TmcViewInputHelper.clearValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (int)currIdx, (String[])new String[]{"e_bankcreditcurrency", "e_bankcreditamt"});
        int entryRowCount = this.getModel().getEntryRowCount("banksyndicate_entry");
        if (currIdx == entryRowCount - 1 || entryRowCount < 2) {
            return;
        }
        DynamicObjectCollection entryEntitys = this.getModel().getEntryEntity("banksyndicate_entry");
        BigDecimal totalShareAmount = entryEntitys.stream().map(o -> o.getBigDecimal("e_shareamount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        if (drawAmount == null || drawAmount.compareTo(totalShareAmount) == 0) {
            return;
        }
        BigDecimal subAmount = drawAmount.subtract(totalShareAmount);
        rowEntity = this.getModel().getEntryRowEntity("banksyndicate_entry", entryRowCount - 1);
        BigDecimal notDrawAmt = rowEntity.getBigDecimal("e_notdrawamount");
        BigDecimal shareAmount = rowEntity.getBigDecimal("e_shareamount").add(subAmount);
        if (shareAmount.compareTo(notDrawAmt) > 0) {
            shareAmount = notDrawAmt;
        }
        if (shareAmount.compareTo(BigDecimal.ZERO) < 0) {
            shareAmount = BigDecimal.ZERO;
        }
        BigDecimal entryAmount = rowEntity.getBigDecimal("e_shareamount");
        this.getPageCache().put("e_shareamount", "e_shareamount");
        this.getModel().setValue("e_shareamount", (Object)shareAmount, entryRowCount - 1);
        this.getPageCache().remove("e_shareamount");
        if (entryAmount.compareTo(shareAmount) != 0) {
            this.getModel().setValue("e_bankcreditlimit", null, entryRowCount - 1);
            TmcViewInputHelper.clearValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (int)(entryRowCount - 1), (String[])new String[]{"e_bankcreditcurrency", "e_bankcreditamt"});
        }
    }

    private void setShareAmount() {
        if (!BizTypeEnum.SL.getValue().equals(this.getModel().getValue("loantype"))) {
            return;
        }
        DynamicObjectCollection loanBillEntrys = this.getModel().getEntryEntity("banksyndicate_entry");
        BigDecimal notDrawAmount = (BigDecimal)this.getModel().getValue("notdrawamount");
        if (EmptyUtil.isEmpty((BigDecimal)notDrawAmount)) {
            return;
        }
        BigDecimal drawAmount = (BigDecimal)this.getModel().getValue("drawamount");
        BigDecimal ratio = drawAmount.divide(notDrawAmount, 18, 4);
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        int amtPrecision = currency != null ? currency.getInt("amtprecision") : 2;
        this.getPageCache().put("e_shareamount", "e_shareamount");
        BigDecimal totalAmount = BigDecimal.ZERO;
        for (int rowIdx = 0; rowIdx < loanBillEntrys.size(); ++rowIdx) {
            DynamicObject loanBillEntryRow = (DynamicObject)loanBillEntrys.get(rowIdx);
            loanBillEntryRow.set("e_bankcreditlimit", null);
            loanBillEntryRow.set("e_bankcreditcurrency", null);
            loanBillEntryRow.set("e_bankcreditamt", (Object)BigDecimal.ZERO);
            if (notDrawAmount.compareTo(loanBillEntryRow.getBigDecimal("e_notdrawamount")) == 0) {
                this.getModel().setValue("e_shareamount", (Object)drawAmount, rowIdx);
                totalAmount = totalAmount.add(drawAmount);
                continue;
            }
            BigDecimal shareAmount = ratio.multiply(loanBillEntryRow.getBigDecimal("e_notdrawamount")).setScale(amtPrecision, RoundingMode.HALF_UP);
            this.getModel().setValue("e_shareamount", (Object)shareAmount, rowIdx);
            totalAmount = totalAmount.add(shareAmount);
        }
        BigDecimal subAmount = drawAmount.subtract(totalAmount);
        for (int rowIdx = 0; rowIdx < loanBillEntrys.size(); ++rowIdx) {
            DynamicObject mbEntry = (DynamicObject)loanBillEntrys.get(rowIdx);
            if (!"MB".equals(mbEntry.getString("e_bankrole"))) continue;
            BigDecimal mbAmount = mbEntry.getBigDecimal("e_notdrawamount");
            BigDecimal shareAmt = mbEntry.getBigDecimal("e_shareamount").add(subAmount);
            if (mbAmount.compareTo(BigDecimal.ZERO) > 0 && mbAmount.compareTo(shareAmt) > 0) {
                this.getModel().setValue("e_shareamount", (Object)shareAmt, rowIdx);
                break;
            }
            this.setScaleAmount(loanBillEntrys, subAmount);
            break;
        }
        this.getView().updateView("banksyndicate_entry");
        this.getPageCache().remove("e_shareamount");
        DynamicObject loanContractBill = TmcDataServiceHelper.loadSingle((String)"cfm_loancontractbill", (QFilter[])new QFilter[]{new QFilter("billno", "=", this.getModel().getValue("contractbillno"))});
        if (EmptyUtil.isNoEmpty((DynamicObject)loanContractBill) && !loanContractBill.getBoolean("isinit")) {
            boolean isContractOccupy;
            DynamicObject productFactory = loanContractBill.getDynamicObject("productfactory");
            boolean bl = isContractOccupy = EmptyUtil.isNoEmpty((DynamicObject)productFactory) && productFactory.getBoolean("isloancommit");
            if (!isContractOccupy) {
                ArrayList<Integer> removeIndexes = new ArrayList<Integer>();
                for (int rowIdx = 0; rowIdx < this.getModel().getEntryRowCount("entry_gcontract"); ++rowIdx) {
                    if (!((Boolean)this.getModel().getValue("gcreditguarantee", rowIdx)).booleanValue()) continue;
                    removeIndexes.add(rowIdx);
                }
                this.getView().getPageCache().put("isDeleteGuaranteeEntry", "yes");
                this.getModel().deleteEntryRows("entry_gcontract", removeIndexes.stream().mapToInt(i -> i).toArray());
            }
        }
    }

    private void setScaleAmount(DynamicObjectCollection loanBillEntrys, BigDecimal subAmount) {
        for (int rowIdx = 0; rowIdx < loanBillEntrys.size(); ++rowIdx) {
            DynamicObject loanBillEntry = (DynamicObject)loanBillEntrys.get(rowIdx);
            if (EmptyUtil.isEmpty((BigDecimal)subAmount)) break;
            if (SlBankRoleEnum.isMb((String)loanBillEntry.getString("e_bankrole"))) continue;
            BigDecimal notAmount = loanBillEntry.getBigDecimal("e_notdrawamount");
            BigDecimal shareAmount = loanBillEntry.getBigDecimal("e_shareamount");
            BigDecimal eAmount = notAmount.subtract(shareAmount);
            if (subAmount.compareTo(BigDecimal.ZERO) > 0 && eAmount.compareTo(subAmount) < 0) {
                subAmount = subAmount.subtract(eAmount);
                this.getModel().setValue("e_shareamount", (Object)shareAmount.add(eAmount), rowIdx);
                continue;
            }
            this.getModel().setValue("e_shareamount", (Object)shareAmount.add(subAmount), rowIdx);
            break;
        }
    }
}

