/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.loanbill;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.tmc.cfm.common.enums.BatchIntViewInfoEnum;
import kd.tmc.cfm.common.enums.DrawTypeEnum;
import kd.tmc.cfm.common.helper.CfmBillCommonHelper;
import kd.tmc.cfm.common.helper.CfmContractBillHelper;
import kd.tmc.cfm.common.helper.LoanBillHelper;
import kd.tmc.cfm.common.resource.AbstractBizResource;
import kd.tmc.cfm.common.resource.BizResourceFactory;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.RepaymentWayEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class LoanBillBatchEdit
extends AbstractFormPlugin {
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.loadUnWriteOffAmt();
    }

    private void loadUnWriteOffAmt() {
        OperationStatus operationStatus = this.getView().getFormShowParameter().getStatus();
        String entityName = this.getModel().getDataEntityType().getName();
        if (entityName.startsWith("fl_") || operationStatus == OperationStatus.ADDNEW) {
            return;
        }
        BigDecimal noWriteOffPreInstAmt = LoanBillHelper.getNoWriteOffPreInstAmt((DynamicObject)this.getModel().getDataEntity(), (boolean)false);
        TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"unwriteoffamt", (Object)noWriteOffPreInstAmt);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if (StringUtils.equals((CharSequence)"pushtointerestbill", (CharSequence)formOperate.getOperateKey())) {
            this.checkPushToInterestBill(args);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if (StringUtils.equals((CharSequence)"pushtointerestbill", (CharSequence)operateKey) && args.getOperationResult().isSuccess()) {
            this.openIntBatchEdit();
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        if (StringUtils.equals((CharSequence)"CLOSE_BAKE_KEY_FILTER", (CharSequence)evt.getActionId()) && null != evt.getReturnData()) {
            BillShowParameter parameter = new BillShowParameter();
            parameter.setStatus(OperationStatus.ADDNEW);
            this.initShowParameter((FormShowParameter)parameter);
            parameter.setCustomParam("navparam", evt.getReturnData());
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "CLOSE_BAKE_KEY_EXIST"));
            this.getView().showForm((FormShowParameter)parameter);
        }
    }

    private void initShowParameter(FormShowParameter parameter) {
        String formId = CfmBillCommonHelper.getFormIdByShowParameter((IFormView)this.getView());
        BatchIntViewInfoEnum batchIntViewInfo = BatchIntViewInfoEnum.getInfoEnum((String)formId, (String)"loan");
        parameter.setFormId(batchIntViewInfo.getFormId());
    }

    protected void openIntBatchEdit() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setStatus(OperationStatus.ADDNEW);
        parameter.setFormId("cfm_navigate_addnew");
        Object[] loanBills = TmcDataServiceHelper.load((Object[])new Object[]{this.getModel().getDataEntity().getPkValue()}, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"ifm_loanbill"));
        String dJson = DynamicObjectSerializeUtil.serialize((Object[])loanBills, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"ifm_loanbill"));
        boolean isPayIntByPlan = CfmContractBillHelper.isPayIntByPlan((DynamicObject)loanBills[0]);
        parameter.setCustomParam("loanbill", (Object)dJson);
        parameter.setCustomParam("loanInt", (Object)true);
        parameter.setCustomParam("fromLoanBill", (Object)true);
        parameter.setCustomParam("isPayIntByPlan", (Object)isPayIntByPlan);
        BatchIntViewInfoEnum batchIntViewInfo = BatchIntViewInfoEnum.getInfoEnum((String)CfmBillCommonHelper.getFormIdByShowParameter((IFormView)this.getView()), (String)"loan");
        parameter.setCustomParam("formid", (Object)batchIntViewInfo.getFormId());
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "CLOSE_BAKE_KEY_FILTER"));
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(parameter);
        StyleCss sc = new StyleCss();
        sc.setHeight("340px");
        parameter.getOpenStyle().setInlineStyleCss(sc);
        this.getView().showForm(parameter);
    }

    private void checkPushToInterestBill(BeforeDoOperationEventArgs args) {
        DynamicObject productFactory;
        DynamicObject bizBill = this.getModel().getDataEntity();
        DynamicObject loanBillDO = TmcDataServiceHelper.loadSingle((Object)bizBill.getPkValue(), (String)"cfm_loanbill", (String)"id,billstatus,drawtype");
        String billstatus = loanBillDO.getString("billstatus");
        String billdrawtype = loanBillDO.getString("drawtype");
        AbstractBizResource bizResource = new BizResourceFactory().getBizResource(bizBill.getString("datasource"));
        if (StringUtils.equals((CharSequence)billstatus, (CharSequence)BillStatusEnum.AUDIT.getValue())) {
            if (StringUtils.equals((CharSequence)billdrawtype, (CharSequence)DrawTypeEnum.CLOSEOUT.getValue()) || StringUtils.equals((CharSequence)billdrawtype, (CharSequence)DrawTypeEnum.DRAWING.getValue())) {
                this.getView().showErrorNotification(bizResource.getLbLoanbillPushInterestBillError());
                args.setCancel(true);
            }
        } else {
            this.getView().showErrorNotification(bizResource.getLbPushInterestBillError());
            args.setCancel(true);
        }
        if (EmptyUtil.isNoEmpty((DynamicObject)(productFactory = (DynamicObject)this.getModel().getValue("productfactory"))) && !productFactory.getBoolean("iscallint")) {
            this.getView().showTipNotification(bizResource.getProductIsCallint());
            args.setCancel(true);
            return;
        }
        String repaymentWay = (String)this.getModel().getValue("repaymentway");
        ArrayList repayWays = Lists.newArrayList((Object[])new String[]{RepaymentWayEnum.debj.getValue(), RepaymentWayEnum.debx.getValue(), RepaymentWayEnum.dbdx.getValue()});
        if (repayWays.contains(repaymentWay)) {
            this.getView().showErrorNotification(bizResource.getLbDedxPushInterestBillError());
            args.setCancel(true);
        }
    }
}

