/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.loanbill;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.control.Control;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.tmc.cfm.common.enums.LoanTypeEnum;
import kd.tmc.cfm.common.helper.BusinessHelper;
import kd.tmc.cfm.common.helper.CfmContractBillHelper;
import kd.tmc.cfm.common.helper.CfmFinVarietyHelper;
import kd.tmc.cfm.common.helper.CreditLimitHelper;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.CreditFinTypeEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.common.AbstractCreditLimitEditPlugin;

public class LoanBillCreditLimitPlugin
extends AbstractCreditLimitEditPlugin {
    protected Map<String, String> getBizPropertys() {
        HashMap<String, String> propertys = new HashMap<String, String>();
        propertys.put("org", this.getOrgField());
        propertys.put("finorg", this.getFinOrgField());
        propertys.put("drawamount", "drawamount");
        propertys.put("startDate", "bizdate");
        propertys.put("endDate", "expiredate");
        propertys.put("currency", "currency");
        return propertys;
    }

    protected Long getCreditTypeId() {
        return CfmFinVarietyHelper.getCreditTypeByFinVarietyId((Long)((Long)this.getFinProduct().getPkValue()));
    }

    public void afterBindData(EventObject e) {
        Object loanConId = this.getModel().getValue("sourcebillid");
        Object loandCredit = this.getModel().getValue("creditlimit");
        if (EmptyUtil.isNoEmpty((Object)loanConId) && loandCredit != null) {
            DynamicObject applyBill;
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"creditamt", "creditcurrency"});
            DynamicObject loandCon = TmcDataServiceHelper.loadSingle((Object)loanConId, (String)"cfm_loancontractbill", (String)"id,loanapply");
            if (loandCon != null && loandCon.getDynamicObject("loanapply") != null && (applyBill = TmcDataServiceHelper.loadSingle((Object)loandCon.getDynamicObject("loanapply").getPkValue(), (String)"cfm_loan_apply", (String)"id,creditlimit")) != null && applyBill.getDynamicObject("creditlimit") != null && applyBill.getDynamicObject("creditlimit").getLong("id") == ((DynamicObject)loandCredit).getLong("id")) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"creditlimit"});
                this.getPageCache().put("creditLimit", "creditlimit");
                DynamicObject creditUseBill = CreditLimitHelper.getCreditUseBill((Long)applyBill.getLong("id"), (String)"cfm_loan_apply");
                if (creditUseBill != null) {
                    this.getPageCache().put("ratio", String.valueOf(creditUseBill.getBigDecimal("creditratio")));
                }
            }
        }
        super.afterBindData(e);
    }

    public boolean isPreOccupy() {
        Object status = this.getModel().getValue("billstatus");
        return BillStatusEnum.SAVE.getValue().equals(status);
    }

    protected void setCreditUseFields() {
        String loanType = (String)this.getModel().getValue("loantype");
        if (!LoanTypeEnum.isBanksLoan((String)loanType)) {
            super.setCreditUseFields();
        }
    }

    protected BigDecimal setCreditRatio() {
        DynamicObject creditUseBill;
        DynamicObject creditLimit = (DynamicObject)this.getModel().getValue("creditlimit");
        DynamicObject finProduct = this.getFinProduct();
        BigDecimal creditRatio = finProduct != null ? finProduct.getBigDecimal("creditratio") : Constants.ONE_HUNDRED;
        creditRatio = this.dealSuretyRatio(creditRatio);
        if (creditLimit == null) {
            return creditRatio;
        }
        if (this.getPageCache().get("ratio") != null) {
            return new BigDecimal(this.getPageCache().get("ratio"));
        }
        if (EmptyUtil.isNoEmpty((Object)this.getModel().getValue("id")) && (creditUseBill = CreditLimitHelper.getCreditUseBill((Long)((Long)this.getModel().getValue("id")), (String)"cfm_loanbill")) != null) {
            return creditUseBill.getBigDecimal("creditratio");
        }
        return creditRatio;
    }

    private BigDecimal dealSuretyRatio(BigDecimal creditRatio) {
        DynamicObjectCollection sureties = this.getModel().getEntryEntity("entry_surety");
        BigDecimal suretyRatio = sureties.stream().filter(d -> EmptyUtil.isNoEmpty((DynamicObject)d.getDynamicObject("suretybill"))).map(d -> d.getDynamicObject("suretybill").getBigDecimal("suretyrate")).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal ratio = creditRatio.subtract(suretyRatio);
        return ratio.compareTo(BigDecimal.ZERO) > 0 ? ratio : BigDecimal.ZERO;
    }

    private DynamicObject getFinProduct() {
        return (DynamicObject)this.getModel().getValue("finproduct");
    }

    protected String getCreditVariety() {
        DynamicObject finProduct = (DynamicObject)this.getModel().getValue("finproduct");
        return finProduct.getString("name");
    }

    protected BigDecimal getAmount() {
        return (BigDecimal)this.getModel().getValue("drawamount");
    }

    public boolean isSubmitReCreate() {
        return this.getModel().getValue("creditlimit") != null;
    }

    public boolean checkCreditlimitParams() {
        BigDecimal drawamt;
        StringBuilder errorMessage = new StringBuilder();
        if (this.getModel().getValue("currency") == null) {
            errorMessage.append(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u501f\u6b3e\u5e01\u79cd\u3002", (String)"LoanBillCreditLimitPlugin_0", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
        }
        if ((drawamt = (BigDecimal)this.getModel().getValue("drawamount")) == null || drawamt.compareTo(BigDecimal.ZERO) <= 0) {
            errorMessage.append(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u63d0\u6b3e\u91d1\u989d\u3002", (String)"LoanBillCreditLimitPlugin_1", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
        }
        if (this.getModel().getValue("finproduct") == null) {
            errorMessage.append(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u878d\u8d44\u54c1\u79cd\u3002", (String)"LoanBillCreditLimitPlugin_2", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
        }
        if (this.getModel().getValue("creditor") == null) {
            errorMessage.append(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u503a\u6743\u4eba\u3002", (String)"LoanBillCreditLimitPlugin_3", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
        }
        if (EmptyUtil.isNoEmpty((String)errorMessage.toString())) {
            this.getView().showTipNotification(errorMessage.toString(), Integer.valueOf(6000));
        }
        return EmptyUtil.isNoEmpty((String)errorMessage.toString()) ? Boolean.FALSE : Boolean.TRUE;
    }

    protected Long getSourceBillId() {
        Object loanContractBill = this.getModel().getValue("loancontractbill");
        if (loanContractBill == null) {
            return null;
        }
        DynamicObject applybill = BusinessHelper.getLoanApplyBill((DynamicObject)((DynamicObject)loanContractBill));
        if (applybill != null) {
            this.getPageCache().put("sourceType", "cfm_loan_apply");
            return applybill.getLong("id");
        }
        return null;
    }

    protected String getSourceType() {
        return this.getPageCache().get("sourceType");
    }

    protected String creditType() {
        String loanType = (String)this.getModel().getValue("loantype");
        if (LoanTypeEnum.ENTRUSTLOAN.getValue().equals(loanType) || LoanTypeEnum.LINKLEND.getValue().equals(loanType)) {
            return CreditFinTypeEnum.ORG.getValue();
        }
        return CreditFinTypeEnum.FINORG.getValue();
    }

    private String getOrgField() {
        String formId = this.getView().getFormShowParameter().getFormId();
        if ("cim_invest_loanbill".equals(formId)) {
            return "debtor";
        }
        return "org";
    }

    private String getFinOrgField() {
        String formId = this.getView().getFormShowParameter().getFormId();
        if ("cim_invest_loanbill".equals(formId)) {
            return "creditorg";
        }
        return "creditor";
    }

    protected String getCreditUseAmtField() {
        String creditorType = (String)this.getModel().getValue("creditortype");
        String loanType = (String)this.getModel().getValue("loantype");
        Object creditLimit = this.getModel().getValue("creditlimit");
        if (EmptyUtil.isEmpty((Object)creditLimit)) {
            return null;
        }
        String billStatus = (String)this.getModel().getValue("billstatus");
        if (BillStatusEnum.SAVE.getValue().equals(billStatus) && !CfmContractBillHelper.creditPreUse((String)loanType, (String)creditorType)) {
            return null;
        }
        return "creditamt";
    }

    protected String getCreditUseCurrencyField() {
        return "creditcurrency";
    }

    protected Long getCreditUseSrcBillId() {
        Object limit = this.getModel().getValue("creditlimit");
        if (this.getPageCache().get("creditLimit") != null && EmptyUtil.isEmpty((Object)limit)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"creditamt", "creditcurrency"});
        }
        return null;
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        super.beforeF7Select(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (this.getCreditlimiFieldMap().containsKey(key)) {
            DynamicObjectCollection sureties;
            BigDecimal suretyRatio;
            BigDecimal creditRatio;
            DynamicObject finProduct = (DynamicObject)this.getModel().getValue("finproduct");
            BigDecimal bigDecimal = creditRatio = finProduct != null && finProduct.containsProperty("creditratio") ? finProduct.getBigDecimal("creditratio") : Constants.ONE_HUNDRED;
            if (EmptyUtil.isEmpty((BigDecimal)creditRatio)) {
                creditRatio = Constants.ONE_HUNDRED;
            }
            if (creditRatio.compareTo(suretyRatio = (sureties = this.getModel().getEntryEntity("entry_surety")).stream().filter(d -> EmptyUtil.isNoEmpty((DynamicObject)d.getDynamicObject("suretybill"))).map(d -> d.getDynamicObject("suretybill").getBigDecimal("suretyrate")).reduce(BigDecimal.ZERO, BigDecimal::add)) <= 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6388\u4fe1\u5360\u6bd4\u4e3a0\uff0c\u65e0\u6cd5\u9009\u62e9\u6388\u4fe1\u989d\u5ea6\u5355\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"LoanBillCreditLimitPlugin_4", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
            }
        }
    }
}

