/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.loanbill;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.TextAreaProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.tmc.cfm.formplugin.loanbill.LoanBillFormHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class LoanBillImportPlugin
extends AbstractBasePlugIn {
    private static Log logger = LogFactory.getLog(LoanBillImportPlugin.class);

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        switch (operateKey = args.getOperateKey()) {
            case "entryimport": {
                this.showForm(false);
                break;
            }
            case "intentryimport": {
                this.showForm(true);
            }
        }
    }

    private void showForm(boolean isIntPlan) {
        FormShowParameter showForm = new FormShowParameter();
        showForm.setFormId("cfm_entryimport");
        showForm.getOpenStyle().setShowType(ShowType.Modal);
        String billFormId = this.getView().getFormShowParameter().getFormId();
        HashMap<String, String> params = new HashMap<String, String>(16);
        params.put("BillFormId", this.getModel().getDataEntityType().getName());
        params.put("BillEntryId", this.getEntryPropByFormId(billFormId, isIntPlan));
        showForm.setCustomParams(params);
        showForm.setCloseCallBack(new CloseCallBack((IFormPlugin)this, isIntPlan ? "cfm_intentryimport" : "cfm_entryimport"));
        this.getView().showForm(showForm);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        Map data = (Map)e.getReturnData();
        if (data == null) {
            return;
        }
        if ("cfm_entryimport".equals(e.getActionId())) {
            this.entryImportDataHandler(data, false);
        } else if ("cfm_intentryimport".equals(e.getActionId())) {
            this.entryImportDataHandler(data, true);
        }
    }

    private void entryImportDataHandler(Map<String, Object> importReturnData, boolean isIntPlan) {
        String formId = this.getView().getFormShowParameter().getFormId();
        String entryProp = this.getEntryPropByFormId(formId, isIntPlan);
        Object imptMethod = importReturnData.get("imptmethod");
        HashSet<Date> dateSet = new HashSet<Date>(16);
        if ("cover".equals(imptMethod)) {
            this.getModel().deleteEntryData(entryProp);
        } else if ("append".equals(imptMethod)) {
            DynamicObjectCollection entryentity = this.getModel().getEntryEntity(entryProp);
            for (int i = entryentity.size() - 1; i >= 0; --i) {
                DynamicObject entry = (DynamicObject)entryentity.get(i);
                if (formId.endsWith("_intplan") || isIntPlan) {
                    if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{entry.get("interesdate"), entry.get("interestcalamount")})) {
                        this.getModel().deleteEntryRow(entryProp, i);
                        this.getView().updateView(entryProp);
                    }
                    dateSet.add((Date)entry.get("interesdate"));
                    continue;
                }
                if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{entry.get("exrepaymentdate"), entry.get("exdrawamount")})) continue;
                this.getModel().deleteEntryRow(entryProp, i);
                this.getView().updateView(entryProp);
            }
        }
        List rowDatas = (List)importReturnData.get("rowDatas");
        Set billnos = rowDatas.stream().map(o -> (String)o.get("billno")).filter(EmptyUtil::isNoEmpty).collect(Collectors.toSet());
        if (EmptyUtil.isNoEmpty(billnos) && billnos.size() > 1) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u5bfc\u5165\u7684\u7f16\u7801\u5b57\u6bb5\u5b58\u5728\u591a\u4e2a,\u4e0d\u80fd\u5bfc\u5165\u3002", (String)"LoanBillImportPlugin_10", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (EmptyUtil.isNoEmpty(billnos) && billnos.size() == 1 && !billnos.toArray()[0].equals(this.getModel().getValue("billno"))) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u5b58\u5728\u5bfc\u5165\u7684\u7f16\u7801\u5b57\u6bb5\u4e0e\u5f53\u524d\u5355\u636e\u7f16\u53f7\u4e0d\u4e00\u81f4,\u4e0d\u80fd\u5bfc\u5165\u3002", (String)"LoanBillImportPlugin_11", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
            return;
        }
        this.dealImportData(entryProp, dateSet, rowDatas);
        this.getModel().endInit();
        this.getView().updateView(entryProp);
    }

    private void dealImportData(String entryProp, Set<Date> dateSet, List<Map<String, String>> rowDatas) {
        StringBuilder errorInfo = new StringBuilder();
        this.getModel().beginInit();
        block6: for (Map<String, String> row : rowDatas) {
            String tips;
            int rowIndex = this.getModel().createNewEntryRow(entryProp);
            try {
                for (Map.Entry<String, String> r : row.entrySet()) {
                    String key = r.getKey();
                    String value = r.getValue();
                    IDataEntityProperty property = this.getModel().getProperty(key);
                    if ("repaymentdesc".equals(key) || "instdescription".equals(key)) {
                        TextAreaProp text = new TextAreaProp();
                        if (property instanceof TextAreaProp) {
                            text = (TextAreaProp)property;
                        }
                        if (text.getMaxLenth() > 0 && EmptyUtil.isNoEmpty((String)value) && value.length() > text.getMaxLenth()) {
                            value = value.substring(0, text.getMaxLenth());
                            String maxTip = String.format(ResManager.loadKDString((String)"\u7b2c %1$s \u884c: %2$s \u5b57\u6bb5\u6570\u636e\u8d85\u51fa\u6700\u5927\u9650\u5236, \u5df2\u622a\u53d6\u6709\u6548\u90e8\u5206\u3002", (String)"LoanBillImportPlugin_2", (String)"tmc-cfm-formplugin", (Object[])new Object[0]), row.get("excelrow"), property.getDisplayName().getLocaleValue());
                            errorInfo.append(maxTip).append("\n");
                        }
                        this.getModel().setValue(key, (Object)value, rowIndex);
                    }
                    if ("repayaccount.bankaccountnumber".equals(key) || "intaccount.bankaccountnumber".equals(key)) {
                        if (EmptyUtil.isEmpty((String)value)) {
                            throw new KDBizException(ResManager.loadKDString((String)"\u8fd8\u6b3e/\u4ed8\u606f\u8d26\u6237\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"LoanBillImportPlugin_12", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
                        }
                        QFilter[] filter = new QFilter[]{new QFilter("bankaccountnumber", "=", (Object)value)};
                        DynamicObject account = TmcDataServiceHelper.loadSingle((String)"bd_accountbanks", (String)"id,bankaccountnumber,name", (QFilter[])filter);
                        if (EmptyUtil.isEmpty((DynamicObject)account)) {
                            throw new KDBizException(ResManager.loadKDString((String)"\u586b\u5165\u7684\u8fd8\u6b3e/\u4ed8\u606f\u8d26\u6237\u4e0d\u5b58\u5728\u3002", (String)"LoanBillImportPlugin_13", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
                        }
                        if ("repayaccount.bankaccountnumber".equals(key)) {
                            this.getModel().setValue("repayaccount", (Object)account, rowIndex);
                        } else {
                            this.getModel().setValue("intaccount", (Object)account, rowIndex);
                        }
                    }
                    if (property instanceof DecimalProp) {
                        if (EmptyUtil.isEmpty((String)value)) {
                            throw new KDBizException(ResManager.loadKDString((String)"\u91d1\u989d\u6570\u636e\u5fc5\u987b\u5927\u4e8e0\u3002", (String)"LoanBillImportPlugin_3", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
                        }
                        BigDecimal amount = new BigDecimal(value);
                        if (amount.compareTo(BigDecimal.ZERO) <= 0) {
                            throw new KDBizException(ResManager.loadKDString((String)"\u91d1\u989d\u6570\u636e\u5fc5\u987b\u5927\u4e8e0\u3002", (String)"LoanBillImportPlugin_3", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
                        }
                        if (amount.compareTo(new BigDecimal("999999999.99")) > 0) {
                            throw new KDBizException(ResManager.loadKDString((String)"\u91d1\u989d\u6570\u503c\u4e0d\u80fd\u5927\u4e8e999999999.99\u3002", (String)"LoanBillImportPlugin_8", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
                        }
                        this.getModel().setValue(key, (Object)amount, rowIndex);
                    }
                    if ("exrepaymentdate".equals(key) || "interesdate".equals(key)) {
                        try {
                            if (EmptyUtil.isEmpty((String)value)) {
                                throw new KDBizException(ResManager.loadKDString((String)"\u9884\u8ba1\u4ed8/\u6536\u606f\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"LoanBillImportPlugin_9", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
                            }
                            SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
                            Date date = sf.parse(value);
                            if ("interesdate".equals(key)) {
                                if (!dateSet.add(date)) {
                                    throw new KDBizException(ResManager.loadKDString((String)"\u9884\u8ba1\u4ed8/\u6536\u606f\u65e5\u671f\u4e0d\u5141\u8bb8\u76f8\u7b49\u3002", (String)"LoanBillImportPlugin_7", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
                                }
                                String volidRepayDateResult = LoanBillFormHelper.getVolidRepayDateResult(this.getModel(), date);
                                if (EmptyUtil.isNoEmpty((String)volidRepayDateResult)) {
                                    throw new KDBizException(volidRepayDateResult);
                                }
                            }
                            this.getModel().setValue(key, (Object)date, rowIndex);
                        }
                        catch (KDBizException bizExp) {
                            this.getModel().deleteEntryRow(entryProp, rowIndex);
                            String tips2 = String.format(ResManager.loadKDString((String)"\u7b2c %1$s \u884c: %2$s", (String)"LoanBillImportPlugin_5", (String)"tmc-cfm-formplugin", (Object[])new Object[0]), row.get("excelrow"), bizExp.getMessage());
                            errorInfo.append(tips2).append("\n");
                            continue block6;
                        }
                        catch (Exception e) {
                            this.getModel().deleteEntryRow(entryProp, rowIndex);
                            String importTip = String.format(ResManager.loadKDString((String)"\u7b2c %1$s \u884c: %2$s \u5b57\u6bb5, \u8f93\u5165\u6570\u636e\u683c\u5f0f\u6709\u8bef\u3002", (String)"LoanBillImportPlugin_4", (String)"tmc-cfm-formplugin", (Object[])new Object[0]), row.get("excelrow"), property.getDisplayName().getLocaleValue());
                            errorInfo.append(importTip).append("\n");
                            continue block6;
                        }
                    }
                    if ("repayplan_entry".equals(entryProp)) {
                        QFilter modifyerFilter = new QFilter("id", "=", (Object)RequestContext.get().getCurrUserId());
                        DynamicObject bosUser = TmcDataServiceHelper.loadSingleFromCache((String)"bos_user", (QFilter[])new QFilter[]{modifyerFilter});
                        this.getModel().setValue("repaymentmodifier", (Object)bosUser, rowIndex);
                        this.getModel().setValue("repaymentmodifytime", (Object)new Date(), rowIndex);
                    }
                    if (!"interest_entry".equals(entryProp) || !"cim_invest_loanb_intplan".equals(this.getView().getFormShowParameter().getFormId())) continue;
                    DynamicObject accountBank = (DynamicObject)this.getModel().getValue("accountbank");
                    this.getModel().setValue("intaccount", (Object)accountBank, rowIndex);
                }
            }
            catch (KDBizException bizExp) {
                this.getModel().deleteEntryRow(entryProp, rowIndex);
                tips = String.format(ResManager.loadKDString((String)"\u7b2c %1$s \u884c: %2$s", (String)"LoanBillImportPlugin_5", (String)"tmc-cfm-formplugin", (Object[])new Object[0]), row.get("excelrow"), bizExp.getMessage());
                errorInfo.append(tips).append("\n");
                logger.info("EntryImport >> data >> " + (Object)((Object)bizExp));
            }
            catch (Exception e) {
                this.getModel().deleteEntryRow(entryProp, rowIndex);
                tips = String.format(ResManager.loadKDString((String)"\u7b2c %1$s \u884c: %2$s", (String)"LoanBillImportPlugin_5", (String)"tmc-cfm-formplugin", (Object[])new Object[0]), row.get("excelrow"), e.getMessage());
                errorInfo.append(tips).append("\n");
                logger.info("EntryImport >> data >> " + e.getMessage());
            }
        }
        if (EmptyUtil.isNoEmpty((String)errorInfo.toString())) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u90e8\u5206\u6570\u636e\u5bfc\u5165\u5f02\u5e38, \u8bf7\u70b9\u51fb\"\u5c55\u793a\u8be6\u60c5\"\u67e5\u770b\u3002", (String)"LoanBillImportPlugin_6", (String)"tmc-cfm-formplugin", (Object[])new Object[0]), errorInfo.toString(), MessageTypes.Default);
        }
    }

    private String getEntryPropByFormId(String billFormId, boolean isIntPlan) {
        if (billFormId.endsWith("_intplan") || isIntPlan) {
            return "interest_entry";
        }
        return "repayplan_entry";
    }
}

