/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.loanbill;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.tmc.cfm.common.enums.BizTypeEnum;
import kd.tmc.cfm.common.enums.DataSourceEnum;
import kd.tmc.cfm.common.enums.DrawTypeEnum;
import kd.tmc.cfm.common.helper.CfmBillCommonHelper;
import kd.tmc.cfm.common.helper.InterestCalcHelper;
import kd.tmc.cfm.common.helper.LoanBillHelper;
import kd.tmc.cfm.common.helper.LoanWriteBackHelper;
import kd.tmc.cfm.common.resource.AbstractBizResource;
import kd.tmc.cfm.common.resource.BizResourceFactory;
import kd.tmc.cfm.formplugin.common.LoanBillApplyFormHelper;
import kd.tmc.cfm.formplugin.resource.CfmFormResourceEnum;
import kd.tmc.fbp.common.enums.CreditorTypeEnum;
import kd.tmc.fbp.common.enums.RepaymentWayEnum;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.model.interest.PlanCallResult;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.tuple.Pair;

public class LoanInstPlanModifyPlugin
extends AbstractBasePlugIn
implements BeforeF7SelectListener {
    private static final Log logger = LogFactory.getLog(LoanInstPlanModifyPlugin.class);

    public void registerListener(EventObject e) {
        BasedataEdit intAccount;
        TextEdit loanBillNumber = (TextEdit)this.getControl("loanbill");
        if (EmptyUtil.isNoEmpty((Object)loanBillNumber)) {
            loanBillNumber.addClickListener((ClickListener)this);
        }
        if (EmptyUtil.isNoEmpty((Object)(intAccount = (BasedataEdit)this.getControl("intaccount")))) {
            intAccount.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"loanbill", null);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        CfmBillCommonHelper.setRepayIntPlanBotnVisable((IFormView)this.getView());
        String formId = this.getView().getFormShowParameter().getFormId();
        if ("ifm_loanbill_repayplan_l".equals(formId)) {
            CfmBillCommonHelper.setSignMustInput((IFormView)this.getView(), (Boolean)Boolean.TRUE, (String[])new String[]{"interesdate", "interestcalamount"});
        }
        if ("ifm_loanbill_intplan".equals(formId)) {
            CfmBillCommonHelper.setSignMustInput((IFormView)this.getView(), (Boolean)Boolean.TRUE, (String[])new String[]{"loanbill"});
        }
        if (OperationStatus.ADDNEW != this.getView().getFormShowParameter().getStatus()) {
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"loanbill", (Object)this.getModel().getValue("billno"));
        }
        this.setCanEditByIntState();
        if (OperationStatus.EDIT == this.getView().getFormShowParameter().getStatus()) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"loanbill"});
        }
        if (LoanBillApplyFormHelper.validateCfmPlanParam(this.getModel().getDataEntity())) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"bar_instplansave"});
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent args) {
        String propName = args.getProperty().getName();
        if ("intaccount".equals(propName)) {
            String creditorType = (String)this.getModel().getValue("creditortype");
            String acctClassify = StringUtils.equals((CharSequence)creditorType, (CharSequence)CreditorTypeEnum.SETTLECENTER.getValue()) ? "I" : "B";
            ListShowParameter showParameter = (ListShowParameter)args.getFormShowParameter();
            showParameter.getListFilterParameter().getQFilters().add(new QFilter("acctclassify", "=", (Object)acctClassify));
        }
    }

    private void showConfirmTip(String flag) {
        this.getView().showConfirm(CfmFormResourceEnum.LoanInstPlanModifyPlugin_01.loadKDString(), MessageBoxOptions.YesNo, new ConfirmCallBackListener(String.format("handInstPlan_callBackId_%s", flag), (IFormPlugin)this));
    }

    private void setCanEditByIntState() {
        DynamicObject loanBill = this.getModel().getDataEntity(true);
        DynamicObjectCollection entrys = loanBill.getDynamicObjectCollection("interest_entry");
        int size = entrys.size();
        for (int i = 0; i < size; ++i) {
            DynamicObject repayPlan = (DynamicObject)entrys.get(i);
            if (repayPlan.getInt("intstate") == 1) {
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"interesdate", "interestcalamount", "instdescription", "intaccount", "intstartdate", "intenddate", "intstate", "intway"});
            }
            if (!LoanBillHelper.isYkx((DynamicObject)loanBill) || i != 0 || !LoanBillHelper.isPrePayint((String)repayPlan.getString("intway"))) continue;
            this.getView().setEnable(Boolean.FALSE, i, new String[]{"interesdate"});
        }
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        Control source = (Control)e.getSource();
        String key = source.getKey();
        int rowIndex = e.getRowIndex();
        Object value = e.getValue();
        switch (key) {
            case "handinstplan": {
                this.handinstPlanBeforePost(e, rowIndex, (Boolean)value);
                break;
            }
        }
    }

    private void handinstPlanBeforePost(BeforeFieldPostBackEvent e, int rowIndex, boolean isHandin) {
        String error;
        if (isHandin && EmptyUtil.isNoEmpty((String)(error = this.checkLoanBillNotEmpty()))) {
            e.setCancel(true);
            this.getView().showTipNotification(error);
            this.getView().updateView("handinstplan", rowIndex);
        }
    }

    private String checkLoanBillNotEmpty() {
        if (EmptyUtil.isEmpty((Object)this.getModel().getValue("loanbill"))) {
            LocaleString loanBillno = CfmBillCommonHelper.getDisPlayPropName((IDataModel)this.getModel(), (String)"loanbill");
            if (this.getView().getEntityId().equals("cim_invest_loanbill")) {
                return CfmFormResourceEnum.RepaymentPlanModifyPlugin_3.loadKDString();
            }
            return CfmFormResourceEnum.LoanInstPlanModifyPlugin_03.loadKDString(loanBillno);
        }
        return null;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId;
        super.confirmCallBack(messageBoxClosedEvent);
        switch (callBackId = messageBoxClosedEvent.getCallBackId()) {
            case "handInstPlan_callBackId_handinstplan": {
                if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
                    OperateOption option = OperateOption.create();
                    option.setVariableValue("ispassVoid", "true");
                    this.getView().invokeOperation("calinstplan", option);
                    break;
                }
                this.getModel().setValue("handinstplan", (Object)Boolean.TRUE);
                break;
            }
            case "handInstPlan_callBackId_calinstplan": {
                if (!MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) break;
                OperateOption option = OperateOption.create();
                option.setVariableValue("ispassVoid", "true");
                this.getView().invokeOperation("calinstplan", option);
                break;
            }
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        EntryProp entryProp = e.getEntryProp();
        String entryName = entryProp.getName();
        if ("interest_entry".equals(entryName)) {
            for (RowDataEntity row : e.getRowDataEntities()) {
                int index = row.getRowIndex();
                if (index < 0) continue;
                this.newScheduleEntry(index);
            }
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        String entryName = e.getEntryProp().getName();
        if ("interest_entry".equals(entryName)) {
            for (int index : e.getRowIndexs()) {
                String repayState = (String)this.getModel().getValue("intstate", index);
                if ("1".equals(repayState)) {
                    String ispayIntStatePropName = CfmBillCommonHelper.getPropLocalDisplayName((IFormView)this.getView(), (String)"intstate");
                    this.getView().showTipNotification(CfmFormResourceEnum.LoanInstPlanModifyPlugin_05.loadKDString(ispayIntStatePropName));
                    e.setCancel(true);
                }
                DynamicObject loanBill = this.getModel().getDataEntity(false);
                String intWay = (String)this.getModel().getValue("intway");
                if (!LoanBillHelper.isYkx((DynamicObject)loanBill) || index != 0 || !LoanBillHelper.isPrePayint((String)intWay)) continue;
                this.getView().showTipNotification(CfmFormResourceEnum.LoanInstPlanModifyPlugin_07.loadKDString());
                e.setCancel(true);
            }
        }
    }

    public void click(EventObject evt) {
        if (evt.getSource() instanceof Control) {
            String key;
            switch (key = ((Control)evt.getSource()).getKey()) {
                case "loanbill": {
                    this.openLoanBill();
                }
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        String error = this.checkLoanBillNotEmpty();
        if (EmptyUtil.isNoEmpty((String)error)) {
            args.setCancel(true);
            this.getView().showTipNotification(error);
            return;
        }
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "calinstplan": {
                Boolean isHandinstPlan = (Boolean)this.getModel().getValue("handinstplan");
                if ("true".equals(formOperate.getOption().getVariableValue("ispassVoid", "")) || isHandinstPlan.booleanValue()) break;
                this.showConfirmTip(operateKey);
                args.setCancel(true);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        OperationResult operationResult = args.getOperationResult();
        switch (operateKey) {
            case "instplansave": {
                if (operationResult == null || !operationResult.isSuccess()) break;
                this.getView().invokeOperation("refresh");
                break;
            }
            case "calinstplan": {
                if (operationResult == null || !operationResult.isSuccess()) break;
                this.reCalInstPlanAndSetVal((Boolean)this.getModel().getValue("handinstplan"));
                this.setCanEditByIntState();
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        switch (e.getProperty().getName()) {
            case "interestsettledplan": {
                if (this.getModel().getValue("interestsettledplan") == null) {
                    TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"interestsettledplan", (Object)e.getChangeSet()[0].getOldValue());
                    return;
                }
                this.reCalInstPlanAndSetVal((Boolean)this.getModel().getValue("handinstplan"));
                break;
            }
        }
    }

    private void reCalInstPlanAndSetVal(boolean isHand) {
        DynamicObject loanBill = this.getModel().getDataEntity(true);
        Pair intBills = null;
        if (isHand) {
            DynamicObjectCollection entrys = (DynamicObjectCollection)this.getModel().getValue("interest_entry");
            if (!this.checkEntrys(loanBill, entrys)) {
                return;
            }
            ArrayList<PlanCallResult> intPlanList = new ArrayList<PlanCallResult>(entrys.size());
            for (DynamicObject entry : entrys) {
                PlanCallResult callResult = new PlanCallResult();
                if (LoanBillHelper.isPrePayint((String)entry.getString("intway"))) {
                    callResult.setBizDate(loanBill.getDate("expiredate"));
                } else {
                    callResult.setBizDate(entry.getDate("interesdate"));
                }
                intPlanList.add(callResult);
            }
            intBills = InterestCalcHelper.callIntPlanByHand((DynamicObject)loanBill, intPlanList);
        } else {
            intBills = InterestCalcHelper.callIntPlan((DynamicObject)loanBill);
        }
        LoanWriteBackHelper.loanBillWriteBack((Pair)intBills, (DynamicObject)this.getModel().getDataEntity(), (boolean)false);
        this.getView().updateView("interest_entry");
    }

    private boolean checkEntrys(DynamicObject loanBill, DynamicObjectCollection instPlans) {
        AbstractBizResource bizResource = new BizResourceFactory().getBizResource(loanBill.getString("datasource"));
        int size = instPlans.size();
        for (int i = 0; i < size; ++i) {
            DynamicObject rowLoanBill = (DynamicObject)instPlans.get(i);
            Date interesDate = rowLoanBill.getDate("interesdate");
            if (!EmptyUtil.isEmpty((Object)interesDate)) continue;
            this.getView().showErrorNotification(String.format(bizResource.getLbPreInstDateIsNotnull(), i + 1));
            return false;
        }
        return true;
    }

    private void newScheduleEntry(int index) {
        DynamicObject accountBank = (DynamicObject)this.getModel().getValue("accountbank");
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"intaccount", (Object)accountBank, (int)index);
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"intstate", (Object)"0", (int)index);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        Object returnData = e.getReturnData();
        if ("loanbill".equals(e.getActionId()) && EmptyUtil.isNoEmpty((Object)returnData)) {
            Object id = ((ListSelectedRowCollection)returnData).get(0).getPrimaryKeyValue();
            ((IBillModel)this.getModel()).load(id);
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"loanbill", (Object)((ListSelectedRowCollection)returnData).get(0).getBillNo());
            this.getView().updateView();
        }
    }

    private void openLoanBill() {
        Long userPK = RequestContext.get().getCurrUserId();
        QFilter qFilter = new QFilter("drawtype", "!=", (Object)DrawTypeEnum.CLOSEOUT.getValue());
        String loanType = (String)this.getModel().getValue("loantype");
        if (this.getView().getFormShowParameter().getCustomParams().containsKey("biztype")) {
            String bizType = (String)this.getView().getFormShowParameter().getCustomParam("biztype");
            Object[] bizTypes = bizType.split(",");
            if (EmptyUtil.isNoEmpty((Object[])bizTypes)) {
                qFilter.and(new QFilter("loantype", "in", (Object)bizTypes));
            }
        } else if (EmptyUtil.isNoEmpty((String)loanType)) {
            qFilter.and(new QFilter("loantype", "in", (Object)BizTypeEnum.getSameTypeComb((String)loanType)));
        }
        String appId = this.getView().getFormShowParameter().getAppId();
        List orgIdSet = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)userPK, (String)appId, (String)this.getModel().getDataEntityType().getName(), (String)"47150e89000000ac");
        String billFormId = this.getView().getFormShowParameter().getFormId();
        if ("cim_invest_loanb_intplan".equals(billFormId)) {
            qFilter.and("datasource", "=", (Object)DataSourceEnum.INVEST.getValue());
            qFilter.and(new QFilter("creditorg.id", "in", (Object)orgIdSet));
        } else if ("cfm_loanbill_bond_intplan".equals(billFormId)) {
            qFilter.and("datasource", "=", (Object)DataSourceEnum.BOND.getValue());
            qFilter.and(new QFilter("org.id", "in", (Object)orgIdSet));
        } else if ("ifm_loanbill_intplan".equals(billFormId)) {
            qFilter.and("datasource", "=", (Object)DataSourceEnum.IFM.getValue());
            qFilter.and(new QFilter("org.id", "in", (Object)orgIdSet));
        } else if ("cfm_loanbill_intplan".equals(billFormId)) {
            qFilter.and("datasource", "=", (Object)DataSourceEnum.CFM.getValue());
            qFilter.and(new QFilter("org.id", "in", (Object)orgIdSet));
        }
        List<String> repayWays = Arrays.asList(RepaymentWayEnum.debx.getValue(), RepaymentWayEnum.debj.getValue(), RepaymentWayEnum.dbdx.getValue());
        qFilter.and(new QFilter("repaymentway", "not in", repayWays));
        qFilter.and(CfmBillCommonHelper.getIntPlanFilter());
        ListShowParameter paramter = ShowFormHelper.createShowListForm((String)billFormId, (boolean)false, (int)0, (boolean)true);
        paramter.getListFilterParameter().setFilter(qFilter);
        logger.info("LoanInstPlanModifyPlugin filter:" + qFilter);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "loanbill");
        paramter.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)paramter);
    }
}

