/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.loanbill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.tmc.cfm.common.enums.BizTypeEnum;
import kd.tmc.cfm.common.enums.DataSourceEnum;
import kd.tmc.cfm.common.enums.DrawTypeEnum;
import kd.tmc.cfm.common.helper.CfmBillCommonHelper;
import kd.tmc.cfm.common.helper.LoanBillRepayPlanHelper;
import kd.tmc.cfm.common.resource.AbstractBizResource;
import kd.tmc.cfm.common.resource.BizResourceFactory;
import kd.tmc.cfm.formplugin.common.LoanBillApplyFormHelper;
import kd.tmc.cfm.formplugin.resource.CfmFormResourceEnum;
import kd.tmc.fbp.common.enums.CreditorTypeEnum;
import kd.tmc.fbp.common.enums.RepaymentWayEnum;
import kd.tmc.fbp.common.enums.SettleIntModeEnum;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class RepaymentPlanModifyPlugin
extends AbstractBasePlugIn
implements BeforeF7SelectListener {
    private static final Log logger = LogFactory.getLog(RepaymentPlanModifyPlugin.class);

    public void registerListener(EventObject e) {
        BasedataEdit rePayAccount;
        TextEdit loanBillNumber = (TextEdit)this.getControl("loanbill");
        if (EmptyUtil.isNoEmpty((Object)loanBillNumber)) {
            loanBillNumber.addClickListener((ClickListener)this);
        }
        if (EmptyUtil.isNoEmpty((Object)(rePayAccount = (BasedataEdit)this.getControl("repayaccount")))) {
            rePayAccount.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData changeData = e.getChangeSet()[0];
        int rowIndex = changeData.getRowIndex();
        Object newVal = changeData.getNewValue();
        Object oldVal = changeData.getOldValue();
        String propName = e.getProperty().getName();
        IDataModel model = this.getModel();
        switch (propName) {
            case "exdrawamount": {
                int rowCount = model.getEntryRowCount("repayplan_entry");
                if (rowIndex != rowCount - 1) {
                    this.calLastRowAmtVal();
                }
                this.setUpdateRowInfo(rowIndex);
                break;
            }
            case "exrepaymentdate": 
            case "repaymentdesc": 
            case "repayaccount": {
                if (!EmptyUtil.isNoEmpty((Object)newVal) || newVal.equals(oldVal)) break;
                this.setUpdateRowInfo(rowIndex);
                break;
            }
            case "repaymentway": 
            case "stageplan": {
                if (newVal == null) {
                    return;
                }
                DynamicObject loanBill = model.getDataEntity(true);
                if (EmptyUtil.isEmpty((Object)loanBill.getPkValue())) {
                    return;
                }
                this.updateSettleIntMode(model, loanBill);
                LoanBillRepayPlanHelper.updateLoanBillRepayPlan((DynamicObject)loanBill, (boolean)false);
                this.setCanEditByRepayState();
                this.getView().updateView("repayplan_entry");
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent args) {
        String propName = args.getProperty().getName();
        if (StringUtils.equals((CharSequence)propName, (CharSequence)"repayaccount")) {
            String creditorType = (String)this.getModel().getValue("creditortype");
            String acctClassify = StringUtils.equals((CharSequence)creditorType, (CharSequence)CreditorTypeEnum.SETTLECENTER.getValue()) ? "I" : "B";
            ListShowParameter showParameter = (ListShowParameter)args.getFormShowParameter();
            showParameter.getListFilterParameter().getQFilters().add(new QFilter("acctclassify", "=", (Object)acctClassify));
        }
    }

    private void updateSettleIntMode(IDataModel model, DynamicObject loanBill) {
        String repayment = loanBill.getString("repaymentway");
        if (RepaymentWayEnum.isBqhbdqhx((String)repayment) || RepaymentWayEnum.isDqhbdqhx((String)repayment)) {
            model.setValue("settleintmode", (Object)SettleIntModeEnum.gdpljx.getValue());
        } else {
            model.setValue("settleintmode", (Object)SettleIntModeEnum.lsbq.getValue());
        }
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        Control source = (Control)e.getSource();
        String key = source.getKey();
        int rowIndex = e.getRowIndex();
        Object value = e.getValue();
        if (EmptyUtil.isEmpty((Object)value)) {
            return;
        }
        switch (key) {
            case "exdrawamount": {
                this.exdrawAmountBeforePost(e, key, rowIndex, value);
                break;
            }
            case "exrepaymentdate": {
                this.expaymentDateBeforePost(e, key, rowIndex, value);
                break;
            }
        }
    }

    private void expaymentDateBeforePost(BeforeFieldPostBackEvent e, String key, int rowIndex, Object value) {
        String fmtStr = ((DateEdit)this.getControl("exrepaymentdate")).getFormatString();
        Date repaymentDate = DateUtils.stringToDate((String)value.toString(), (String)fmtStr);
        Date maxYetDoRepayDate = this.getMaxYetDoRepayDate();
        if (EmptyUtil.isNoEmpty((Object)maxYetDoRepayDate) && repaymentDate.compareTo(maxYetDoRepayDate) <= 0) {
            e.setCancel(true);
            String repayDatePropName = CfmBillCommonHelper.getPropLocalDisplayName((IFormView)this.getView(), (String)"exrepaymentdate");
            this.getView().showTipNotification(CfmFormResourceEnum.RepaymentPlanModifyPlugin_7.loadKDString(repayDatePropName, repayDatePropName, DateUtils.formatString((Date)maxYetDoRepayDate, (String)"yyyy-MM-dd")));
            this.getView().updateView(key, rowIndex);
        }
    }

    private void exdrawAmountBeforePost(BeforeFieldPostBackEvent e, String key, int rowIndex, Object value) {
        BigDecimal newRowtotalAmts;
        BigDecimal drawAmt = (BigDecimal)this.getModel().getValue("drawamount");
        BigDecimal allEntryRowsAmt = this.getAllEntryRowsAmt("exdrawamount");
        DynamicObject rowInfo = this.getModel().getEntryRowEntity("repayplan_entry", rowIndex);
        BigDecimal beforeRowAmt = rowInfo.getBigDecimal("exdrawamount");
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("repayplan_entry");
        BigDecimal lastRowAmt = BigDecimal.ZERO;
        if (entrys.size() - 1 != rowIndex) {
            lastRowAmt = ((DynamicObject)entrys.get(entrys.size() - 1)).getBigDecimal("exdrawamount");
        }
        if ((newRowtotalAmts = allEntryRowsAmt.subtract(beforeRowAmt).subtract(lastRowAmt).add(new BigDecimal(value + ""))).compareTo(drawAmt) > 0) {
            e.setCancel(true);
            String entityName = this.getModel().getDataEntityType().getName();
            String msg = EmptyUtil.isNoEmpty((String)entityName) && entityName.startsWith("ifm") ? CfmFormResourceEnum.RepaymentPlanModifyPlugin_8.loadKDString() : (DataSourceEnum.isBond((String)((String)this.getModel().getValue("datasource"))) ? CfmFormResourceEnum.RepaymentPlanModifyPlugin_10.loadKDString() : CfmFormResourceEnum.RepaymentPlanModifyPlugin_5.loadKDString());
            this.getView().showTipNotification(msg);
            this.getView().updateView(key, rowIndex);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IFormView view = this.getView();
        CfmBillCommonHelper.setRepayIntPlanBotnVisable((IFormView)view);
        String formId = view.getFormShowParameter().getFormId();
        if ("ifm_loanbill_repayplan_l".equals(formId)) {
            CfmBillCommonHelper.setSignMustInput((IFormView)view, (Boolean)Boolean.TRUE, (String[])new String[]{"loanbill"});
        }
        if (OperationStatus.EDIT == this.getView().getFormShowParameter().getStatus()) {
            view.setEnable(Boolean.FALSE, new String[]{"loanbill"});
        }
        IDataModel model = this.getModel();
        TmcViewInputHelper.setValWithoutDataChanged((IDataModel)model, (String)"loanbill", (Object)model.getValue("billno"));
        this.setCanEditByRepayState();
        if (LoanBillApplyFormHelper.validateCfmPlanParam(this.getModel().getDataEntity())) {
            view.setEnable(Boolean.FALSE, new String[]{"bar_scsave"});
        }
    }

    private void setCanEditByRepayState() {
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("repayplan_entry");
        int size = entrys.size();
        for (int i = 0; i < size; ++i) {
            DynamicObject repayPlan = (DynamicObject)entrys.get(i);
            if (repayPlan.getInt("repaystate") != 1) continue;
            this.getView().setEnable(Boolean.FALSE, i, new String[]{"exrepaymentdate", "exdrawamount", "erepayamount", "enotrepayamount", "repayaccount", "repaymentdesc"});
        }
    }

    public void initialize() {
        super.initialize();
        this.initRepaymentWayItems();
    }

    private void initRepaymentWayItems() {
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(8);
        comboItems.add(this.createComboItem(RepaymentWayEnum.bqhblsbq));
        comboItems.add(this.createComboItem(RepaymentWayEnum.dqhblsbq));
        comboItems.add(this.createComboItem(RepaymentWayEnum.bqhbdqhx));
        comboItems.add(this.createComboItem(RepaymentWayEnum.dqhbdqhx));
        comboItems.add(this.createComboItem(RepaymentWayEnum.zdyhk));
        ((ComboEdit)this.getControl("repaymentway")).setComboItems(comboItems);
    }

    private ComboItem createComboItem(RepaymentWayEnum repaymentWay) {
        ComboItem comboItem = new ComboItem();
        comboItem.setValue(repaymentWay.getValue());
        comboItem.setCaption(new LocaleString(repaymentWay.getName()));
        return comboItem;
    }

    public void click(EventObject evt) {
        if (evt.getSource() instanceof Control) {
            String key;
            switch (key = ((Control)evt.getSource()).getKey()) {
                case "loanbill": {
                    this.openLoanBill();
                }
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "newentryplan": 
            case "entryimport": {
                this.validEntryRowOp(args);
                break;
            }
            case "schedulesave": {
                if (!EmptyUtil.isEmpty((Object)this.getModel().getValue("loanbill"))) break;
                if (StringUtils.equals((CharSequence)"cfm_loanbill_bond", (CharSequence)this.getModel().getDataEntityType().getName())) {
                    this.getModel().setValue("datasource", (Object)DataSourceEnum.BOND.getValue());
                } else if (StringUtils.equals((CharSequence)"cim_invest_loanbill", (CharSequence)this.getModel().getDataEntityType().getName())) {
                    this.getModel().setValue("datasource", (Object)DataSourceEnum.INVEST.getValue());
                } else {
                    this.getModel().setValue("datasource", (Object)DataSourceEnum.CFM.getValue());
                }
                AbstractBizResource bizResource = new BizResourceFactory().getBizResource((String)this.getModel().getValue("datasource"));
                this.getView().showErrorNotification(bizResource.getIbMustChooseloanno());
                args.setCancel(true);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        switch (operateKey = args.getOperateKey()) {
            case "schedulesave": {
                if (args.getOperationResult() == null || !args.getOperationResult().isSuccess()) break;
                this.getView().invokeOperation("refresh");
            }
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        EntryProp entryProp = e.getEntryProp();
        String entryName = entryProp.getName();
        if ("repayplan_entry".equals(entryName)) {
            for (RowDataEntity row : e.getRowDataEntities()) {
                int index = row.getRowIndex();
                if (index < 0) continue;
                this.newScheduleEntry(index);
            }
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        int[] indexs = e.getRowIndexs();
        EntryProp entryProp = e.getEntryProp();
        if ("repayplan_entry".equals(entryProp.getName()) && indexs.length > 0) {
            for (int row : indexs) {
                if (!"1".equals(this.getModel().getValue("repaystate", row))) continue;
                String repayStatePropName = CfmBillCommonHelper.getPropLocalDisplayName((IFormView)this.getView(), (String)"repaystate");
                this.getView().showTipNotification(CfmFormResourceEnum.RepaymentPlanModifyPlugin_9.loadKDString(repayStatePropName));
                e.setCancel(true);
            }
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        EntryProp entryProp = e.getEntryProp();
        String entryName = entryProp.getName();
        if ("repayplan_entry".equals(entryName)) {
            this.calLastRowAmtVal();
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        Object returnData = e.getReturnData();
        if ("loanbill".equals(e.getActionId()) && EmptyUtil.isNoEmpty((Object)returnData)) {
            Object id = ((ListSelectedRowCollection)returnData).get(0).getPrimaryKeyValue();
            ((IBillModel)this.getModel()).load(id);
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"loanbill", (Object)((ListSelectedRowCollection)returnData).get(0).getBillNo());
            this.getView().updateView();
        }
    }

    private void validEntryRowOp(BeforeDoOperationEventArgs args) {
        if (EmptyUtil.isEmpty((Object)this.getModel().getValue("billno"))) {
            String formId = this.getView().getFormShowParameter().getFormId();
            String tipWord = CfmFormResourceEnum.RepaymentPlanModifyPlugin_1.loadKDString();
            if ("cfm_loanbill_bond_p".equals(formId)) {
                tipWord = CfmFormResourceEnum.RepaymentPlanModifyPlugin_2.loadKDString();
            } else if ("cim_invest_loanbil_plan".equals(formId) || "ifm_loanbill_repayplan_l".equals(formId)) {
                tipWord = CfmFormResourceEnum.RepaymentPlanModifyPlugin_3.loadKDString();
            }
            this.getView().showTipNotification(tipWord);
            args.setCancel(true);
        }
    }

    private void newScheduleEntry(int index) {
        BigDecimal drawAmt = (BigDecimal)this.getModel().getValue("drawamount");
        String repaymentway = (String)this.getModel().getValue("repaymentway");
        DynamicObject accountBank = (DynamicObject)this.getModel().getValue("accountbank");
        if ((repaymentway.equals(RepaymentWayEnum.bqhblsbq.getValue()) || repaymentway.equals(RepaymentWayEnum.bqhbdqhx.getValue())) && 0 == index) {
            this.getModel().setValue("exrepaymentdate", this.getModel().getValue("expiredate"));
            this.getModel().setValue("exdrawamount", (Object)drawAmt);
            this.getModel().setValue("enotrepayamount", this.getModel().getValue("drawamount"));
        } else {
            this.calLastRowAmtVal();
        }
        this.setUpdateRowInfo(index);
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"repaymentdesc", (Object)this.getDefaultRemark(), (int)index);
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"repayaccount", (Object)accountBank, (int)index);
    }

    private void calLastRowAmtVal() {
        DynamicObjectCollection lastRowInfos = this.getModel().getEntryEntity("repayplan_entry");
        if (lastRowInfos.size() > 0) {
            int lastRow = lastRowInfos.getRowCount() - 1;
            BigDecimal allEntryRowsAmt = BigDecimal.ZERO;
            for (int i = 0; i < lastRowInfos.size() - 1; ++i) {
                allEntryRowsAmt = allEntryRowsAmt.add(((DynamicObject)lastRowInfos.get(i)).getBigDecimal("exdrawamount"));
            }
            BigDecimal drawAmt = (BigDecimal)this.getModel().getValue("drawamount");
            BigDecimal remainAmt = drawAmt.subtract(allEntryRowsAmt);
            if (EmptyUtil.isNoEmpty((BigDecimal)remainAmt) && !"1".equals(this.getModel().getValue("repaystate", lastRow))) {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"exdrawamount", (Object)remainAmt, (int)lastRow);
                this.setUpdateRowInfo(lastRow);
            }
        }
    }

    private Date getMaxYetDoRepayDate() {
        DynamicObjectCollection rowInfos = this.getModel().getEntryEntity("repayplan_entry");
        return rowInfos.stream().filter(o -> EmptyUtil.isNoEmpty((Object)o.getDate("exrepaymentdate"))).filter(o -> "1".equals(o.getString("repaystate"))).map(o -> o.getDate("exrepaymentdate")).max(Comparator.comparing(o -> o)).orElse(null);
    }

    private BigDecimal getAllEntryRowsAmt(String entryField) {
        EntryGrid entryGrid = (EntryGrid)this.getControl("repayplan_entry");
        return entryGrid.getSum(entryField);
    }

    private void setUpdateRowInfo(int rowIndex) {
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"repaymentmodifier", (Object)RequestContext.get().getCurrUserId(), (int)rowIndex);
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"repaymentmodifytime", (Object)DateUtils.getCurrentTime(), (int)rowIndex);
    }

    private void openLoanBill() {
        Long userPK = RequestContext.get().getCurrUserId();
        QFilter qFilter = new QFilter("drawtype", "!=", (Object)DrawTypeEnum.CLOSEOUT.getValue());
        String loanType = (String)this.getModel().getValue("loantype");
        if (this.getView().getFormShowParameter().getCustomParams().containsKey("biztype")) {
            String bizType = (String)this.getView().getFormShowParameter().getCustomParam("biztype");
            Object[] bizTypes = bizType.split(",");
            if (EmptyUtil.isNoEmpty((Object[])bizTypes)) {
                qFilter.and(new QFilter("loantype", "in", (Object)bizTypes));
            }
        } else if (EmptyUtil.isNoEmpty((String)loanType)) {
            qFilter.and(new QFilter("loantype", "in", (Object)BizTypeEnum.getSameTypeComb((String)loanType)));
        }
        String appId = this.getView().getFormShowParameter().getAppId();
        List orgIdSet = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)userPK, (String)appId, (String)this.getModel().getDataEntityType().getName(), (String)"47150e89000000ac");
        String billFormId = this.getView().getFormShowParameter().getFormId();
        if ("cim_invest_loanbil_plan".equals(billFormId)) {
            qFilter.and("datasource", "=", (Object)DataSourceEnum.INVEST.getValue());
            qFilter.and(new QFilter("creditorg.id", "in", (Object)orgIdSet));
        } else if ("cfm_loanbill_bond_p".equals(billFormId)) {
            qFilter.and("datasource", "=", (Object)DataSourceEnum.BOND.getValue());
            qFilter.and(new QFilter("org.id", "in", (Object)orgIdSet));
        } else if ("ifm_loanbill_repayplan_l".equals(billFormId)) {
            qFilter.and("datasource", "=", (Object)DataSourceEnum.IFM.getValue());
            qFilter.and(new QFilter("org.id", "in", (Object)orgIdSet));
        } else if ("cfm_loadbill_view".equals(billFormId)) {
            qFilter.and("datasource", "=", (Object)DataSourceEnum.CFM.getValue());
            qFilter.and(new QFilter("org.id", "in", (Object)orgIdSet));
        }
        List<String> noOpPlanWays = Arrays.asList(RepaymentWayEnum.debx.getValue(), RepaymentWayEnum.debj.getValue(), RepaymentWayEnum.dbdx.getValue());
        qFilter.and(new QFilter("repaymentway", "not in", noOpPlanWays));
        ListShowParameter paramter = ShowFormHelper.createShowListForm((String)billFormId, (boolean)false, (int)0, (boolean)true);
        logger.info("RepaymentPlanModifyPlugin filter:" + qFilter);
        paramter.getListFilterParameter().setFilter(qFilter);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "loanbill");
        paramter.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)paramter);
    }

    private String getDefaultRemark() {
        return CfmFormResourceEnum.RepaymentPlanModifyPlugin_6.loadKDString();
    }
}

