/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.loanbillapply;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cfm.common.repository.LoanBillRepository;
import kd.tmc.fbp.common.helper.BillChangeHistoryHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.common.billversion.AbstractBillVersionTabEdit;

public class LoanBillApplyHistoryPlugin
extends AbstractBillVersionTabEdit {
    protected final List<String> applyFields = Arrays.asList("h_applydate", "h_loanbillno");

    protected String getApplyBillEntity() {
        String formId = this.getView().getFormShowParameter().getFormId();
        if ("cfm_loanbill_b_l".equals(formId) || "cfm_loanbill_e_l".equals(formId)) {
            return "cfm_apply_loanbill";
        }
        return "cim_apply_loanbill";
    }

    protected Map<String, String> getEntryNameAndEntryKey() {
        HashMap<String, String> entryMap = new HashMap<String, String>();
        entryMap.put("repayplan_entry", "exrepaymentdate");
        entryMap.put("interest_entry", "interesdate");
        return entryMap;
    }

    protected Map<String, String> getEntryPropAndTabPage() {
        HashMap<String, String> entryMap = new HashMap<String, String>(16);
        entryMap.put("repayplan_entry", "tabrepaymentplan");
        entryMap.put("interest_entry", "tabintplan");
        return entryMap;
    }

    protected String getModifyTabName() {
        return "tabpage_history";
    }

    protected String getModifyEntryName() {
        return "history_entry";
    }

    protected List<String> getShowFieldProp() {
        String prefix = "h_";
        String suffix = ".id";
        ArrayList<String> show = new ArrayList<String>(30);
        show.add("h_version");
        show.add("h_id");
        show.add("h_applyid");
        show.add(prefix + "org" + suffix);
        show.add(prefix + "textcreditor");
        show.add(prefix + "contractname");
        show.add(prefix + "currency" + suffix);
        show.add(prefix + "startintdate");
        show.add(prefix + "expiredate");
        show.add(prefix + "term");
        show.add(prefix + "loanbillno");
        show.add(prefix + "applydate");
        show.add(this.getClickApplyNo());
        return show;
    }

    protected String getClickVersion() {
        return "h_version";
    }

    protected String getClickApplyNo() {
        return "h_applybillno";
    }

    protected List<String> getHiddenButton() {
        return Arrays.asList("bar_save", "bar_submit", "bar_submitandnew", "bar_del", "bar_audit", "bar_print", "bar_modify", "bar_adjustinterest", "bar_refresh", "bar_check", "bar_updateinstplan", "bar_repaymentsc", "bar_cancelconfirm");
    }

    protected LocaleString getFormTitle() {
        return new LocaleString(ResManager.loadKDString((String)"\u5386\u53f2\u7248\u672c\u660e\u7ec6", (String)"LoanBillApplyHighLight_0", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
    }

    protected String getBizBillInfo() {
        Long loanBillId = (Long)this.getModel().getValue("id");
        return SerializationUtils.serializeToBase64((Object)LoanBillRepository.loadSingle((Long)loanBillId));
    }

    protected void dealVsEntryInfo(DynamicObject[] historys, TableValueSetter vs, LinkedHashMap<String, String> maps) {
        for (DynamicObject history : historys) {
            if (EmptyUtil.isEmpty((Object)history.get("applyentity"))) continue;
            ArrayList<Object> addRow = new ArrayList<Object>(16);
            DynamicObject applyBill = BillChangeHistoryHelper.deserializeBillInfo((DynamicObject)history);
            for (Map.Entry<String, String> map : maps.entrySet()) {
                String key = map.getKey();
                String value = map.getValue();
                if (this.hisHeadFields.contains(value)) {
                    addRow.add(history.get(key));
                    continue;
                }
                if (this.applyFields.contains(value)) {
                    addRow.add(this.getRowVal(history, key));
                    continue;
                }
                addRow.add(applyBill.get(key));
            }
            vs.addRow(addRow.toArray());
        }
    }

    private Object getRowVal(DynamicObject history, String key) {
        DynamicObject applyBill = QueryServiceHelper.queryOne((String)"cfm_apply_loanbill", (String)key, (QFilter[])new QFilter[]{new QFilter("id", "=", history.get("applyid"))});
        if (EmptyUtil.isEmpty((DynamicObject)applyBill)) {
            return null;
        }
        return applyBill.get(key);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObjectCollection history_entry = this.getModel().getEntryEntity("history_entry");
        if (history_entry.size() == 0) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{this.getModifyTabName()});
        }
    }
}

