/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.loanbillapply;

import java.util.List;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cfm.common.enums.DataSourceEnum;
import kd.tmc.cfm.common.helper.IfmBizDealHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.list.AbstractTmcBillBaseList;

public class LoanBillApplyList
extends AbstractTmcBillBaseList {
    public void setFilter(SetFilterEvent e) {
        List qFilters = e.getQFilters();
        String formId = ((ListShowParameter)this.getView().getFormShowParameter()).getBillFormId();
        if ("cfm_apply_loanbill".equals(formId)) {
            qFilters.add(new QFilter("datasource", "=", (Object)DataSourceEnum.CFM.getValue()));
        } else if ("cim_apply_loanbill".equals(formId)) {
            qFilters.add(new QFilter("datasource", "=", (Object)DataSourceEnum.INVEST.getValue()));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if ("pushbizdealbill".equals(operateKey)) {
            IfmBizDealHelper.validatePush2SettleCenter((IFormView)this.getView(), (String)"cfm_apply_loanbill", (List)this.getSelectedIdList(), (BeforeDoOperationEventArgs)args);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        Long selectedId;
        super.afterDoOperation(args);
        String opKey = args.getOperateKey();
        if ("trace2loan".equals(opKey) && EmptyUtil.isNoEmpty((Long)(selectedId = this.getSelectedId()))) {
            BillList billList = (BillList)this.getControl("billlistap");
            if (EmptyUtil.isEmpty((Object)billList.getEntityType())) {
                return;
            }
            String dataEntity = billList.getEntityType().getName();
            DynamicObject applyBill = QueryServiceHelper.queryOne((String)dataEntity, (String)"id, billstatus, loanbill", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)selectedId)});
            LoanBillApplyList.trace2Loan(applyBill, this.getView(), dataEntity);
        }
    }

    public static void trace2Loan(DynamicObject applyBill, IFormView view, String dataEntity) {
        DynamicObject tagBill;
        if (!BillStatusEnum.AUDIT.getValue().equals(applyBill.getString("billstatus"))) {
            view.showTipNotification(ResManager.loadKDString((String)"\u5df2\u5ba1\u6838\u7684\u5355\u636e\u624d\u80fd\u8fdb\u884c\u8054\u67e5\u5355\u636e\u3002", (String)"LoanBillApplyList_0", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
            return;
        }
        String entity = "cfm_loanbill";
        if ("cim_apply_loanbill".equals(dataEntity)) {
            entity = "cim_invest_loanbill";
        }
        if (EmptyUtil.isEmpty((DynamicObject)(tagBill = QueryServiceHelper.queryOne((String)entity, (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "=", applyBill.get("loanbill"))})))) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8be5\u53d8\u66f4\u7533\u8bf7\u5355\u672a\u627e\u5230\u63d0\u6b3e\u5355\u6216\u653e\u6b3e\u5355,\u4e0d\u80fd\u8fdb\u884c\u6b64\u64cd\u4f5c\u3002", (String)"LoanBillApplyList_1", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
            return;
        }
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setPkId(tagBill.get("id"));
        showParameter.setFormId(entity);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setStatus(OperationStatus.VIEW);
        view.showForm((FormShowParameter)showParameter);
    }
}

