/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.preinterestbill;

import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterBuildDrawFilterEventArgs;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.tmc.cfm.common.bean.InterestCalcRequest;
import kd.tmc.cfm.common.enums.PrePeriodParamEnum;
import kd.tmc.cfm.common.helper.InterestCalcHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.model.interest.IntBillExtInfo;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class PreInstBillConvertPlugin
extends AbstractConvertPlugIn {
    private static final Log logger = LogFactory.getLog(PreInstBillConvertPlugin.class);

    public void afterBuildDrawFilter(AfterBuildDrawFilterEventArgs e) {
        Map variables = this.getOption().getVariables();
        String instfilterStr = (String)variables.get("instBillfilter");
        QFilter loanFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()).and(new QFilter("productfactory", "=", (Object)0).or(new QFilter("productfactory.iscallint", "=", (Object)"1")));
        if (EmptyUtil.isNoEmpty((String)instfilterStr)) {
            loanFilter.and(QFilter.fromSerializedString((String)instfilterStr));
        }
        e.setPlugFilter(loanFilter);
    }

    public void afterConvert(AfterConvertEventArgs e) {
        super.afterConvert(e);
        ExtendedDataEntitySet entitySet = e.getTargetExtDataEntitySet();
        ExtendedDataEntity[] entitys = entitySet.FindByEntityKey(this.getTgtMainType().getName());
        Map variables = this.getOption().getVariables();
        String preperiod = (String)variables.get("preperiod");
        logger.info("\u671f\u95f4:preperiod=" + preperiod);
        String preinstbillstatus = (String)variables.get("preinstbillstatus");
        logger.info("\u72b6\u6001:preinstbillstatus=" + preinstbillstatus);
        String autoPre = (String)variables.get("auto");
        logger.info("\u81ea\u52a8\u9884\u63d0:autoPre=" + autoPre);
        for (ExtendedDataEntity entity : entitys) {
            IntBillExtInfo intBill;
            DynamicObject preInterestBill = entity.getDataEntity();
            Long loanbillid = preInterestBill.getLong("sourcebillid");
            DynamicObject loanbillDO = TmcDataServiceHelper.loadSingle((Object)loanbillid, (String)"cfm_loanbill");
            if ("submit".equals(preinstbillstatus)) {
                preInterestBill.set("billstatus", (Object)BillStatusEnum.SUBMIT.getValue());
            } else if ("audit".equals(preinstbillstatus)) {
                preInterestBill.set("billstatus", (Object)BillStatusEnum.AUDIT.getValue());
            }
            if ("true".equals(autoPre)) {
                preInterestBill.set("auto", (Object)"1");
            }
            preInterestBill.set("predictpreinstamt", null);
            preInterestBill.set("actpreinstamt", null);
            preInterestBill.set("entrys", null);
            Date prestenddate = DateUtils.getCurrentDate();
            if (PrePeriodParamEnum.THISMONTH.getValue().equals(preperiod)) {
                prestenddate = DateUtils.getLastDayOfMonth((Date)DateUtils.getCurrentDate());
            } else if (PrePeriodParamEnum.LASTMONTH.getValue().equals(preperiod)) {
                prestenddate = DateUtils.getLastDayOfMonth((Date)DateUtils.getLastMonth((Date)DateUtils.getCurrentDate(), (int)1));
            } else if (PrePeriodParamEnum.THISSEASON.getValue().equals(preperiod)) {
                prestenddate = DateUtils.getQuarterEnd((Date)DateUtils.getCurrentDate());
            }
            preInterestBill.set("prestenddate", (Object)prestenddate);
            Date preBeginDate = loanbillDO.getDate("endpreinstdate");
            if (EmptyUtil.isNoEmpty((Object)preBeginDate)) {
                preBeginDate = DateUtils.getNextDay((Date)preBeginDate, (int)1);
                preInterestBill.set("prestartdate", (Object)preBeginDate);
            } else {
                preBeginDate = loanbillDO.getDate("startintdate");
                preInterestBill.set("prestartdate", (Object)preBeginDate);
            }
            prestenddate = InterestCalcHelper.getEndIntDate((DynamicObject)loanbillDO, (Date)prestenddate);
            if (!EmptyUtil.isNoEmpty((Object)prestenddate) || !EmptyUtil.isNoEmpty((Object)preBeginDate) || prestenddate.compareTo(preBeginDate) < 0 || !EmptyUtil.isNoEmpty((Object)(intBill = InterestCalcHelper.callInt((InterestCalcRequest)InterestCalcRequest.build((DynamicObject)loanbillDO, (Date)preBeginDate, (Date)prestenddate, (boolean)true))))) continue;
            preInterestBill.set("predictpreinstamt", (Object)intBill.getAmount());
            preInterestBill.set("actpreinstamt", (Object)intBill.getAmount());
            DynamicObjectCollection entrys = preInterestBill.getDynamicObjectCollection("entrys");
            InterestCalcHelper.addDetail((DynamicObjectCollection)entrys, (List)intBill.getExtDetails());
        }
    }
}

