/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.preinterestbill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.field.AmountEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cfm.common.enums.PreIntOperateTypeEnum;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class PreIntCorrectConfirmEdit
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnok"});
    }

    public void afterCreateNewData(EventObject e) {
        this.loadPreIntBill();
        this.initShowView();
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        String key = c.getKey();
        if (StringUtils.equals((CharSequence)key, (CharSequence)"btnok") && this.validate()) {
            this.getView().returnDataToParent(this.getOperateInfo());
            this.getView().close();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)propName, (CharSequence)"confirmtype")) {
            this.initShowView();
        }
    }

    private void initShowView() {
        String confirmType = (String)this.getModel().getValue("confirmtype");
        boolean isSupInt = PreIntOperateTypeEnum.isSupInt((String)confirmType);
        TmcViewInputHelper.registerVisibleStatus((IFormView)this.getView(), (String[])new String[]{"supintamt"}, (boolean)isSupInt);
        TmcViewInputHelper.registerVisibleStatus((IFormView)this.getView(), (String[])new String[]{"writeoffamt"}, (!isSupInt ? 1 : 0) != 0);
    }

    private Map<String, Object> getOperateInfo() {
        HashMap<String, Object> dataMap = new HashMap<String, Object>(4);
        String confirmType = (String)this.getModel().getValue("confirmtype");
        dataMap.put("confirmtype", confirmType);
        DynamicObjectCollection entry = this.getModel().getEntryEntity("entrys");
        String amtField = PreIntOperateTypeEnum.isSupInt((String)confirmType) ? "supintamt" : "writeoffamt";
        Map<Object, BigDecimal> confirmInfoMap = entry.stream().collect(Collectors.toMap(v -> v.get("preintid"), p -> p.getBigDecimal(amtField)));
        dataMap.put("confirminfo", confirmInfoMap);
        return dataMap;
    }

    private void loadPreIntBill() {
        List ids = (List)this.getView().getFormShowParameter().getCustomParams().get("param_preintbillids");
        if (EmptyUtil.isEmpty((Collection)ids)) {
            return;
        }
        QFilter filter = new QFilter("id", "in", (Object)ids);
        DynamicObjectCollection preIntBills = QueryServiceHelper.query((String)"cfm_preinterestbill", (String)"id,billno,currency,nowriteoffamt", (QFilter[])filter.toArray());
        ArrayList billList = new ArrayList(preIntBills.size());
        for (DynamicObject preIntBill : preIntBills) {
            HashMap<String, Object> dataMap = new HashMap<String, Object>(16);
            dataMap.put("preintid", preIntBill.getLong("id"));
            dataMap.put("billno", preIntBill.getString("billno"));
            dataMap.put("currency", preIntBill.getLong("currency"));
            dataMap.put("writeoffamt", preIntBill.getBigDecimal("nowriteoffamt"));
            dataMap.put("nowriteoffamt", preIntBill.getBigDecimal("nowriteoffamt"));
            billList.add(dataMap);
        }
        TmcViewInputHelper.batchFillEntity((String)"entrys", (AbstractFormDataModel)((AbstractFormDataModel)this.getModel()), billList);
    }

    private boolean validate() {
        IFormView view = this.getView();
        DynamicObjectCollection entry = this.getModel().getEntryEntity("entrys");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)entry)) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5206\u5f55\u4fe1\u606f\u3002", (String)"PreIntCorrectConfirmEdit_0", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
            return false;
        }
        String confirmType = (String)this.getModel().getValue("confirmtype");
        boolean isSupInt = PreIntOperateTypeEnum.isSupInt((String)confirmType);
        String amtField = isSupInt ? "supintamt" : "writeoffamt";
        LocaleString amtFieldName = ((AmountEdit)this.getControl(amtField)).getProperty().getDisplayName();
        Map<Object, BigDecimal> dataMap = this.LoadNoWriteOffAmtMap(entry);
        int rowIndex = 0;
        boolean result = true;
        for (DynamicObject row : entry) {
            ++rowIndex;
            BigDecimal amount = row.getBigDecimal(amtField);
            if (EmptyUtil.isEmpty((BigDecimal)amount)) {
                view.showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5206\u5f55\u7b2c%1s\u884c%2s\u3002", (String)"PreIntCorrectConfirmEdit_1", (String)"tmc-cfm-formplugin", (Object[])new Object[0]), rowIndex, amtFieldName));
                result = false;
                continue;
            }
            if (isSupInt) {
                BigDecimal noWriteOffAmt = dataMap.get(row.get("preintid"));
                if (null == noWriteOffAmt || noWriteOffAmt.add(amount).compareTo(Constants.MAX_AMOUNT) <= 0) continue;
                view.showTipNotification(String.format(ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%1s\u884c\u8865\u63d0\u540e\u9884\u63d0\u5355\u5269\u4f59\u672a\u51b2\u9500\u91d1\u989d\u8d85\u51fa\u91d1\u989d\u6700\u5927\u503c\u8303\u56f4 9,999,999,999,999.9999\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\u3002", (String)"PreIntCorrectConfirmEdit_2", (String)"tmc-cfm-formplugin", (Object[])new Object[0]), rowIndex));
                result = false;
                continue;
            }
            if (amount.compareTo(row.getBigDecimal("nowriteoffamt")) <= 0) continue;
            view.showTipNotification(String.format(ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%1s\u884c%2s\u4e0d\u80fd\u5927\u4e8e\u672a\u51b2\u9500\u9884\u63d0\u91d1\u989d\u3002", (String)"PreIntCorrectConfirmEdit_3", (String)"tmc-cfm-formplugin", (Object[])new Object[0]), rowIndex, amtFieldName));
            result = false;
        }
        return result;
    }

    private Map<Object, BigDecimal> LoadNoWriteOffAmtMap(DynamicObjectCollection entry) {
        Object[] ids = entry.stream().map(v -> v.get("preintid")).toArray();
        DynamicObjectCollection preIntBills = QueryServiceHelper.query((String)"cfm_preinterestbill", (String)"id,nowriteoffamt", (QFilter[])new QFilter("id", "in", (Object)ids).toArray());
        return preIntBills.stream().collect(Collectors.toMap(v -> v.get("id"), p -> p.getBigDecimal("nowriteoffamt")));
    }
}

