/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.preinterestbill;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.TextEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cfm.common.enums.ConfirmStatusEnum;
import kd.tmc.cfm.common.enums.DataSourceEnum;
import kd.tmc.cfm.common.enums.LoanTypeEnum;
import kd.tmc.cfm.common.enums.PreIntOperateTypeEnum;
import kd.tmc.cfm.common.enums.RecordStatusEnum;
import kd.tmc.cfm.common.helper.CfmBillCommonHelper;
import kd.tmc.cfm.common.resource.BizResourceFactory;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.RepaymentWayEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.StringUtils;

public class PreInterestBillEdit
extends AbstractBillPlugIn {
    private static final Log logger = LogFactory.getLog(PreInterestBillEdit.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TextEdit loanBillNo = (TextEdit)this.getControl("loanbillno");
        loanBillNo.addClickListener((ClickListener)this);
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        CfmBillCommonHelper.PreOpenPageDeal((PreOpenFormEventArgs)e, (boolean)false);
    }

    public void click(EventObject evt) {
        if (evt.getSource() instanceof Control) {
            String key;
            switch (key = ((Control)evt.getSource()).getKey()) {
                case "loanbillno": {
                    this.drawLoanBill();
                }
            }
        }
    }

    private void drawLoanBill() {
        OperateOption option = OperateOption.create();
        QFilter instBillfilter = new QFilter("repaymentway", "not in", (Object)new String[]{RepaymentWayEnum.debx.getValue(), RepaymentWayEnum.debj.getValue(), RepaymentWayEnum.dbdx.getValue()});
        option.setVariableValue("instBillfilter", instBillfilter.toSerializedString());
        String formId = this.getView().getFormShowParameter().getFormId();
        if ("cfm_preinterestbill_e".equals(formId) || "cim_preinterestbill".equals(formId)) {
            this.getView().invokeOperation("draworg", option);
        } else if ("cfm_preinterestbill_bond".equals(formId)) {
            this.getView().invokeOperation("drawbond", option);
        } else {
            this.getView().invokeOperation("drawbank", option);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getModel().setValue("org", null);
        this.getModel().setValue("bizdate", (Object)DateUtils.getCurrentDate());
        String formId = this.getView().getFormShowParameter().getFormId();
        if ("cfm_preinterestbill_bond".equals(formId)) {
            this.getModel().setValue("loantype", (Object)LoanTypeEnum.BOND.getValue());
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Long preInstId = (Long)this.getModel().getValue("id");
        if (EmptyUtil.isNoEmpty((Long)preInstId)) {
            QFilter sourcebillFilter = new QFilter("sourcebillid", "=", (Object)preInstId);
            String recordStatus = (String)this.getModel().getValue("recordstatus");
            boolean isHasVoucher = TmcDataServiceHelper.exists((String)"ai_daptracker", (QFilter[])new QFilter[]{sourcebillFilter});
            if (isHasVoucher && RecordStatusEnum.NORECORD.getValue().equals(recordStatus)) {
                this.getModel().setValue("recordstatus", (Object)RecordStatusEnum.ALRECORD.getValue());
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.getModel().getDataEntity()});
            } else if (!isHasVoucher && RecordStatusEnum.ALRECORD.getValue().equals(recordStatus)) {
                this.getModel().setValue("recordstatus", (Object)RecordStatusEnum.NORECORD.getValue());
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.getModel().getDataEntity()});
            }
        }
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String confirmStatus = dataEntity.getString("confirmstatus");
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        boolean showWaitConfirm = customParams.containsKey("confirm") && ConfirmStatusEnum.WAITCONFIRM.getValue().equals(confirmStatus);
        this.getView().setVisible(Boolean.valueOf(showWaitConfirm), new String[]{"bar_confirm", "bar_returnback"});
        this.updateCorrectControl();
        this.setEntryColumnVisibleForSofr();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if ("calinterest".equals(operateKey)) {
            String formId = this.getView().getFormShowParameter().getFormId();
            String dataSource = DataSourceEnum.CFM.getValue();
            if ("cfm_preinterestbill_bond".equals(formId)) {
                dataSource = DataSourceEnum.BOND.getValue();
            }
            if (EmptyUtil.isEmpty((Object)this.getModel().getValue("loanbillno"))) {
                this.getView().showTipNotification(new BizResourceFactory().getBizResource(dataSource).getIbMustChooseloanno());
                args.setCancel(true);
                return;
            }
            if (EmptyUtil.isEmpty((Object)this.getModel().getValue("prestartdate"))) {
                this.getView().showTipNotification(new BizResourceFactory().getBizResource(dataSource).getIbMustChoosePreDate());
                args.setCancel(true);
                return;
            }
            if (EmptyUtil.isEmpty((Object)this.getModel().getValue("prestenddate"))) {
                this.getView().showTipNotification(new BizResourceFactory().getBizResource(dataSource).getIbMustChoosePreEndDate());
                args.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        OperationResult opResult = args.getOperationResult();
        if ("calinterest".equals(operateKey) && opResult.isSuccess()) {
            this.getView().updateView();
        }
        if (args.getOperationResult() != null && args.getOperationResult().isSuccess()) {
            switch (operateKey) {
                case "audit": 
                case "submit": 
                case "unsubmit": 
                case "unaudit": {
                    this.getView().invokeOperation("refresh");
                    break;
                }
                case "businessconfirm": 
                case "cancelconfirm": {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"BusinessConfirmInitPlugin_5", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
                    this.getView().invokeOperation("refresh");
                }
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String fieldKey = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        switch (fieldKey) {
            case "prestenddate": {
                Date prestenddate = (Date)this.getModel().getValue("prestenddate");
                if (!EmptyUtil.isNoEmpty((Object)prestenddate)) break;
                this.getModel().setValue("bizdate", (Object)DateUtils.getLastDay((Date)((Date)newValue), (int)1));
                this.getModel().deleteEntryData("entrys");
                this.getModel().setValue("predictpreinstamt", (Object)0);
                this.getModel().setValue("actpreinstamt", (Object)0);
                break;
            }
            case "actpreinstamt": {
                this.getModel().setValue("nowriteoffamt", e.getChangeSet()[0].getNewValue());
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if (StringUtils.equals((CharSequence)"bar_returnback", (CharSequence)itemKey)) {
            this.backOp();
        }
    }

    private void backOp() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("cfm_confirm_back");
        showParameter.setCustomParam("billid", this.getModel().getValue("id"));
        showParameter.setCustomParam("businesstype", (Object)this.getView().getEntityId());
        showParameter.getOpenStyle().setShowType(ShowType.NonModal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "cfm_confirm_back"));
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        Map data;
        super.closedCallBack(e);
        if (StringUtils.equals((CharSequence)e.getActionId(), (CharSequence)"cfm_confirm_back") && null != (data = (Map)e.getReturnData())) {
            String entityName = this.getView().getEntityId();
            Object[] load = BusinessDataServiceHelper.load((Object[])new Object[]{data.get("billid")}, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)entityName));
            if (EmptyUtil.isEmpty((Object[])load)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u7684\u6570\u636e\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BusinessConfirmPlugin_0", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
                return;
            }
            for (Object dynamicObject : load) {
                dynamicObject.set("returnreason", (Object)String.valueOf(data.get("reason")));
            }
            OperationResult result = OperationServiceHelper.executeOperate((String)"back", (String)entityName, (DynamicObject[])load, (OperateOption)OperateOption.create());
            List errorInfos = result.getAllErrorOrValidateInfo();
            if (!result.isSuccess()) {
                ArrayList<String> errorMessages = new ArrayList<String>(errorInfos.size());
                for (IOperateInfo iOperateInfo : errorInfos) {
                    errorMessages.add(iOperateInfo.getMessage());
                }
                if (!errorMessages.isEmpty()) {
                    this.getView().showErrorNotification(String.join((CharSequence)"\n", errorMessages));
                } else {
                    this.getView().showErrorNotification(result.getMessage());
                }
            } else {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u9000\u56de\u6210\u529f\u3002", (String)"BusinessConfirmPlugin_1", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
                this.getView().invokeOperation("refresh");
            }
        }
    }

    public void beforeBindData(EventObject e) {
        Map customParams;
        String parentFormId;
        super.beforeBindData(e);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String status = dataEntity.getString("billstatus");
        String dataSource = dataEntity.getString("datasource");
        String confirmStatus = dataEntity.getString("confirmstatus");
        this.getView().setVisible(Boolean.FALSE, new String[]{"bar_cancelconfirm"});
        IFormView parentView = null;
        try {
            parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        }
        catch (Exception e1) {
            logger.error(String.format("getViewNoPlugin() error:%s", e1.getMessage()));
        }
        if (parentView != null && "bos_list".equals(parentFormId = parentView.getEntityId()) && ConfirmStatusEnum.YETCONFIRM.getValue().equals(confirmStatus) && BillStatusEnum.AUDIT.getValue().equals(status)) {
            String entityName = this.getModel().getDataEntityType().getName();
            if (DataSourceEnum.INVEST.getValue().equals(dataSource) && entityName.startsWith("cfm") || DataSourceEnum.CFM.getValue().equals(dataSource) && entityName.startsWith("cim")) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"bar_cancelconfirm"});
            }
        }
        String formId = this.getView().getFormShowParameter().getFormId();
        if (BillStatusEnum.AUDIT.getValue().equals(status)) {
            if (DataSourceEnum.CFM.getValue().equals(dataSource)) {
                if ("cfm_preinterestbill_e".equals(formId)) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"bar_unaudit"});
                } else {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"bar_unaudit"});
                }
            } else if (DataSourceEnum.INVEST.getValue().equals(dataSource)) {
                if ("cim_preinterestbill".equals(formId)) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"bar_unaudit"});
                } else {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"bar_unaudit"});
                }
            } else {
                this.getView().setVisible(Boolean.TRUE, new String[]{"bar_unaudit"});
            }
        }
        if (BillStatusEnum.SUBMIT.getValue().equals(status)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_unsubmit"});
        }
        boolean showWaitConfirm = (customParams = this.getView().getFormShowParameter().getCustomParams()).containsKey("confirm") && ConfirmStatusEnum.WAITCONFIRM.getValue().equals(confirmStatus);
        this.getView().setVisible(Boolean.valueOf(showWaitConfirm), new String[]{"bar_confirm", "bar_returnback"});
    }

    private void updateCorrectControl() {
        String operateType = (String)this.getModel().getValue("operatetype");
        if (PreIntOperateTypeEnum.isSupInt((String)operateType)) {
            HashMap<String, LocaleString> controlMap = new HashMap<String, LocaleString>(4);
            controlMap.put("text", ResManager.getLocaleString((String)"\u51b2\u6b63", (String)"PreInterestBillEdit_0", (String)"tmc-cfm-formplugin"));
            this.getView().updateControlMetadata("writeoffpanelap", controlMap);
        }
    }

    private void setEntryColumnVisibleForSofr() {
        Long loanId = (Long)this.getModel().getValue("sourcebillid");
        boolean isSofrRate = false;
        if (EmptyUtil.isNoEmpty((Long)loanId)) {
            DynamicObject loanBillDO = TmcDataServiceHelper.loadSingle((String)"cfm_loanbill", (String)"issofrrate", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)loanId)});
            isSofrRate = null != loanBillDO && loanBillDO.getBoolean("issofrrate");
        }
        this.getView().setVisible(Boolean.valueOf(isSofrRate), new String[]{"confirmratedate", "lookdays", "floatrate", "floatint", "totalint", "lasttotalint", "curtotalint"});
    }
}

