/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.preinterestbill;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cfm.common.enums.ConfirmStatusEnum;
import kd.tmc.cfm.common.enums.DataSourceEnum;
import kd.tmc.cfm.common.helper.BatchIntBillHelper;
import kd.tmc.cfm.common.helper.CfmBillCommonHelper;
import kd.tmc.cfm.common.helper.IntBillWriteOffHelper;
import kd.tmc.cfm.formplugin.resource.CfmFormResourceEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.CreditorTypeEnum;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.list.AbstractTmcListPlugin;

public class PreInterestBillList
extends AbstractTmcListPlugin {
    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        CfmBillCommonHelper.PreOpenPageDeal((PreOpenFormEventArgs)e, (boolean)true);
    }

    public void setFilter(SetFilterEvent e) {
        String bizType;
        Object[] bizTypes;
        FormShowParameter parameter = this.getView().getFormShowParameter();
        if (parameter.getCustomParams().containsKey("biztype") && EmptyUtil.isNoEmpty((Object[])(bizTypes = (bizType = (String)parameter.getCustomParam("biztype")).split(",")))) {
            e.getQFilters().add(new QFilter("loantype", "in", (Object)bizTypes));
        }
        this.addCreditorTypeFilter(e);
        e.getQFilters().add(new QFilter("id", "not in", this.getPreIntIds()));
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        if (parameter.getCustomParams().containsKey("biztype")) {
            String bizType = (String)parameter.getCustomParam("biztype");
            e.getParameter().getCustomParams().put("biztype", bizType);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        FormOperate formOperate = (FormOperate)args.getSource();
        block4 : switch (operateKey = formOperate.getOperateKey()) {
            case "redwriteoff": 
            case "unredwriteoff": {
                DynamicObject[] preIntBills;
                List ids = this.getSelectedIdList();
                QFilter filter = new QFilter("id", "in", (Object)ids);
                String preIntBillFormId = this.getDataEntityName();
                for (DynamicObject preIntBill : preIntBills = TmcDataServiceHelper.load((String)preIntBillFormId, (String)"id, billno,datasource,org,creditorg,creditortype", (QFilter[])filter.toArray())) {
                    String creditorType = preIntBill.getString("creditortype");
                    String dataSource = preIntBill.getString("datasource");
                    String mainOrgFeild = CfmBillCommonHelper.getFundOrgFieldName((String)dataSource, (boolean)true, (String)creditorType);
                    if (EmptyUtil.isEmpty((DynamicObject)preIntBill.getDynamicObject(mainOrgFeild))) {
                        this.getView().showTipNotification(CfmFormResourceEnum.PreInterestBillList_1.loadKDString(preIntBill.getString("billno")));
                        args.setCancel(true);
                        break block4;
                    }
                    long orgId = preIntBill.getDynamicObject(mainOrgFeild).getLong("id");
                    boolean isRedWriteOffParam = IntBillWriteOffHelper.isRedWriteOffParam((long)orgId);
                    boolean isDeposit = BatchIntBillHelper.isDepostPreInt((String)preIntBillFormId);
                    if (isRedWriteOffParam || isDeposit) continue;
                    this.getView().showTipNotification(CfmFormResourceEnum.PreInterestBillList_0.loadKDString());
                    args.setCancel(true);
                    break block4;
                }
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        OperationResult operationResult = args.getOperationResult();
        switch (operateKey) {
            case "redwriteoff": 
            case "unredwriteoff": 
            case "uncorrect": {
                if (operationResult == null || !operationResult.isSuccess()) break;
                this.getView().invokeOperation("refresh");
                break;
            }
            case "precorrect": {
                if (operationResult == null || !operationResult.isSuccess()) break;
                this.showCorrectConfirm(operationResult.getSuccessPkIds());
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        if (StringUtils.equals((CharSequence)"reversal_action", (CharSequence)event.getActionId()) && EmptyUtil.isNoEmpty((Object)event.getReturnData())) {
            Map returnData = (Map)event.getReturnData();
            String confirmType = (String)returnData.get("confirmtype");
            Map confirmInfo = (Map)returnData.get("confirminfo");
            Object[] preIntBillIds = confirmInfo.keySet().toArray();
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("param_preintbillids", JSON.toJSONString((Object)confirmInfo));
            operateOption.setVariableValue("confirmtype", confirmType);
            String entityId = ((BillList)this.getControl("billlistap")).getEntityId();
            TmcOperateServiceHelper.execOperate((String)"correct", (String)entityId, (Object[])preIntBillIds, (OperateOption)operateOption);
            this.getView().invokeOperation("refresh");
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"PreInterestBillList_1", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
        }
    }

    private void addCreditorTypeFilter(SetFilterEvent e) {
        String billFormId;
        BillList billList = (BillList)this.getControl("billlistap");
        switch (billFormId = billList.getBillFormId()) {
            case "cfm_preinterestbill_e": {
                QFilter filter = new QFilter("datasource", "=", (Object)DataSourceEnum.INVEST.getValue()).and(new QFilter("debtortype", "=", (Object)CreditorTypeEnum.INNERUNIT.getValue())).and(new QFilter("confirmstatus", "=", (Object)ConfirmStatusEnum.YETCONFIRM.getValue()));
                QFilter filter2 = new QFilter("datasource", "!=", (Object)DataSourceEnum.INVEST.getValue());
                filter.or(filter2);
                e.getQFilters().add(filter);
                break;
            }
            case "cim_depositpreint": {
                e.getQFilters().add(new QFilter("datasource", "=", (Object)DataSourceEnum.CIM.getValue()));
                if (CfmBillCommonHelper.isRelateAppSet((String)TmcAppEnum.CIM.getValue())) break;
                e.getQFilters().add(new QFilter("clientorg.finorgtype.type", "!=", (Object)"1"));
                break;
            }
            case "ifm_depositpreint": {
                e.getQFilters().add(new QFilter("datasource", "=", (Object)DataSourceEnum.CIM.getValue()));
                e.getQFilters().add(new QFilter("clientorg.enable", "=", (Object)true));
                e.getQFilters().add(new QFilter("clientorg.finorgtype.type", "=", (Object)"1"));
                break;
            }
            case "cim_preinterestbill": {
                QFilter filter = new QFilter("datasource", "!=", (Object)DataSourceEnum.INVEST.getValue()).and("creditortype", "=", (Object)CreditorTypeEnum.INNERUNIT.getValue()).and(new QFilter("confirmstatus", "=", (Object)ConfirmStatusEnum.YETCONFIRM.getValue()));
                QFilter filter2 = new QFilter("datasource", "=", (Object)DataSourceEnum.INVEST.getValue());
                filter.or(filter2);
                e.getQFilters().add(filter);
                break;
            }
            case "cfm_preinterestbill_b": {
                if (CfmBillCommonHelper.isRelateAppSet((String)TmcAppEnum.CFM.getValue())) break;
                e.getQFilters().add(new QFilter("creditortype", "!=", (Object)CreditorTypeEnum.SETTLECENTER.getValue()));
                break;
            }
        }
    }

    protected List<QFilter> addCustomFilterForFilterCol(String fieldName) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(1);
        if (StringUtils.equals((CharSequence)"clientorg.name", (CharSequence)fieldName)) {
            QFilter intPreFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
            String entityName = this.getDataEntityName();
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)entityName, (String)"clientorg", (QFilter[])intPreFilter.toArray(), null);
            Iterator iterator = dataSet.distinct().iterator();
            HashSet<Object> pkIdSet = new HashSet<Object>();
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                pkIdSet.add(row.get("clientorg"));
            }
            filters.add(new QFilter("id", "in", pkIdSet));
        }
        return filters;
    }

    private Set<Long> getPreIntIds() {
        DynamicObjectCollection intbillentries = QueryServiceHelper.query((String)"cfm_intbill_batch_pre", (String)"entry.intbillid", (QFilter[])new QFilter[]{new QFilter("billstatus", "in", (Object)new String[]{"A", "B"}), new QFilter("entry.intbillid", "!=", (Object)0L)});
        DynamicObjectCollection intbills = QueryServiceHelper.query((String)"cfm_preinterestbill", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)intbillentries.stream().map(o -> o.get("entry.intbillid")).toArray()), new QFilter("billstatus", "=", (Object)"B")});
        HashSet<Long> intIds = new HashSet<Long>();
        intbills.stream().forEach(item -> intIds.add(item.getLong("id")));
        intIds.remove(0L);
        return intIds;
    }

    private void showCorrectConfirm(List<Object> preIntBillIds) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("cfm_correct_confirm");
        showParameter.setStatus(OperationStatus.EDIT);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("param_preintbillids", preIntBillIds);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "reversal_action"));
        this.getView().showForm(showParameter);
    }
}

