/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.productfactory;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.servicehelper.basedata.BaseDataRefrenceHelper;
import kd.tmc.cfm.common.enums.BizTypeEnum;
import kd.tmc.cfm.common.enums.CalcIntWayEnum;
import kd.tmc.cfm.common.enums.LookBackTypeEnum;
import kd.tmc.cfm.common.enums.PostPositionTypeEnum;
import kd.tmc.cfm.common.enums.RateAdjustCycleTypeEnum;
import kd.tmc.cfm.common.enums.RateAdjustStyleEnum;
import kd.tmc.fbp.common.enums.CreditorTypeEnum;
import kd.tmc.fbp.common.enums.IntCalMethodEnum;
import kd.tmc.fbp.common.enums.InterestTypeEnum;
import kd.tmc.fbp.common.enums.RepaymentWayEnum;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.common.helper.IntcalMethodChgHelper;

public class ProductFactoryEdit
extends AbstractBasePlugIn {
    public void propertyChanged(PropertyChangedArgs args) {
        String propName;
        super.propertyChanged(args);
        switch (propName = args.getProperty().getName()) {
            case "iscandefer": {
                this.isCanDeferChgEvt();
                break;
            }
            case "isgraceperiod": {
                this.isGracePeriodChgEvt();
                break;
            }
            case "currencyrule": {
                this.currencyRuleChgEvt();
                break;
            }
            case "biztype": {
                this.biztypeChgEvt();
                this.biztypeDefault();
                this.changeFinproductByBizType();
                this.setRepaymentMode();
                this.initIntCalBox();
                break;
            }
            case "ratetype": {
                this.rateTypeChgEvt(false);
                this.intcalMethodChgEvt();
                break;
            }
            case "islkbizprop": {
                this.isLkBizpropChaEvt();
                break;
            }
            case "issofrrate": {
                this.setRepaymentMode();
                break;
            }
            case "calcintway": {
                this.calcIntWayChgEvt();
                break;
            }
            case "iscallcompint": {
                this.initIntCalBox();
                break;
            }
            case "rateadjustmethod": {
                this.initRateResetCycle();
                break;
            }
            case "postpositiontype": {
                this.initLookbacktype();
                this.initRateresetdays(false);
                break;
            }
            case "intcalmethod": {
                this.intcalMethodChgEvt();
                break;
            }
        }
        TmcViewInputHelper.hideErrTip((IFormView)this.getView(), (String)propName);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initDataStutus();
        Long pkValue = (Long)this.getModel().getDataEntity().getPkValue();
        boolean isRef = BaseDataRefrenceHelper.isRefrenced((String)this.getModel().getDataEntityType().getName(), (Object)this.getModel().getDataEntity().getPkValue());
        if (!isRef || pkValue == 0L) {
            this.intcalMethodChgEvt();
            this.initIntCalBox();
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.biztypeChgEvt();
        this.rateTypeChgEvt(true);
        this.biztypeDefault();
    }

    public void afterLoadData(EventObject e) {
        this.checkBaseDateRefrence();
    }

    protected void checkBaseDateRefrence() {
        boolean isRef = BaseDataRefrenceHelper.isRefrenced((String)"cfm_productfactory", (Object)this.getModel().getDataEntity().getPkValue());
        if (isRef) {
            this.getView().getFormShowParameter().setStatus(OperationStatus.VIEW);
        }
    }

    protected void initDataStutus() {
        this.isCanDeferChgEvt();
        this.isGracePeriodChgEvt();
        this.currencyRuleChgEvt();
        this.creditorTypeByBizType();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        if ("save".equals(op.getOperateKey())) {
            boolean isCanDefer = (Boolean)this.getModel().getValue("iscandefer");
            if (isCanDefer && !TmcViewInputHelper.checkMustInput((IFormView)this.getView(), (IDataModel)this.getModel(), (boolean)true, (String[])new String[]{"defermaxcount"})) {
                args.setCancel(true);
            }
            this.getModel().setValue("status", (Object)"C");
        }
    }

    private void batchSetValue(Object value, String ... props) {
        IDataModel model = this.getModel();
        for (String prop : props) {
            model.setValue(prop, value);
        }
    }

    private void isLkBizpropChaEvt() {
        boolean isLkBizprop = (Boolean)this.getModel().getValue("islkbizprop");
        if (!isLkBizprop) {
            this.batchSetValue(Boolean.FALSE, "isslinfo", "istradefininfo", "isscminfo", "isprojectinfo");
        }
        this.getView().setEnable(Boolean.valueOf(isLkBizprop), new String[]{"isslinfo", "istradefininfo", "isscminfo", "isprojectinfo"});
    }

    protected void isCanDeferChgEvt() {
        boolean isCanDefer = (Boolean)this.getModel().getValue("iscandefer");
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)isCanDefer, (String[])new String[]{"defermaxcount"});
        if (!isCanDefer) {
            this.getModel().setValue("iscanoverterm", (Object)false);
        }
        this.getView().setEnable(Boolean.valueOf(isCanDefer), new String[]{"iscanoverterm"});
    }

    protected void isGracePeriodChgEvt() {
        boolean isGracePeriod = (Boolean)this.getModel().getValue("isgraceperiod");
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)isGracePeriod, (String[])new String[]{"capitalgracedays", "intgracedays", "gracecallintmode", "graceadjustrule"});
    }

    protected void currencyRuleChgEvt() {
        String rule = (String)this.getModel().getValue("currencyrule");
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)"assigncurrency".equals(rule), (String[])new String[]{"currency"});
    }

    protected void biztypeChgEvt() {
        this.initIntCalBox();
    }

    protected void rateTypeChgEvt(boolean isInitData) {
        this.initRateAdjustMethod(isInitData);
    }

    protected void biztypeDefault() {
        this.creditorTypeByBizType();
        IDataModel model = this.getModel();
        String bizType = (String)model.getValue("biztype");
        BizTypeEnum bizTypeEnum = BizTypeEnum.getByValue((String)bizType);
        if (bizTypeEnum != null) {
            switch (bizTypeEnum) {
                case LOAN: 
                case SL: {
                    model.setValue("creditortype", (Object)"bank");
                    break;
                }
                case ENTRUST: 
                case EC: {
                    model.setValue("creditortype", (Object)"innerunit");
                    break;
                }
                case BOND: {
                    model.setValue("creditortype", (Object)"other");
                    break;
                }
            }
        }
        if (!BizTypeEnum.isLoan((String)bizType)) {
            this.batchSetValue(Boolean.FALSE, "isloancommit", "iscycleloan");
        }
    }

    private void calcIntWayChgEvt() {
        this.initIntCalBox();
        this.initRateAdjustMethod(false);
        this.initRateResetCycle();
        this.initPostpositiontype();
        this.initLookbacktype();
    }

    private void initPostpositiontype() {
        String calcIntWay = (String)this.getModel().getValue("calcintway");
        boolean isPostposition = CalcIntWayEnum.isPostposition((String)calcIntWay);
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)isPostposition, (String[])new String[]{"postpositiontype"});
        this.getView().setVisible(Boolean.valueOf(isPostposition), new String[]{"postpositiontype"});
        this.getModel().setValue("postpositiontype", (Object)(isPostposition ? PostPositionTypeEnum.LOOKBACK.getValue() : null));
    }

    private void initLookbacktype() {
        String postpositiontype = (String)this.getModel().getValue("postpositiontype");
        boolean isLookback = PostPositionTypeEnum.isLookback((String)postpositiontype);
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)isLookback, (String[])new String[]{"lookbacktype"});
        this.getView().setVisible(Boolean.valueOf(isLookback), new String[]{"lookbacktype"});
        this.getModel().setValue("lookbacktype", (Object)(isLookback ? LookBackTypeEnum.NOOBSERVE.getValue() : null));
    }

    private void initRateresetdays(boolean isInitData) {
        String postpositiontype = (String)this.getModel().getValue("postpositiontype");
        boolean isLookback = PostPositionTypeEnum.isLookback((String)postpositiontype);
        String rateType = (String)this.getModel().getValue("ratetype");
        boolean isFloat = InterestTypeEnum.FLOAT.getValue().equals(rateType);
        if (!isInitData) {
            this.getModel().setValue("rateresetdays", (Object)(isFloat && isLookback ? 5 : 0));
        }
        this.getView().setVisible(Boolean.valueOf(!PostPositionTypeEnum.isStandard((String)postpositiontype)), new String[]{"rateresetdays"});
    }

    private void initRateAdjustMethod(boolean isInitData) {
        boolean isCanSetCycle;
        String calcIntWay = (String)this.getModel().getValue("calcintway");
        String rateType = (String)this.getModel().getValue("ratetype");
        boolean isFloat = InterestTypeEnum.FLOAT.getValue().equals(rateType);
        boolean isPostposition = CalcIntWayEnum.isPostposition((String)calcIntWay);
        this.getView().setEnable(Boolean.valueOf(isFloat && !isPostposition), new String[]{"rateadjustmethod"});
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)isFloat, (String[])new String[]{"rateadjustmethod"});
        boolean bl = isCanSetCycle = isPostposition && isFloat;
        if (!isInitData) {
            this.getModel().setValue("rateadjustmethod", (Object)(isCanSetCycle ? RateAdjustStyleEnum.CYCLE.getValue() : null));
        }
        this.initRateresetdays(isInitData);
    }

    private void initRateResetCycle() {
        String calcIntWay = (String)this.getModel().getValue("calcintway");
        boolean isPostposition = CalcIntWayEnum.isPostposition((String)calcIntWay);
        String rateadjustmethod = (String)this.getModel().getValue("rateadjustmethod");
        boolean isCycle = RateAdjustStyleEnum.isCycle((String)rateadjustmethod);
        boolean isMustInput = isPostposition && isCycle;
        this.getView().setVisible(Boolean.valueOf(isMustInput), new String[]{"rateresetcyclelap"});
        if (isMustInput) {
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)isMustInput, (String[])new String[]{"rateresetcycle"});
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)isMustInput, (String[])new String[]{"rateresetcycleday"});
        }
        this.getModel().setValue("rateresetcycle", (Object)(isMustInput ? RateAdjustCycleTypeEnum.D.getValue() : null));
        this.getModel().setValue("rateresetcycleday", (Object)(isMustInput ? Integer.valueOf(1) : null));
    }

    protected void creditorTypeByBizType() {
        String bizType = (String)this.getModel().getValue("biztype");
        this.createCreditorType(BizTypeEnum.isLoan((String)bizType) || BizTypeEnum.isSL((String)bizType), BizTypeEnum.isEC((String)bizType) || BizTypeEnum.isEntrust((String)bizType), BizTypeEnum.isBond((String)bizType));
    }

    private ComboItem createComboItem(String value, String caption) {
        ComboItem comboItem = new ComboItem();
        comboItem.setValue(value);
        comboItem.setCaption(new LocaleString(caption));
        return comboItem;
    }

    private void createCreditorType(boolean isLoan, boolean isEc, boolean isBond) {
        ArrayList<String> comboItemValues = new ArrayList<String>();
        if (isLoan) {
            comboItemValues.addAll(Arrays.asList(CreditorTypeEnum.BANK.getValue(), CreditorTypeEnum.FINORG.getValue()));
        }
        if (isEc) {
            comboItemValues.addAll(Arrays.asList(CreditorTypeEnum.INNERUNIT.getValue(), CreditorTypeEnum.CUSTOM.getValue(), CreditorTypeEnum.OTHER.getValue()));
        }
        if (isBond) {
            comboItemValues.add(CreditorTypeEnum.OTHER.getValue());
        }
        TmcViewInputHelper.resetComboItems(comboItemValues, (String)"creditortype", (IFormView)this.getView());
    }

    private void changeFinproductByBizType() {
        String bizType = (String)this.getModel().getValue("biztype");
        DynamicObject finproduct = (DynamicObject)this.getModel().getValue("finproduct");
        if (EmptyUtil.isNoEmpty((DynamicObject)finproduct) && BizTypeEnum.isEntrust((String)bizType) != finproduct.getBoolean("iswtdk")) {
            this.getModel().setValue("finproduct", null);
        }
    }

    private void setRepaymentMode() {
        Object bizType = this.getModel().getValue("biztype");
        boolean isSofrRate = (Boolean)this.getModel().getValue("issofrrate");
        List<ComboItem> repaymentModes = this.getRepaymentMode(BizTypeEnum.BOND.getValue().equals(bizType), isSofrRate);
        ComboEdit repay = (ComboEdit)this.getControl("repaymentmode");
        repay.setComboItems(repaymentModes);
    }

    private ComboItem createComboItem(RepaymentWayEnum repaymentWay) {
        return this.createComboItem(repaymentWay.getValue(), repaymentWay.getName());
    }

    private List<ComboItem> getRepaymentMode(Boolean isBond, boolean isSofr) {
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(10);
        comboItems.add(this.createComboItem(RepaymentWayEnum.bqhblsbq));
        comboItems.add(this.createComboItem(RepaymentWayEnum.dqhblsbq));
        comboItems.add(this.createComboItem(RepaymentWayEnum.bqhbdqhx));
        comboItems.add(this.createComboItem(RepaymentWayEnum.dqhbdqhx));
        if (!isBond.booleanValue() && !isSofr) {
            comboItems.add(this.createComboItem(RepaymentWayEnum.debx));
            comboItems.add(this.createComboItem(RepaymentWayEnum.debj));
            comboItems.add(this.createComboItem(RepaymentWayEnum.dbdx));
        }
        comboItems.add(this.createComboItem(RepaymentWayEnum.zdyhk));
        return comboItems;
    }

    private ComboItem createComboItem(IntCalMethodEnum intCalMethod) {
        return this.createComboItem(intCalMethod.getValue(), intCalMethod.getName());
    }

    private void initIntCalBox() {
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(10);
        String bizType = (String)this.getModel().getValue("biztype");
        if (!BizTypeEnum.isBond((String)bizType)) {
            Boolean isCompInt = (Boolean)this.getModel().getValue("iscallcompint");
            String intCalMethod = (String)this.getModel().getValue("intcalmethod");
            if (isCompInt.booleanValue()) {
                comboItems.add(this.createComboItem(IntCalMethodEnum.compcallint));
                intCalMethod = IntCalMethodEnum.compcallint.getValue();
            } else {
                comboItems.add(this.createComboItem(IntCalMethodEnum.onecallint));
                comboItems.add(this.createComboItem(IntCalMethodEnum.periodcallint));
                comboItems.add(this.createComboItem(IntCalMethodEnum.totalcallint));
                if (EmptyUtil.isEmpty((String)intCalMethod) || IntCalMethodEnum.isCompcallint((String)intCalMethod)) {
                    intCalMethod = IntCalMethodEnum.totalcallint.getValue();
                }
            }
            ((ComboEdit)this.getControl("intcalmethod")).setComboItems(comboItems);
            this.getModel().setValue("intcalmethod", (Object)intCalMethod);
        }
    }

    private void intcalMethodChgEvt() {
        String intcalMethod = (String)this.getModel().getValue("intcalmethod");
        String status = (String)this.getModel().getValue("status");
        ComboEdit basis = (ComboEdit)this.getControl("basis");
        if (basis == null) {
            return;
        }
        List comboItems = IntcalMethodChgHelper.getBasisComboItem((String)intcalMethod, (String)status);
        basis.setComboItems(comboItems);
        if (EmptyUtil.isNoEmpty((Object)comboItems)) {
            this.getModel().setValue("basis", (Object)((ComboItem)comboItems.get(0)).getValue());
        }
    }
}

