/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.rateadjust;

import com.alibaba.fastjson.JSONArray;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cfm.common.enums.BatchRateAdjustViewInfoEnum;
import kd.tmc.cfm.common.enums.BondTypeEnum;
import kd.tmc.cfm.common.enums.DataSourceEnum;
import kd.tmc.cfm.common.enums.LoanContractStatusEnum;
import kd.tmc.cfm.common.enums.RateAdjustStyleEnum;
import kd.tmc.cfm.common.enums.RateSignEnum;
import kd.tmc.cfm.common.resource.AbstractBizResource;
import kd.tmc.cfm.common.resource.BizResourceFactory;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.CreditorTypeEnum;
import kd.tmc.fbp.common.enums.InterestTypeEnum;
import kd.tmc.fbp.common.enums.RepaymentWayEnum;
import kd.tmc.fbp.common.enums.SettleIntModeEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class RateAdjustBatchNavEdit
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String INVEST = "invest";

    public void registerListener(EventObject e) {
        BasedataEdit company = (BasedataEdit)this.getControl("company");
        company.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit referenceRate = (BasedataEdit)this.getControl("referencerate");
        referenceRate.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners(new String[]{"contractbill"});
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String fieldName;
        switch (fieldName = evt.getProperty().getName()) {
            case "company": {
                this.setOrgFilter(evt);
                break;
            }
            case "referencerate": {
                this.setReferenceRateFilter(evt);
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long contractId = (Long)this.getView().getFormShowParameter().getCustomParam("contractId");
        String dataSource = (String)this.getView().getFormShowParameter().getCustomParam("dataSource");
        ArrayList<Long> billIds = new ArrayList<Long>(1);
        if (EmptyUtil.isNoEmpty((Long)contractId)) {
            billIds.add(contractId);
            if (!"bond".equals(dataSource)) {
                DynamicObject contractBill = this.getContractBill(contractId);
                this.getModel().setValue("company", this.getCompany(contractBill, dataSource));
                this.getModel().setValue("currency", (Object)contractBill.getDynamicObject("currency"));
                this.getModel().setValue("interesttype", (Object)contractBill.getString("interesttype"));
                this.getModel().setValue("contractbill", (Object)contractBill.getString("number"));
                this.getModel().setValue("settleintmode", (Object)contractBill.getString("settleintmode"));
                this.getModel().setValue("referencerate", (Object)contractBill.getDynamicObject("referencerate"));
                this.rebuildComboItem(contractBill);
            } else {
                DynamicObject contractBill = TmcDataServiceHelper.loadSingle((Object)contractId, (String)"cfm_loancontract_bo_f7", (String)"id,number,org,bondtype,currency,settleintmode,referencerate");
                String bondType = contractBill.getString("bondtype");
                this.getModel().setValue("currency", (Object)contractBill.getDynamicObject("currency"));
                this.getModel().setValue("company", this.getCompany(contractBill, dataSource));
                this.getModel().setValue("interesttype", (Object)("floatratebond".equals(bondType) ? InterestTypeEnum.FLOAT.getValue() : InterestTypeEnum.FIXED.getValue()));
                this.getModel().setValue("contractbill", (Object)contractBill.getString("number"));
                this.getModel().setValue("settleintmode", (Object)contractBill.getString("settleintmode"));
                this.getModel().setValue("referencerate", (Object)contractBill.getDynamicObject("referencerate"));
                this.getPageCache().put("contractbill", SerializationUtils.toJsonString((Object)(contractBill.getLong("id") + ";")));
            }
            this.getPageCache().put("contractbill", SerializationUtils.toJsonString(billIds));
        }
    }

    private void rebuildComboItem(DynamicObject contractBill) {
        if ("contractBill".equals(this.getView().getFormShowParameter().getCustomParam("dataSrc"))) {
            if (InterestTypeEnum.isFixed((String)contractBill.getString("interesttype"))) {
                this.setComboItem(InterestTypeEnum.FIXED);
            } else if (InterestTypeEnum.isAgree((String)contractBill.getString("interesttype"))) {
                this.setComboItem(InterestTypeEnum.AGREE);
            }
        }
    }

    private DynamicObject getContractBill(Long contractId) {
        return TmcDataServiceHelper.loadSingle((Object)contractId, (String)"cfm_loancontractbill_f7", (String)"id,number,org,creditorg,interesttype,currency,repaymentway,startinterestrate,settleintmode,referencerate,rateadjuststyle");
    }

    private Object getCompany(DynamicObject contractBill, String dataSource) {
        if (INVEST.equals(dataSource)) {
            return this.getDynamicObjectCollection(contractBill.getDynamicObject("creditorg"));
        }
        return this.getDynamicObjectCollection(contractBill.getDynamicObject("org"));
    }

    private void setComboItem(InterestTypeEnum type) {
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(16);
        comboItems.add(RateAdjustBatchNavEdit.createComboItem(type));
        comboItems.add(RateAdjustBatchNavEdit.createComboItem(InterestTypeEnum.FLOAT));
        ComboEdit interestTypeCom = (ComboEdit)this.getControl("interesttype");
        interestTypeCom.setComboItems(comboItems);
    }

    public static ComboItem createComboItem(InterestTypeEnum interestType) {
        ComboItem comboItem = new ComboItem();
        comboItem.setValue(interestType.getValue());
        comboItem.setCaption(new LocaleString(InterestTypeEnum.getName((String)interestType.getValue())));
        return comboItem;
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setInterestTypeMustInput();
        this.initEnableAndVisible();
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"rateadjuststyle", "rateadjustcycletype", "rateadjustcycle"});
    }

    private void initEnableAndVisible() {
        String dataSrc = (String)this.getView().getFormShowParameter().getCustomParam("dataSrc");
        if ("contractBill".equals(dataSrc)) {
            String interestType = (String)this.getModel().getValue("interesttype");
            this.setLockProp(interestType);
            this.settleintModeVisible(interestType);
            this.setRateAdjustDateVisible(interestType);
        } else {
            this.settleintModeVisible();
        }
    }

    public void click(EventObject evt) {
        TextEdit text;
        super.click(evt);
        if (evt.getSource() instanceof TextEdit && "contractbill".equals((text = (TextEdit)evt.getSource()).getKey())) {
            this.showContractBillF7(text.getKey());
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        ListSelectedRowCollection selectedRow = (ListSelectedRowCollection)evt.getReturnData();
        if (EmptyUtil.isEmpty((Collection)selectedRow)) {
            return;
        }
        String actionId = evt.getActionId();
        List billIds = selectedRow.stream().map(row -> row.getPrimaryKeyValue()).collect(Collectors.toList());
        if ("contractbill".equals(actionId)) {
            List billnos = selectedRow.stream().map(row -> row.getBillNo()).collect(Collectors.toList());
            this.getModel().setValue(actionId, (Object)String.join((CharSequence)";", billnos));
            this.getPageCache().put(actionId, SerializationUtils.toJsonString(billIds));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (StringUtils.equals((CharSequence)"confirm", (CharSequence)operateKey)) {
            Date adjustEffectDate = (Date)this.getModel().getValue("intdate");
            if (!this.checkMustInput() || this.validateDate(adjustEffectDate)) {
                args.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evtArgs) {
        if (StringUtils.equals((CharSequence)"confirm", (CharSequence)evtArgs.getOperateKey()) && evtArgs.getOperationResult().isSuccess()) {
            if (this.existsRateAdjust()) {
                return;
            }
            String interestType = (String)this.getModel().getValue("interesttype");
            BigDecimal interestRate = (BigDecimal)this.getModel().getValue("interestrate");
            if ((InterestTypeEnum.isFixed((String)interestType) || InterestTypeEnum.isAgree((String)interestType)) && BigDecimal.ZERO.compareTo(interestRate) == 0) {
                this.showConfirmTip();
                return;
            }
            Map<String, Object> valMap = this.getNavFilterMap();
            this.getView().returnDataToParent(valMap);
            this.getView().close();
        }
    }

    private boolean existsRateAdjust() {
        String contractBill = (String)this.getModel().getValue("contractbill");
        QFilter contractFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        contractFilter.and(new QFilter("billno", "in", (Object)contractBill.split(";")));
        DynamicObjectCollection contractBills = QueryServiceHelper.query((String)"cfm_loancontractbill", (String)"id, billno", (QFilter[])new QFilter[]{contractFilter});
        if (contractBills.size() == 0) {
            return false;
        }
        List ids = contractBills.stream().map(r -> r.getLong("id")).collect(Collectors.toList());
        QFilter baseFilter = new QFilter("loancontractbill", "in", ids);
        QFilter statusFilter = new QFilter("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getValue());
        if (QueryServiceHelper.exists((String)"cfm_rateadjustbill", (QFilter[])new QFilter[]{baseFilter, statusFilter})) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u5408\u540c\u6709\u672a\u5ba1\u6838\u7684\u5229\u7387\u8c03\u6574\u5355\uff0c\u8bf7\u5904\u7406\u3002", (String)"RateAdjustBatchNavEdit_6", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
            return true;
        }
        boolean existsOnWayBill = QueryServiceHelper.exists((String)"cfm_loanbill", (QFilter[])new QFilter[]{baseFilter, statusFilter});
        if (existsOnWayBill) {
            String dataSource = (String)this.getView().getFormShowParameter().getCustomParam("dataSource");
            AbstractBizResource biz2Resource = new BizResourceFactory().getBizResource(dataSource);
            this.getView().showTipNotification(biz2Resource.getCbInterestUnAdjustOp());
            return true;
        }
        return false;
    }

    private void showConfirmTip() {
        this.getView().showConfirm(ResManager.loadKDString((String)"\u8c03\u6574\u540e\u5229\u7387\uff08%\uff09\u4e3a0\uff0c\u786e\u5b9a\u7ee7\u7eed\u64cd\u4f5c\u5417\uff1f", (String)"RateAdjustBatchNavEdit_3", (String)"tmc-cfm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("CONFIRM_RATEADJUST_CALLBACK", (IFormPlugin)this));
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String id = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult res = messageBoxClosedEvent.getResult();
        if (StringUtils.equals((CharSequence)id, (CharSequence)"CONFIRM_RATEADJUST_CALLBACK") && MessageBoxResult.Yes.equals((Object)res)) {
            Map<String, Object> valMap = this.getNavFilterMap();
            this.getView().returnDataToParent(valMap);
            this.getView().close();
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String fieldName;
        super.propertyChanged(args);
        switch (fieldName = args.getProperty().getName()) {
            case "interesttype": {
                this.interestTypeChgEvt();
                this.foreColor(fieldName);
                break;
            }
            case "rateadjuststyle": {
                this.setMustInput();
                this.foreColor(fieldName);
                break;
            }
            case "intdate": {
                this.validateDate((Date)args.getChangeSet()[0].getNewValue());
                this.foreColor(fieldName);
                break;
            }
            case "settleintmode": {
                this.setIntPlanVisible((String)args.getChangeSet()[0].getNewValue());
                this.foreColor(fieldName);
                break;
            }
            case "referencerate": 
            case "rateadjustcycletype": 
            case "rateadjustcycle": 
            case "ratesign": 
            case "ratefloatpoint": 
            case "rateadjustdate": 
            case "interestrate": {
                this.foreColor(fieldName);
            }
        }
    }

    private void foreColor(String key) {
        HashMap<String, String> fieldMap = new HashMap<String, String>(2);
        fieldMap.put("fc", "#ED9121");
        this.getView().updateControlMetadata(key, fieldMap);
    }

    private void setIntPlanVisible(String settleIntMode) {
        String interestType = (String)this.getModel().getValue("interesttype");
        boolean isVisible = (InterestTypeEnum.isFixed((String)interestType) || InterestTypeEnum.isAgree((String)interestType)) && SettleIntModeEnum.isGdpljx((String)settleIntMode);
        this.getView().setVisible(Boolean.valueOf(isVisible), new String[]{"interestsettledplan"});
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)isVisible, (String[])new String[]{"interestsettledplan"});
        if (!SettleIntModeEnum.isGdpljx((String)settleIntMode)) {
            this.getModel().setValue("interestsettledplan", null);
        }
    }

    private void setMustInput() {
        String rateAdjustStyle = (String)this.getModel().getValue("rateadjuststyle");
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (this.isFloat() && RateAdjustStyleEnum.isCycle((String)rateAdjustStyle) ? 1 : 0) != 0, (String[])new String[]{"rateadjustdate"});
    }

    private void interestTypeChgEvt() {
        if (!"contractBill".equals(this.getView().getFormShowParameter().getCustomParam("dataSrc"))) {
            this.getModel().setValue("contractbill", null);
        }
        this.getModel().setValue("interestrate", null);
        this.getModel().setValue("referencerate", null);
        this.getModel().setValue("ratefloatpoint", null);
        this.getModel().setValue("ratesign", null);
        this.setInterestTypeMustInput();
        this.setVisible();
        Long contractId = (Long)this.getView().getFormShowParameter().getCustomParam("contractId");
        if (EmptyUtil.isNoEmpty((Long)contractId)) {
            String interestType = (String)this.getModel().getValue("interesttype");
            this.settleintModeVisible(interestType);
        }
    }

    private void setVisible() {
        Long contractId = (Long)this.getView().getFormShowParameter().getCustomParam("contractId");
        if (EmptyUtil.isEmpty((Long)contractId)) {
            return;
        }
        DynamicObject contractBill = this.getContractBill(contractId);
        String interestType = contractBill.getString("interesttype");
        if ((InterestTypeEnum.isFixed((String)interestType) || InterestTypeEnum.isAgree((String)interestType)) && "contractBill".equals(this.getView().getFormShowParameter().getCustomParam("dataSrc"))) {
            this.getView().setVisible(Boolean.valueOf(this.isFloat()), new String[]{"rateadjustdate", "rateadjuststyle", "rateadjustcycletype", "rateadjustcycle"});
            this.getView().setVisible(Boolean.valueOf(!this.isFloat()), new String[]{"currency", "contractbill"});
            FieldEdit referenceRate = (FieldEdit)this.getView().getControl("referencerate");
            FieldEdit ratesign = (FieldEdit)this.getView().getControl("ratesign");
            referenceRate.setCaption(new LocaleString(ResManager.loadKDString((String)"\u53c2\u8003\u5229\u7387", (String)"RateAdjustBatchNavEdit_4", (String)"tmc-cfm-formplugin", (Object[])new Object[0])));
            ratesign.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5229\u7387\u6d6e\u52a8\u57fa\u70b9", (String)"RateAdjustBatchNavEdit_5", (String)"tmc-cfm-formplugin", (Object[])new Object[0])));
            this.getModel().setValue("ratesign", (Object)RateSignEnum.ADD.getValue());
            this.getModel().setValue("ratefloatpoint", (Object)BigDecimal.ZERO);
            this.setMustInput();
        }
    }

    private void showContractBillF7(String fieldName) {
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        if (this.isFloat() && EmptyUtil.isEmpty((DynamicObject)currency)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5e01\u79cd\u3002", (String)"RateAdjustBatchNavEdit_1", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
            return;
        }
        ListShowParameter parameter = ShowFormHelper.createShowListForm((String)"ifm_loancontractbill", (boolean)true, (int)0, (boolean)true);
        BatchRateAdjustViewInfoEnum batchIntViewInfo = this.getBatchIntViewInfo();
        parameter.setBillFormId(batchIntViewInfo.getContractFormId());
        parameter.getListFilterParameter().getQFilters().add(this.getContractFilter());
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, fieldName));
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void setInterestTypeMustInput() {
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (!this.isFloat() ? 1 : 0) != 0, (String[])new String[]{"interestrate"});
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)this.isFloat(), (String[])new String[]{"referencerate", "currency"});
    }

    private void setLockProp(String interestType) {
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"company", "interesttype", "currency", "contractbill"});
        String dataSource = (String)this.getView().getFormShowParameter().getCustomParam("dataSource");
        if ((InterestTypeEnum.isFixed((String)interestType) || InterestTypeEnum.isAgree((String)interestType)) && !DataSourceEnum.isBond((String)dataSource)) {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"interesttype"});
        }
    }

    private void settleintModeVisible(String interestType) {
        String dataSource = (String)this.getView().getFormShowParameter().getCustomParam("dataSource");
        Long contractId = (Long)this.getView().getFormShowParameter().getCustomParam("contractId");
        if (!DataSourceEnum.isBond((String)dataSource)) {
            DynamicObject contractBill = this.getContractBill(contractId);
            BigDecimal startInterestRate = contractBill.getBigDecimal("startinterestrate");
            String repaymentWay = contractBill.getString("repaymentway");
            boolean isVisible = (InterestTypeEnum.isFixed((String)interestType) || InterestTypeEnum.isAgree((String)interestType)) && BigDecimal.ZERO.compareTo(startInterestRate) == 0;
            this.getView().setVisible(Boolean.valueOf(isVisible && RepaymentWayEnum.isZdyhk((String)repaymentWay)), new String[]{"settleintmode"});
            String settleIntMode = (String)this.getModel().getValue("settleintmode");
            this.getView().setVisible(Boolean.valueOf(isVisible && SettleIntModeEnum.isGdpljx((String)settleIntMode)), new String[]{"interestsettledplan"});
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (isVisible && SettleIntModeEnum.isGdpljx((String)settleIntMode) ? 1 : 0) != 0, (String[])new String[]{"interestsettledplan"});
            this.getView().setVisible(Boolean.valueOf(!InterestTypeEnum.isFixed((String)interestType) && !InterestTypeEnum.isAgree((String)interestType)), new String[]{"fg_rateadjustcycle", "fieldsetpanelap"});
            this.getView().setEnable(Boolean.valueOf(RepaymentWayEnum.isZdyhk((String)repaymentWay)), new String[]{"settleintmode"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"settleintmode"});
            QFilter qFilter = new QFilter("loancontractbill", "=", (Object)contractId).and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()).and("interesttype", "!=", (Object)InterestTypeEnum.FLOAT.getValue()).and(new QFilter("startloanrate", "=", (Object)0));
            boolean exists = TmcDataServiceHelper.exists((String)"cfm_loanbill_bond", (QFilter[])qFilter.toArray());
            this.getView().setVisible(Boolean.valueOf(exists), new String[]{"interestsettledplan"});
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)exists, (String[])new String[]{"interestsettledplan"});
        }
    }

    private void setRateAdjustDateVisible(String interestType) {
        if (DataSourceEnum.isBond((String)((String)this.getView().getFormShowParameter().getCustomParam("dataSource")))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"rateadjustdate"});
        } else {
            String rateAdjustStyle = (String)this.getModel().getValue("rateadjuststyle");
            Long contractId = (Long)this.getView().getFormShowParameter().getCustomParam("contractId");
            DynamicObject contractBill = this.getContractBill(contractId);
            String intType = contractBill.getString("interesttype");
            boolean isAdjustToFloat = (InterestTypeEnum.isFixed((String)intType) || InterestTypeEnum.isAgree((String)intType)) && InterestTypeEnum.isFloat((String)interestType) && RateAdjustStyleEnum.isCycle((String)rateAdjustStyle);
            boolean isFloatCycle = InterestTypeEnum.isFloat((String)intType) && RateAdjustStyleEnum.isCycle((String)contractBill.getString("rateadjuststyle"));
            this.getView().setVisible(Boolean.valueOf(isAdjustToFloat || isFloatCycle), new String[]{"rateadjustdate"});
        }
    }

    private void settleintModeVisible() {
        this.getView().setVisible(Boolean.FALSE, new String[]{"settleintmode", "interestsettledplan", "rateadjustdate"});
    }

    private boolean checkMustInput() {
        if (this.isFloat()) {
            return TmcViewInputHelper.checkMustInput((IFormView)this.getView(), (IDataModel)this.getModel(), (boolean)true, (String[])new String[]{"intdate", "interesttype", "currency", "contractbill", "referencerate"});
        }
        return TmcViewInputHelper.checkMustInput((IFormView)this.getView(), (IDataModel)this.getModel(), (boolean)true, (String[])new String[]{"intdate", "interesttype", "contractbill"});
    }

    private boolean isFloat() {
        String interestType = (String)this.getModel().getValue("interesttype");
        return InterestTypeEnum.isFloat((String)interestType);
    }

    private QFilter getContractFilter() {
        String dataSource = (String)this.getView().getFormShowParameter().getCustomParam("dataSource");
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        QFilter qFilter = this.getOrgFilter();
        JSONArray bizType = (JSONArray)this.getView().getFormShowParameter().getCustomParam("biztype");
        if (EmptyUtil.isNoEmpty((Object)bizType)) {
            qFilter.and(new QFilter("loantype", "in", (Object)bizType));
        }
        qFilter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
        if (EmptyUtil.isNoEmpty((DynamicObject)currency)) {
            qFilter.and("currency.id", "=", currency.getPkValue());
        }
        qFilter.and(new QFilter("datasource", "in", this.getDataSource()));
        if (!DataSourceEnum.IFM.getValue().equals(dataSource)) {
            qFilter.and("creditortype", "!=", (Object)CreditorTypeEnum.SETTLECENTER.getValue());
        } else {
            qFilter.and("creditortype", "=", (Object)CreditorTypeEnum.SETTLECENTER.getValue());
        }
        String interesttype = (String)this.getModel().getValue("interesttype");
        if ("bond".equals(dataSource)) {
            qFilter.and("bondtype", "=", (Object)(InterestTypeEnum.FLOAT.getValue().equals(interesttype) ? BondTypeEnum.FLOATRATEBOND.getValue() : BondTypeEnum.FIXEDRATEBOND.getValue()));
        } else {
            qFilter.and("interesttype", "=", (Object)interesttype);
        }
        qFilter.and("contractstatus", "=", (Object)LoanContractStatusEnum.EXECUTING.getValue());
        qFilter.and(this.getLoanBillQFilter());
        return qFilter;
    }

    private List<Long> getAuthOrgIds() {
        String appId = this.getView().getFormShowParameter().getAppId();
        String parentFormId = this.getParentFormId();
        BatchRateAdjustViewInfoEnum infoEnumByFormId = BatchRateAdjustViewInfoEnum.getInfoEnumByFormId((String)parentFormId);
        List<Long> authOrgIds = new ArrayList<Long>(10);
        if (EmptyUtil.isNoEmpty((Object)infoEnumByFormId)) {
            authOrgIds = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)infoEnumByFormId.getParentEntityId(), (String)"47150e89000000ac");
        }
        return authOrgIds;
    }

    private String getMainOrgFeild() {
        String mainOrgField = "org";
        String datasource = this.getBatchIntViewInfo().getDataSource();
        if (DataSourceEnum.INVEST.getValue().equals(datasource)) {
            mainOrgField = "creditorg";
        }
        return mainOrgField;
    }

    private void setReferenceRateFilter(BeforeF7SelectEvent e) {
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        if (EmptyUtil.isEmpty((DynamicObject)currency)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5e01\u79cd\u3002", (String)"RateAdjustBatchNavEdit_1", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        QFilter qFilter = new QFilter("currency.id", "=", currency.getPkValue());
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().getQFilters().add(qFilter);
    }

    private QFilter getLoanBillQFilter() {
        Date intDate = (Date)this.getModel().getValue("intdate");
        QFilter loanFilter = new QFilter("endinstdate", "<=", (Object)intDate);
        loanFilter.or(new QFilter("endinstdate", "is null", null));
        DynamicObject[] loanBills = TmcDataServiceHelper.load((String)"cfm_loanbill", (String)"sourcebillid", (QFilter[])new QFilter[]{loanFilter});
        List sourceBillIds = Arrays.stream(loanBills).map(o -> o.getLong("sourcebillid")).collect(Collectors.toList());
        return new QFilter("id", "in", sourceBillIds);
    }

    private QFilter getOrgFilter() {
        DynamicObjectCollection companys = (DynamicObjectCollection)this.getModel().getValue("company");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)companys)) {
            Set ids = companys.stream().map(c -> c.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toSet());
            return new QFilter(this.getMainOrgFeild(), "in", ids);
        }
        List<Long> authOrgIds = this.getAuthOrgIds();
        return new QFilter(this.getMainOrgFeild(), "in", (Object)authOrgIds.toArray());
    }

    private void setOrgFilter(BeforeF7SelectEvent e) {
        List<Long> authOrgIds = this.getAuthOrgIds();
        QFilter qFilter = new QFilter("id", "in", (Object)authOrgIds.toArray());
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().getQFilters().add(qFilter);
    }

    protected Map<String, Object> getNavFilterMap() {
        HashMap<String, Object> valMap = new HashMap<String, Object>(16);
        DynamicObjectCollection company = (DynamicObjectCollection)this.getModel().getValue("company");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)company)) {
            valMap.put("company", company);
        }
        String interestType = (String)this.getModel().getValue("interesttype");
        valMap.put("interesttype", interestType);
        Date intDate = (Date)this.getModel().getValue("intdate");
        valMap.put("intdate", DateUtils.formatString((Date)intDate, (String)"yyyy-MM-dd"));
        valMap.put("contractbill", this.getPageCache().get("contractbill"));
        BigDecimal interestRate = (BigDecimal)this.getModel().getValue("interestrate");
        valMap.put("interestrate", interestRate);
        DynamicObject referenceRate = (DynamicObject)this.getModel().getValue("referencerate");
        valMap.put("referencerate", referenceRate);
        BigDecimal rateFloatPoint = (BigDecimal)this.getModel().getValue("ratefloatpoint");
        valMap.put("ratefloatpoint", rateFloatPoint);
        String rateSign = (String)this.getModel().getValue("ratesign");
        valMap.put("ratesign", rateSign);
        String rateAdjustStyle = (String)this.getModel().getValue("rateadjuststyle");
        valMap.put("rateadjuststyle", rateAdjustStyle);
        String rateAdjustCycleType = (String)this.getModel().getValue("rateadjustcycletype");
        valMap.put("rateadjustcycletype", rateAdjustCycleType);
        Integer rateAdjustCycle = (Integer)this.getModel().getValue("rateadjustcycle");
        valMap.put("rateadjustcycle", rateAdjustCycle);
        Date rateAdjustDate = (Date)this.getModel().getValue("rateadjustdate");
        valMap.put("rateadjustdate", rateAdjustDate);
        String settleIntMode = (String)this.getModel().getValue("settleintmode");
        valMap.put("settleintmode", settleIntMode);
        DynamicObject interestSettledPlan = (DynamicObject)this.getModel().getValue("interestsettledplan");
        valMap.put("interestsettledplan", interestSettledPlan);
        Long contractId = (Long)this.getView().getFormShowParameter().getCustomParam("contractId");
        if (EmptyUtil.isEmpty((Long)contractId)) {
            valMap.put("isAdjustToFloat", false);
        } else {
            String dataSource = (String)this.getView().getFormShowParameter().getCustomParam("dataSource");
            if (!DataSourceEnum.isBond((String)dataSource)) {
                DynamicObject contractBill = this.getContractBill(contractId);
                String intType = contractBill.getString("interesttype");
                valMap.put("isAdjustToFloat", (InterestTypeEnum.isFixed((String)intType) || InterestTypeEnum.isAgree((String)intType)) && InterestTypeEnum.isFloat((String)interestType));
            }
        }
        return valMap;
    }

    private List<String> getDataSource() {
        ArrayList<String> dataSources = new ArrayList<String>();
        String formId = this.getParentFormId();
        if (StringUtils.equals((CharSequence)"cim_rateadjustbill", (CharSequence)formId)) {
            dataSources.add(INVEST);
            dataSources.add("cfm");
        } else if (StringUtils.equals((CharSequence)"ifm_rateadjustbill", (CharSequence)formId)) {
            dataSources.add("ifm");
        } else if (StringUtils.equals((CharSequence)"cfm_rateadjustbill_bond", (CharSequence)formId)) {
            dataSources.add("bond");
        } else {
            dataSources.add("cfm");
        }
        return dataSources;
    }

    protected BatchRateAdjustViewInfoEnum getBatchIntViewInfo() {
        return BatchRateAdjustViewInfoEnum.getInfoEnumByFormId((String)this.getParentFormId());
    }

    protected String getParentFormId() {
        Map param = this.getView().getFormShowParameter().getCustomParams();
        return EmptyUtil.isNoEmpty(param.get("formid")) ? param.get("formid").toString() : "";
    }

    private DynamicObjectCollection getDynamicObjectCollection(DynamicObject obj) {
        DynamicObjectCollection collection = new DynamicObjectCollection();
        collection.add((Object)obj);
        return collection;
    }

    private boolean validateDate(Date adjustEffectDate) {
        String dataSource = (String)this.getView().getFormShowParameter().getCustomParam("dataSource");
        if (DataSourceEnum.isBond((String)dataSource)) {
            return false;
        }
        Long contractId = (Long)this.getView().getFormShowParameter().getCustomParam("contractId");
        if (EmptyUtil.isEmpty((Long)contractId)) {
            return false;
        }
        DynamicObject contractBill = this.getContractBill(contractId);
        String intType = contractBill.getString("interesttype");
        String interestType = (String)this.getModel().getValue("interesttype");
        if (!InterestTypeEnum.isFixed((String)intType) && !InterestTypeEnum.isAgree((String)intType) || !InterestTypeEnum.isFloat((String)interestType)) {
            return false;
        }
        QFilter qFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        qFilter.and(new QFilter("loancontractbill", "=", (Object)contractId));
        qFilter.and(new QFilter("startintdate", ">", (Object)adjustEffectDate));
        boolean exists = QueryServiceHelper.exists((String)"cfm_loanbill", (QFilter[])new QFilter[]{qFilter});
        if (exists) {
            String msg = ResManager.loadKDString((String)"\u8c03\u6574\u751f\u6548\u65e5\u4e0d\u80fd\u5c0f\u4e8e\u8d77\u606f\u65e5\u3002", (String)"RateAdjustBillEdit_2", (String)"tmc-cfm-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(msg);
            return true;
        }
        return false;
    }
}

