/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.rateadjust;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.bill.BillView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cfm.common.enums.AdjustEleEnum;
import kd.tmc.cfm.common.enums.ConfirmStatusEnum;
import kd.tmc.cfm.common.enums.DrawTypeEnum;
import kd.tmc.cfm.common.enums.LoanContractStatusEnum;
import kd.tmc.cfm.common.enums.RateAdjustStyleEnum;
import kd.tmc.cfm.common.helper.CfmRateAdjustHelper;
import kd.tmc.cfm.common.helper.RateAdjustHelper;
import kd.tmc.cfm.formplugin.rateadjust.CreateRateAdjustBill;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.CreditorTypeEnum;
import kd.tmc.fbp.common.enums.InterestTypeEnum;
import kd.tmc.fbp.common.enums.RepaymentWayEnum;
import kd.tmc.fbp.common.enums.SettleIntModeEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class RateAdjustBillEdit
extends AbstractBasePlugIn
implements BeforeF7SelectListener,
HyperLinkClickListener {
    private static Log logger = LogFactory.getLog(RateAdjustBillEdit.class);
    private static final Map<String, String> headEntryFieldMap = new HashMap<String, String>(16);
    private static final String[] drawProps;
    private static String[] beforeF7_PROPS;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entry = (EntryGrid)this.getView().getControl("entry");
        entry.addHyperClickListener((HyperLinkClickListener)this);
        for (String prop : beforeF7_PROPS) {
            BasedataEdit control = (BasedataEdit)this.getControl(prop);
            if (control == null) continue;
            control.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName;
        Object newVal = e.getChangeSet()[0].getNewValue();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        switch (propName = e.getProperty().getName()) {
            case "loancontractbill": {
                this.initLoanHeadAndEntryVal();
                break;
            }
            case "lisadjust": {
                this.setRowInfo(rowIndex, newVal);
                break;
            }
            case "adjustele": {
                this.initLoanHeadAndEntryVal();
                this.setNull();
                break;
            }
            case "afterinterestrate": 
            case "afterratesign": 
            case "afterratefloatpoint": 
            case "rateadjuststyle": {
                this.rateAdjustStyleEvt(propName, newVal);
                break;
            }
            case "settleintmode": {
                this.setTleIntModeEvt(newVal);
                break;
            }
            case "interestsettledplan": {
                this.interestSettledPlanEvt(newVal);
                break;
            }
            case "afterrefrate": {
                this.afterRefRateEvt(newVal);
                break;
            }
            case "lsettleintmode": {
                this.settleIntModeEvt(rowIndex, newVal);
                break;
            }
            case "afterlloanrate": 
            case "afterlratesign": 
            case "afterlrefrate": 
            case "afterlratefloatpoint": {
                this.setAfterAdjustRate(rowIndex);
                break;
            }
            case "ladjusteffectdate": {
                this.setAfterAdjustRate(rowIndex);
                Date adjustEffectDate = (Date)this.getModel().getValue("ladjusteffectdate", rowIndex);
                this.getModel().setValue("lrateadjustdate", (Object)adjustEffectDate, rowIndex);
                break;
            }
            case "adjusteffectdate": {
                this.setAfterAdjustRate();
                this.setRateAdjustDate((Date)newVal);
                break;
            }
            case "issofrrate": {
                this.afterRateAdjustKeyValEvt("lissofrrate", newVal);
                break;
            }
            case "afterrateadjustkey": {
                this.afterRateAdjustKeyValEvt("afterlrateadjustkey", newVal);
                break;
            }
            case "afterrateadjustval": {
                this.afterRateAdjustKeyValEvt("afterlrateadjustval", newVal);
                break;
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object contractId = formShowParameter.getCustomParam("RATEADJUSTBILLEDIT_CONTRACTID");
        if (EmptyUtil.isNoEmpty((Object)contractId)) {
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"loancontractbill", (Object)contractId);
            this.initLoanHeadAndEntryVal();
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setLocked();
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key = evt.getProperty().getName();
        ListShowParameter sp = (ListShowParameter)evt.getFormShowParameter();
        if (StringUtils.equals((CharSequence)key, (CharSequence)"loancontractbill")) {
            QFilter adjustFilter;
            Object[] rateAdjustBills;
            QFilter qFilter = new QFilter("contractstatus", "=", (Object)LoanContractStatusEnum.EXECUTING.getValue());
            qFilter.and(new QFilter("status", "=", (Object)BillStatusEnum.AUDIT.getValue()));
            String formId = ((BillView)this.getView()).getFormId();
            if (StringUtils.equals((CharSequence)"ifm_rateadjustbill", (CharSequence)formId)) {
                qFilter.and(new QFilter("creditortype", "=", (Object)CreditorTypeEnum.SETTLECENTER.getValue()));
            } else {
                Object[] bizTypes;
                String bizType = (String)this.getView().getFormShowParameter().getCustomParam("biztype");
                if (EmptyUtil.isNoEmpty((String)bizType) && EmptyUtil.isNoEmpty((Object[])(bizTypes = bizType.split(",")))) {
                    qFilter.and(new QFilter("loantype", "in", (Object)bizTypes));
                }
                qFilter.and(new QFilter("datasource", "=", (Object)this.getDataSource()));
                qFilter.and(new QFilter("creditortype", "!=", (Object)CreditorTypeEnum.SETTLECENTER.getValue()));
            }
            if (!StringUtils.equals((CharSequence)"cfm_rateadjustbill_bond", (CharSequence)formId)) {
                QFilter floatFilter = new QFilter("interesttype", "=", (Object)InterestTypeEnum.FLOAT.getValue());
                QFilter agreeFilter = new QFilter("interesttype", "=", (Object)InterestTypeEnum.AGREE.getValue());
                QFilter intFilter = floatFilter.or(agreeFilter);
                qFilter.and(intFilter);
            }
            if (EmptyUtil.isNoEmpty((Object[])(rateAdjustBills = TmcDataServiceHelper.load((String)"cfm_rateadjustbill", (String)"id,loancontractbill", (QFilter[])new QFilter[]{adjustFilter = new QFilter("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getValue())})))) {
                ArrayList<Object> contractIds = new ArrayList<Object>(10);
                for (Object Adjust : rateAdjustBills) {
                    DynamicObject loanContractBill = Adjust.getDynamicObject("loancontractbill");
                    if (!EmptyUtil.isNoEmpty((DynamicObject)loanContractBill)) continue;
                    contractIds.add(loanContractBill.getPkValue());
                }
                qFilter.and(new QFilter("id", "not in", contractIds));
            }
            this.setMainOrgQFilter(qFilter, formId);
            logger.info("\u5408\u540cF7\u7684\u8fc7\u6ee4\u6761\u4ef6\u4e3aqFilter: " + qFilter.toString());
            sp.getListFilterParameter().setFilter(qFilter);
        } else if (StringUtils.equals((CharSequence)"afterrefrate", (CharSequence)key) || StringUtils.equals((CharSequence)"afterlrefrate", (CharSequence)key)) {
            Optional.ofNullable((DynamicObject)this.getModel().getValue("currency")).map(r -> r.getLong("id")).ifPresent(id -> ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter().getQFilters().add(new QFilter("currency", "=", id)));
        }
    }

    void setMainOrgQFilter(QFilter qFilter, String formId) {
        String appId = this.getView().getFormShowParameter().getAppId();
        List orgIdCollection = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)this.getModel().getDataEntityType().getName(), (String)"47150e89000000ac");
        String mainOrgField = "org";
        if (formId.startsWith("cim_")) {
            mainOrgField = "creditorg";
        }
        qFilter.and(mainOrgField, "in", (Object)orgIdCollection.toArray());
    }

    private String getDataSource() {
        String dataSource = "cfm";
        String formId = ((BillView)this.getView()).getFormId();
        if (StringUtils.equals((CharSequence)"cim_rateadjustbill", (CharSequence)formId)) {
            dataSource = "invest";
        } else if (StringUtils.equals((CharSequence)"ifm_rateadjustbill", (CharSequence)formId)) {
            dataSource = "ifm";
        } else if (StringUtils.equals((CharSequence)"cfm_rateadjustbill_bond", (CharSequence)formId)) {
            dataSource = "bond";
        }
        return dataSource;
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        int rowIndex = evt.getRowIndex();
        String key = evt.getFieldName();
        if (rowIndex > -1 && StringUtils.equals((CharSequence)key, (CharSequence)"ldrawbill")) {
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("entry", rowIndex);
            DynamicObject ldrawBill = entryRowEntity.getDynamicObject("ldrawbill");
            if (EmptyUtil.isEmpty((DynamicObject)ldrawBill)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6240\u67e5\u8be2\u7684\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u540e\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"RateAdjustBillEdit_1", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
                return;
            }
            BillShowParameter showParameter = new BillShowParameter();
            showParameter.setFormId(CfmRateAdjustHelper.getFormEntityFromRateAdjustBill((IFormView)this.getView()));
            showParameter.setPkId(ldrawBill.getPkValue());
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    private void setRowInfo(int rowIndex, Object newVal) {
        if (AdjustEleEnum.ADJUSTLOAN.getValue().equals(this.getModel().getValue("adjustele"))) {
            DynamicObject rowInfo = this.getModel().getEntryRowEntity("entry", rowIndex);
            DynamicObject loanBill = rowInfo.getDynamicObject("ldrawbill");
            if (!((Boolean)newVal).booleanValue()) {
                this.getModel().setValue("afterlloanrate", rowInfo.get("lloanrate"), rowIndex);
                this.getModel().setValue("afterlratesign", rowInfo.get("lratesign"), rowIndex);
                this.getModel().setValue("afterlratefloatpoint", rowInfo.get("lratefloatpoint"), rowIndex);
                this.getModel().setValue("afterlrefrate", rowInfo.get("lrefrate"), rowIndex);
                this.getModel().setValue("afterlrateadjustkey", rowInfo.get("lrateadjustkey"), rowIndex);
                this.getModel().setValue("afterlrateadjustval", rowInfo.get("lrateadjustval"), rowIndex);
                this.getModel().setValue("lsettleintmode", (Object)loanBill.getString("settleintmode"), rowIndex);
                this.getModel().setValue("linterestsettledplan", loanBill.get("interestsettledplan"), rowIndex);
                this.getModel().setValue("lissofrrate", loanBill.get("issofrrate"), rowIndex);
                if (this.checkAdjustStyle(loanBill)) {
                    Date adjustEffectDate = (Date)this.getModel().getValue("adjusteffectdate");
                    this.getModel().setValue("lrateadjustdate", (Object)adjustEffectDate, rowIndex);
                }
            }
            this.getView().setEnable(Boolean.valueOf(this.checkAdjustStyle(loanBill) && (Boolean)newVal != false), rowIndex, new String[]{"lrateadjustdate"});
            boolean isGdpljx = SettleIntModeEnum.isGdpljx((String)rowInfo.getString("lsettleintmode"));
            String interestType = loanBill.getString("interesttype");
            BigDecimal startInterestRate = loanBill.getBigDecimal("startloanrate");
            BigDecimal loanRate = loanBill.getBigDecimal("loanrate");
            boolean is0Rate = (InterestTypeEnum.isFixed((String)interestType) || InterestTypeEnum.isAgree((String)interestType)) && BigDecimal.ZERO.compareTo(startInterestRate) == 0 && BigDecimal.ZERO.compareTo(loanRate) == 0;
            this.getView().setEnable(Boolean.valueOf((Boolean)newVal != false && is0Rate && isGdpljx), rowIndex, new String[]{"linterestsettledplan"});
            boolean isZdyhk = RepaymentWayEnum.isZdyhk((String)loanBill.getString("repaymentway"));
            this.getView().setEnable(Boolean.valueOf((Boolean)newVal != false && is0Rate && isZdyhk), rowIndex, new String[]{"lsettleintmode"});
            this.setAfterAdjustRate(rowIndex);
        }
    }

    private void initLoanHeadAndEntryVal() {
        DynamicObject contractBill = (DynamicObject)this.getModel().getValue("loancontractbill");
        if (EmptyUtil.isEmpty((DynamicObject)contractBill)) {
            return;
        }
        this.getModel().setValue("productfactory", (Object)contractBill.getLong("productfactory.id"));
        this.getModel().setValue("org", (Object)contractBill.getDynamicObject("org"));
        String formId = ((BillView)this.getView()).getFormId();
        if (!StringUtils.equals((CharSequence)"cfm_rateadjustbill_bond", (CharSequence)formId)) {
            this.getModel().setValue("creditorg", (Object)contractBill.getDynamicObject("creditorg"));
        }
        this.getModel().setValue("creditortype", (Object)contractBill.getString("creditortype"));
        this.getModel().setValue("interestrate", (Object)contractBill.getBigDecimal("interestrate"));
        if (!InterestTypeEnum.isFloat((String)contractBill.getString("interesttype"))) {
            this.getModel().setValue("afterinterestrate", (Object)contractBill.getBigDecimal("interestrate"));
        }
        this.getModel().setValue("refrate", (Object)contractBill.getLong("referencerate.id"));
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"afterrefrate", (Object)contractBill.getLong("referencerate.id"));
        this.getModel().setValue("rateadjustkey", (Object)contractBill.getString("rateadjustcycletype"));
        this.getModel().setValue("rateadjustval", (Object)contractBill.getInt("rateadjustcycle"));
        this.getModel().setValue("afterrateadjustkey", (Object)contractBill.getString("rateadjustcycletype"));
        this.getModel().setValue("afterrateadjustval", (Object)contractBill.getInt("rateadjustcycle"));
        this.getModel().setValue("ratesign", (Object)contractBill.getString("ratesign"));
        this.getModel().setValue("ratefloatpoint", (Object)contractBill.getBigDecimal("ratefloatpoint"));
        this.getModel().setValue("afterratesign", (Object)contractBill.getString("ratesign"));
        this.getModel().setValue("afterratefloatpoint", (Object)0);
        this.getModel().setValue("currency", (Object)contractBill.getDynamicObject("currency"));
        this.getModel().setValue("amount", (Object)contractBill.getBigDecimal("amount"));
        this.getModel().setValue("drawamount", (Object)contractBill.getBigDecimal("drawamount"));
        this.getModel().setValue("notrepayamount", (Object)contractBill.getBigDecimal("notrepayamount"));
        this.getModel().setValue("repaymentway", (Object)contractBill.getString("repaymentway"));
        this.getModel().setValue("beforeinteresttype", (Object)contractBill.getString("interesttype"));
        this.getModel().deleteEntryData("entry");
        Object[] loanBills = this.getLoanBills(contractBill);
        if (EmptyUtil.isEmpty((Object[])loanBills)) {
            return;
        }
        Map loanIdAdjustInfoMap = RateAdjustHelper.getLoanIdAdjustInfoMap((DynamicObject[])loanBills);
        boolean isAdjustToFloat = (Boolean)this.getModel().getValue("isadjusttofloat");
        Date adjustDate = new Date();
        TableValueSetter vs = this.getTVS();
        for (Object loanBill : loanBills) {
            BigDecimal beforeLoanRate;
            long loanId = loanBill.getLong("id");
            String rateSign = loanBill.getString("ratesign");
            BigDecimal rateFloatPoint = loanBill.getBigDecimal("ratefloatpoint");
            DynamicObject referenceRate = loanBill.getDynamicObject("referencerate");
            String afterRateSign = rateSign;
            BigDecimal afterRateFloatPoint = rateFloatPoint;
            DynamicObject afterRefRate = referenceRate;
            String rateAdjustCycleType = loanBill.getString("rateadjustcycletype");
            int rateAdjustCycle = loanBill.getInt("rateadjustcycle");
            BigDecimal afterLoanRate = beforeLoanRate = loanBill.getBigDecimal("loanrate");
            if (EmptyUtil.isNoEmpty(loanIdAdjustInfoMap.get(loanId))) {
                Map adjustInfoMap = (Map)loanIdAdjustInfoMap.get(loanId);
                adjustDate = DateUtils.getNextDay((Date)((Date)adjustInfoMap.get("adjustdate")), (int)1);
                afterRateSign = adjustInfoMap.get("ratesign").toString();
                afterRateFloatPoint = (BigDecimal)adjustInfoMap.get("ratefloatpoint");
                referenceRate = (DynamicObject)adjustInfoMap.get("referencerate");
                afterLoanRate = (BigDecimal)adjustInfoMap.get("loanrate");
            }
            DynamicObject interestSettledPlan = loanBill.getDynamicObject("interestsettledplan");
            BigDecimal afterAdjustRate = CreateRateAdjustBill.getAfterAdjustRate((DynamicObject)loanBill, afterLoanRate, adjustDate, referenceRate, afterRateSign, afterRateFloatPoint, isAdjustToFloat);
            vs.addRow(new Object[]{loanId, loanBill.getBigDecimal("drawamount"), loanBill.getBigDecimal("notrepayamount"), loanBill.getDynamicObject("currency").getLong("id"), true, adjustDate, afterLoanRate, afterLoanRate, afterRateSign, afterRateFloatPoint, afterRateSign, afterRateFloatPoint, EmptyUtil.isNoEmpty((DynamicObject)referenceRate) ? Long.valueOf(referenceRate.getLong("id")) : null, EmptyUtil.isNoEmpty((DynamicObject)referenceRate) ? Long.valueOf(referenceRate.getLong("id")) : null, loanBill.getBoolean("issofrrate"), loanBill.getString("rateadjuststyle"), rateAdjustCycleType, rateAdjustCycle, rateAdjustCycleType, rateAdjustCycle, loanBill.getString("settleintmode"), EmptyUtil.isNoEmpty((DynamicObject)interestSettledPlan) ? interestSettledPlan.getPkValue() : null, this.checkAdjustStyle((DynamicObject)loanBill) ? adjustDate : null, afterAdjustRate});
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        model.batchCreateNewEntryRow("entry", vs);
        model.endInit();
        this.getView().updateView("entry");
        this.setLocked();
    }

    private void setLocked() {
        DynamicObjectCollection entrys = (DynamicObjectCollection)this.getModel().getValue("entry");
        for (int i = 0; i < entrys.size(); ++i) {
            DynamicObject entry = (DynamicObject)entrys.get(i);
            boolean isAdjust = entry.getBoolean("lisadjust");
            boolean isGdpljx = SettleIntModeEnum.isGdpljx((String)entry.getString("lsettleintmode"));
            DynamicObject loanBill = entry.getDynamicObject("ldrawbill");
            String interestType = loanBill.getString("interesttype");
            BigDecimal startInterestRate = loanBill.getBigDecimal("startloanrate");
            BigDecimal loanRate = loanBill.getBigDecimal("loanrate");
            boolean is0Rate = (InterestTypeEnum.isFixed((String)interestType) || InterestTypeEnum.isAgree((String)interestType)) && BigDecimal.ZERO.compareTo(startInterestRate) == 0 && BigDecimal.ZERO.compareTo(loanRate) == 0;
            this.getView().setEnable(Boolean.valueOf(isAdjust && is0Rate && isGdpljx), i, new String[]{"linterestsettledplan"});
            boolean isZdyhk = RepaymentWayEnum.isZdyhk((String)loanBill.getString("repaymentway"));
            this.getView().setEnable(Boolean.valueOf(isAdjust && is0Rate && isZdyhk), i, new String[]{"lsettleintmode"});
            boolean isEnable = this.checkAdjustStyle(loanBill);
            this.getView().setEnable(Boolean.valueOf(isEnable), i, new String[]{"lrateadjustdate"});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if (StringUtils.equals((CharSequence)"unaudit", (CharSequence)operateKey)) {
            formOperate.getOption().setVariableValue("RATEADJUSTBILL_FORMID", CfmRateAdjustHelper.getFormIdFromView((IFormView)this.getView()));
        }
    }

    private void settleIntModeEvt(int rowIndex, Object newVal) {
        if (EmptyUtil.isNoEmpty((Object)newVal)) {
            this.getView().setEnable(Boolean.valueOf(SettleIntModeEnum.isGdpljx((String)newVal.toString())), rowIndex, new String[]{"linterestsettledplan"});
            if (SettleIntModeEnum.isLsbq((String)newVal.toString())) {
                this.getModel().setValue("linterestsettledplan", null, rowIndex);
            }
        }
    }

    private void setNull() {
        this.getModel().setValue("settleintmode", (Object)SettleIntModeEnum.gdpljx.getValue());
        this.getModel().setValue("interestsettledplan", null);
    }

    private void rateAdjustStyleEvt(String propName, Object newVal) {
        if (AdjustEleEnum.ADJUSTCONTRACT.getValue().equals(this.getModel().getValue("adjustele"))) {
            int entryRowCount = this.getModel().getEntryRowCount("entry");
            for (int i = 0; i < entryRowCount; ++i) {
                this.getModel().setValue(headEntryFieldMap.get(propName), newVal, i);
            }
        }
    }

    private void afterRefRateEvt(Object newVal) {
        boolean isAdjustToFloat = (Boolean)this.getModel().getValue("isadjusttofloat");
        if (isAdjustToFloat) {
            this.getModel().setValue("refrate", newVal);
        }
        int entryRowCount = this.getModel().getEntryRowCount("entry");
        for (int i = 0; i < entryRowCount; ++i) {
            this.getModel().setValue("afterlrefrate", newVal, i);
            if (!isAdjustToFloat) continue;
            this.getModel().setValue("lrefrate", newVal, i);
        }
        this.setAfterAdjustRate();
    }

    private void setAfterAdjustRate() {
        int entryRowCount = this.getModel().getEntryRowCount("entry");
        for (int i = 0; i < entryRowCount; ++i) {
            this.setAfterAdjustRate(i);
        }
    }

    private void setRateAdjustDate(Date adjustEffectDate) {
        int entryRowCount = this.getModel().getEntryRowCount("entry");
        for (int i = 0; i < entryRowCount; ++i) {
            DynamicObject loanBill = (DynamicObject)this.getModel().getValue("ldrawbill", i);
            if (this.checkAdjustStyle(loanBill)) {
                this.getModel().setValue("lrateadjustdate", (Object)adjustEffectDate, i);
            }
            this.getModel().setValue("ladjusteffectdate", (Object)adjustEffectDate, i);
        }
    }

    private void setTleIntModeEvt(Object newVal) {
        if (AdjustEleEnum.ADJUSTCONTRACT.getValue().equals(this.getModel().getValue("adjustele"))) {
            int entryRowCount = this.getModel().getEntryRowCount("entry");
            for (int i = 0; i < entryRowCount; ++i) {
                boolean is0Rate;
                DynamicObject loanBill = (DynamicObject)this.getModel().getValue("ldrawbill", i);
                boolean bl = is0Rate = BigDecimal.ZERO.compareTo(loanBill.getBigDecimal("startloanrate")) == 0 && BigDecimal.ZERO.compareTo(loanBill.getBigDecimal("loanrate")) == 0;
                if (!is0Rate || !RepaymentWayEnum.isZdyhk((String)loanBill.getString("repaymentway"))) continue;
                this.getModel().setValue("lsettleintmode", newVal, i);
            }
            this.getModel().setValue("interestsettledplan", null);
        }
    }

    private void interestSettledPlanEvt(Object newVal) {
        if (AdjustEleEnum.ADJUSTCONTRACT.getValue().equals(this.getModel().getValue("adjustele"))) {
            int entryRowCount = this.getModel().getEntryRowCount("entry");
            for (int i = 0; i < entryRowCount; ++i) {
                boolean isZdyhkAndGdpljx;
                DynamicObject loanBill = (DynamicObject)this.getModel().getValue("ldrawbill", i);
                String settleintMode = (String)this.getModel().getValue("lsettleintmode", i);
                boolean is0Rate = BigDecimal.ZERO.compareTo(loanBill.getBigDecimal("startloanrate")) == 0 && BigDecimal.ZERO.compareTo(loanBill.getBigDecimal("loanrate")) == 0;
                boolean isZdyhk = RepaymentWayEnum.isZdyhk((String)loanBill.getString("repaymentway"));
                boolean isGdpljx = SettleIntModeEnum.isGdpljx((String)loanBill.getString("settleintmode"));
                boolean bl = isZdyhkAndGdpljx = isZdyhk && SettleIntModeEnum.isGdpljx((String)settleintMode);
                if (!is0Rate || !isGdpljx && !isZdyhkAndGdpljx) continue;
                this.getModel().setValue("linterestsettledplan", newVal, i);
            }
        }
    }

    private void afterRateAdjustKeyValEvt(String prop, Object newVal) {
        int entryRowCount = this.getModel().getEntryRowCount("entry");
        for (int i = 0; i < entryRowCount; ++i) {
            this.getModel().setValue(prop, newVal, i);
        }
    }

    private void setAfterAdjustRate(int rowIndex) {
        boolean isAdjust = (Boolean)this.getModel().getValue("lisadjust", rowIndex);
        DynamicObject loanBill = (DynamicObject)this.getModel().getValue("ldrawbill", rowIndex);
        if (EmptyUtil.isEmpty((DynamicObject)loanBill)) {
            return;
        }
        if (isAdjust) {
            BigDecimal afterLoanRate = (BigDecimal)this.getModel().getValue("afterlloanrate", rowIndex);
            Date adjustEffectDate = (Date)this.getModel().getValue("ladjusteffectdate", rowIndex);
            DynamicObject afterRefRate = (DynamicObject)this.getModel().getValue("afterlrefrate", rowIndex);
            String afterRateSign = (String)this.getModel().getValue("afterlratesign", rowIndex);
            BigDecimal afterRateFloatPoint = (BigDecimal)this.getModel().getValue("afterlratefloatpoint", rowIndex);
            boolean isAdjustToFloat = (Boolean)this.getModel().getValue("isadjusttofloat");
            BigDecimal afterAdjustRate = CreateRateAdjustBill.getAfterAdjustRate(loanBill, afterLoanRate, adjustEffectDate, afterRefRate, afterRateSign, afterRateFloatPoint, isAdjustToFloat);
            this.getModel().setValue("afteradjustrate", (Object)afterAdjustRate, rowIndex);
        } else {
            QFilter qfilter = new QFilter("id", "=", (Object)loanBill.getLong("id")).and("rateadjust_entry.ra_effectdate", "<=", (Object)DateUtils.getCurrentDate());
            DynamicObjectCollection queryDatas = QueryServiceHelper.query((String)"cfm_loanbill", (String)"id,rateadjust_entry.ra_effectdate,rateadjust_entry.ra_yearrate", (QFilter[])qfilter.toArray());
            Map idObjMap = queryDatas.stream().collect(Collectors.toMap(o -> o.getLong("id"), Function.identity(), (a, b) -> a.getDate("rateadjust_entry.ra_effectdate").compareTo(b.getDate("rateadjust_entry.ra_effectdate")) >= 0 ? a : b));
            DynamicObject rateObj = (DynamicObject)idObjMap.get(loanBill.getLong("id"));
            if (EmptyUtil.isNoEmpty((DynamicObject)rateObj)) {
                this.getModel().setValue("afteradjustrate", (Object)rateObj.getBigDecimal("rateadjust_entry.ra_yearrate"), rowIndex);
            } else {
                this.getModel().setValue("afteradjustrate", (Object)0, rowIndex);
            }
        }
    }

    private boolean checkAdjustStyle(DynamicObject loanBill) {
        boolean isAdjustToFloat = (Boolean)this.getModel().getValue("isadjusttofloat");
        String rateAdjustStyle = (String)this.getModel().getValue("rateadjuststyle");
        return isAdjustToFloat && RateAdjustStyleEnum.isCycle((String)rateAdjustStyle) || RateAdjustStyleEnum.isCycle((String)loanBill.getString("rateadjuststyle"));
    }

    private TableValueSetter getTVS() {
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("ldrawbill", new Object[0]).addField("ldrawamount", new Object[0]).addField("lnotrepayamount", new Object[0]).addField("loancurrency", new Object[0]).addField("lisadjust", new Object[0]).addField("ladjusteffectdate", new Object[0]).addField("lloanrate", new Object[0]).addField("afterlloanrate", new Object[0]).addField("lratesign", new Object[0]).addField("lratefloatpoint", new Object[0]).addField("afterlratesign", new Object[0]).addField("afterlratefloatpoint", new Object[0]).addField("lrefrate", new Object[0]).addField("afterlrefrate", new Object[0]).addField("lissofrrate", new Object[0]).addField("loanrateadjuststyle", new Object[0]).addField("lrateadjustkey", new Object[0]).addField("lrateadjustval", new Object[0]).addField("afterlrateadjustkey", new Object[0]).addField("afterlrateadjustval", new Object[0]).addField("lsettleintmode", new Object[0]).addField("linterestsettledplan", new Object[0]).addField("lrateadjustdate", new Object[0]).addField("afteradjustrate", new Object[0]);
        return vs;
    }

    private DynamicObject[] getLoanBills(DynamicObject contractBill) {
        QFilter qFilter = new QFilter("sourcebillid", "=", contractBill.getPkValue()).and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()).and("drawtype", "!=", (Object)DrawTypeEnum.CLOSEOUT.getValue()).and("confirmstatus", "=", (Object)ConfirmStatusEnum.YETCONFIRM.getValue());
        DynamicObject[] loanBills = TmcDataServiceHelper.load((String)"cfm_loanbill", (String)String.join((CharSequence)",", drawProps), (QFilter[])new QFilter[]{qFilter});
        return loanBills;
    }

    static {
        headEntryFieldMap.put("afterinterestrate", "afterlloanrate");
        headEntryFieldMap.put("afterratesign", "afterlratesign");
        headEntryFieldMap.put("afterratefloatpoint", "afterlratefloatpoint");
        headEntryFieldMap.put("rateadjuststyle", "loanrateadjuststyle");
        drawProps = new String[]{"id", "billno", "loanrate", "ratesign", "startloanrate", "repaymentway", "ratefloatpoint", "drawamount", "notrepayamount", "settleintmode", "interestsettledplan", "interesttype", "rateresetdays", "rateadjuststyle", "loantype", "referencerate", "rateadjustcycletype", "rateadjustcycle", "currency", "issofrrate", "datasource"};
        beforeF7_PROPS = new String[]{"loancontractbill", "afterrefrate", "afterlrefrate"};
    }
}

