/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.repayapply;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.DateEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cfm.common.enums.ApplyBusinessStatusEnum;
import kd.tmc.cfm.common.enums.ConfirmStatusEnum;
import kd.tmc.cfm.common.enums.DataSourceEnum;
import kd.tmc.cfm.common.enums.DrawTypeEnum;
import kd.tmc.cfm.common.enums.LoanContractStatusEnum;
import kd.tmc.cfm.common.enums.LoanTypeEnum;
import kd.tmc.cfm.common.enums.RepaySelectWayEnum;
import kd.tmc.cfm.common.helper.CfmBillCommonHelper;
import kd.tmc.cfm.common.helper.CfmContractBillHelper;
import kd.tmc.cfm.common.helper.FormParameterHelper;
import kd.tmc.cfm.common.helper.LoanBillHelper;
import kd.tmc.cfm.common.helper.RepaymentbillHelper;
import kd.tmc.cfm.common.resource.AbstractBizResource;
import kd.tmc.cfm.common.resource.BizResourceFactory;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.InterTypeEnum;
import kd.tmc.fbp.common.enums.InterestTypeEnum;
import kd.tmc.fbp.common.enums.OppUnitTypeEnum;
import kd.tmc.fbp.common.enums.RepaymentWayEnum;
import kd.tmc.fbp.common.exception.TmcBizException;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.model.interest.IntBillDetailInfo;
import kd.tmc.fbp.common.model.interest.IntBillExtInfo;
import kd.tmc.fbp.common.model.interest.IntBillInfo;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class RepayApplyBillEdit
extends AbstractBillPlugIn
implements HyperLinkClickListener {
    private static Log logger = LogFactory.getLog(RepayApplyBillEdit.class);
    private static final String SELECTBILLNO_CLOSECALLBACK = "selectbillno_closeCallBack";
    private static final String CHANGE_REPAYWAY_CALLBACKID = "change_repayway_callBackId";
    private static final String SELECTS = "id, drawamount, notrepayamount, loantype, repaymentway, repayplan_entry, repayplan_entry.exrepaymentdate, repayplan_entry.enotrepayamount, repayplan_entry.repaystate, interest_entry, interest_entry.interesdate, interest_entry.interestcalamount, interest_entry.intstate";
    private static final String[] repayProps = new String[]{"amount", "bizdate", "predictinstamt", "entrys", "entrys.inststartdate", "entrys.instenddate", "entrys.instdays", "entrys.instprincipalamt", "entrys.rate", "entrys.ratetrandays", "entrys.instamt", "entrys.instctg"};

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid loans = (EntryGrid)this.getControl("loans");
        if (loans != null) {
            loans.addHyperClickListener((HyperLinkClickListener)this);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DateEdit preRepayDate = (DateEdit)this.getControl("prerepaydate");
        preRepayDate.setMinDate(DateUtils.getCurrentDate());
        this.setFreeRate();
        boolean isRepayByPlan = this.setEnable();
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getModel().setValue("org", null);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName = e.getProperty().getName();
        Object newVal = e.getChangeSet()[0].getNewValue();
        Object oldVal = e.getChangeSet()[0].getOldValue();
        switch (propName) {
            case "repayway": {
                if (newVal.equals(oldVal) || !EmptyUtil.isNoEmpty((DynamicObjectCollection)this.getModel().getEntryEntity("loans"))) break;
                this.showConfirmTip();
                break;
            }
            case "e_repayamount": {
                BigDecimal recAmt = this.getAllEntryRowsAmt("e_repayamount");
                this.getModel().setValue("amount", (Object)recAmt);
                int index = e.getChangeSet()[0].getRowIndex();
                this.calInt(index);
                break;
            }
            case "e_preintamt": {
                BigDecimal intAmt = this.getAllEntryRowsAmt("e_preintamt");
                this.getModel().setValue("instamt", (Object)intAmt);
                break;
            }
            case "isratio": 
            case "amount": {
                this.calEntryAmt();
                break;
            }
            case "bizdate": {
                Date bizDate = (Date)this.getModel().getValue("bizdate");
                this.getModel().setValue("prerepaydate", (Object)bizDate);
                DateEdit preRepayDate = (DateEdit)this.getControl("prerepaydate");
                preRepayDate.setMinDate(bizDate);
                break;
            }
            case "e_ispayinst": {
                this.isPayInstChgEvt(e);
                break;
            }
            case "prerepaydate": {
                this.repayDateCgs(false);
                break;
            }
        }
    }

    private void repayDateCgs(boolean isRepayByPlan) {
        Date repayDate = (Date)this.getModel().getValue("prerepaydate");
        for (int i = 0; i < this.getModel().getEntryRowCount("loans"); ++i) {
            DynamicObject loansEntry = this.getModel().getEntryRowEntity("loans", i);
            DynamicObject loanBillF7 = loansEntry.getDynamicObject("e_loanbill");
            if (EmptyUtil.isEmpty((DynamicObject)loanBillF7)) {
                return;
            }
            boolean enable = !LoanBillHelper.isYkx((DynamicObject)loanBillF7) || repayDate.compareTo(loanBillF7.getDate("expiredate")) > 0;
            this.getView().setEnable(Boolean.valueOf(enable), i, new String[]{"e_ispayinst", "e_combineinst"});
            if (isRepayByPlan) continue;
            this.calInt(i);
        }
    }

    private boolean setEnable() {
        DynamicObject contractBill = (DynamicObject)this.getModel().getValue("loancontractbill");
        if (EmptyUtil.isEmpty((DynamicObject)contractBill)) {
            return Boolean.FALSE;
        }
        boolean isRepayByPlan = CfmContractBillHelper.isRepayByPlan((DynamicObject)this.getContractBill(contractBill.getPkValue()));
        this.getView().setEnable(Boolean.valueOf(!isRepayByPlan), new String[]{"prerepaydate"});
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("loans");
        for (int i = 0; i < entrys.size(); ++i) {
            this.getView().setEnable(Boolean.valueOf(!isRepayByPlan), i, new String[]{"e_repayamount"});
        }
        return isRepayByPlan;
    }

    private void setFreeRate() {
        DynamicObjectCollection loans = this.getModel().getEntryEntity("loans");
        if (!CollectionUtils.isEmpty((Collection)loans)) {
            int len = loans.size();
            for (int i = 0; i < len; ++i) {
                DynamicObject loan = (DynamicObject)loans.get(i);
                DynamicObject loanBill = loan.getDynamicObject("e_loanbill");
                BigDecimal loanRate = loanBill.getBigDecimal("loanrate");
                String interestType = loanBill.getString("interesttype");
                if (null == loanRate || loanRate.compareTo(BigDecimal.ZERO) != 0 || !EmptyUtil.isNoEmpty((String)interestType) || InterestTypeEnum.FLOAT.getValue().equals(interestType)) continue;
                this.getModel().setValue("e_ispayinst", (Object)false, i);
                this.getModel().setValue("e_combineinst", (Object)false, i);
                this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"e_ispayinst", "e_combineinst"});
            }
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String fieldName = evt.getFieldName();
        if ("e_loanbill".equals(fieldName)) {
            this.hyper2LoanBill(evt);
        } else if ("e_calintamt".equals(fieldName)) {
            this.showIntDetailForm(evt.getRowIndex());
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        Object returnData = e.getReturnData();
        if (EmptyUtil.isEmpty((Object)returnData)) {
            return;
        }
        ListSelectedRowCollection selectedRows = (ListSelectedRowCollection)returnData;
        switch (actionId) {
            case "selectbillno_closeCallBack": {
                this.selectBillNoCloseCallBack(selectedRows.get(0));
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        OperationResult operationResult = args.getOperationResult();
        if (operationResult == null || !operationResult.isSuccess()) {
            return;
        }
        switch (op.getOperateKey()) {
            case "calint": {
                int rowIndex = this.getModel().getEntryCurrentRowIndex("loans");
                this.calInt(rowIndex);
                break;
            }
            case "repaydraw": {
                this.repayDrawOp();
                break;
            }
            case "trace2repay": {
                CfmBillCommonHelper.trace2RepayExtendBill((DynamicObject)this.getModel().getDataEntity(), (IFormView)this.getView(), (String)"repay");
                break;
            }
        }
    }

    private void repayDrawOp() {
        String entityName = this.getModel().getDataEntityType().getName();
        QFilter comFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()).and("confirmstatus", "=", (Object)ConfirmStatusEnum.YETCONFIRM.getValue());
        String appId = this.getView().getFormShowParameter().getAppId();
        List comIdList = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)entityName, (String)"47150e89000000ac");
        QFilter permQfilter = new QFilter("org.id", "in", (Object)comIdList);
        comFilter.and(permQfilter);
        this.getLoanTypeFilter(comFilter, entityName);
        QFilter ingApplyFilter = new QFilter("businessstatus", "in", Arrays.asList(ApplyBusinessStatusEnum.APPLY.getValue(), ApplyBusinessStatusEnum.HANDING.getValue(), ApplyBusinessStatusEnum.NOTHAND.getValue())).and(permQfilter);
        DynamicObjectCollection applyConBills = QueryServiceHelper.query((String)entityName, (String)"id,loancontractbill,loans.e_loanbill", (QFilter[])ingApplyFilter.toArray());
        if (this.isContractRepay()) {
            Set<Long> contractIdSet;
            Object[] contractIds = (Long[])applyConBills.stream().map(o -> o.getLong("loancontractbill")).toArray(Long[]::new);
            comFilter.and("contractstatus", "in", Arrays.asList(LoanContractStatusEnum.REGISTERED.getValue(), LoanContractStatusEnum.EXECUTING.getValue())).and("notrepayamount", ">", (Object)0);
            if (EmptyUtil.isNoEmpty((Object[])contractIds)) {
                comFilter.and("id", "not in", (Object)contractIds);
                logger.info("\u6821\u9a8c\u6709\u5728\u9014\u8fd8\u6b3e\u7533\u8bf7\u5355\u7684\u5408\u540ccontractIds{}:", (Object)Arrays.toString(contractIds));
            }
            if (EmptyUtil.isNoEmpty(contractIdSet = this.getContractIds())) {
                comFilter.and("id", "not in", contractIdSet);
                logger.info("\u8fc7\u6ee4\u6389\u6709\u5f02\u5e01\u79cd\u63d0\u6b3e\u7684\u5408\u540ccontractIdSet{}:", contractIdSet);
            }
            this.showBillF7(this.getContractFormId(entityName), comFilter);
        } else {
            Set loanIds = applyConBills.stream().map(o -> o.getLong("loans.e_loanbill")).collect(Collectors.toSet());
            comFilter.and("notrepayamount", ">", (Object)0).and("drawtype", "!=", (Object)DrawTypeEnum.CLOSEOUT.getValue());
            if (EmptyUtil.isNoEmpty(loanIds)) {
                comFilter.and("id", "not in", loanIds);
                logger.info("\u6821\u9a8c\u6709\u5728\u9014\u8fd8\u6b3e\u7533\u8bf7\u5355\u7684loanIds{}:", loanIds);
            }
            this.showBillF7(this.getLoanFormId(entityName), comFilter);
        }
    }

    private void getLoanTypeFilter(QFilter comFilter, String entityName) {
        if ("cfm_repayapplybill".equals(entityName)) {
            comFilter.and("loantype", "in", Arrays.asList(LoanTypeEnum.BANKLOAN.getValue(), LoanTypeEnum.BANKSLOAN.getValue(), LoanTypeEnum.LINKLEND.getValue(), LoanTypeEnum.ENTRUSTLOAN.getValue()));
        } else if ("fl_rentpay_apply".equals(entityName)) {
            comFilter.and("loantype", "=", (Object)LoanTypeEnum.FINLEASE.getValue());
            comFilter.and("notdrawamount", "=", (Object)0);
        } else if ("cfm_repayapplybill_bond".equals(entityName)) {
            comFilter.and("loantype", "=", (Object)LoanTypeEnum.BOND.getValue());
        }
    }

    private Set<Long> getContractIds() {
        QFilter filter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()).and("confirmstatus", "=", (Object)ConfirmStatusEnum.YETCONFIRM.getValue()).and("notrepayamount", ">", (Object)0).and("drawtype", "!=", (Object)DrawTypeEnum.CLOSEOUT.getValue());
        DynamicObjectCollection loadBills = QueryServiceHelper.query((String)"cfm_loanbill", (String)"id, currency, contractcny, loancontractbill", (QFilter[])filter.toArray());
        HashSet<Long> ids = new HashSet<Long>(16);
        if (EmptyUtil.isEmpty((DynamicObjectCollection)loadBills)) {
            return ids;
        }
        for (DynamicObject loanBill : loadBills) {
            if (loanBill.getLong("currency") == loanBill.getLong("contractcny")) continue;
            ids.add(loanBill.getLong("loancontractbill"));
        }
        return ids;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (CHANGE_REPAYWAY_CALLBACKID.equals(messageBoxClosedEvent.getCallBackId())) {
            if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
                this.getModel().deleteEntryData("loans");
                HashMap<String, Object> valMap = new HashMap<String, Object>(16);
                valMap.put("org", null);
                valMap.put("currency", null);
                valMap.put("amount", BigDecimal.ZERO);
                valMap.put("contractdrawamt", BigDecimal.ZERO);
                valMap.put("notrepayamt", BigDecimal.ZERO);
                valMap.put("instamt", BigDecimal.ZERO);
                valMap.put("totalamt", BigDecimal.ZERO);
                valMap.put("accountbank", null);
                if ("cfm_repayapplybill_bond".equals(this.getModel().getDataEntityType().getName())) {
                    valMap.put("payeetype", OppUnitTypeEnum.SUPPLIER.getValue());
                    valMap.put("payee", null);
                    valMap.put("payeetext", null);
                    valMap.put("payeeaccttext", null);
                    valMap.put("payeebank", null);
                    valMap.put("isbuyback", Boolean.FALSE);
                }
                this.getModel().setValue("loancontractbill", null);
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), valMap);
            } else {
                String nowRePayWay = (String)this.getModel().getValue("repayway");
                nowRePayWay = RepaySelectWayEnum.CONTRACTREPAY.getValue().equals(nowRePayWay) ? RepaySelectWayEnum.LOANREPAY.getValue() : RepaySelectWayEnum.CONTRACTREPAY.getValue();
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"repayway", (Object)nowRePayWay);
            }
        }
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        Control source = (Control)e.getSource();
        String key = source.getKey();
        int rowIndex = e.getRowIndex();
        Object value = e.getValue();
        switch (key) {
            case "e_repayamount": {
                DynamicObject rowInfo = this.getModel().getEntryRowEntity("loans", rowIndex);
                BigDecimal norepayAmt = rowInfo.getBigDecimal("e_notrepayamount");
                if (!EmptyUtil.isNoEmpty((Object)value) || new BigDecimal(value + "").compareTo(norepayAmt) <= 0) break;
                e.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u884c\u7684\u9884\u8ba1\u8fd8\u6b3e\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u672a\u8fd8\u672c\u91d1\u3002", (String)"RepayApplyBillEdit_3", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
                this.getView().updateView(key, rowIndex);
                break;
            }
            case "amount": {
                BigDecimal allNorepayAmt = this.getAllEntryRowsAmt("e_notrepayamount");
                if (!EmptyUtil.isNoEmpty((Object)value) || new BigDecimal(value + "").compareTo(allNorepayAmt) <= 0) break;
                e.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u5934\u7684\u8fd8\u6b3e\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u672a\u8fd8\u672c\u91d1\u4e4b\u548c\u3002", (String)"RepayApplyBillEdit_4", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
                this.getView().updateView(key);
            }
        }
    }

    private void calEntryAmt() {
        if (!((Boolean)this.getModel().getValue("isratio")).booleanValue()) {
            return;
        }
        BigDecimal repayAmt = (BigDecimal)this.getModel().getValue("amount");
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("loans");
        if (BigDecimal.ZERO.compareTo(repayAmt) == 0) {
            for (int i = 0; i < entrys.size(); ++i) {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"e_repayamount", (Object)0, (int)i);
            }
        } else {
            BigDecimal allLoansAmt = this.getAllEntryRowsAmt("e_drawamount");
            for (int i = 0; i < entrys.size(); ++i) {
                DynamicObject entry = (DynamicObject)entrys.get(i);
                BigDecimal loanAmt = entry.getBigDecimal("e_drawamount");
                BigDecimal rowRepayAmt = loanAmt.divide(allLoansAmt, 20, 4).multiply(repayAmt);
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"e_repayamount", (Object)rowRepayAmt, (int)i);
                this.calInt(i);
            }
        }
    }

    private BigDecimal getAllEntryRowsAmt(String entryField) {
        EntryGrid entryGrid = (EntryGrid)this.getControl("loans");
        return entryGrid.getSum(entryField);
    }

    private void showConfirmTip() {
        this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u8fd8\u6b3e\u9009\u62e9\u65b9\u5f0f\uff0c\u5c06\u6e05\u7a7a\u5df2\u586b\u6709\u7684\u5355\u636e\u4fe1\u606f\uff0c\u786e\u5b9a\u7ee7\u7eed\u64cd\u4f5c\u5417\uff1f", (String)"RepayApplyBillEdit_1", (String)"tmc-cfm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(CHANGE_REPAYWAY_CALLBACKID, (IFormPlugin)this));
    }

    private void hyper2LoanBill(HyperLinkClickEvent evt) {
        int rowIndex = evt.getRowIndex();
        if (rowIndex > -1) {
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("loans", rowIndex);
            DynamicObject loanBill = entryRowEntity.getDynamicObject("e_loanbill");
            if (EmptyUtil.isNoEmpty((DynamicObject)loanBill)) {
                BillShowParameter parameter = new BillShowParameter();
                parameter.setFormId(FormParameterHelper.getLoanBillFormByBizType((IFormView)this.getView()));
                parameter.setPkId((Object)loanBill.getLong("id"));
                parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm((FormShowParameter)parameter);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6240\u67e5\u8be2\u7684\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u540e\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"RepayApplyBillEdit_2", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private boolean isContractRepay() {
        String repayWay = (String)this.getModel().getValue("repayway");
        return RepaySelectWayEnum.CONTRACTREPAY.getValue().equals(repayWay);
    }

    private void selectBillNoCloseCallBack(ListSelectedRow listSelectedRow) {
        Object pkId = listSelectedRow.getPrimaryKeyValue();
        List<String> repayWays = Arrays.asList(RepaymentWayEnum.bqhblsbq.getValue(), RepaymentWayEnum.dqhblsbq.getValue(), RepaymentWayEnum.debx.getValue(), RepaymentWayEnum.debj.getValue(), RepaymentWayEnum.dbdx.getValue());
        boolean isRepayByPlan = false;
        String repaymentWay = null;
        if (this.isContractRepay()) {
            DynamicObject contractBill = this.getContractBill(pkId);
            this.fillContractInfo(contractBill, null);
            this.setAccountBank(contractBill);
            repaymentWay = contractBill.getString("repaymentway");
            Object[] loanBills = this.getLoanBills(pkId);
            if (EmptyUtil.isNoEmpty((Object[])loanBills)) {
                isRepayByPlan = CfmContractBillHelper.isRepayByPlan((DynamicObject)contractBill);
                this.isRepayByPlanValidate(isRepayByPlan, (DynamicObject[])loanBills, contractBill.getString("datasource"));
                this.setPreRepayDate((DynamicObject)loanBills[0], isRepayByPlan);
                ArrayList<HashMap<String, Object>> billList = new ArrayList<HashMap<String, Object>>(loanBills.length);
                Map<String, BigDecimal> headMap = new HashMap<String, BigDecimal>(10);
                headMap.put("amount", BigDecimal.ZERO);
                headMap.put("instamt", BigDecimal.ZERO);
                for (Object loanBill : loanBills) {
                    HashMap<String, Object> bill = new HashMap<String, Object>(loanBills.length);
                    bill.put("e_loanbill", loanBill.getLong("id"));
                    bill.put("e_drawamount", loanBill.get("drawamount"));
                    bill.put("e_notrepayamount", loanBill.get("notrepayamount"));
                    if ("fl_rentpay_apply".equals(this.getView().getEntityId())) {
                        bill.put("e_repayamount", this.getModel().getValue("amount"));
                        bill.put("e_preintamt", this.getModel().getValue("instamt"));
                        bill.put("e_combineinst", this.getModel().getValue("totalamt"));
                        bill.put("e_ispayinst", Boolean.TRUE);
                    } else {
                        boolean isPayInst = false;
                        if (repayWays.contains(loanBill.getString("repaymentway"))) {
                            isPayInst = true;
                            bill.put("e_ispayinst", Boolean.TRUE);
                        } else {
                            bill.put("e_ispayinst", Boolean.FALSE);
                            bill.put("e_combineinst", Boolean.FALSE);
                        }
                        headMap = this.doRepayByPlan((DynamicObject)loanBill, isPayInst, true, bill, headMap);
                    }
                    billList.add(bill);
                }
                TmcViewInputHelper.batchFillEntity((String)"loans", (AbstractFormDataModel)((AbstractFormDataModel)this.getModel()), billList);
                if (!"fl_rentpay_apply".equals(this.getView().getEntityId())) {
                    BigDecimal headAmount = (BigDecimal)headMap.get("amount");
                    BigDecimal headInstAmt = (BigDecimal)headMap.get("instamt");
                    this.getModel().setValue("amount", (Object)headAmount);
                    this.getModel().setValue("instamt", (Object)headInstAmt);
                    this.getModel().setValue("totalamt", (Object)headAmount.add(headInstAmt));
                }
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u5408\u540c\u4e0b,\u6240\u6709\u7684\u63d0\u6b3e\u5df2\u7ecf\u7ed3\u6e05,\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"RepayApplyBillEdit_5", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
            }
        } else {
            DynamicObject loanBill = this.getLoanBill(pkId);
            if (EmptyUtil.isEmpty((DynamicObject)loanBill) || loanBill == null) {
                return;
            }
            this.setAccountBank(loanBill);
            repaymentWay = loanBill.getString("repaymentway");
            this.fillContractInfo(loanBill.getDynamicObject("loancontractbill"), loanBill);
            this.getModel().deleteEntryData("loans");
            this.getModel().createNewEntryRow("loans");
            this.getModel().setValue("e_loanbill", (Object)loanBill.getLong("id"), 0);
            this.getModel().setValue("e_drawamount", loanBill.get("drawamount"), 0);
            this.getModel().setValue("e_notrepayamount", loanBill.get("notrepayamount"), 0);
            boolean isPayInst = false;
            if (repayWays.contains(loanBill.getString("repaymentway"))) {
                isPayInst = true;
                this.getModel().setValue("e_ispayinst", (Object)Boolean.TRUE, 0);
            } else {
                this.getModel().setValue("instamt", (Object)BigDecimal.ZERO);
                this.getModel().setValue("e_preintamt", (Object)BigDecimal.ZERO, 0);
            }
            DynamicObject loanContract = loanBill.getDynamicObject("loancontractbill");
            if (EmptyUtil.isEmpty((DynamicObject)loanContract)) {
                return;
            }
            isRepayByPlan = CfmContractBillHelper.isRepayByPlan((DynamicObject)this.getContractBill(loanContract.getPkValue()));
            this.doRepayByPlan(loanBill, isPayInst, false, null, null);
        }
        this.getModel().setValue("isratio", (Object)false);
        this.setEnableByPlan(isRepayByPlan, repaymentWay);
    }

    private void setEnableByPlan(boolean isRepayByPlan, String repaymentWay) {
        this.getView().setEnable(Boolean.valueOf(!RepaymentWayEnum.isHbfx((String)repaymentWay) && !isRepayByPlan), new String[]{"isratio"});
        this.getView().setEnable(Boolean.valueOf(!RepaymentWayEnum.isHbfx((String)repaymentWay) && !isRepayByPlan), new String[]{"prerepaydate"});
        DynamicObjectCollection loans = this.getModel().getEntryEntity("loans");
        int len = loans.size();
        for (int i = 0; i < len; ++i) {
            this.getView().setEnable(Boolean.valueOf(!RepaymentWayEnum.isHbfx((String)repaymentWay) && !isRepayByPlan), i, new String[]{"e_repayamount"});
            DynamicObject loan = (DynamicObject)loans.get(i);
            DynamicObject loanBill = loan.getDynamicObject("e_loanbill");
            BigDecimal loanRate = loanBill.getBigDecimal("loanrate");
            String interestType = loanBill.getString("interesttype");
            if (null == loanRate || loanRate.compareTo(BigDecimal.ZERO) != 0 || !EmptyUtil.isNoEmpty((String)interestType) || InterestTypeEnum.FLOAT.getValue().equals(interestType)) continue;
            this.getModel().setValue("e_ispayinst", (Object)false, i);
            this.getModel().setValue("e_combineinst", (Object)false, i);
            this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"e_ispayinst", "e_combineinst"});
        }
    }

    private Map<String, BigDecimal> doRepayByPlan(DynamicObject loanBill, boolean isPayInst, boolean isContractRepay, Map<String, Object> bill, Map<String, BigDecimal> headMap) {
        DynamicObjectCollection repayPlanEntrys = loanBill.getDynamicObjectCollection("repayplan_entry");
        if (repayPlanEntrys.size() == 0) {
            return headMap;
        }
        DynamicObject repayPlanEntry = repayPlanEntrys.stream().filter(o -> o.getBigDecimal("enotrepayamount").compareTo(BigDecimal.ZERO) > 0).filter(o -> o.getInt("repaystate") == 0).min(Comparator.comparing(c -> c.getDate("exrepaymentdate"))).orElseGet(null);
        DynamicObjectCollection intPlanEntrys = loanBill.getDynamicObjectCollection("interest_entry");
        if (EmptyUtil.isNoEmpty((DynamicObject)repayPlanEntry)) {
            Date exRepaymentDate = repayPlanEntry.getDate("exrepaymentdate");
            BigDecimal enotRepayAmount = repayPlanEntry.getBigDecimal("enotrepayamount");
            BigDecimal payIntAmt = BigDecimal.ZERO;
            if (isPayInst && EmptyUtil.isNoEmpty((DynamicObjectCollection)intPlanEntrys)) {
                payIntAmt = intPlanEntrys.stream().filter(o -> DateUtils.getDataFormat((Date)o.getDate("interesdate"), (boolean)true).compareTo(DateUtils.getDataFormat((Date)exRepaymentDate, (boolean)true)) == 0).filter(o -> o.getInt("intstate") == 0).map(o -> o.getBigDecimal("interestcalamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
            }
            if (isContractRepay) {
                bill.put("e_repayamount", enotRepayAmount);
                bill.put("e_calintamt", payIntAmt);
                bill.put("e_preintamt", payIntAmt);
                headMap.put("amount", enotRepayAmount.add(headMap.get("amount")));
                headMap.put("instamt", payIntAmt.add(headMap.get("instamt")));
            } else {
                this.getModel().setValue("e_repayamount", (Object)enotRepayAmount, 0);
                this.getModel().setValue("e_calintamt", (Object)payIntAmt, 0);
                this.getModel().setValue("e_preintamt", (Object)payIntAmt, 0);
                this.getModel().setValue("prerepaydate", (Object)exRepaymentDate);
                this.getModel().setValue("accountbank", (Object)repayPlanEntry.getDynamicObject("repayaccount"));
            }
        }
        return headMap;
    }

    private void setAccountBank(DynamicObject contractBill) {
        DynamicObject accountBank = contractBill.getDynamicObject("accountbank");
        if (DataSourceEnum.isInvest((String)contractBill.getString("datasource"))) {
            accountBank = contractBill.getDynamicObject("loaneracctbank");
        }
        this.getModel().setValue("accountbank", (Object)accountBank);
    }

    private void fillContractInfo(DynamicObject contractBill, DynamicObject loanBill) {
        this.getModel().setValue("org", contractBill.getDynamicObject("org").getPkValue());
        this.getModel().setValue("loancontractbill", contractBill.getPkValue());
        this.getModel().setValue("loantype", (Object)contractBill.getString("loantype"));
        this.getModel().setValue("currency", (Object)contractBill.getDynamicObject("currency"));
        this.getModel().setValue("contractdrawamt", (Object)contractBill.getBigDecimal("drawamount"));
        this.getModel().setValue("notrepayamt", (Object)contractBill.getBigDecimal("notrepayamount"));
        this.getModel().setValue("datasource", (Object)contractBill.getString("datasource"));
        if ("fl_rentpay_apply".equals(this.getView().getEntityId())) {
            DynamicObjectCollection rentPlans = contractBill.getDynamicObjectCollection("entry_rentplan");
            Optional<DynamicObject> firstPlan = rentPlans.stream().filter(v -> "unexecute".equals(v.getString("executestatus"))).findFirst();
            if (firstPlan.isPresent()) {
                DynamicObject rentPlan = firstPlan.get();
                this.getModel().setValue("prerepaydate", (Object)rentPlan.getDate("paydate"));
                this.getModel().setValue("totalamt", (Object)rentPlan.getBigDecimal("rentamt"));
                this.getModel().setValue("amount", (Object)rentPlan.getBigDecimal("principal"));
                this.getModel().setValue("instamt", (Object)rentPlan.getBigDecimal("intamt"));
            }
        } else {
            this.getModel().setValue("loancurrency", (Object)contractBill.getDynamicObject("currency"));
            if (EmptyUtil.isNoEmpty((DynamicObject)loanBill)) {
                this.getModel().setValue("loancurrency", (Object)loanBill.getDynamicObject("currency"));
            }
        }
    }

    private void setPreRepayDate(DynamicObject loanBill, boolean isRepayByPlan) {
        DynamicObjectCollection repayPlanEntrys;
        DynamicObject repayPlanEntry;
        if (isRepayByPlan && EmptyUtil.isNoEmpty((DynamicObject)(repayPlanEntry = (repayPlanEntrys = loanBill.getDynamicObjectCollection("repayplan_entry")).stream().filter(o -> o.getBigDecimal("enotrepayamount").compareTo(BigDecimal.ZERO) > 0).filter(o -> o.getInt("repaystate") == 0).min(Comparator.comparing(c -> c.getDate("exrepaymentdate"))).orElseGet(null)))) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"prerepaydate", (Object)repayPlanEntry.getDate("exrepaymentdate"));
        }
    }

    private String getContractFormId(String entityName) {
        String formId = "cfm_loancontractbill";
        if ("fl_rentpay_apply".equals(entityName)) {
            formId = "fl_leasecontractbill";
        } else if ("cfm_repayapplybill_bond".equals(entityName)) {
            formId = "cfm_loancontract_bo";
        }
        return formId;
    }

    private String getLoanFormId(String entityName) {
        String formId = "cfm_loanbill";
        if ("fl_rentpay_apply".equals(entityName)) {
            formId = "fl_receiptbill";
        } else if ("cfm_repayapplybill_bond".equals(entityName)) {
            formId = "cfm_loanbill_bond";
        }
        return formId;
    }

    private void showBillF7(String formId, QFilter filter) {
        ListShowParameter lsp = ShowFormHelper.createShowListForm((String)formId, (boolean)false, (int)2);
        lsp.setCustomParam("ismergerows", (Object)Boolean.FALSE);
        lsp.getListFilterParameter().getQFilters().add(filter);
        logger.info("show\u7684\u5355\u636e\u5e03\u5c40\u662f" + formId + "\u8fc7\u6ee4\u6761\u4ef6\u662f:" + lsp.getListFilterParameter().getQFilters());
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, SELECTBILLNO_CLOSECALLBACK);
        lsp.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)lsp);
    }

    private void calInt(int index) {
        IntBillExtInfo intBill;
        if (!BillStatusEnum.SAVE.getValue().equals(this.getModel().getValue("billstatus"))) {
            return;
        }
        DynamicObject loansEntry = this.getModel().getEntryRowEntity("loans", index);
        DynamicObject loanBillF7 = loansEntry.getDynamicObject("e_loanbill");
        if (EmptyUtil.isEmpty((DynamicObject)loanBillF7)) {
            return;
        }
        DynamicObject loanBill = TmcDataServiceHelper.loadSingle((Object)loanBillF7.getPkValue(), (String)"cfm_loanbill");
        DynamicObject loanContract = loanBill.getDynamicObject("loancontractbill");
        loanContract = TmcDataServiceHelper.loadSingle((Object)loanContract.get("id"), (String)"cfm_loancontractbill", (String)"id,billno,productfactory,repaymentway");
        AbstractBizResource bizResource = new BizResourceFactory().getBizResource(loanBill.getString("datasource"));
        boolean isPayInst = (Boolean)this.getModel().getValue("e_ispayinst", index);
        if (!isPayInst) {
            return;
        }
        String msg = this.vailRepayDate(bizResource, index);
        if (EmptyUtil.isNotEmpty((CharSequence)msg)) {
            return;
        }
        BigDecimal repayAmount = (BigDecimal)this.getModel().getValue("e_repayamount", index);
        if (repayAmount == null || repayAmount.compareTo(BigDecimal.ZERO) <= 0) {
            return;
        }
        Date repayDate = (Date)this.getModel().getValue("prerepaydate");
        String error = LoanBillHelper.verifyLastEntIntDate((DynamicObject)loanBill, (Date)repayDate);
        if (EmptyUtil.isNoEmpty((String)error)) {
            this.getView().showTipNotification(error);
            return;
        }
        Date lastPayInstDate = loanBill.getDate("lastpayinstdate");
        if (lastPayInstDate != null && repayDate.compareTo(lastPayInstDate) < 0) {
            this.getView().showTipNotification(String.format(bizResource.getRbPayinterestDateMin(), DateUtils.formatString((Date)lastPayInstDate, (String)"yyyy-MM-dd")));
            return;
        }
        Date instDate = loanBill.getDate("bizdate");
        if (instDate != null && repayDate.compareTo(instDate) <= 0) {
            this.getView().showTipNotification(String.format(bizResource.getRepayAndInstdateCompare(), DateUtils.formatString((Date)instDate, (String)"yyyy-MM-dd")));
            return;
        }
        try {
            intBill = RepaymentbillHelper.getIntBillInfo((DynamicObject)loanContract, (DynamicObject)loanBill, (Date)repayDate, (BigDecimal)repayAmount);
        }
        catch (TmcBizException e) {
            this.getView().showTipNotification(e.getMessage());
            return;
        }
        IDataModel model = this.getModel();
        if (intBill == null) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"e_ispayinst", (Object)Boolean.FALSE, (int)index);
            model.setValue("e_calintamt", (Object)BigDecimal.ZERO, index);
            model.setValue("e_combineinst", (Object)Boolean.FALSE, index);
            model.setValue("e_preintamt", (Object)BigDecimal.ZERO, index);
            this.getView().showTipNotification(bizResource.getcanNotcalIntamt());
            return;
        }
        model.setValue("e_calintamt", (Object)intBill.getAmount(), index);
        model.setValue("e_preintamt", (Object)intBill.getAmount(), index);
        model.setValue("intdetail_tag", (Object)SerializationUtils.toJsonString((Object)intBill), index);
        Date startIntDate = loanBill.getDate("startintdate");
        if (intBill == null && startIntDate != null && repayDate.compareTo(startIntDate) <= 0) {
            this.getView().showTipNotification(String.format(bizResource.getStartinterestDate(), DateUtils.formatString((Date)startIntDate, (String)"yyyy-MM-dd")), Integer.valueOf(6000));
        }
    }

    private String vailRepayDate(AbstractBizResource bizResource, int index) {
        Object loanbill = this.getModel().getValue("e_loanbill", index);
        if (EmptyUtil.isEmpty((Object)loanbill)) {
            return bizResource.getRbLoanbillNotNull();
        }
        Date repayDate = (Date)this.getModel().getValue("bizdate");
        if (repayDate == null) {
            return bizResource.getRbRepayDateNotNull();
        }
        return "";
    }

    private void showIntDetailForm(int index) {
        FormShowParameter parameter = new FormShowParameter();
        DynamicObject entry = this.getModel().getEntryRowEntity("loans", index);
        if (!entry.getBoolean("e_ispayinst")) {
            return;
        }
        if (EmptyUtil.isEmpty((BigDecimal)entry.getBigDecimal("e_calintamt"))) {
            return;
        }
        if (EmptyUtil.isEmpty((String)entry.getString("intdetail_tag"))) {
            this.fillInterestCalAndSave(entry.getDynamicObject("e_loanbill"));
        }
        Map customParams = parameter.getCustomParams();
        customParams.put("loanbillid", entry.getDynamicObject("e_loanbill").getLong("id"));
        customParams.put("intdetail", entry.getString("intdetail_tag"));
        customParams.put("currency", ((DynamicObject)this.getModel().getValue("loancurrency")).getPkValue());
        parameter.setStatus(OperationStatus.VIEW);
        parameter.setFormId(this.getIntDetailFormId(entry));
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(parameter);
    }

    private void fillInterestCalAndSave(DynamicObject loanBillF7) {
        if (EmptyUtil.isEmpty((DynamicObject)loanBillF7)) {
            return;
        }
        Long repaymentBillId = (Long)this.getModel().getValue("id");
        if (repaymentBillId == null || repaymentBillId.intValue() == 0) {
            return;
        }
        QFilter instFilter = new QFilter("sourcebillid", "=", loanBillF7.getPkValue()).and(new QFilter("repaymentid", "=", (Object)repaymentBillId));
        DynamicObject interestBill = TmcDataServiceHelper.loadSingle((String)"cfm_interestbill", (String)String.join((CharSequence)",", repayProps), (QFilter[])new QFilter[]{instFilter});
        if (EmptyUtil.isEmpty((DynamicObject)interestBill)) {
            return;
        }
        this.getModel().setValue("intdetail_tag", (Object)SerializationUtils.toJsonString((Object)this.genIntDetail(interestBill)));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.getModel().getDataEntity()});
    }

    private IntBillInfo genIntDetail(DynamicObject interestBill) {
        IntBillInfo detail = new IntBillInfo();
        detail.setAmount(interestBill.getBigDecimal("amount"));
        detail.setBizDate(interestBill.getDate("bizdate"));
        DynamicObjectCollection entrys = interestBill.getDynamicObjectCollection("entrys");
        int index = 0;
        ArrayList<IntBillDetailInfo> intDetails = new ArrayList<IntBillDetailInfo>(16);
        for (DynamicObject entry : entrys) {
            IntBillDetailInfo intDetail = new IntBillDetailInfo();
            intDetail.setPrinciple(entry.getBigDecimal("instprincipalamt"));
            intDetail.setDays(entry.getInt("instdays"));
            intDetail.setBeginDate(entry.getDate("inststartdate"));
            intDetail.setEndDate(entry.getDate("instenddate"));
            InterTypeEnum intType = InterTypeEnum.valueOf((String)entry.getString("instctg"));
            intDetail.setIntType(intType);
            intDetail.setBasisDay(entry.getInt("ratetrandays"));
            intDetail.setAmount(entry.getBigDecimal("instamt"));
            intDetail.setRate(entry.getBigDecimal("rate"));
            intDetail.setSeq(index++);
            intDetails.add(intDetail);
        }
        detail.setDetails(intDetails);
        return detail;
    }

    private String getIntDetailFormId(DynamicObject entry) {
        DynamicObject loanBill = entry.getDynamicObject("e_loanbill");
        if (EmptyUtil.isEmpty((DynamicObject)loanBill)) {
            return "ifm_intbill_detail";
        }
        if ((loanBill = TmcDataServiceHelper.loadSingle((Object)loanBill.getPkValue(), (String)"cfm_loanbill")).getBoolean("issofrrate")) {
            return "ifm_intbillsofr_detail";
        }
        return "ifm_intbill_detail";
    }

    private void isPayInstChgEvt(PropertyChangedArgs e) {
        Boolean ispayinst = (Boolean)this.getModel().getValue("e_ispayinst");
        int index = e.getChangeSet()[0].getRowIndex();
        if (!ispayinst.booleanValue()) {
            TmcViewInputHelper.clearValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (int)index, (String[])new String[]{"e_preintamt", "e_calintamt", "intdetail_tag"});
            this.getView().setEnable(Boolean.valueOf(false), index, new String[]{"e_preintamt", "e_calintamt"});
        } else {
            this.calInt(index);
            this.getView().setEnable(Boolean.valueOf(true), index, new String[]{"e_preintamt", "e_calintamt"});
        }
        this.calcTotalAmt();
    }

    private void calcTotalAmt() {
        BigDecimal totalRepayAmt = this.getAllEntryRowsAmt("e_repayamount");
        BigDecimal totalActintAmt = this.getAllEntryRowsAmt("e_preintamt");
        this.getModel().setValue("totalamt", (Object)totalRepayAmt.add(totalActintAmt));
        this.getModel().setValue("instamt", (Object)totalActintAmt);
    }

    private void isRepayByPlanValidate(boolean isRepayByPlan, DynamicObject[] loanBills, String dataSource) {
        if (isRepayByPlan && loanBills.length > 1 && CfmContractBillHelper.isCanNotRepay((DynamicObject[])loanBills)) {
            AbstractBizResource bizResource = new BizResourceFactory().getBizResource(dataSource);
            throw new KDBizException(bizResource.getrepayByPlanLoansCheck());
        }
    }

    private DynamicObject[] getLoanBills(Object pkId) {
        QFilter filter = new QFilter("loancontractbill.id", "=", pkId).and("notrepayamount", ">", (Object)0).and(new QFilter("drawtype", "in", Arrays.asList(DrawTypeEnum.DRAWED.getValue(), DrawTypeEnum.PARTPAYMENT.getValue())));
        return TmcDataServiceHelper.load((String)"cfm_loanbill", (String)SELECTS, (QFilter[])filter.toArray());
    }

    private DynamicObject getLoanBill(Object pkId) {
        Map map = TmcDataServiceHelper.loadFromCache((String)"cfm_loanbill", (QFilter[])new QFilter[]{new QFilter("id", "=", pkId)});
        if (map == null || map.isEmpty()) {
            return null;
        }
        Object[] loanBills = map.values().toArray(new DynamicObject[0]);
        if (EmptyUtil.isEmpty((Object[])loanBills)) {
            return null;
        }
        return loanBills[0];
    }

    private DynamicObject getContractBill(Object pkId) {
        String flieds = "id, org, currency, drawamount, notrepayamount, loantype, datasource, creditortype, productfactory, creditorg, repaymentway, accountbank, loaneracctbank";
        String entityName = "cfm_loancontractbill";
        if ("fl_rentpay_apply".equals(this.getView().getEntityId())) {
            flieds = flieds + ", startdate, enddate, leasehold, entry_rentplan, paydate, rentamt, principal, intamt, executestatus";
            entityName = "fl_leasecontractbill";
        }
        return TmcDataServiceHelper.loadSingle((Object)pkId, (String)entityName, (String)flieds);
    }
}

