/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.repaymentbill;

import java.math.BigDecimal;
import java.util.Comparator;
import java.util.Date;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.tmc.cfm.common.helper.CfmContractBillHelper;
import kd.tmc.cfm.common.helper.LoanBillHelper;
import kd.tmc.cfm.common.helper.RepaymentbillHelper;
import kd.tmc.cfm.common.repository.RepaymentBillRepository;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.RepaymentWayEnum;
import kd.tmc.fbp.common.helper.SuretyHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class RepaymentBillConvertPlugin
extends AbstractConvertPlugIn {
    private static final Log logger = LogFactory.getLog(RepaymentBillConvertPlugin.class);

    public void afterConvert(AfterConvertEventArgs e) {
        super.afterConvert(e);
        ExtendedDataEntitySet targetExtDataEntitySet = e.getTargetExtDataEntitySet();
        String entityName = this.getTgtMainType().getName();
        ExtendedDataEntity[] extendedDataEntities = targetExtDataEntitySet.FindByEntityKey(entityName);
        Map variables = this.getOption().getVariables();
        String autoRepay = (String)variables.get("auto");
        logger.info("\u81ea\u52a8\u8fd8\u6b3e:autoPre=" + autoRepay);
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
            DynamicObject repaymentBill = extendedDataEntity.getDataEntity();
            if ("true".equals(autoRepay)) {
                repaymentBill.set("auto", (Object)"1");
            }
            repaymentBill.set("billstatus", (Object)BillStatusEnum.SAVE.getValue());
            this.initRepaymentBill(repaymentBill);
        }
    }

    private void initRepaymentBill(DynamicObject repaymentBill) {
        this.initByPlan(repaymentBill);
        this.setSuretyEntry(repaymentBill);
        RepaymentbillHelper.setSlBankRepayDefaultEntrys((DynamicObject)repaymentBill, (String)"e_repayamount", (String)"s_repayamount");
        RepaymentbillHelper.setSlBankRepayDefaultEntrys((DynamicObject)repaymentBill, (String)"e_actintamt", (String)"s_repayinst");
    }

    private void setSuretyEntry(DynamicObject repaymentBill) {
        DynamicObject suretyBill = this.getSuretyBill(repaymentBill);
        if (null != suretyBill) {
            DynamicObject suretyEntry = repaymentBill.getDynamicObjectCollection("entry_surety").addNew();
            suretyEntry.set("suretybill", (Object)suretyBill);
            suretyEntry.set("suretyinvestorgtype", (Object)suretyBill.getString("investorgtype"));
            suretyEntry.set("suretyfinorg", suretyBill.get("finorginfo"));
            suretyEntry.set("suretyfinorgother", (Object)suretyBill.getString("finorgother"));
            suretyEntry.set("suretyaccount", suretyBill.get("settleaccount"));
            suretyEntry.set("suretycurrency", suretyBill.get("currency"));
            suretyEntry.set("suretyamount", (Object)suretyBill.getBigDecimal("amount"));
            suretyEntry.set("suretysurplusamount", (Object)suretyBill.getBigDecimal("surplusamount"));
            suretyEntry.set("suretyintdate", (Object)suretyBill.getDate("intdate"));
            suretyEntry.set("suretyterm", (Object)suretyBill.getString("term"));
            suretyEntry.set("suretyexpiredate", (Object)suretyBill.getDate("expiredate"));
        }
    }

    private DynamicObject getSuretyBill(DynamicObject repaymentBill) {
        DynamicObject loanContract = repaymentBill.getDynamicObject("loancontractbill");
        if (EmptyUtil.isEmpty((Object)loanContract)) {
            return null;
        }
        return SuretyHelper.loadSuretyBillByDebit((Long)loanContract.getLong("id"));
    }

    private void initByPlan(DynamicObject repaymentBill) {
        boolean isRepayByPlan = CfmContractBillHelper.isRepayByPlan((DynamicObject)repaymentBill);
        DynamicObjectCollection repayLoanEntrys = repaymentBill.getDynamicObjectCollection("loans");
        Date headRepayDate = DateUtils.getCurrentDate();
        BigDecimal headRepayAmt = BigDecimal.ZERO;
        BigDecimal headIntAmt = BigDecimal.ZERO;
        for (DynamicObject repayLoanEntry : repayLoanEntrys) {
            DynamicObject repayAccount;
            DynamicObject loanBillF7 = repayLoanEntry.getDynamicObject("e_loanbill");
            String repayWays = loanBillF7.getString("repaymentway");
            if (repayLoanEntrys.size() > 1 && (repayWays.contains(RepaymentWayEnum.debx.getValue()) || repayWays.contains(RepaymentWayEnum.debj.getValue()) || repayWays.contains(RepaymentWayEnum.dbdx.getValue()))) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7b26\u5408\u6761\u4ef6\u7684\u5355\u636e\u6709\u591a\u4e2a,\u8be5\u8fd8\u6b3e/\u6536\u56de\u65b9\u5f0f\u4e0d\u652f\u6301\u8be5\u6279\u91cf\u64cd\u4f5c\u3002", (String)"RepaymentBillConvertPlugin_01", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
            }
            DynamicObject[] loanbills = this.getLoanBills(loanBillF7);
            this.setEntryAmount(repayLoanEntry, loanBillF7);
            if (null == loanbills || loanbills.length <= 0) continue;
            DynamicObjectCollection intPlanEntrys = loanbills[0].getDynamicObjectCollection("interest_entry");
            DynamicObjectCollection repayPlanEntrys = loanbills[0].getDynamicObjectCollection("repayplan_entry");
            DynamicObject repayPlanEntry = repayPlanEntrys.stream().filter(o -> o.getBigDecimal("enotrepayamount").compareTo(BigDecimal.ZERO) > 0).filter(o -> o.getInt("repaystate") == 0).min(Comparator.comparing(c -> c.getDate("exrepaymentdate"))).orElseGet(null);
            if (!EmptyUtil.isNoEmpty((DynamicObject)repayPlanEntry)) continue;
            Date exRepaymentDate = repayPlanEntry.getDate("exrepaymentdate");
            BigDecimal enotRepayAmount = repayPlanEntry.getBigDecimal("enotrepayamount");
            BigDecimal payIntAmt = BigDecimal.ZERO;
            if (repayLoanEntry.getBoolean("e_ispayinst") && EmptyUtil.isNoEmpty((DynamicObjectCollection)intPlanEntrys)) {
                payIntAmt = intPlanEntrys.stream().filter(o -> o.getDate("interesdate").compareTo(exRepaymentDate) == 0).filter(o -> o.getInt("intstate") == 0).map(o -> o.getBigDecimal("interestcalamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
                repayLoanEntry.set("e_actintamt", (Object)payIntAmt);
                headIntAmt = headIntAmt.add(payIntAmt);
            }
            repayLoanEntry.set("e_repayamount", (Object)enotRepayAmount);
            BigDecimal convertRate = loanBillF7.getBigDecimal("convertrate");
            convertRate = convertRate.compareTo(BigDecimal.ZERO) > 0 ? convertRate : BigDecimal.ONE;
            repayLoanEntry.set("e_convertactintamt", (Object)payIntAmt.multiply(convertRate));
            repayLoanEntry.set("e_convertrepayamt", (Object)enotRepayAmount.multiply(convertRate));
            this.setConvertRepayAmt(loanBillF7, repayLoanEntry, enotRepayAmount);
            headRepayAmt = headRepayAmt.add(enotRepayAmount);
            if (exRepaymentDate.compareTo(headRepayDate) > 0 || isRepayByPlan) {
                headRepayDate = exRepaymentDate;
            }
            if ((repayAccount = repayPlanEntry.getDynamicObject("repayaccount")) == null) continue;
            repaymentBill.set("accountbank", (Object)repayAccount);
        }
        repaymentBill.set("bizdate", (Object)headRepayDate);
        repaymentBill.set("amount", (Object)headRepayAmt);
        repaymentBill.set("totalamt", (Object)headRepayAmt.add(headIntAmt));
    }

    private void setEntryAmount(DynamicObject repayLoanEntry, DynamicObject loanBillF7) {
        BigDecimal lockinamount = LoanBillHelper.calLockInAmout((Long)loanBillF7.getLong("id"));
        BigDecimal repayableamount = loanBillF7.getBigDecimal("drawamount").subtract(lockinamount);
        repayLoanEntry.set("e_repayableamount", (Object)repayableamount);
        repayLoanEntry.set("e_repayamount", (Object)repayableamount);
        BigDecimal convertRate = loanBillF7.getBigDecimal("convertrate");
        convertRate = convertRate.compareTo(BigDecimal.ZERO) > 0 ? convertRate : BigDecimal.ONE;
        repayLoanEntry.set("e_convertrepayamt", (Object)repayableamount.multiply(convertRate));
    }

    private DynamicObject[] getLoanBills(DynamicObject loanBillF7) {
        QFilter qFilter = new QFilter("id", "=", loanBillF7.getPkValue()).and("repayplan_entry.enotrepayamount", ">", (Object)0);
        Map map = TmcDataServiceHelper.loadFromCache((String)"cfm_loanbill", (QFilter[])qFilter.toArray());
        if (map != null && !map.isEmpty()) {
            return map.values().toArray(new DynamicObject[0]);
        }
        return null;
    }

    private void setConvertRepayAmt(DynamicObject loanBillF7, DynamicObject repayLoanEntry, BigDecimal repayAmt) {
        if (repayAmt.compareTo(loanBillF7.getBigDecimal("notrepayamount")) == 0) {
            BigDecimal yetRepayAmt = RepaymentBillRepository.getRepayAmountByLoanBillId((Long)loanBillF7.getLong("id"));
            logger.info("\u6700\u540e\u4e00\u6b21\u8fd8\u6b3e\uff0c\u5df2\u8fd8\u91d1\u989d yetRepayAmt=" + yetRepayAmt);
            repayLoanEntry.set("e_convertrepayamt", (Object)loanBillF7.getBigDecimal("convertdrawamt").subtract(yetRepayAmt));
        }
    }
}

