/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.repaymentbill;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.FilterContainerInitEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cfm.common.enums.LoanTypeEnum;
import kd.tmc.cfm.common.helper.CfmBillCommonHelper;
import kd.tmc.cfm.common.helper.IfmBizDealHelper;
import kd.tmc.cfm.common.resource.BizResourceFactory;
import kd.tmc.cfm.formplugin.common.CfmPush2PayFormOrListHelper;
import kd.tmc.cfm.formplugin.common.CommonBillFormHelper;
import kd.tmc.cfm.formplugin.helper.CfmFormHelper;
import kd.tmc.fbp.common.enums.CreditorTypeEnum;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.list.AbstractTmcListPlugin;
import org.apache.commons.lang3.StringUtils;

public class RepaymentBillList
extends AbstractTmcListPlugin {
    private static final Log logger = LogFactory.getLog(RepaymentBillList.class);

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String isshowtoolbarap = (String)formShowParameter.getCustomParam("isshowtoolbarap");
        if (null != isshowtoolbarap && isshowtoolbarap.equals("no")) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"filtercontainerap"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"toolbarap"});
        }
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        CfmBillCommonHelper.PreOpenPageDeal((PreOpenFormEventArgs)e, (boolean)true);
    }

    public void setFilter(SetFilterEvent e) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String bizType = (String)parameter.getCustomParam("biztype");
        List qFilters = e.getQFilters();
        String formId = ((ListShowParameter)this.getView().getFormShowParameter()).getBillFormId();
        if (EmptyUtil.isNoEmpty((String)bizType)) {
            qFilters.add(new QFilter("loantype", "in", (Object)bizType.split(",")));
        } else {
            String compareStr = "fl_rentpaybill".equals(formId) ? "=" : "!=";
            qFilters.add(new QFilter("loantype", compareStr, (Object)LoanTypeEnum.FINLEASE.getValue()));
        }
        if (formId.startsWith("ifm_")) {
            QFilter qFilter = new QFilter("settlestatus", "in", Arrays.asList("addnew", "accept")).and("creditortype", "=", (Object)CreditorTypeEnum.SETTLECENTER.getValue());
            qFilters.add(qFilter);
        } else if (formId.startsWith("cfm_") || formId.startsWith("cim_")) {
            qFilters.add(new QFilter("settlestatus", "!=", (Object)"addnew"));
            if (!CfmBillCommonHelper.isRelateAppSet((String)TmcAppEnum.CFM.getValue())) {
                qFilters.add(new QFilter("creditortype", "!=", (Object)CreditorTypeEnum.SETTLECENTER.getValue()));
            }
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        Object param;
        FilterContainerInitEvent filterContainerInitEvent = args.getFilterContainerInitEvent();
        List filterColumnList = filterContainerInitEvent.getCommonFilterColumns();
        CommonFilterColumn bizDateFilterCol = filterColumnList.stream().filter(filterCol -> StringUtils.equals((CharSequence)filterCol.getFieldName(), (CharSequence)"bizdate")).findFirst().orElse(null);
        if (bizDateFilterCol == null) {
            return;
        }
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String isshowtoolbarap = (String)formShowParameter.getCustomParam("isshowtoolbarap");
        if (null != isshowtoolbarap && isshowtoolbarap.equals("no")) {
            bizDateFilterCol.setDefaultValue(null);
        }
        if (null != (param = formShowParameter.getCustomParam("filter"))) {
            QFilter qfilter = QFilter.fromSerializedString((String)param.toString());
            String property = qfilter.getProperty();
            Object value = qfilter.getValue();
            String cp = qfilter.getCP();
            for (FilterColumn filterColumn : args.getFilterContainerInitEvent().getCommonFilterColumns()) {
                CommonFilterColumn commonFilter = (CommonFilterColumn)filterColumn;
                if (commonFilter.getFieldName().equals(property)) {
                    if (StringUtils.equals((CharSequence)"in", (CharSequence)cp) && value != null) {
                        ArrayList<String> values = new ArrayList<String>(Arrays.asList((String[])value));
                        commonFilter.setDefaultValues(values);
                        continue;
                    }
                    commonFilter.setDefaultValue(value == null ? "" : value.toString());
                    continue;
                }
                commonFilter.setDefaultValue(null);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        CfmPush2PayFormOrListHelper.listPush2PayForwardValid(args, this.getView());
        switch (operateKey) {
            case "pushbizdealbill": {
                this.validatePush2SettleCenter(args);
                break;
            }
            case "pushandsave2pay": 
            case "generatevoucher": {
                CfmBillCommonHelper.checkUnAuditIntBill((BeforeDoOperationEventArgs)args, (IFormView)this.getView());
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String opKey = args.getOperateKey();
        OperationResult operationResult = args.getOperationResult();
        switch (opKey) {
            case "trackinterest": {
                this.traceInterestBill(args);
                break;
            }
            case "audit": 
            case "pushandsave2pay": {
                if (operationResult == null || !operationResult.isSuccess()) break;
                this.getView().invokeOperation("refresh");
                break;
            }
        }
    }

    private void traceInterestBill(AfterDoOperationEventArgs args) {
        BillShowParameter showParameter;
        List selectedRows = args.getOperationResult().getSuccessPkIds();
        if (EmptyUtil.isEmpty((Collection)selectedRows)) {
            this.getView().showTipNotification(new BizResourceFactory().getBizResource("").getRbTrackNotselectrow());
            return;
        }
        ArrayList<Long> billIds = new ArrayList<Long>(selectedRows.size());
        for (Object row : selectedRows) {
            billIds.add((Long)row);
        }
        DynamicObjectCollection repaymentbills = QueryServiceHelper.query((String)"cfm_repaymentbill", (String)"id,datasource", (QFilter[])new QFilter[]{new QFilter("id", "in", billIds)});
        HashSet<String> datasourceKings = new HashSet<String>();
        if (!repaymentbills.isEmpty()) {
            for (DynamicObject repaymentbill : repaymentbills) {
                String datasource = repaymentbill.getString("datasource");
                datasourceKings.add(datasource);
            }
        }
        if (datasourceKings.size() > 1) {
            this.getView().showTipNotification(new BizResourceFactory().getBizResource("").getIbDatasourcediff());
            return;
        }
        DynamicObjectCollection targetBills = QueryServiceHelper.query((String)"cfm_interestbill", (String)"id", (QFilter[])new QFilter[]{new QFilter("repaymentid", "in", billIds)});
        if (EmptyUtil.isEmpty((DynamicObjectCollection)targetBills)) {
            this.getView().showTipNotification(new BizResourceFactory().getBizResource("").getRbNotTrackdata());
            return;
        }
        if (targetBills.size() == 1) {
            showParameter = new BillShowParameter();
            showParameter.setPkId(((DynamicObject)targetBills.get(0)).get("id"));
            showParameter.setFormId(CommonBillFormHelper.getInterestFormId(this.getView()));
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setCustomParam("isshowtoolbarap", (Object)"no");
            this.getView().showForm((FormShowParameter)showParameter);
        } else {
            showParameter = new ListShowParameter();
            showParameter.setIsolationOrg(false);
            showParameter.setBillFormId(CommonBillFormHelper.getInterestFormId(this.getView()));
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>(16);
            HashSet<Object> pks = new HashSet<Object>(targetBills.size());
            for (DynamicObject targetBill : targetBills) {
                pks.add(targetBill.get("id"));
            }
            qFilters.add(new QFilter("id", "in", pks));
            showParameter.getListFilterParameter().setQFilters(qFilters);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setCustomParam("isshowtoolbarap", (Object)"no");
            showParameter.setShowFilter(false);
            showParameter.setShowQuickFilter(false);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        if (parameter.getCustomParams().containsKey("biztype")) {
            String bizType = (String)parameter.getCustomParam("biztype");
            e.getParameter().getCustomParams().put("biztype", bizType);
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        String fieldName;
        switch (fieldName = args.getFieldName()) {
            case "paybill_number": {
                CfmFormHelper.showPayBillList(args, this.getView());
                break;
            }
        }
    }

    private void validatePush2SettleCenter(BeforeDoOperationEventArgs args) {
        List repayIds = this.getSelectedIdList();
        if (EmptyUtil.isEmpty((Collection)repayIds)) {
            return;
        }
        IfmBizDealHelper.validatePush2SettleCenter((IFormView)this.getView(), (String)"cfm_repaymentbill", (List)repayIds, (BeforeDoOperationEventArgs)args);
    }
}

