/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.scheme;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterDeleteEntryEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cfm.common.enums.LoanTypeEnum;
import kd.tmc.cfm.common.enums.RateSignEnum;
import kd.tmc.fbp.common.enums.CreditorTypeEnum;
import kd.tmc.fbp.common.enums.InterestTypeEnum;
import kd.tmc.fbp.common.helper.MarketDataServiceHelper;
import kd.tmc.fbp.common.helper.TermHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.bd.TmcBaseDataEdit;

public class FinancingSchemeEdit
extends TmcBaseDataEdit
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit loanApplyF7 = (BasedataEdit)this.getControl("loanapply");
        loanApplyF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners(new String[]{"e_textcost"});
        BasedataEdit referRateF7 = (BasedataEdit)this.getControl("referrate");
        referRateF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit finProductF7 = (BasedataEdit)this.getControl("finproduct");
        finProductF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void click(EventObject evt) {
        TextEdit e;
        String fieldKey;
        super.click(evt);
        if (evt.getSource() instanceof TextEdit && "e_textcost".equals(fieldKey = (e = (TextEdit)evt.getSource()).getFieldKey())) {
            BasedataEdit control = (BasedataEdit)this.getControl("samplecost");
            control.click();
        }
    }

    public void beforeBindData(EventObject e) {
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String propName = evt.getProperty().getName();
        if ("loanapply".equals(propName)) {
            this.initLoanApplyFilter(evt);
        } else if ("referrate".equals(propName)) {
            this.initReferRateFilter(evt);
        } else if ("finproduct".equals(propName)) {
            this.initFinproductFilter(evt);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object cacheOrgId = customParams.get("mainOrgId");
        if (null != cacheOrgId) {
            this.getModel().setValue("org", (Object)Long.valueOf(cacheOrgId.toString()));
        }
        this.getModel().setValue("e_textcost", (Object)ResManager.loadKDString((String)"\u5229\u606f", (String)"FinancingSchemeEdit_2", (String)"tmc-cfm-formplugin", (Object[])new Object[0]), 0);
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        String interestType = (String)this.getModel().getValue("interesttype");
        if (InterestTypeEnum.isAgree((String)interestType)) {
            this.getModel().setValue("interesttype", (Object)InterestTypeEnum.FIXED.getValue());
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initCreditorTypeComb();
        this.getView().setEnable(Boolean.valueOf(false), 0, new String[]{"e_textcost", "e_interestrate", "e_costamt"});
        this.getModel().setDataChanged(false);
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        super.beforeDeleteRow(e);
        EntryProp entryProp = e.getEntryProp();
        if ("entry".equals(entryProp.getName()) && e.getRowIndexs()[0] == 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5229\u606f\u884c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"FinancingSchemeEdit_0", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        IDataEntityProperty iDataEntityProperty = args.getProperty();
        String propertyName = iDataEntityProperty.getName();
        ChangeData[] changeData = args.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        Object oldValue = changeData[0].getOldValue();
        switch (propertyName) {
            case "interesttype": {
                this.interestTypeChgEvt();
                break;
            }
            case "e_costamt": {
                this.calcCompcost();
                break;
            }
            case "startdate": 
            case "enddate": {
                this.termDateChgEvt(propertyName, (Date)oldValue);
                break;
            }
            case "term": {
                this.termChgEvt();
                break;
            }
            case "amount": 
            case "compcost": {
                this.calcCompcostRate();
                this.calcInterestCostAmt();
                break;
            }
            case "samplecost": {
                this.sampleCostChgEvt();
                break;
            }
            case "interestrate": {
                this.getModel().setValue("e_interestrate", this.getModel().getValue("interestrate"), 0);
                this.calcInterestCostAmt();
                break;
            }
            case "referrate": {
                this.getView().updateView(propertyName, 0);
                this.calcInterestCostAmt();
                this.calcInterestrate();
                break;
            }
            case "loanapply": {
                this.loanapplyChgEvt();
                break;
            }
            case "ratefloatpoint": 
            case "ratesign": {
                this.calcInterestrate();
                break;
            }
            case "ratecyclesign": {
                if (!EmptyUtil.isEmpty((Object)this.getModel().getValue("ratecyclesign"))) break;
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"ratecyclesign", (Object)"M");
                break;
            }
            case "fintype": {
                this.initCreditorTypeComb();
                break;
            }
            case "finproduct": {
                this.autoWriteRateInfo();
                break;
            }
            case "creditortype": {
                if (!CreditorTypeEnum.SETTLECENTER.getValue().equals(newValue) && !CreditorTypeEnum.SETTLECENTER.getValue().equals(oldValue)) break;
                this.getModel().setValue("finproduct", null);
                break;
            }
        }
    }

    public void afterDeleteEntry(AfterDeleteEntryEventArgs e) {
        super.afterDeleteEntry(e);
        String entryName = e.getEntryProp().getName();
        if ("entry".equals(entryName)) {
            this.calcCompcost();
        }
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        Control source = (Control)e.getSource();
        String key = source.getKey();
        Object value = e.getValue();
        this.verifyInput(key, value, e);
    }

    private void interestTypeChgEvt() {
        this.registerMustInput();
        this.calcInterestCostAmt();
        this.calcCompcost();
    }

    private void termChgEvt() {
        this.calcEndDate();
        this.calcCompcostRate();
        this.calcInterestCostAmt();
    }

    private void termDateChgEvt(String propName, Date oldValue) {
        if (!this.checkDate()) {
            if (StringUtils.equals((CharSequence)"startdate", (CharSequence)propName)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u9884\u8ba1\u5f00\u59cb\u65e5\u5fc5\u987b\u5c0f\u4e8e\u9884\u8ba1\u7ed3\u675f\u65e5\u671f\u3002", (String)"FinSchemeInfoEdit_0", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u9884\u8ba1\u7ed3\u675f\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u9884\u8ba1\u5f00\u59cb\u65e5\u3002", (String)"FinSchemeInfoEdit_1", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
            }
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)propName, (Object)oldValue);
            return;
        }
        this.calcTerm();
        this.calcInterestCostAmt();
    }

    private boolean checkDate() {
        Date startDate = (Date)this.getModel().getValue("startdate");
        Date endDate = (Date)this.getModel().getValue("enddate");
        return EmptyUtil.isAnyoneEmpty((Object[])new Object[]{startDate, endDate}) || startDate.compareTo(endDate) < 0;
    }

    private void sampleCostChgEvt() {
        IDataModel model = this.getModel();
        DynamicObject sampleCost = (DynamicObject)model.getValue("samplecost");
        int entryCurrentRowIndex = model.getEntryCurrentRowIndex("entry");
        model.setValue("e_cost", (Object)sampleCost, entryCurrentRowIndex);
        model.setValue("e_textcost", (Object)sampleCost.getString("name"), entryCurrentRowIndex);
    }

    private void loanapplyChgEvt() {
        IDataModel model = this.getModel();
        DynamicObject loanApply = (DynamicObject)model.getValue("loanapply");
        if (null != loanApply) {
            model.setValue("currency", (Object)loanApply.getDynamicObject("currency"));
            model.setValue("amount", (Object)loanApply.getBigDecimal("amount"));
        }
    }

    private void calcInterestrate() {
        DynamicObject referRate;
        IDataModel model = this.getModel();
        String interestType = (String)model.getValue("interesttype");
        if (StringUtils.equals((CharSequence)interestType, (CharSequence)InterestTypeEnum.FIXED.getValue())) {
            return;
        }
        String rateSign = (String)model.getValue("ratesign");
        if (EmptyUtil.isEmpty((String)rateSign)) {
            rateSign = RateSignEnum.ADD.getValue();
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)model, (String)"ratesign", (Object)rateSign);
        }
        if (null == (referRate = (DynamicObject)model.getValue("referrate"))) {
            model.setValue("interestrate", (Object)0);
            return;
        }
        BigDecimal rate = MarketDataServiceHelper.referRate((String)referRate.getString("number"), (Date)new Date(), (boolean)false);
        if (null == rate || BigDecimal.ZERO.compareTo(rate) == 0) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)model, (String)"interestrate", null);
            return;
        }
        BigDecimal rateFloatPoint = (BigDecimal)model.getValue("ratefloatpoint");
        BigDecimal rateFloat = rateFloatPoint.divide(new BigDecimal("100"), 6, RoundingMode.HALF_UP);
        if (StringUtils.equals((CharSequence)RateSignEnum.SUBTRACT.getValue(), (CharSequence)rateSign)) {
            rateFloat = rateFloat.negate();
        }
        model.setValue("interestrate", (Object)rate.add(rateFloat));
    }

    private void calcInterestCostAmt() {
        IDataModel model = this.getModel();
        Date startDate = (Date)model.getValue("startdate");
        Date endDate = (Date)model.getValue("enddate");
        if (EmptyUtil.isEmpty((Object)endDate) || EmptyUtil.isEmpty((Object)startDate)) {
            return;
        }
        int termDays = DateUtils.getDiffDays((Date)startDate, (Date)endDate) - 1;
        BigDecimal amount = (BigDecimal)model.getValue("amount");
        if (EmptyUtil.isEmpty((BigDecimal)amount)) {
            return;
        }
        BigDecimal rate = (BigDecimal)model.getValue("interestrate");
        if (null == rate) {
            model.setValue("e_costamt", (Object)BigDecimal.ZERO, 0);
            return;
        }
        BigDecimal interestCostAmt = rate.multiply(new BigDecimal(termDays)).multiply(amount).divide(new BigDecimal(36000), amount.scale(), 4);
        model.setValue("e_costamt", (Object)interestCostAmt, 0);
    }

    private void registerMustInput() {
        String interestType = (String)this.getModel().getValue("interesttype");
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (!StringUtils.equals((CharSequence)InterestTypeEnum.FIXED.getValue(), (CharSequence)interestType) ? 1 : 0) != 0, (String[])new String[]{"referrate"});
    }

    protected void verifyInput(String key, Object value, BeforeFieldPostBackEvent e) {
        switch (key) {
            case "term": {
                if (TermHelper.isRightFormat((IDataModel)this.getModel(), (IFormView)this.getView(), (String)value.toString())) break;
                e.setCancel(true);
                this.getView().updateView(key);
                return;
            }
        }
    }

    private void calcCompcost() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entry");
        this.getModel().setValue("compcost", (Object)entryGrid.getSum("e_costamt"));
    }

    private void calcCompcostRate() {
        IDataModel model = this.getModel();
        BigDecimal compCost = (BigDecimal)model.getValue("compcost");
        BigDecimal amount = (BigDecimal)model.getValue("amount");
        String term = (String)model.getValue("term");
        if (BigDecimal.ZERO.compareTo(amount) == 0 || EmptyUtil.isEmpty((String)term)) {
            return;
        }
        if (BigDecimal.ZERO.compareTo(compCost) == 0) {
            model.setValue("compcostrate", null);
            return;
        }
        int termDays = DateUtils.getDiffDays((Date)((Date)model.getValue("startdate")), (Date)((Date)model.getValue("enddate"))) - 1;
        if (termDays <= 0) {
            model.setValue("compcostrate", null);
            return;
        }
        BigDecimal compCostRate = compCost.multiply(new BigDecimal(36000)).divide(amount.multiply(new BigDecimal(termDays)), amount.scale(), 4);
        model.setValue("compcostrate", (Object)compCostRate);
    }

    private void calcEndDate() {
        DynamicObject scheme = this.getModel().getDataEntity();
        Date startDate = scheme.getDate("startdate");
        String termStr = scheme.getString("term");
        if (null == startDate || EmptyUtil.isEmpty((String)termStr)) {
            return;
        }
        Date endDate = TermHelper.getDateByTerm((String)termStr, (Date)startDate);
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"enddate", (Object)endDate);
    }

    private void calcTerm() {
        DynamicObject scheme = this.getModel().getDataEntity();
        Date startDate = scheme.getDate("startdate");
        Date endDate = scheme.getDate("enddate");
        if (null == startDate || null == endDate) {
            return;
        }
        String term = DateUtils.getDiff_ymd((Date)startDate, (Date)endDate);
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"term", (Object)term);
    }

    private void initCreditorTypeComb() {
        String finType = (String)this.getModel().getValue("fintype");
        List<String> comboItemValues = StringUtils.equals((CharSequence)LoanTypeEnum.BANKLOAN.getValue(), (CharSequence)finType) ? Arrays.asList(CreditorTypeEnum.BANK.getValue(), CreditorTypeEnum.FINORG.getValue(), CreditorTypeEnum.SETTLECENTER.getValue()) : (StringUtils.equals((CharSequence)LoanTypeEnum.BANKSLOAN.getValue(), (CharSequence)finType) ? Collections.singletonList(CreditorTypeEnum.BANK.getValue()) : Arrays.asList(CreditorTypeEnum.INNERUNIT.getValue(), CreditorTypeEnum.CUSTOM.getValue(), CreditorTypeEnum.OTHER.getValue()));
        TmcViewInputHelper.resetComboItems(comboItemValues, (String)"creditortype", (IFormView)this.getView());
    }

    private void autoWriteRateInfo() {
        String creditorType = (String)this.getModel().getValue("creditortype");
        if (!CreditorTypeEnum.SETTLECENTER.getValue().equals(creditorType)) {
            return;
        }
        DynamicObject finProduct = (DynamicObject)this.getModel().getValue("finproduct");
        if (finProduct == null) {
            this.getModel().setValue("interesttype", null);
            this.getModel().setValue("ratesign", null);
            this.getModel().setValue("ratefloatpoint", null);
            this.getModel().setValue("referrate", null);
            this.getModel().setValue("interestrate", null);
            return;
        }
        DynamicObject ldProduct = QueryServiceHelper.queryOne((String)"ifm_ldproduct", (String)"id,ratetype,basis,floatrate,productprice,referrate,ratesignbp,ratefloatpoints", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)finProduct.getLong("id"))});
        if (ldProduct == null) {
            return;
        }
        String rateType = ldProduct.getString("ratetype");
        boolean isFloatRate = InterestTypeEnum.FLOAT.getValue().equals(rateType);
        this.getModel().setValue("interesttype", (Object)rateType);
        BigDecimal productRate = ldProduct.getBigDecimal("productprice");
        if (isFloatRate) {
            this.getModel().setValue("ratesign", (Object)ldProduct.getString("ratesignbp"));
            this.getModel().setValue("ratefloatpoint", ldProduct.get("ratefloatpoints"));
            this.getModel().setValue("referrate", (Object)ldProduct.getLong("referrate"));
        } else {
            this.getModel().setValue("interestrate", (Object)productRate);
        }
    }

    private void initLoanApplyFilter(BeforeF7SelectEvent evt) {
        QFilter qfilter;
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (null != org) {
            qfilter = new QFilter("org", "=", org.getPkValue());
        } else {
            Long userId = RequestContext.get().getCurrUserId();
            List authorizedBankOrgId = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)userId, (String)"cfm", (String)"cfm_financingscheme", (String)"47156aff000000ac");
            qfilter = new QFilter("org", "in", (Object)authorizedBankOrgId);
        }
        showParameter.getListFilterParameter().getQFilters().add(qfilter);
    }

    private void initFinproductFilter(BeforeF7SelectEvent evt) {
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(8);
        String creditorType = (String)this.getModel().getValue("creditortype");
        if (EmptyUtil.isEmpty((String)creditorType)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u503a\u6743\u4eba\u7c7b\u578b\u3002", (String)"LoanApplySchemeEditPlugin_6", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        if (CreditorTypeEnum.SETTLECENTER.getValue().equals(creditorType)) {
            DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
            if (EmptyUtil.isEmpty((DynamicObject)currency)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5e01\u79cd\u3002", (String)"FinancingSchemeEdit_3", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            List ids = Arrays.stream(TmcDataServiceHelper.load((String)"ifm_ldproduct", (String)"id", (QFilter[])new QFilter[]{new QFilter("currency", "=", currency.getPkValue())})).map(DataEntityBase::getPkValue).collect(Collectors.toList());
            qFilters.add(new QFilter("id", "in", ids));
            qFilters.add(new QFilter("biztype", "=", (Object)"ifm"));
            showParameter.getCustomParams().put("containDefault", "true");
        } else {
            qFilters.add(new QFilter("biztype", "=", (Object)"cfm"));
        }
        showParameter.getListFilterParameter().getQFilters().addAll(qFilters);
    }

    private void initReferRateFilter(BeforeF7SelectEvent evt) {
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        QFilter qfilter = null != currency ? new QFilter("currency", "=", currency.getPkValue()) : new QFilter("currency", "=", (Object)0);
        showParameter.getListFilterParameter().getQFilters().add(qfilter);
    }
}

