/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.unifyloanreturn;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.TextEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.tmc.cfm.common.helper.UnifyLoanRepayHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.CreditorTypeEnum;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class UnifyLoanRepayEdit
extends AbstractBasePlugIn
implements HyperLinkClickListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"e_loanbill"});
        EntryGrid useEntry = (EntryGrid)this.getControl("unifyloanuse_entry");
        if (useEntry != null) {
            useEntry.addHyperClickListener((HyperLinkClickListener)this);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setUnifyUseEntryColumn();
    }

    public void hyperLinkClick(HyperLinkClickEvent event) {
        String fieldName;
        int rowIndex = event.getRowIndex();
        switch (fieldName = event.getFieldName()) {
            case "u_loanbill": {
                BillShowParameter parameter = new BillShowParameter();
                String useType = (String)this.getModel().getValue("u_usetype", rowIndex);
                parameter.setFormId("enter".equals(useType) ? "cfm_loanbill_e_l" : "cfm_loanbill_b_l");
                DynamicObject loanBill = (DynamicObject)this.getModel().getValue("u_loanbillid", rowIndex);
                parameter.setPkId(loanBill.getPkValue());
                parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                parameter.setStatus(OperationStatus.VIEW);
                this.getView().showForm((FormShowParameter)parameter);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String field = e.getProperty().getName();
        ChangeData changeSet = e.getChangeSet()[0];
        int rowIndex = changeSet.getRowIndex();
        switch (field) {
            case "currency": 
            case "interesttype": 
            case "creditorg": {
                this.getModel().deleteEntryData("unifyloanfrom_entry");
                this.getModel().deleteEntryData("unifyloanuse_entry");
                break;
            }
            case "e_loanbill": {
                this.loanBill_ChangedEvt(rowIndex);
                break;
            }
            case "isunifyloanreturn": {
                boolean isUnify = (Boolean)this.getModel().getValue("isunifyloanreturn");
                this.getModel().setValue("isunifycredit", (Object)isUnify);
                this.getModel().deleteEntryData("unifyloanfrom_entry");
                this.getModel().deleteEntryData("unifyloanuse_entry");
                break;
            }
            case "e_fromtype": {
                DynamicObjectCollection cols = this.getModel().getEntryEntity("unifyloanfrom_entry");
                DataEntityPropertyCollection properties = cols.getDynamicObjectType().getProperties();
                for (int i = 0; i < properties.size(); ++i) {
                    String entryField = ((IDataEntityProperty)properties.get(i)).getName();
                    if ("e_fromtype".equals(entryField) || "seq".equals(entryField) || "id".equals(entryField)) continue;
                    this.getModel().setValue(entryField, null, rowIndex);
                }
                break;
            }
        }
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        String field;
        if (EmptyUtil.isEmpty((Object)e.getValue())) {
            return;
        }
        Control source = (Control)e.getSource();
        switch (field = source.getKey()) {
            case "e_useamt": {
                this.validateUseAmt(e, field);
                break;
            }
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        String field;
        super.beforeClick(evt);
        TextEdit source = (TextEdit)evt.getSource();
        switch (field = source.getKey()) {
            case "e_loanbill": {
                String fromType = (String)this.getModel().getValue("e_fromtype");
                if (EmptyUtil.isEmpty((String)fromType)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u6765\u6e90\u7c7b\u578b\u201d\u3002", (String)"UnifyLoanRepayEdit_1", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                }
                if (TmcViewInputHelper.checkMustInput((IFormView)this.getView(), (IDataModel)this.getModel(), (boolean)false, (String[])new String[]{"currency", "interesttype", "creditorg", "startintdate"})) break;
                evt.setCancel(true);
                return;
            }
        }
    }

    public void click(EventObject evt) {
        String field;
        super.click(evt);
        TextEdit source = (TextEdit)evt.getSource();
        switch (field = source.getKey()) {
            case "e_loanbill": {
                this.showLoanBillList();
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        ListSelectedRowCollection returnData = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
        if (EmptyUtil.isEmpty((Collection)returnData)) {
            return;
        }
        ListSelectedRow selectedRow = returnData.get(0);
        int rowIndex = this.getModel().getEntryCurrentRowIndex("unifyloanfrom_entry");
        switch (actionId) {
            case "CLOSE_CALLBACK_LOANBILL": {
                this.getModel().setValue("e_loanbillid", selectedRow.getPrimaryKeyValue(), rowIndex);
                this.getModel().setValue("e_loanbill", (Object)selectedRow.getBillNo(), rowIndex);
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        switch (operateKey = source.getOperateKey()) {
            case "unifyloanreturn_calcrate": 
            case "unifyloanreturn_save": {
                BigDecimal drawAmount = (BigDecimal)this.getModel().getValue("drawamount");
                if (EmptyUtil.isEmpty((BigDecimal)drawAmount)) {
                    args.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u201c\u653e\u6b3e\u91d1\u989d\u201d\u3002", (String)"UnifyLoanRepayEdit_2", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
                    return;
                }
                ((FormOperate)args.getSource()).getOption().setVariableValue("ENTRY_SAVE", "true");
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs event) {
        String operateKey;
        super.afterDoOperation(event);
        OperationResult operationResult = event.getOperationResult();
        if (EmptyUtil.isEmpty((Object)operationResult) || !operationResult.isSuccess()) {
            return;
        }
        switch (operateKey = event.getOperateKey()) {
            case "unifyloanreturn_calcrate": {
                UnifyLoanRepayHelper.calcSynthesiseRate((DynamicObject)this.getModel().getDataEntity(true));
                this.getView().updateView("unifyloanfrom_entry");
                break;
            }
            case "unifyloanreturn_save": {
                this.getView().updateView("unifyloanfrom_entry");
                break;
            }
        }
    }

    private void showLoanBillList() {
        String fromType = (String)this.getModel().getValue("e_fromtype");
        String formId = TmcAppEnum.CFM.getValue().equals(fromType) ? "cfm_loanbill" : "cfm_loanbill_bond";
        ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)formId, (boolean)false);
        List qFilters = showParameter.getListFilterParameter().getQFilters();
        this.addCommonLoanBillFilter(qFilters);
        this.addSpecificLoanBillFilter(qFilters, fromType);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "CLOSE_CALLBACK_LOANBILL"));
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void addCommonLoanBillFilter(List<QFilter> qFilters) {
        qFilters.add(new QFilter("notrepayamount", ">", (Object)0));
        qFilters.add(new QFilter("bizdate", "<=", this.getModel().getValue("startintdate")));
        qFilters.add(new QFilter("currency", "=", ((DynamicObject)this.getModel().getValue("currency")).getPkValue()));
        qFilters.add(new QFilter("interesttype", "=", this.getModel().getValue("interesttype")));
        qFilters.add(new QFilter("org", "=", ((DynamicObject)this.getModel().getValue("creditorg")).getPkValue()));
        qFilters.add(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
        qFilters.add(new QFilter("creditortype", "!=", (Object)CreditorTypeEnum.SETTLECENTER.getValue()));
        Set selectedIds = this.getModel().getEntryEntity("unifyloanfrom_entry").stream().filter(o -> o.get("e_loanbill") != null).filter(o -> o.get("e_loanbillid") != null).map(o -> o.getDynamicObject("e_loanbillid")).map(o -> o.getLong("id")).collect(Collectors.toSet());
        qFilters.add(new QFilter("id", "not in", selectedIds));
    }

    private void addSpecificLoanBillFilter(List<QFilter> qFilters, String fromType) {
        if (TmcAppEnum.CFM.getValue().equals(fromType)) {
            qFilters.add(new QFilter("loantype", "in", Arrays.asList("loan", "sl")));
        } else if ("bond".equals(fromType)) {
            qFilters.add(new QFilter("loantype", "=", (Object)"bond"));
        }
    }

    private void loanBill_ChangedEvt(int rowIndex) {
        if (EmptyUtil.isEmpty((Object)this.getModel().getValue("e_loanbill", rowIndex))) {
            return;
        }
        DynamicObject loan = (DynamicObject)this.getModel().getValue("e_loanbillid", rowIndex);
        if (EmptyUtil.isEmpty((DynamicObject)loan)) {
            return;
        }
        DynamicObject loanBill = TmcDataServiceHelper.loadSingleFromCache((Object)loan.getPkValue(), (String)"cfm_loanbill");
        this.getModel().setValue("e_useamt", (Object)this.getMinAmt(loanBill), rowIndex);
        this.getModel().setValue("e_newloanrate", (Object)UnifyLoanRepayHelper.getNewestRate((DynamicObject)loanBill), rowIndex);
    }

    private BigDecimal getMinAmt(DynamicObject loanBill) {
        BigDecimal notRepayAmt;
        BigDecimal amount = (BigDecimal)this.getModel().getValue("drawamount");
        return amount.compareTo(notRepayAmt = loanBill.getBigDecimal("notrepayamount")) <= 0 ? amount : notRepayAmt;
    }

    private void validateUseAmt(BeforeFieldPostBackEvent e, String field) {
        DynamicObject loanBill = (DynamicObject)this.getModel().getValue("e_loanbillid", e.getRowIndex());
        if (EmptyUtil.isEmpty((DynamicObject)loanBill)) {
            return;
        }
        BigDecimal minAmt = this.getMinAmt(loanBill);
        if (new BigDecimal(String.valueOf(e.getValue())).compareTo(minAmt) > 0) {
            e.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7528\u6b3e\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u5f53\u524d\u5355\u636e\u7684\u653e\u6b3e/\u53d1\u884c\u91d1\u989d\uff0c\u4e5f\u4e0d\u80fd\u5927\u4e8e\u5173\u8054\u5355\u636e\u7684\u501f\u6b3e\u63d0\u6b3e\u4f59\u989d\u3002", (String)"UnifyLoanRepayEdit_3", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
            this.getView().updateView(field, e.getRowIndex());
        }
    }

    private void setUnifyUseEntryColumn() {
        boolean isUnify = (Boolean)this.getModel().getValue("isunifyloanreturn");
        boolean isUnifyDebit = (Boolean)this.getModel().getValue("isunifydebit");
        if (isUnify && isUnifyDebit) {
            DynamicObjectCollection useEntry = this.getModel().getEntryEntity("unifyloanuse_entry");
            if (EmptyUtil.isEmpty((DynamicObjectCollection)useEntry)) {
                return;
            }
            int scale = Optional.ofNullable((DynamicObject)this.getModel().getValue("currency")).map(r -> r.getInt("amtprecision")).orElse(10);
            for (int i = 0; i < useEntry.size(); ++i) {
                DynamicObject row = (DynamicObject)useEntry.get(i);
                DynamicObject loanBill = row.getDynamicObject("u_loanbillid");
                if (EmptyUtil.isEmpty((DynamicObject)loanBill)) continue;
                BigDecimal useAmt = row.getBigDecimal("u_useamt");
                BigDecimal drawAmt = loanBill.getBigDecimal("drawamount");
                BigDecimal repayPart = loanBill.getBigDecimal("repayamount").multiply(useAmt).divide(drawAmt, scale, 4);
                row.set("u_payamt", (Object)repayPart);
                row.set("u_useloanamt", (Object)useAmt.subtract(repayPart));
                row.set("u_payint", (Object)loanBill.getBigDecimal("payinterestamount").multiply(useAmt).divide(drawAmt, scale, 4));
                row.set("u_notpayint", (Object)loanBill.getBigDecimal("calculaterateamount").multiply(useAmt).divide(drawAmt, scale, 4));
            }
            this.getView().updateView("unifyloanuse_entry");
        }
    }
}

