/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.opservice.apply;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.tmc.cim.common.enums.InterestTypeEnum;
import kd.tmc.cim.common.enums.SchemeBizStatusEnum;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BaseEnableEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class DepositApplySchemeSaveService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("tradechannel");
        selector.add("org");
        selector.add("finorginfo");
        selector.add("investvarieties");
        selector.add("prenoticeday");
        selector.add("currency");
        selector.add("amount");
        selector.add("intdate");
        selector.add("term");
        selector.add("deadline");
        selector.add("expiredate");
        selector.add("interesttype");
        selector.add("interestrate");
        selector.add("referencerate");
        selector.add("ratesign");
        selector.add("ratefloatpoint");
        selector.add("profitamount");
        selector.add("expireredeposit");
        selector.add("releaseamount");
        selector.add("estimatedate");
        selector.add("releasetype");
        selector.add("inquiry");
        selector.add("entry");
        selector.add("s_entry");
        selector.add("c_entry");
        selector.add("billstatus");
        selector.add("currency");
        selector.add("c_org");
        selector.add("c_investvarieties");
        selector.add("c_finorginfo");
        selector.add("e_schemeid");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        ArrayList<DynamicObject> waiteSaveSchemes = new ArrayList<DynamicObject>(16);
        ArrayList<Object> depositApplyIds = new ArrayList<Object>(dataEntities.length);
        String submitByCard = this.getOperationVariable().getOrDefault("param_save_bycard", "");
        for (DynamicObject depositApply : dataEntities) {
            if (!depositApply.getBoolean("inquiry")) {
                depositApply.getDynamicObjectCollection("entry").clear();
                depositApply.getDynamicObjectCollection("s_entry").clear();
                this.doDeleteScheme(Collections.singletonList(depositApply.getPkValue()), null);
                continue;
            }
            this.clearSchemeInfo(depositApply);
            if (CollectionUtils.isEmpty((Collection)depositApply.getDynamicObjectCollection("s_entry"))) {
                if (!EmptyUtil.isNoEmpty((String)submitByCard)) continue;
                depositApply.getDynamicObjectCollection("entry").clear();
                this.doDeleteScheme(Collections.singletonList(depositApply.getPkValue()), null);
                continue;
            }
            depositApplyIds.add(depositApply.getPkValue());
            this.genDepositSchemes(waiteSaveSchemes, depositApply);
        }
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{waiteSaveSchemes, depositApplyIds})) {
            return;
        }
        this.doSaveScheme(waiteSaveSchemes);
        this.doDeleteScheme(depositApplyIds, waiteSaveSchemes.stream().map(DataEntityBase::getPkValue).toArray());
        this.doModifySchemeEntry(dataEntities, waiteSaveSchemes);
    }

    private void genDepositSchemes(List<DynamicObject> waiteSaveSchemes, DynamicObject depositApply) {
        DynamicObjectCollection cardEntry = depositApply.getDynamicObjectCollection("s_entry");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)cardEntry)) {
            return;
        }
        long currUserId = RequestContext.get().getCurrUserId();
        Timestamp currentTime = DateUtils.getCurrentTime();
        ArrayList<DynamicObject> depositSchemes = new ArrayList<DynamicObject>(cardEntry.size());
        for (DynamicObject card : cardEntry) {
            DynamicObject cardScheme = (DynamicObject)card.getDynamicObjectCollection("c_entry").get(0);
            DynamicObject newScheme = TmcDataServiceHelper.newDynamicObject((String)"cim_depositscheme");
            newScheme.set("depositapply", (Object)depositApply);
            newScheme.set("applydate", (Object)depositApply.getDate("applydate"));
            newScheme.set("status", (Object)depositApply.getString("billstatus"));
            newScheme.set("creator", (Object)currUserId);
            newScheme.set("createtime", (Object)currentTime);
            newScheme.set("id", (Object)cardScheme.getLong("c_schemeid"));
            newScheme.set("bizstatus", (Object)SchemeBizStatusEnum.UNDETERMINED.getValue());
            newScheme.set("enable", (Object)BaseEnableEnum.ENABLE.getValue());
            this.copyProperties(cardScheme, newScheme, "c_");
            depositSchemes.add(newScheme);
        }
        waiteSaveSchemes.addAll(depositSchemes);
    }

    private void doDeleteScheme(List<Object> depositApplyIds, Object[] schemeIds) {
        QFilter qFilter = new QFilter("depositapply", "in", depositApplyIds);
        if (EmptyUtil.isNoEmpty((Object[])schemeIds)) {
            qFilter.and("id", "not in", (Object)schemeIds);
        }
        DeleteServiceHelper.delete((String)"cim_depositscheme", (QFilter[])qFilter.toArray());
    }

    private void doSaveScheme(List<DynamicObject> depositSchemes) {
        HashMap<DynamicObject, DynamicObject> modifySchemeMap = new HashMap<DynamicObject, DynamicObject>(16);
        ArrayList<DynamicObject> newSchemes = new ArrayList<DynamicObject>(16);
        Object[] schemeIds = depositSchemes.stream().map(DataEntityBase::getPkValue).toArray();
        DynamicObject[] modifySchemes = TmcDataServiceHelper.load((Object[])schemeIds, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cim_depositscheme"));
        Map<Long, DynamicObject> schemeMap = Arrays.stream(modifySchemes).collect(Collectors.toMap(v -> v.getLong("id"), o -> o));
        for (DynamicObject depositScheme : depositSchemes) {
            DynamicObject modifyScheme = schemeMap.get(depositScheme.getLong("id"));
            if (EmptyUtil.isNoEmpty((DynamicObject)modifyScheme)) {
                modifySchemeMap.put(modifyScheme, depositScheme);
                continue;
            }
            newSchemes.add(depositScheme);
        }
        if (!CollectionUtils.isEmpty(newSchemes)) {
            OperateOption option = OperateOption.create();
            option.setVariableValue("fromdepositapply", "true");
            TmcOperateServiceHelper.execOperate((String)"save", (String)"cim_depositscheme", (DynamicObject[])newSchemes.toArray(new DynamicObject[0]), (OperateOption)option);
        }
        if (!CollectionUtils.isEmpty(modifySchemeMap)) {
            this.doModifyScheme(modifySchemeMap);
        }
    }

    private void doModifyScheme(Map<DynamicObject, DynamicObject> modifySchemeMap) {
        ArrayList<DynamicObject> modifySchemes = new ArrayList<DynamicObject>(modifySchemeMap.size());
        for (Map.Entry<DynamicObject, DynamicObject> entry : modifySchemeMap.entrySet()) {
            DynamicObject modifyScheme = entry.getKey();
            DynamicObject newScheme = entry.getValue();
            newScheme.set("creator", (Object)modifyScheme.getDynamicObject("creator"));
            newScheme.set("createtime", (Object)modifyScheme.getDate("createtime"));
            this.copyProperties(newScheme, modifyScheme, "");
            modifySchemes.add(modifyScheme);
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("fromdepositapply", "true");
        TmcOperateServiceHelper.execOperate((String)"save", (String)"cim_depositscheme", (DynamicObject[])modifySchemes.toArray(new DynamicObject[0]), (OperateOption)option);
    }

    private void doModifySchemeEntry(DynamicObject[] dataEntities, List<DynamicObject> relateSchemes) {
        Map relateSchemeMap = relateSchemes.stream().collect(Collectors.toMap(v -> v.getLong("id"), o -> o, (o1, o2) -> o1, HashMap::new));
        for (DynamicObject depositApply : dataEntities) {
            DynamicObjectCollection schemeEntry = depositApply.getDynamicObjectCollection("entry");
            if (!depositApply.getBoolean("inquiry")) {
                schemeEntry.clear();
                continue;
            }
            DynamicObjectCollection cardSchemes = depositApply.getDynamicObjectCollection("s_entry");
            if (CollectionUtils.isEmpty((Collection)cardSchemes)) continue;
            ArrayList<Long> schemeIds = new ArrayList<Long>();
            for (DynamicObject cardScheme : cardSchemes) {
                DynamicObject cSchemeDo;
                DynamicObject cEntryDo = (DynamicObject)cardScheme.getDynamicObjectCollection("c_entry").get(0);
                if (EmptyUtil.isEmpty((DynamicObject)cEntryDo)) continue;
                Long schemeId = cEntryDo.getLong("c_schemeid");
                schemeIds.add(schemeId);
                DynamicObject depositScheme = (DynamicObject)relateSchemeMap.get(schemeId);
                if (EmptyUtil.isEmpty((DynamicObject)depositScheme)) continue;
                if (InterestTypeEnum.FIXED.getValue().equals(depositScheme.getString("interesttype"))) {
                    depositScheme.set("ratesign", null);
                }
                if (EmptyUtil.isNoEmpty((DynamicObject)(cSchemeDo = cEntryDo.getDynamicObject("c_depositscheme")))) {
                    depositScheme.set("number", (Object)cSchemeDo.getString("number"));
                    continue;
                }
                DynamicObject schemeDb = TmcDataServiceHelper.loadSingle((Object)schemeId, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cim_depositscheme"));
                if (EmptyUtil.isEmpty((DynamicObject)schemeDb)) continue;
                depositScheme.set("number", (Object)schemeDb.getString("number"));
            }
            schemeEntry.clear();
            String selectScheme = this.getSelectScheme(cardSchemes);
            for (Long schemeId : schemeIds) {
                DynamicObject depositScheme = (DynamicObject)relateSchemeMap.get(schemeId);
                if (depositScheme == null) continue;
                DynamicObject newScheme = schemeEntry.addNew();
                newScheme.set("e_isselect", (Object)Objects.equals(depositScheme.getString("number"), selectScheme));
                newScheme.set("e_schemeid", (Object)depositScheme.getLong("id"));
                this.copyProperties(depositScheme, newScheme, "e_");
                newScheme.set("e_depositscheme", (Object)depositScheme);
            }
        }
    }

    private void clearSchemeInfo(DynamicObject depositApply) {
        depositApply.set("tradechannel", (Object)"");
        depositApply.set("org", (Object)0L);
        depositApply.set("finorginfo", (Object)0L);
        depositApply.set("prenoticeday", (Object)"");
        depositApply.set("amount", (Object)0);
        depositApply.set("intdate", null);
        depositApply.set("term", (Object)"");
        depositApply.set("deadline", (Object)"");
        depositApply.set("expiredate", null);
        depositApply.set("interesttype", (Object)"");
        depositApply.set("interestrate", (Object)0);
        depositApply.set("referencerate", (Object)0);
        depositApply.set("ratesign", (Object)"");
        depositApply.set("ratefloatpoint", (Object)0);
        depositApply.set("profitamount", (Object)0);
        depositApply.set("expireredeposit", (Object)"");
        depositApply.set("releaseamount", (Object)0);
        depositApply.set("estimatedate", null);
        depositApply.set("releasetype", (Object)"");
        depositApply.set("currency", null);
        depositApply.set("investvarieties", null);
    }

    private void copyProperties(DynamicObject srcObj, DynamicObject targetObj, String prefix) {
        DataEntityPropertyCollection properties = targetObj.getDynamicObjectType().getProperties();
        List srcObjProps = srcObj.getDynamicObjectType().getProperties().stream().map(IMetadata::getName).collect(Collectors.toList());
        for (IDataEntityProperty property : properties) {
            String srcPropName;
            String propName = property.getName();
            String string = srcPropName = propName.startsWith(prefix) ? propName.replace(prefix, "") : prefix + propName;
            if (Arrays.asList("id", "seq", "number").contains(propName) || !srcObjProps.contains(srcPropName)) continue;
            targetObj.set(propName, srcObj.get(srcPropName));
        }
    }

    private String getSelectScheme(DynamicObjectCollection schemeCardEntry) {
        String schemeNumber = "";
        int cardSize = schemeCardEntry.size();
        if (cardSize == 1) {
            schemeNumber = ((DynamicObject)schemeCardEntry.get(0)).getString("s_number");
        } else if (cardSize > 1) {
            schemeNumber = schemeCardEntry.stream().filter(v -> v.getBoolean("selecttag")).map(v -> v.getString("s_number")).filter(EmptyUtil::isNoEmpty).findFirst().orElse(null);
        }
        return schemeNumber;
    }
}

