/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.opservice.apply;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cim.common.enums.SchemeBizStatusEnum;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class FinApplySchemeSaveService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("finaccountf7");
        selector.add("finaccount");
        selector.add("product");
        selector.add("productno");
        selector.add("productname");
        selector.add("investvarieties");
        selector.add("productfactory");
        selector.add("settleaccount");
        selector.add("valuedate");
        selector.add("expiredate");
        selector.add("term");
        selector.add("redeemway");
        selector.add("amount");
        selector.add("buycopies");
        selector.add("iopv");
        selector.add("revenuetype");
        selector.add("planrevenue");
        selector.add("floatplanrevenue");
        selector.add("basis");
        selector.add("planamount");
        selector.add("intdate");
        selector.add("redeempattern");
        selector.add("redeempatternstr");
        selector.add("bonusway");
        selector.add("revenueproject");
        selector.add("risklevel");
        selector.add("explain");
        selector.add("finorginfo");
        selector.add("inquiry");
        selector.add("entry");
        selector.add("s_entry");
        selector.add("c_entry");
        selector.add("billstatus");
        selector.add("currency");
        selector.add("c_finaccount");
        selector.add("c_finaccountf7");
        selector.add("c_finorginfo");
        selector.add("e_schemeid");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        ArrayList<DynamicObject> waiteSaveSchemes = new ArrayList<DynamicObject>(16);
        ArrayList<Object> finApplyIds = new ArrayList<Object>(dataEntities.length);
        String submitByCard = this.getOperationVariable().getOrDefault("param_save_bycard", "");
        for (DynamicObject finApply : dataEntities) {
            this.initDefaultValue(finApply);
            if (!finApply.getBoolean("inquiry")) {
                finApply.getDynamicObjectCollection("entry").clear();
                finApply.getDynamicObjectCollection("s_entry").clear();
                this.doDeleteScheme(Collections.singletonList(finApply.getPkValue()), null);
                continue;
            }
            this.clearSchemeInfo(finApply);
            if (CollectionUtils.isEmpty((Collection)finApply.getDynamicObjectCollection("s_entry"))) {
                if (!EmptyUtil.isNoEmpty((String)submitByCard)) continue;
                finApply.getDynamicObjectCollection("entry").clear();
                this.doDeleteScheme(Collections.singletonList(finApply.getPkValue()), null);
                continue;
            }
            finApplyIds.add(finApply.getPkValue());
            this.genFinSchemes(waiteSaveSchemes, finApply);
        }
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{waiteSaveSchemes, finApplyIds})) {
            return;
        }
        this.doSaveScheme(waiteSaveSchemes);
        this.doDeleteScheme(finApplyIds, waiteSaveSchemes.stream().map(DataEntityBase::getPkValue).toArray());
        this.doModifySchemeEntry(dataEntities, waiteSaveSchemes);
    }

    private void initDefaultValue(DynamicObject finApply) {
        if (null == finApply.get("redeempattern")) {
            finApply.set("redeempattern", (Object)0);
        }
        if (finApply.getBoolean("inquiry")) {
            return;
        }
        DynamicObject finOrgInfo = finApply.getDynamicObject("finorginfo");
        if (EmptyUtil.isEmpty((DynamicObject)finOrgInfo)) {
            return;
        }
        if (StringUtils.equals((CharSequence)finOrgInfo.getDynamicObject("finorgtype").getString("number"), (CharSequence)"FI-014")) {
            DynamicObject finAccountF7 = finApply.getDynamicObject("finaccountf7");
            if (EmptyUtil.isNoEmpty((DynamicObject)finAccountF7)) {
                finApply.set("finaccount", (Object)finAccountF7.getString("number"));
            }
        } else {
            finApply.set("finaccountf7", null);
        }
    }

    private void genFinSchemes(List<DynamicObject> waiteSaveSchemes, DynamicObject finApply) {
        DynamicObjectCollection cardEntry = finApply.getDynamicObjectCollection("s_entry");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)cardEntry)) {
            return;
        }
        long currUserId = RequestContext.get().getCurrUserId();
        Timestamp currentTime = DateUtils.getCurrentTime();
        ArrayList<DynamicObject> finSchemes = new ArrayList<DynamicObject>(cardEntry.size());
        for (DynamicObject card : cardEntry) {
            DynamicObject cardScheme = (DynamicObject)card.getDynamicObjectCollection("c_entry").get(0);
            DynamicObject newScheme = TmcDataServiceHelper.newDynamicObject((String)"cim_finscheme");
            newScheme.set("finapply", finApply.getPkValue());
            newScheme.set("status", (Object)finApply.getString("billstatus"));
            newScheme.set("currency", (Object)finApply.getDynamicObject("currency"));
            newScheme.set("creator", (Object)currUserId);
            newScheme.set("createtime", (Object)currentTime);
            newScheme.set("comment", (Object)cardScheme.getString("c_explain"));
            newScheme.set("id", (Object)cardScheme.getLong("c_schemeid"));
            newScheme.set("bizstatus", (Object)SchemeBizStatusEnum.UNDETERMINED.getValue());
            newScheme.set("number", (Object)cardScheme.getString("c_number"));
            this.copyProperties(cardScheme, newScheme, "c_");
            newScheme.set("finaccount", (Object)cardScheme.getString("c_finaccount"));
            newScheme.set("finaccountf7", cardScheme.get("c_finaccountf7"));
            finSchemes.add(newScheme);
        }
        waiteSaveSchemes.addAll(finSchemes);
    }

    private void doDeleteScheme(List<Object> finApplyIds, Object[] schemeIds) {
        QFilter qfiter = new QFilter("finApply", "in", finApplyIds);
        if (EmptyUtil.isNoEmpty((Object[])schemeIds)) {
            qfiter.and("id", "not in", (Object)schemeIds);
        }
        DeleteServiceHelper.delete((String)"cim_finscheme", (QFilter[])qfiter.toArray());
    }

    private void doSaveScheme(List<DynamicObject> finSchemes) {
        HashMap<DynamicObject, DynamicObject> modifySchemeMap = new HashMap<DynamicObject, DynamicObject>(16);
        ArrayList<DynamicObject> newSchemes = new ArrayList<DynamicObject>(16);
        Object[] schemeIds = finSchemes.stream().map(DataEntityBase::getPkValue).toArray();
        DynamicObject[] modifySchemes = TmcDataServiceHelper.load((Object[])schemeIds, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cim_finscheme"));
        Map<Long, DynamicObject> schemeMap = Arrays.stream(modifySchemes).collect(Collectors.toMap(v -> v.getLong("id"), o -> o));
        for (DynamicObject finScheme : finSchemes) {
            DynamicObject modifyScheme = schemeMap.get(finScheme.getLong("id"));
            if (EmptyUtil.isNoEmpty((DynamicObject)modifyScheme)) {
                finScheme.set("finapply", modifyScheme.get("finapply"));
                modifySchemeMap.put(modifyScheme, finScheme);
                continue;
            }
            newSchemes.add(finScheme);
        }
        if (EmptyUtil.isNoEmpty(newSchemes)) {
            SaveServiceHelper.save((DynamicObject[])newSchemes.toArray(new DynamicObject[0]));
        }
        if (EmptyUtil.isNoEmpty(modifySchemeMap)) {
            this.doModifyScheme(modifySchemeMap);
        }
    }

    private void doModifyScheme(Map<DynamicObject, DynamicObject> modifySchemeMap) {
        ArrayList<DynamicObject> modifySchemes = new ArrayList<DynamicObject>(modifySchemeMap.size());
        for (Map.Entry<DynamicObject, DynamicObject> entry : modifySchemeMap.entrySet()) {
            DynamicObject modifyScheme = entry.getKey();
            DynamicObject newScheme = entry.getValue();
            newScheme.set("creator", (Object)modifyScheme.getDynamicObject("creator"));
            newScheme.set("createtime", (Object)modifyScheme.getDate("createtime"));
            this.copyProperties(newScheme, modifyScheme, "");
            modifySchemes.add(modifyScheme);
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("fromfinapply", "true");
        TmcOperateServiceHelper.execOperate((String)"save", (String)"cim_finscheme", (DynamicObject[])modifySchemes.toArray(new DynamicObject[0]), (OperateOption)option);
    }

    private void doModifySchemeEntry(DynamicObject[] dataEntities, List<DynamicObject> relateSchemes) {
        Map relateSchemeMap = relateSchemes.stream().collect(Collectors.toMap(v -> v.getLong("id"), o -> o, (o1, o2) -> o1, HashMap::new));
        for (DynamicObject finApply : dataEntities) {
            DynamicObjectCollection schemeEntry = finApply.getDynamicObjectCollection("entry");
            if (!finApply.getBoolean("inquiry")) {
                schemeEntry.clear();
                continue;
            }
            DynamicObjectCollection cardSchemes = finApply.getDynamicObjectCollection("s_entry");
            if (CollectionUtils.isEmpty((Collection)cardSchemes)) continue;
            List schemeIds = cardSchemes.stream().map(v -> (DynamicObject)v.getDynamicObjectCollection("c_entry").get(0)).map(v -> v.getLong("c_schemeid")).collect(Collectors.toList());
            schemeEntry.clear();
            int seq = 0;
            long selectScheme = this.getSelectScheme(cardSchemes);
            for (Long schemeId : schemeIds) {
                DynamicObject finScheme = (DynamicObject)relateSchemeMap.get(schemeId);
                DynamicObject newScheme = schemeEntry.addNew();
                newScheme.set("seq", (Object)seq++);
                newScheme.set("e_explain", (Object)finScheme.getString("comment"));
                newScheme.set("e_schemeid", (Object)finScheme.getLong("id"));
                newScheme.set("e_isselect", (Object)Objects.equals(finScheme.getLong("id"), selectScheme));
                this.copyProperties(finScheme, newScheme, "e_");
            }
        }
    }

    private long getSelectScheme(DynamicObjectCollection schemeCardEntry) {
        if (schemeCardEntry.size() == 1) {
            return ((DynamicObject)schemeCardEntry.get(0)).getLong("s_schemeid");
        }
        return schemeCardEntry.stream().filter(v -> v.getBoolean("selecttag")).map(v -> v.getLong("s_schemeid")).findFirst().orElse(0L);
    }

    private void clearSchemeInfo(DynamicObject finApply) {
        finApply.set("product", null);
        finApply.set("productno", (Object)"");
        finApply.set("productname", (Object)"");
        finApply.set("investvarieties", (Object)0L);
        finApply.set("productfactory", (Object)0L);
        finApply.set("finorginfo", (Object)0L);
        finApply.set("finaccount", (Object)"");
        finApply.set("finaccountf7", (Object)0L);
        finApply.set("settleaccount", (Object)0L);
        finApply.set("valuedate", null);
        finApply.set("expiredate", null);
        finApply.set("term", (Object)"");
        finApply.set("redeemway", (Object)"");
        finApply.set("amount", (Object)0);
        finApply.set("buycopies", (Object)0);
        finApply.set("iopv", (Object)0);
        finApply.set("revenuetype", (Object)"");
        finApply.set("planrevenue", (Object)0);
        finApply.set("floatplanrevenue", (Object)0);
        finApply.set("basis", (Object)"");
        finApply.set("planamount", (Object)0);
        finApply.set("intdate", null);
        finApply.set("redeempattern", (Object)0);
        finApply.set("redeempatternstr", (Object)"");
        finApply.set("bonusway", (Object)"");
        finApply.set("revenueproject", (Object)0L);
        finApply.set("risklevel", (Object)"");
        finApply.set("explain", (Object)"");
    }

    private void copyProperties(DynamicObject srcObj, DynamicObject targetObj, String prefix) {
        DataEntityPropertyCollection properties = targetObj.getDynamicObjectType().getProperties();
        List srcObjProps = srcObj.getDynamicObjectType().getProperties().stream().map(IMetadata::getName).collect(Collectors.toList());
        for (IDataEntityProperty property : properties) {
            String srcPropName;
            String propName = property.getName();
            String string = srcPropName = propName.startsWith(prefix) ? propName.replace(prefix, "") : prefix + propName;
            if (Arrays.asList("id", "seq", "number").contains(propName) || !srcObjProps.contains(srcPropName)) continue;
            targetObj.set(propName, srcObj.get(srcPropName));
        }
    }
}

