/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.opservice.apply;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cim.common.enums.FinApplyTypeEnum;
import kd.tmc.cim.common.enums.FinBizStatusEnum;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;

public class FinApplySubmitService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("finservicestatus");
        selector.add("inquiry");
        selector.add("s_entry");
        selector.add("e_schemeid");
        selector.add("applytype");
        selector.add("lastamount");
        selector.add("amount");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        ArrayList<Long> schemeIds = new ArrayList<Long>(16);
        for (DynamicObject finApply : dataEntities) {
            String bizStatus = finApply.getBoolean("inquiry") ? FinBizStatusEnum.QUERYING.getValue() : FinBizStatusEnum.APPLYING.getValue();
            finApply.set("finservicestatus", (Object)bizStatus);
            String applyType = finApply.getString("applytype");
            if (FinApplyTypeEnum.PURCHASE.getValue().equals(applyType)) {
                finApply.set("lastamount", (Object)finApply.getBigDecimal("amount"));
            }
            DynamicObjectCollection entrys = finApply.getDynamicObjectCollection("entry");
            if (!finApply.getBoolean("inquiry") || !CollectionUtils.isEmpty((Collection)finApply.getDynamicObjectCollection("s_entry")) || CollectionUtils.isEmpty((Collection)entrys)) continue;
            schemeIds.addAll(entrys.stream().map(v -> v.getLong("e_schemeid")).collect(Collectors.toList()));
        }
        if (!CollectionUtils.isEmpty(schemeIds)) {
            this.syncSchemeStatus(schemeIds);
        }
    }

    private void syncSchemeStatus(List<Long> schemeIds) {
        DynamicObject[] finSchemes;
        for (DynamicObject finScheme : finSchemes = TmcDataServiceHelper.load((String)"cim_finscheme", (String)"bizstatus,status", (QFilter[])new QFilter[]{new QFilter("id", "in", schemeIds)})) {
            finScheme.set("status", (Object)BillStatusEnum.SUBMIT.getValue());
        }
        SaveServiceHelper.save((DynamicObject[])finSchemes);
    }
}

