/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.opservice.deposit;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cim.common.enums.AgreeDepositStatusEnum;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class AgreeDepositAutoReDepositService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("status");
        selector.add("startdate");
        selector.add("enddate");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        ArrayList<DynamicObject> oriBillList = new ArrayList<DynamicObject>(dataEntities.length);
        ArrayList<DynamicObject> newBillList = new ArrayList<DynamicObject>(dataEntities.length);
        Map operMap = this.getOperationVariable();
        String operateByUser = (String)operMap.get("OPERATE_BY_USER");
        for (DynamicObject agreeDeposit : dataEntities) {
            DynamicObject oriBill = TmcDataServiceHelper.loadSingle((Object)agreeDeposit.getPkValue(), (String)"cim_agreement_deposit");
            DynamicObject newBill = TmcDataServiceHelper.clone((DynamicObject)oriBill);
            newBill.set("billno", (Object)CodeRuleServiceHelper.getNumber((String)"cim_agreement_deposit", (DynamicObject)newBill, (String)String.valueOf(newBill.getDynamicObject("org").getPkValue())));
            newBill.set("status", (Object)AgreeDepositStatusEnum.NORMAL.getValue());
            Date endDate = agreeDeposit.getDate("enddate");
            newBill.set("startdate", (Object)endDate);
            Date startDate = agreeDeposit.getDate("startdate");
            int diffDays = DateUtils.getDiffDays((Date)startDate, (Date)endDate);
            newBill.set("enddate", (Object)DateUtils.getNextDay((Date)endDate, (int)(diffDays - 1)));
            newBill.set("isredepositgenerate", (Object)Boolean.TRUE);
            newBill.set("srcdepositno", (Object)agreeDeposit.getString("billno"));
            newBill.set("creator", (Object)RequestContext.get().getCurrUserId());
            newBill.set("createtime", (Object)new Date());
            if (EmptyUtil.isEmpty((String)operateByUser)) {
                newBill.set("billstatus", (Object)BillStatusEnum.AUDIT.getValue());
                agreeDeposit.set("status", (Object)AgreeDepositStatusEnum.CLOSED.getValue());
                oriBillList.add(agreeDeposit);
            } else {
                newBill.set("billstatus", (Object)BillStatusEnum.SAVE.getValue());
            }
            newBillList.add(newBill);
        }
        if (EmptyUtil.isNoEmpty(oriBillList)) {
            SaveServiceHelper.update((DynamicObject[])oriBillList.toArray(new DynamicObject[0]));
        }
        if (EmptyUtil.isNoEmpty(newBillList)) {
            SaveServiceHelper.save((DynamicObject[])newBillList.toArray(new DynamicObject[0]));
        }
    }
}

