/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.opservice.deposit;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cim.common.enums.DepositApplyStatusEnum;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class AgreeDepositSaveSubmitService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("sourcebillid");
        selector.add("apply");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        ArrayList<DynamicObject> srcBillList = new ArrayList<DynamicObject>(dataEntities.length);
        for (DynamicObject agree : dataEntities) {
            this.updateSrcBillBizStat(agree, srcBillList);
            this.dealSrcBillBotpRelation(agree);
        }
        if (EmptyUtil.isNoEmpty(srcBillList)) {
            SaveServiceHelper.update((DynamicObject[])srcBillList.toArray(new DynamicObject[0]));
        }
    }

    private void updateSrcBillBizStat(DynamicObject agree, List<DynamicObject> srcBillList) {
        DynamicObject apply = agree.getDynamicObject("apply");
        if (EmptyUtil.isEmpty((DynamicObject)apply)) {
            return;
        }
        DynamicObject srcApply = TmcDataServiceHelper.loadSingle((String)"cim_deposit_apply", (String)"applystatus", (QFilter[])new QFilter[]{new QFilter("id", "=", apply.getPkValue())});
        if (EmptyUtil.isNoEmpty((DynamicObject)srcApply)) {
            srcApply.set("applystatus", (Object)DepositApplyStatusEnum.HANDING.getValue());
            srcBillList.add(srcApply);
        }
    }

    private void dealSrcBillBotpRelation(DynamicObject agree) {
        if (EmptyUtil.isNoEmpty((Long)agree.getLong("sourcebillid"))) {
            return;
        }
        Long applyId = Optional.ofNullable(agree.getDynamicObject("apply")).map(r -> r.getLong("id")).orElse(0L);
        this.deleteBotpRation("cim_agreement_deposit", agree.getLong("id"), "cim_deposit_apply", applyId);
        if (EmptyUtil.isNoEmpty((Long)applyId)) {
            TmcBotpHelper.saveRelation((String)"cim_deposit_apply", (Long)applyId, (String)"cim_agreement_deposit", (Long)agree.getLong("id"));
        }
    }

    private void deleteBotpRation(String currEntity, Long currBillId, String sourceEntity, Long srcBillId) {
        boolean isDbExists = QueryServiceHelper.exists((String)currEntity, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)currBillId), new QFilter("apply", "!=", (Object)srcBillId)});
        if (!isDbExists) {
            return;
        }
        DynamicObject sourBill = TmcBotpHelper.getSourceBill((String)currEntity, (Object)currBillId, (String)sourceEntity);
        if (EmptyUtil.isNoEmpty((DynamicObject)sourBill)) {
            TmcBotpHelper.deleteRation((String)currEntity, (Long)sourBill.getLong("id"), (Long)currBillId);
        }
    }
}

