/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.opservice.deposit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.exception.KDException;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cim.common.enums.DepositApplyTypeEnum;
import kd.tmc.cim.common.enums.ReleaseTypeEnum;
import kd.tmc.cim.common.enums.SchemeBizStatusEnum;
import kd.tmc.cim.common.enums.TradeChannelEnum;
import kd.tmc.cim.common.helper.DepositHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;

public class DepositApplyAuditService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("applytype");
        selector.add("deposit");
        selector.add("releaseamount");
        selector.add("estimatedate");
        selector.add("releasetype");
        selector.add("investvarieties");
        selector.add("applystatus");
        selector.add("finorginfo");
        selector.add("amount");
        selector.add("lastamount");
        selector.add("entry");
        selector.add("e_schemeid");
        selector.add("e_isselect");
        selector.add("tradechannel");
        selector.add("org");
        selector.add("prenoticeday");
        selector.add("currency");
        selector.add("intdate");
        selector.add("term");
        selector.add("deadline");
        selector.add("expiredate");
        selector.add("interesttype");
        selector.add("status");
        selector.add("bizstatus");
        selector.add("interestrate");
        selector.add("finaccountf7");
        selector.add("profitamount");
        selector.add("isautodraw");
        selector.add("accountdate");
        selector.add("expireredeposit");
        selector.add("accepttransfer");
        selector.add("transferertype");
        selector.add("transferer");
        selector.add("transfererid");
        selector.add("transferdate");
        selector.add("transferterm");
        selector.add("transferamount");
        selector.add("transferrevenue");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        ArrayList<Long> abandonSchemeIds = new ArrayList<Long>();
        ArrayList<Long> acceptSchemeIds = new ArrayList<Long>();
        for (DynamicObject apply : dataEntities) {
            String applyType = apply.getString("applytype");
            if (!(!DepositApplyTypeEnum.RELEASE.getValue().equals(applyType) || DepositHelper.isSettleCenterBill((DynamicObject)apply) || TradeChannelEnum.ONLINE.getValue().equals(apply.getString("tradechannel")) && ReleaseTypeEnum.isAgreeon((String)apply.getString("releasetype")))) {
                DepositHelper.doPush2ReleaseBill((DynamicObject)apply);
            }
            if (!DepositApplyTypeEnum.DEPOSIT.getValue().equals(applyType)) continue;
            apply.set("lastamount", (Object)apply.getBigDecimal("amount"));
            DynamicObjectCollection entryList = apply.getDynamicObjectCollection("entry");
            if (CollectionUtils.isEmpty((Collection)entryList)) continue;
            for (DynamicObject row : entryList) {
                Long schemeId = row.getLong("e_schemeid");
                if (row.getBoolean("e_isselect")) {
                    acceptSchemeIds.add(schemeId);
                    continue;
                }
                abandonSchemeIds.add(schemeId);
            }
        }
        DynamicObject[] depositSchemes = TmcDataServiceHelper.load((Object[])Stream.concat(abandonSchemeIds.stream(), acceptSchemeIds.stream()).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cim_depositscheme"));
        this.syncSchemeStatus(abandonSchemeIds, depositSchemes);
    }

    private void syncSchemeStatus(List<Long> abandonSchemeIds, DynamicObject[] depositSchemes) {
        for (DynamicObject depositScheme : depositSchemes) {
            depositScheme.set("status", (Object)BillStatusEnum.AUDIT.getValue());
            if (abandonSchemeIds.contains(depositScheme.getLong("id"))) {
                depositScheme.set("bizstatus", (Object)SchemeBizStatusEnum.ABANDON.getValue());
                continue;
            }
            depositScheme.set("bizstatus", (Object)SchemeBizStatusEnum.ACCEPT.getValue());
        }
        SaveServiceHelper.save((DynamicObject[])depositSchemes);
    }
}

