/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.opservice.deposit;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.exception.KDException;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.InterestTypeEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class DepositApplyRelateSchemeService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("inquiry");
        selector.add("entry");
        selector.add("e_isselect");
        selector.add("relatescheme");
        selector.add("e_schemeid");
        selector.add("e_isselect");
        selector.add("relatescheme");
        selector.add("tradechannel");
        selector.add("org");
        selector.add("finorginfo");
        selector.add("prenoticeday");
        selector.add("amount");
        selector.add("intdate");
        selector.add("term");
        selector.add("deadline");
        selector.add("expiredate");
        selector.add("interesttype");
        selector.add("interestrate");
        selector.add("referencerate");
        selector.add("ratesign");
        selector.add("ratefloatpoint");
        selector.add("expireredeposit");
        selector.add("currency");
        selector.add("investvarieties");
        selector.add("rangemin");
        selector.add("rangesign");
        selector.add("rangemax");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        ArrayList<Long> schemeIds = new ArrayList<Long>();
        for (DynamicObject depositApply : dataEntities) {
            DynamicObjectCollection entryList;
            if (!depositApply.getBoolean("inquiry") || depositApply.getBoolean("relatescheme") || CollectionUtils.isEmpty((Collection)(entryList = depositApply.getDynamicObjectCollection("entry")))) continue;
            for (DynamicObject row : entryList) {
                Long schemeId = row.getLong("e_schemeid");
                schemeIds.add(schemeId);
            }
            depositApply.set("relatescheme", (Object)entryList.stream().anyMatch(v -> v.getBoolean("e_isselect")));
        }
        DynamicObject[] depositSchemes = TmcDataServiceHelper.load((Object[])schemeIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cim_depositscheme"));
        this.syncSchemeInfo(dataEntities, depositSchemes);
    }

    private void syncSchemeInfo(DynamicObject[] dataEntities, DynamicObject[] depositSchemes) {
        Map<Long, DynamicObject> schemeMap = Arrays.stream(depositSchemes).collect(Collectors.toMap(v -> v.getLong("id"), o -> o));
        for (DynamicObject depositApply : dataEntities) {
            DynamicObject selectScheme;
            DynamicObject selectEntry;
            DynamicObjectCollection schemeEntry;
            Optional<DynamicObject> selectEntryOptional;
            if (!depositApply.getBoolean("inquiry") || !(selectEntryOptional = (schemeEntry = depositApply.getDynamicObjectCollection("entry")).stream().filter(v -> v.getBoolean("e_isselect")).findFirst()).isPresent() || EmptyUtil.isEmpty((DynamicObject)(selectEntry = selectEntryOptional.orElseGet(null))) || EmptyUtil.isEmpty((DynamicObject)(selectScheme = schemeMap.get(selectEntry.getLong("e_schemeid"))))) continue;
            depositApply.set("tradechannel", (Object)selectScheme.getString("tradechannel"));
            depositApply.set("org", (Object)selectScheme.getDynamicObject("org"));
            depositApply.set("finorginfo", (Object)selectScheme.getDynamicObject("finorginfo"));
            depositApply.set("investvarieties", (Object)selectScheme.getDynamicObject("investvarieties"));
            depositApply.set("prenoticeday", (Object)selectScheme.getString("prenoticeday"));
            depositApply.set("currency", (Object)selectScheme.getDynamicObject("currency"));
            depositApply.set("amount", (Object)selectScheme.getBigDecimal("amount"));
            depositApply.set("lastamount", (Object)selectScheme.getBigDecimal("amount"));
            depositApply.set("intdate", (Object)selectScheme.getDate("intdate"));
            depositApply.set("term", (Object)selectScheme.getString("term"));
            depositApply.set("deadline", (Object)selectScheme.getString("deadline"));
            depositApply.set("expiredate", (Object)selectScheme.getDate("expiredate"));
            depositApply.set("interesttype", (Object)selectScheme.getString("interesttype"));
            depositApply.set("interestrate", (Object)selectScheme.getString("interestrate"));
            depositApply.set("referencerate", (Object)selectScheme.getDynamicObject("referencerate"));
            depositApply.set("ratesign", (Object)selectScheme.getString("ratesign"));
            depositApply.set("ratefloatpoint", selectScheme.get("ratefloatpoint"));
            depositApply.set("expireredeposit", (Object)selectScheme.getString("expireredeposit"));
            if (!InterestTypeEnum.isRange((String)depositApply.getString("interesttype"))) continue;
            depositApply.set("rangemin", (Object)selectScheme.getBigDecimal("rangemin"));
            depositApply.set("rangesign", (Object)selectScheme.getString("rangesign"));
            depositApply.set("rangemax", (Object)selectScheme.getBigDecimal("rangemax"));
        }
    }
}

