/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.opservice.deposit;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.exception.KDException;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cim.common.enums.DepositApplyTypeEnum;
import kd.tmc.cim.common.enums.FinServiceStatusEnum;
import kd.tmc.cim.common.enums.SchemeBizStatusEnum;
import kd.tmc.cim.common.util.StringUtils;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class DepositApplyUnAuditService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("applytype");
        selector.add("lastamount");
        selector.add("applystatus");
        selector.add("deposit");
        selector.add("entry");
        selector.add("e_schemeid");
        selector.add("e_isselect");
        selector.add("relatescheme");
        selector.add("tradechannel");
        selector.add("org");
        selector.add("finorginfo");
        selector.add("prenoticeday");
        selector.add("amount");
        selector.add("intdate");
        selector.add("term");
        selector.add("deadline");
        selector.add("expiredate");
        selector.add("interesttype");
        selector.add("interestrate");
        selector.add("referencerate");
        selector.add("ratesign");
        selector.add("ratefloatpoint");
        selector.add("profitamount");
        selector.add("expireredeposit");
        selector.add("releaseamount");
        selector.add("estimatedate");
        selector.add("releasetype");
        selector.add("currency");
        selector.add("investvarieties");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        ArrayList<Long> schemeIds = new ArrayList<Long>();
        ArrayList<DynamicObject> depositList = new ArrayList<DynamicObject>(dataEntities.length);
        for (DynamicObject depositApply : dataEntities) {
            DynamicObject depositDeal;
            String applyType = depositApply.getString("applytype");
            if (StringUtils.equals((CharSequence)DepositApplyTypeEnum.DEPOSIT.getValue(), (CharSequence)applyType)) {
                depositApply.set("lastamount", null);
                depositApply.set("relatescheme", (Object)false);
                DynamicObjectCollection entryList = depositApply.getDynamicObjectCollection("entry");
                if (CollectionUtils.isEmpty((Collection)entryList)) continue;
                for (DynamicObject row : entryList) {
                    row.set("e_isselect", (Object)false);
                    Long schemeId = row.getLong("e_schemeid");
                    schemeIds.add(schemeId);
                }
                this.clearSchemeInfo(depositApply);
                continue;
            }
            if (!StringUtils.equals((CharSequence)DepositApplyTypeEnum.SUBSIST.getValue(), (CharSequence)applyType) || !EmptyUtil.isNoEmpty((DynamicObject)(depositDeal = depositApply.getDynamicObject("deposit")))) continue;
            DynamicObject deposit = TmcDataServiceHelper.loadSingle((Object)depositDeal.getPkValue(), (String)"cim_deposit", (String)"bizstatus,redeemamount,amount");
            deposit.set("bizstatus", (Object)FinServiceStatusEnum.subscribe_done.getValue());
            BigDecimal redeemAmt = deposit.getBigDecimal("redeemamount");
            if (EmptyUtil.isNoEmpty((BigDecimal)redeemAmt)) {
                deposit.set("bizstatus", (Object)FinServiceStatusEnum.subscribe_part.getValue());
            }
            if (redeemAmt.compareTo(deposit.getBigDecimal("amount")) == 0) {
                deposit.set("bizstatus", (Object)FinServiceStatusEnum.subscribe_end.getValue());
            }
            depositList.add(deposit);
        }
        if (EmptyUtil.isNoEmpty(depositList)) {
            SaveServiceHelper.update((DynamicObject[])depositList.toArray(new DynamicObject[0]));
        }
        this.deleteSaveStatReleaseBill(dataEntities);
        this.syncSchemeStatus(schemeIds);
    }

    private void clearSchemeInfo(DynamicObject depositApply) {
        depositApply.set("tradechannel", (Object)"");
        depositApply.set("org", (Object)0L);
        depositApply.set("finorginfo", (Object)0L);
        depositApply.set("prenoticeday", (Object)"");
        depositApply.set("amount", (Object)0);
        depositApply.set("intdate", null);
        depositApply.set("term", (Object)"");
        depositApply.set("deadline", (Object)"");
        depositApply.set("expiredate", null);
        depositApply.set("interesttype", (Object)"");
        depositApply.set("interestrate", (Object)0);
        depositApply.set("referencerate", (Object)0);
        depositApply.set("ratesign", (Object)"");
        depositApply.set("ratefloatpoint", (Object)0);
        depositApply.set("profitamount", (Object)0);
        depositApply.set("expireredeposit", (Object)"");
        depositApply.set("releaseamount", (Object)0);
        depositApply.set("estimatedate", null);
        depositApply.set("releasetype", (Object)"");
        depositApply.set("currency", null);
        depositApply.set("investvarieties", null);
    }

    private void syncSchemeStatus(List<Long> schemeIds) {
        DynamicObject[] depositSchemes;
        for (DynamicObject depositScheme : depositSchemes = TmcDataServiceHelper.load((Object[])schemeIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cim_depositscheme"))) {
            depositScheme.set("status", (Object)BillStatusEnum.SAVE.getValue());
            depositScheme.set("bizstatus", (Object)SchemeBizStatusEnum.UNDETERMINED.getValue());
        }
        SaveServiceHelper.save((DynamicObject[])depositSchemes);
    }

    private void deleteSaveStatReleaseBill(DynamicObject[] dataEntities) {
        List applyBills = Arrays.stream(dataEntities).filter(r -> StringUtils.equals((CharSequence)DepositApplyTypeEnum.RELEASE.getValue(), (CharSequence)r.getString("applytype"))).collect(Collectors.toList());
        if (EmptyUtil.isNoEmpty(applyBills)) {
            List<Long> applyIds = applyBills.stream().map(r -> r.getLong("id")).collect(Collectors.toList());
            Map targetBills = BFTrackerServiceHelper.findTargetBills((String)dataEntities[0].getDynamicObjectType().getName(), (Long[])applyIds.toArray(new Long[0]));
            if (targetBills != null && targetBills.size() > 0) {
                String targetEntity = "";
                ArrayList targetBillIds = new ArrayList();
                for (Map.Entry entry : targetBills.entrySet()) {
                    targetEntity = (String)entry.getKey();
                    targetBillIds.addAll((Collection)entry.getValue());
                }
                TmcOperateServiceHelper.execOperate((String)"delete", (String)targetEntity, (Object[])targetBillIds.toArray(), (OperateOption)OperateOption.create());
            }
        }
    }
}

