/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.opservice.deposit;

import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.tmc.cim.bussiness.opservice.ebservice.api.EBServiceFacadeImpl;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.constant.DBRouteConst;
import kd.tmc.fbp.common.enums.BeBillStatusEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.service.ebservice.bean.SyncStatusResult;
import kd.tmc.fbp.service.ebservice.data.EBResultStatusCode;

public class DepositCommitBeService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("bebankstatus");
        selector.add("submittime");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        List idList = Arrays.stream(dataEntities).map(s -> (Long)s.getPkValue()).collect(Collectors.toList());
        String tableName = dataEntities[0].getDataEntityType().getAlias();
        String sql = "update " + tableName + " set fbebankstatus = ?, fsubmittime = ? where fid in (" + TmcBusinessBaseHelper.idListToString(idList) + ") and ftradechannel = ? and fbillstatus = ?  and fbebankstatus = ' ' ";
        int[] result = DB.executeBatch((DBRoute)DBRouteConst.TMC, (String)sql, Collections.singletonList(new Object[]{BeBillStatusEnum.OS.getValue(), new Date(), "online", BillStatusEnum.AUDIT.getValue()}));
        if (result.length < 1 || result[0] != idList.size()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6709\u672a\u5b8c\u6210\u7684\u5b58\u6b3e\u4e1a\u52a1\u5355\u636e, \u4e0d\u5141\u8bb8\u518d\u6b21\u63d0\u4ea4\u94f6\u4f01\u3002", (String)"DepositCommitBeService_0", (String)"tmc-cim-business", (Object[])new Object[0]));
        }
    }

    public void afterProcess(DynamicObject[] dataEntities) throws KDException {
        super.afterProcess(dataEntities);
        List<Long> billIdList = Arrays.stream(dataEntities).map(o -> (Long)o.getPkValue()).collect(Collectors.toList());
        List<SyncStatusResult> result = new EBServiceFacadeImpl().commit("deposit", dataEntities[0].getDataEntityType().getName(), billIdList);
        List errList = result.stream().filter(o -> o.getStatusCode() == EBResultStatusCode.ERROR || o.getStatusCode() == EBResultStatusCode.ROLLBACK).collect(Collectors.toList());
        StringBuilder errMsg = new StringBuilder();
        for (SyncStatusResult errResult : errList) {
            errMsg.append(errResult.getErrMsg()).append(' ');
        }
        if (errMsg.length() > 0) {
            throw new KDBizException(errMsg.toString());
        }
    }
}

