/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.opservice.deposit;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.IOperationResult;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cim.common.bean.RevenueConvertParam;
import kd.tmc.cim.common.enums.RevenueSortEnum;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class DepositDealAutoRevenueService
extends AbstractTmcBizOppService {
    private Map<Object, OperationResult> pushResults = new HashMap<Object, OperationResult>();

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("revenuedate");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        Map opMap = this.getOperationVariable();
        String revenueBillStatus = BillStatusEnum.SAVE.getValue();
        String billstatusParam = (String)opMap.get("billstatus_param");
        if (EmptyUtil.isNoEmpty((String)billstatusParam)) {
            revenueBillStatus = billstatusParam;
        }
        Date currentDate = DateUtils.getCurrentDate();
        for (DynamicObject deposit : dataEntities) {
            String entityName;
            OperationResult result;
            DynamicObjectCollection rows = deposit.getDynamicObjectCollection("revenue_entry");
            List revenueRows = rows.stream().filter(r -> r.getDate("revenuedate").compareTo(currentDate) == 0).collect(Collectors.toList());
            if (revenueRows.size() != 1) continue;
            DynamicObject revenueRow = (DynamicObject)revenueRows.get(0);
            Long depositId = deposit.getLong("id");
            OperateOption option = OperateOption.create();
            option.setVariableValue("const_operate_var", "fromAutoRevenue");
            RevenueConvertParam.SourceParam sourceParam = new RevenueConvertParam.SourceParam(depositId);
            sourceParam.addOption("bizdate", DateUtils.formatString((Date)revenueRow.getDate("revenuedate"), (String)"yyyy-MM-dd"));
            RevenueConvertParam convertParam = new RevenueConvertParam("fromAutoRevenue").addParam(sourceParam);
            option.setVariableValue("const_operate_params", SerializationUtils.toJsonString((Object)convertParam));
            try (TXHandle txHandle = TX.requiresNew((String)"cim_deposit_autorenevue");){
                result = TmcOperateServiceHelper.execOperateWithoutThrow((String)"push2revenue", (String)deposit.getDynamicObjectType().getName(), (Object[])new Object[]{depositId}, (OperateOption)option);
            }
            this.pushResults.put(deposit.getPkValue(), result);
            String string = entityName = deposit.getDynamicObjectType().getName().startsWith("cim") ? "cim_dptrevenue" : "ifm_dptrevenue";
            if (BillStatusEnum.SUBMIT.getValue().equals(revenueBillStatus)) {
                this.doRevenueSubmit(depositId, revenueRow, entityName);
                continue;
            }
            if (null == result || !result.isSuccess() || !BillStatusEnum.AUDIT.getValue().equals(revenueBillStatus)) continue;
            List<Object> revenueIds = this.doRevenueSubmit(depositId, revenueRow, entityName);
            TmcOperateServiceHelper.execOperate((String)"audit", (String)entityName, (Object[])revenueIds.toArray(), (OperateOption)OperateOption.create(), (boolean)true);
        }
    }

    public void handlerException(DynamicObject[] dataEntities) throws KDException {
        Object[] errorIds;
        super.handlerException(dataEntities);
        String configStatus = (String)this.getOperationVariable().get("billstatus_param");
        if (this.pushResults.isEmpty() || EmptyUtil.isEmpty((String)configStatus) || BillStatusEnum.isSave((String)configStatus)) {
            return;
        }
        Object[] ids = this.pushResults.values().stream().filter(EmptyUtil::isNoEmpty).filter(OperationResult::isSuccess).flatMap(v -> v.getSuccessPkIds().stream()).toArray();
        QFilter filter = new QFilter("id", "in", (Object)ids);
        if (BillStatusEnum.isSubmit((String)configStatus)) {
            filter.and("billstatus", "=", (Object)BillStatusEnum.SAVE.getValue());
        } else {
            filter.and("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getValue());
        }
        String entityName = dataEntities[0].getDynamicObjectType().getName().startsWith("cim_") ? "cim_dptrevenue" : "ifm_dptrevenue";
        DynamicObjectCollection revenues = QueryServiceHelper.query((String)entityName, (String)"id,billstatus", (QFilter[])filter.toArray());
        Object[] submitIds = revenues.stream().filter(v -> BillStatusEnum.isSubmit((String)v.getString("billstatus"))).map(v -> v.get("id")).toArray();
        if (EmptyUtil.isNoEmpty((Object[])submitIds)) {
            TmcOperateServiceHelper.execOperate((String)"unsubmit", (String)entityName, (Object[])submitIds, (OperateOption)OperateOption.create(), (boolean)true);
        }
        if (EmptyUtil.isNoEmpty((Object[])(errorIds = revenues.stream().map(v -> v.get("id")).toArray()))) {
            TmcOperateServiceHelper.execOperate((String)"delete", (String)entityName, (Object[])errorIds, (OperateOption)OperateOption.create(), (boolean)true);
        }
    }

    public void onReturnOperation(IOperationResult e) throws KDException {
        super.onReturnOperation(e);
        ArrayList<Object> successPkIds = new ArrayList<Object>();
        for (Map.Entry<Object, OperationResult> entry : this.pushResults.entrySet()) {
            OperationResult pushResult = entry.getValue();
            Object pkId = entry.getKey();
            if (null == pushResult) continue;
            boolean success = pushResult.isSuccess();
            if (success) {
                successPkIds.add(pkId);
                continue;
            }
            OperateErrorInfo error = new OperateErrorInfo();
            error.setPkValue(pkId);
            error.setLevel(ErrorLevel.Error);
            error.setMessage(TmcOperateServiceHelper.decodeErrorMsg((OperationResult)pushResult));
            e.addErrorInfo(error);
        }
        e.setSuccessPkIds(successPkIds);
    }

    private List<Object> doRevenueSubmit(Object depositId, DynamicObject revenueRow, String entityName) {
        QFilter qFilter = new QFilter("sourcebillid", "=", depositId);
        qFilter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.SAVE.getValue()));
        qFilter.and(new QFilter("revenuesort", "=", (Object)RevenueSortEnum.revenue.getValue()));
        qFilter.and(new QFilter("bizdate", "=", (Object)revenueRow.getDate("revenuedate")));
        List revenueIds = QueryServiceHelper.queryPrimaryKeys((String)"cim_dptrevenue", (QFilter[])new QFilter[]{qFilter}, (String)"", (int)-1);
        OperateOption option = OperateOption.create();
        option.setVariableValue("WF", "TRUE");
        OperationResult opReulst = TmcOperateServiceHelper.execOperate((String)"submit", (String)entityName, (Object[])revenueIds.toArray(), (OperateOption)option, (boolean)true);
        return opReulst.getSuccessPkIds();
    }
}

