/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.opservice.deposit;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cim.common.enums.FinServiceStatusEnum;
import kd.tmc.cim.common.enums.RevenueSortEnum;
import kd.tmc.cim.common.enums.TradeChannelEnum;
import kd.tmc.cim.common.helper.DepositHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BeBillStatusEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.mq.TmcMQParam;
import kd.tmc.fbp.common.mq.TmcMQTypeEnum;
import kd.tmc.fbp.common.util.EmptyUtil;

public class DepositDealUnAuditService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("bizstatus");
        selector.add("apply");
        selector.add("finorginfo");
        selector.add("amount");
        selector.add("isredepositgenerate");
        selector.add("srcdepositno");
        selector.add("tradechannel");
        selector.add("handredeemamt");
        selector.add("iscreatewhenrelease");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject depositBill : dataEntities) {
            depositBill.set("bizstatus", (Object)FinServiceStatusEnum.subscribe_ing.getValue());
        }
        this.dealReDepositBill(dataEntities);
        this.updateSrcDepositBill(dataEntities);
    }

    public void beforeCommit(DynamicObject[] dataEntities) throws KDException {
        super.beforeCommit(dataEntities);
        DynamicObject[] depositArr = (DynamicObject[])Arrays.stream(dataEntities).filter(r -> !TradeChannelEnum.isOnLine((String)r.getString("tradechannel"))).toArray(DynamicObject[]::new);
        DepositHelper.writeBackDepositApply((DynamicObject[])depositArr, (boolean)true);
        this.asyncDeletePayInfo(dataEntities);
    }

    private void asyncDeletePayInfo(DynamicObject[] depositBills) {
        List autoPushBillIds = Arrays.stream(depositBills).filter(v -> !v.getBoolean("isredepositgenerate")).filter(DepositHelper::isSettleCenterBill).map(DataEntityBase::getPkValue).collect(Collectors.toList());
        if (EmptyUtil.isEmpty(autoPushBillIds)) {
            return;
        }
        HashMap<String, Object> msgParamMap = new HashMap<String, Object>();
        QFilter filter = new QFilter("sourcebillid", "in", autoPushBillIds);
        DynamicObjectCollection transHandleBills = QueryServiceHelper.query((String)"ifm_transhandlebill", (String)"id", (QFilter[])filter.toArray());
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)transHandleBills)) {
            Object[] transBillIds = transHandleBills.stream().map(v -> v.get("id")).toArray();
            msgParamMap.put("ifmentityname", "ifm_transhandlebill");
            msgParamMap.put("transbillids", transBillIds);
        }
        filter.and("billstatus", "!=", (Object)"G");
        DynamicObjectCollection payBills = QueryServiceHelper.query((String)"cas_paybill", (String)"id,billstatus", (QFilter[])filter.toArray());
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)payBills)) {
            Object[] payBillIds = payBills.stream().map(v -> v.get("id")).toArray();
            msgParamMap.put("casentityname", "cas_paybill");
            msgParamMap.put("recpayids", payBillIds);
        }
        if (!CollectionUtils.isEmpty(msgParamMap)) {
            TmcMQParam.build((TmcMQTypeEnum)TmcMQTypeEnum.AUTO_ASYNC_DEL_RECPAY, msgParamMap).sendMessageInDbTranscation("kd.tmc.ifm.trans");
        }
    }

    private void updateSrcDepositBill(DynamicObject[] dataEntities) {
        List<String> srcBillNos = Arrays.stream(dataEntities).filter(r -> r.getBoolean("isredepositgenerate")).filter(r -> !r.getBoolean("iscreatewhenrelease")).map(r -> r.getString("srcdepositno")).collect(Collectors.toList());
        if (EmptyUtil.isEmpty(srcBillNos)) {
            return;
        }
        this.dealSrcDeposit(dataEntities, srcBillNos);
        String dptDealName = dataEntities[0].getDynamicObjectType().getName();
        this.dealRevenueOfSrcDeposit(srcBillNos, dptDealName);
    }

    private void dealRevenueOfSrcDeposit(List<String> srcBillNos, String dptDealName) {
        QFilter qFilter = new QFilter("loanbillno", "in", srcBillNos);
        qFilter.and("revenuesort", "=", (Object)RevenueSortEnum.redeposit_revenue.getValue());
        String entityName = dptDealName.startsWith("ifm") ? "ifm_dptrevenue" : "cim_dptrevenue";
        List revenueIds = QueryServiceHelper.queryPrimaryKeys((String)entityName, (QFilter[])new QFilter[]{qFilter}, (String)"", (int)-1);
        if (EmptyUtil.isEmpty((Collection)revenueIds)) {
            return;
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("fromReleaseAudit", "true");
        TmcOperateServiceHelper.execOperate((String)"unaudit", (String)entityName, (Object[])revenueIds.toArray(), (OperateOption)option);
        TmcOperateServiceHelper.execOperate((String)"delete", (String)entityName, (Object[])revenueIds.toArray(), (OperateOption)option);
    }

    private void dealSrcDeposit(DynamicObject[] dataEntities, List<String> srcBillNos) {
        DynamicObject[] srcDepositBills;
        for (DynamicObject srcDepositBill : srcDepositBills = TmcDataServiceHelper.load((String)dataEntities[0].getDynamicObjectType().getName(), (String)"id,bizstatus,amount,redeemamount,surplusamount,cleardate,billno,lastredeemdate,isinit,handredeemamt", (QFilter[])new QFilter[]{new QFilter("billno", "in", srcBillNos)})) {
            srcDepositBill.set("bizstatus", (Object)FinServiceStatusEnum.subscribe_done.getValue());
            srcDepositBill.set("redeemamount", (Object)0);
            srcDepositBill.set("surplusamount", (Object)srcDepositBill.getBigDecimal("amount"));
            if (EmptyUtil.isNoEmpty((BigDecimal)srcDepositBill.getBigDecimal("handredeemamt")) || EmptyUtil.isNoEmpty((Object)srcDepositBill.getDate("lastredeemdate"))) {
                srcDepositBill.set("bizstatus", (Object)FinServiceStatusEnum.subscribe_part.getValue());
                BigDecimal releasedAmt = this.queryReleasedBillAmt(srcDepositBill);
                srcDepositBill.set("redeemamount", (Object)releasedAmt);
                srcDepositBill.set("surplusamount", (Object)srcDepositBill.getBigDecimal("amount").subtract(releasedAmt));
            }
            srcDepositBill.set("cleardate", null);
        }
        SaveServiceHelper.update((DynamicObject[])srcDepositBills);
    }

    private void dealReDepositBill(DynamicObject[] deposits) {
        Map botpMap;
        Set recBillIds;
        List<Long> depositIds = Arrays.stream(deposits).map(d -> d.getLong("id")).collect(Collectors.toList());
        List srcDepositIds = QueryServiceHelper.queryPrimaryKeys((String)"cim_deposit", (QFilter[])new QFilter("srcdepositid", "in", depositIds).toArray(), null, (int)-1);
        String entityNumber = deposits[0].getDynamicObjectType().getName();
        if (EmptyUtil.isNoEmpty((Object)srcDepositIds)) {
            TmcOperateServiceHelper.execOperate((String)"delete", (String)entityNumber, (Object[])srcDepositIds.toArray(), (OperateOption)OperateOption.create());
        }
        if (EmptyUtil.isNoEmpty((Object)(recBillIds = (Set)(botpMap = BFTrackerServiceHelper.findTargetBills((String)entityNumber, (Long[])depositIds.toArray(new Long[0]))).get("cas_recbill")))) {
            TmcOperateServiceHelper.execOperate((String)"delete", (String)"cas_recbill", (Object[])recBillIds.toArray(), (OperateOption)OperateOption.create(), (boolean)true);
        }
    }

    private BigDecimal queryReleasedBillAmt(DynamicObject srcDepositBill) {
        if (srcDepositBill.getBoolean("isinit")) {
            return srcDepositBill.getBigDecimal("handredeemamt");
        }
        QFilter qFilter = new QFilter("finbillno", "=", srcDepositBill.getPkValue());
        qFilter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
        QFilter offTradeChannelFilter = new QFilter("tradechannel", "!=", (Object)TradeChannelEnum.ONLINE.getValue());
        QFilter onlineTradeChannelFilter = new QFilter("tradechannel", "=", (Object)TradeChannelEnum.ONLINE.getValue());
        onlineTradeChannelFilter.and(new QFilter("bebankstatus", "=", (Object)BeBillStatusEnum.TS.getValue()));
        QFilter tradeFilter = offTradeChannelFilter.or(onlineTradeChannelFilter);
        qFilter.and(tradeFilter);
        DynamicObjectCollection releaseCols = QueryServiceHelper.query((String)"cim_release", (String)"amount", (QFilter[])qFilter.toArray());
        return releaseCols.stream().map(r -> r.getBigDecimal("amount")).reduce((a, b) -> a.add((BigDecimal)b)).orElse(BigDecimal.ZERO);
    }
}

