/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.opservice.deposit;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.tmc.cim.common.helper.DepositHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.model.interest.IntBillDetailInfo;
import kd.tmc.fbp.common.model.interest.IntBillInfo;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class DepositPreInstCalService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("sourcebillid");
        selector.add("prestenddate");
        selector.add("predictpreinstamt");
        selector.add("actpreinstamt");
        selector.add("entrys");
        selector.add("entrys.inststartdate");
        selector.add("entrys.instenddate");
        selector.add("entrys.instdays");
        selector.add("entrys.instprincipalamt");
        selector.add("entrys.rate");
        selector.add("entrys.instamt");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject preInterestEntity : dataEntities) {
            Date expireDate;
            Date endinstdate;
            Date intEndDate;
            DynamicObject finBill = TmcDataServiceHelper.loadSingleFromCache((Object)preInterestEntity.getLong("sourcebillid"), (String)"cim_deposit");
            if (EmptyUtil.isEmpty((DynamicObject)finBill)) continue;
            Date tmpDate = Optional.ofNullable(finBill.getDate("endpreinstdate")).orElseGet(() -> DateUtils.getNextDay((Date)finBill.getDate("intdate"), (int)-1));
            Date intStartDate = DateUtils.getNextDay((Date)tmpDate, (int)1);
            IntBillInfo intBillInfo = DepositHelper.calcDepositBillInt((DynamicObject)finBill, (Date)intStartDate, (Date)(intEndDate = (endinstdate = preInterestEntity.getDate("prestenddate")).compareTo(expireDate = finBill.getDate("expiredate")) <= 0 ? endinstdate : expireDate));
            if (!EmptyUtil.isNoEmpty((Object)intBillInfo)) continue;
            preInterestEntity.set("predictpreinstamt", (Object)intBillInfo.getAmount());
            if (EmptyUtil.isEmpty((BigDecimal)preInterestEntity.getBigDecimal("actpreinstamt"))) {
                preInterestEntity.set("actpreinstamt", (Object)intBillInfo.getAmount());
            }
            DynamicObjectCollection interest_entry = preInterestEntity.getDynamicObjectCollection("entrys");
            this.addDetail(interest_entry, intBillInfo.getDetails());
        }
    }

    private void addDetail(DynamicObjectCollection intDetails, List<IntBillDetailInfo> details) {
        intDetails.clear();
        int seq = 1;
        if (EmptyUtil.isEmpty(details)) {
            return;
        }
        for (IntBillDetailInfo detail : details) {
            DynamicObject intDetail = intDetails.addNew();
            Date inststartdate = detail.getBeginDate();
            Date instenddate = detail.getEndDate();
            int instdays = detail.getDays();
            BigDecimal instprincipalamt = detail.getPrinciple();
            BigDecimal rate = detail.getRate();
            int ratetrandays = detail.getBasisDay();
            BigDecimal instamt = detail.getAmount();
            intDetail.set("seq", (Object)seq++);
            intDetail.set("inststartdate", (Object)inststartdate);
            intDetail.set("instenddate", (Object)instenddate);
            intDetail.set("instdays", (Object)instdays);
            intDetail.set("instprincipalamt", (Object)instprincipalamt);
            intDetail.set("rate", (Object)rate);
            intDetail.set("ratetrandays", (Object)ratetrandays);
            intDetail.set("instamt", (Object)instamt);
        }
    }
}

