/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.opservice.deposit;

import java.util.Arrays;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDException;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class DepositReleaseReCommitBeService
extends AbstractTmcBizOppService {
    public void process(DynamicObject[] dataEntities) throws KDException {
        DynamicObject[] releaseBills;
        for (DynamicObject releaseBill : releaseBills = TmcDataServiceHelper.load((Object[])Arrays.stream(dataEntities).map(DataEntityBase::getPkValue).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cim_release"))) {
            releaseBill.set("isresubmit", (Object)true);
            SaveServiceHelper.update((DynamicObject)releaseBill);
            this.createNewReleaseBill(releaseBill);
        }
    }

    private void createNewReleaseBill(DynamicObject releaseBill) {
        DynamicObject srcBill;
        DynamicObject newReleaseBill = TmcDataServiceHelper.clone((DynamicObject)releaseBill);
        newReleaseBill.set("billno", null);
        newReleaseBill.set("billstatus", (Object)BillStatusEnum.SAVE.getValue());
        newReleaseBill.set("bebankstatus", (Object)"");
        newReleaseBill.set("isresubmit", (Object)false);
        newReleaseBill.set("returnmsg", (Object)"");
        newReleaseBill.set("submittime", (Object)DateUtils.getCurrentTime());
        newReleaseBill.set("srcdepositid", releaseBill.getPkValue());
        newReleaseBill.set("createtime", (Object)DateUtils.getCurrentTime());
        newReleaseBill.set("creator", (Object)RequestContext.get().getCurrUserId());
        TmcOperateServiceHelper.execOperate((String)"save", (String)"cim_release", (DynamicObject[])new DynamicObject[]{newReleaseBill}, (OperateOption)OperateOption.create());
        String sourcebilltype = releaseBill.getString("sourcebilltype");
        if (EmptyUtil.isNoEmpty((String)sourcebilltype) && EmptyUtil.isNoEmpty((DynamicObject)(srcBill = TmcBotpHelper.getSourceBill((String)"cim_release", (Object)releaseBill.getPkValue(), (String)sourcebilltype)))) {
            TmcBotpHelper.saveRelation((DynamicObject)srcBill, (DynamicObject)newReleaseBill);
        }
    }
}

