/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.bussiness.opservice.deposit;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDException;
import kd.bos.extplugin.PluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.sdk.tmc.cim.extpoint.IReleasePushDptRevenue;
import kd.tmc.cim.common.bean.RevenueConvertParam;
import kd.tmc.cim.common.enums.RevenueSortEnum;
import kd.tmc.cim.common.helper.DepositHelper;
import kd.tmc.cim.common.util.StringUtils;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.tuple.Pair;

public class DepositReleaseSubmitService
extends AbstractTmcBizOppService {
    private static final Log log = LogFactory.getLog(DepositReleaseSubmitService.class);

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("isrevenue");
        selector.add("finbillno");
        selector.add("realrevenue");
        selector.add("scorg");
        selector.add("amount");
        selector.add("combineinst");
        selector.add("recamount");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject releaseBill : dataEntities) {
            DepositHelper.setRecAmount((DynamicObject)releaseBill);
            DepositHelper.setScOrg((DynamicObject)releaseBill);
        }
    }

    public void afterProcess(DynamicObject[] dataEntities) throws KDException {
        List depositIds;
        String upstreamEntity;
        List<DynamicObject> releaseBills = Arrays.stream(dataEntities).filter(d -> d.getBoolean("isrevenue") && EmptyUtil.isNoEmpty((BigDecimal)d.getBigDecimal("realrevenue"))).collect(Collectors.toList());
        if (EmptyUtil.isEmpty(releaseBills)) {
            return;
        }
        HashMap<String, List> depositIdMap = new HashMap<String, List>(releaseBills.size());
        RevenueConvertParam convertParam = new RevenueConvertParam("fromRelease");
        ArrayList<RevenueConvertParam.SourceParam> sourceParams = new ArrayList<RevenueConvertParam.SourceParam>(releaseBills.size());
        for (DynamicObject release : releaseBills) {
            Long depositId = release.getLong("finbillno.id");
            upstreamEntity = DepositHelper.getUpstreamEntity((String)release.getDataEntityType().getName());
            depositIds = depositIdMap.computeIfAbsent(upstreamEntity, d -> new ArrayList(2));
            depositIds.add(depositId);
            RevenueConvertParam.SourceParam sourceParam = new RevenueConvertParam.SourceParam(depositId);
            sourceParam.addOption("srcreleaseid", release.getPkValue().toString()).addOption("revenuesort", RevenueSortEnum.redeem_revenue.getValue()).addOption("bizdate", DateUtils.formatString((Date)release.getDate("redeemdate"), (String)"yyyy-MM-dd"));
            String result = this.dealSDK(release);
            if (EmptyUtil.isNoEmpty((String)result)) {
                sourceParam.addOption("SecondDevFieldVal", result);
            }
            sourceParams.add(sourceParam);
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("const_operate_var", "fromRelease");
        for (Map.Entry entry : depositIdMap.entrySet()) {
            upstreamEntity = (String)entry.getKey();
            depositIds = (List)entry.getValue();
            List params = sourceParams.stream().filter(d -> depositIds.contains(d.getSourceBillId())).collect(Collectors.toList());
            convertParam.setParams(params);
            option.setVariableValue("const_operate_params", SerializationUtils.toJsonString((Object)convertParam));
            TmcOperateServiceHelper.execOperate((String)"push2revenue", (String)upstreamEntity, (Object[])depositIds.toArray(new Long[0]), (OperateOption)option);
        }
        this.bindBotpRelation(releaseBills);
    }

    private void bindBotpRelation(List<DynamicObject> releases) {
        List releaseIds = releases.stream().map(d -> d.getLong("id")).collect(Collectors.toList());
        QFilter qFilter = new QFilter("srcreleaseid", "in", releaseIds);
        qFilter.and(new QFilter("revenuesort", "=", (Object)RevenueSortEnum.redeem_revenue.getValue()));
        DynamicObjectCollection dptRevenues = QueryServiceHelper.query((String)"cim_dptrevenue", (String)"id,srcreleaseid", (QFilter[])qFilter.toArray());
        if (dptRevenues.isEmpty()) {
            return;
        }
        Map<Long, Long> srcReleaseIdMap = dptRevenues.stream().collect(Collectors.toMap(d -> d.getLong("srcreleaseid"), d -> d.getLong("id"), (d1, d2) -> d1));
        for (DynamicObject release : releases) {
            long releaseId = release.getLong("id");
            Long revenueId = srcReleaseIdMap.get(releaseId);
            if (EmptyUtil.isEmpty((Long)revenueId)) continue;
            List<Pair<String, String>> botpPairs = this.getBotpPairs(release.getDynamicObjectType().getName());
            for (Pair<String, String> botpPair : botpPairs) {
                TmcBotpHelper.saveRelation((String)((String)botpPair.getLeft()), (Long)releaseId, (String)((String)botpPair.getRight()), (Long)revenueId);
            }
        }
    }

    private List<Pair<String, String>> getBotpPairs(String releaseName) {
        ArrayList<Pair<String, String>> botpPairs = new ArrayList<Pair<String, String>>();
        if (StringUtils.equals((CharSequence)releaseName, (CharSequence)"ifm_release") || StringUtils.equals((CharSequence)releaseName, (CharSequence)"cim_release")) {
            botpPairs.addAll(Arrays.asList(Pair.of((Object)"ifm_release", (Object)"ifm_dptrevenue"), Pair.of((Object)"cim_release", (Object)"cim_dptrevenue")));
        } else {
            botpPairs.addAll(Arrays.asList(Pair.of((Object)"ifm_notice_release", (Object)"ifm_dptrevenue"), Pair.of((Object)"cim_noticerelease", (Object)"cim_dptrevenue")));
        }
        return botpPairs;
    }

    private String dealSDK(DynamicObject release) {
        PluginProxy pluginProxy = PluginProxy.create(IReleasePushDptRevenue.class, (String)"kd.sdk.tmc.cim.extpoint.IReleasePushDptRevenue.getReleaseBillSecondFields");
        List result = pluginProxy.callReplace(proxy -> proxy.getReleaseBillSecondFields(release)).stream().filter(Objects::nonNull).collect(Collectors.toList());
        log.info(String.format("\u5904\u7406\u7ed3\u679c\u53c2\u6570\uff1a%s", result));
        if (EmptyUtil.isNoEmpty(result) && EmptyUtil.isNoEmpty(result.get(0))) {
            Map fields = (Map)result.get(0);
            return fields != null ? JSON.toJSONString((Object)fields) : null;
        }
        return null;
    }
}

